package software.amazon.awscdk.services.cloudfront;

/**
 * An Origin Access Control for Amazon S3 origins.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket myBucket = new Bucket(this, "myBucket");
 * S3OriginAccessControl oac = S3OriginAccessControl.Builder.create(this, "MyOAC")
 *         .signing(Signing.SIGV4_NO_OVERRIDE)
 *         .build();
 * IOrigin s3Origin = S3BucketOrigin.withOriginAccessControl(myBucket, S3BucketOriginWithOACProps.builder()
 *         .originAccessControl(oac)
 *         .build());
 * Distribution.Builder.create(this, "myDist")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(s3Origin)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-originaccesscontrol.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-originaccesscontrol.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:32.540Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.S3OriginAccessControl")
public class S3OriginAccessControl extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.cloudfront.IOriginAccessControl {

    protected S3OriginAccessControl(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected S3OriginAccessControl(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudfront.S3OriginAccessControl.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public S3OriginAccessControl(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.S3OriginAccessControlProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public S3OriginAccessControl(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Imports an S3 origin access control from its id.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param originAccessControlId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.IOriginAccessControl fromOriginAccessControlId(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String originAccessControlId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.S3OriginAccessControl.class, "fromOriginAccessControlId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IOriginAccessControl.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(originAccessControlId, "originAccessControlId is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * The unique identifier of this Origin Access Control.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getOriginAccessControlId() {
        return software.amazon.jsii.Kernel.get(this, "originAccessControlId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudfront.S3OriginAccessControl}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudfront.S3OriginAccessControl> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.cloudfront.S3OriginAccessControlProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * A description of the origin access control.
         * <p>
         * Default: - no description
         * <p>
         * @return {@code this}
         * @param description A description of the origin access control. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * A name to identify the origin access control, with a maximum length of 64 characters.
         * <p>
         * Default: - a generated name
         * <p>
         * @return {@code this}
         * @param originAccessControlName A name to identify the origin access control, with a maximum length of 64 characters. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originAccessControlName(final java.lang.String originAccessControlName) {
            this.props().originAccessControlName(originAccessControlName);
            return this;
        }

        /**
         * Specifies which requests CloudFront signs and the signing protocol.
         * <p>
         * Default: SIGV4_ALWAYS
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originaccesscontrol-originaccesscontrolconfig.html#cfn-cloudfront-originaccesscontrol-originaccesscontrolconfig-signingbehavior">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originaccesscontrol-originaccesscontrolconfig.html#cfn-cloudfront-originaccesscontrol-originaccesscontrolconfig-signingbehavior</a>
         * @param signing Specifies which requests CloudFront signs and the signing protocol. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signing(final software.amazon.awscdk.services.cloudfront.Signing signing) {
            this.props().signing(signing);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cloudfront.S3OriginAccessControl}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudfront.S3OriginAccessControl build() {
            return new software.amazon.awscdk.services.cloudfront.S3OriginAccessControl(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.cloudfront.S3OriginAccessControlProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.cloudfront.S3OriginAccessControlProps.Builder();
            }
            return this.props;
        }
    }
}
