package software.amazon.awscdk.services.codebuild;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.codebuild.*;
 * Project codebuildProject = Project.Builder.create(this, "Project")
 *         .projectName("MyTestProject")
 *         .buildSpec(BuildSpec.fromObject(Map.of(
 *                 "version", "0.2",
 *                 "phases", Map.of(
 *                         "build", Map.of(
 *                                 "commands", List.of("echo \"Hello, CodeBuild!\""))))))
 *         .build();
 * CodeBuildStartBuild task = CodeBuildStartBuild.Builder.create(this, "Task")
 *         .project(codebuildProject)
 *         .integrationPattern(IntegrationPattern.RUN_JOB)
 *         .environmentVariablesOverride(Map.of(
 *                 "ZONE", BuildEnvironmentVariable.builder()
 *                         .type(BuildEnvironmentVariableType.PLAINTEXT)
 *                         .value(JsonPath.stringAt("$.envVariables.zone"))
 *                         .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:32.810Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.BuildEnvironmentVariableType")
public enum BuildEnvironmentVariableType {
    /**
     * An environment variable in plaintext format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PLAINTEXT,
    /**
     * An environment variable stored in Systems Manager Parameter Store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PARAMETER_STORE,
    /**
     * An environment variable stored in AWS Secrets Manager.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SECRETS_MANAGER,
}
