package software.amazon.awscdk.services.codeguruprofiler;

/**
 * A new Profiling Group.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The execution role of your application that publishes to the ProfilingGroup via CodeGuru Profiler Profiling Agent. (the following is merely an example)
 * Role publishAppRole = Role.Builder.create(this, "PublishAppRole")
 *         .assumedBy(new AccountRootPrincipal())
 *         .build();
 * ProfilingGroup profilingGroup = new ProfilingGroup(this, "MyProfilingGroup");
 * profilingGroup.grantPublish(publishAppRole);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:33.051Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codeguruprofiler.ProfilingGroup")
public class ProfilingGroup extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.codeguruprofiler.IProfilingGroup {

    protected ProfilingGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ProfilingGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codeguruprofiler.ProfilingGroup.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ProfilingGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codeguruprofiler.ProfilingGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ProfilingGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Import an existing Profiling Group provided an ARN.
     * <p>
     * @param scope The parent creating construct. This parameter is required.
     * @param id The construct's name. This parameter is required.
     * @param profilingGroupArn Profiling Group ARN. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codeguruprofiler.IProfilingGroup fromProfilingGroupArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String profilingGroupArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codeguruprofiler.ProfilingGroup.class, "fromProfilingGroupArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codeguruprofiler.IProfilingGroup.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(profilingGroupArn, "profilingGroupArn is required") });
    }

    /**
     * Import an existing Profiling Group provided a Profiling Group Name.
     * <p>
     * @param scope The parent creating construct. This parameter is required.
     * @param id The construct's name. This parameter is required.
     * @param profilingGroupName Profiling Group Name. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codeguruprofiler.IProfilingGroup fromProfilingGroupName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String profilingGroupName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codeguruprofiler.ProfilingGroup.class, "fromProfilingGroupName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codeguruprofiler.IProfilingGroup.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(profilingGroupName, "profilingGroupName is required") });
    }

    /**
     * Grant access to publish profiling information to the Profiling Group to the given identity.
     * <p>
     * This will grant the following permissions:
     * <p>
     * <ul>
     * <li>codeguru-profiler:ConfigureAgent</li>
     * <li>codeguru-profiler:PostAgentProfile</li>
     * </ul>
     * <p>
     * @param grantee Principal to grant publish rights to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPublish(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantPublish", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Grant access to read profiling information from the Profiling Group to the given identity.
     * <p>
     * This will grant the following permissions:
     * <p>
     * <ul>
     * <li>codeguru-profiler:GetProfile</li>
     * <li>codeguru-profiler:DescribeProfilingGroup</li>
     * </ul>
     * <p>
     * @param grantee Principal to grant read rights to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantRead", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * The ARN of the Profiling Group.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getProfilingGroupArn() {
        return software.amazon.jsii.Kernel.get(this, "profilingGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the Profiling Group.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getProfilingGroupName() {
        return software.amazon.jsii.Kernel.get(this, "profilingGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codeguruprofiler.ProfilingGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codeguruprofiler.ProfilingGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.codeguruprofiler.ProfilingGroupProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The compute platform of the profiling group.
         * <p>
         * Default: ComputePlatform.DEFAULT
         * <p>
         * @return {@code this}
         * @param computePlatform The compute platform of the profiling group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computePlatform(final software.amazon.awscdk.services.codeguruprofiler.ComputePlatform computePlatform) {
            this.props().computePlatform(computePlatform);
            return this;
        }

        /**
         * A name for the profiling group.
         * <p>
         * Default: - automatically generated name.
         * <p>
         * @return {@code this}
         * @param profilingGroupName A name for the profiling group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder profilingGroupName(final java.lang.String profilingGroupName) {
            this.props().profilingGroupName(profilingGroupName);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.codeguruprofiler.ProfilingGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codeguruprofiler.ProfilingGroup build() {
            return new software.amazon.awscdk.services.codeguruprofiler.ProfilingGroup(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.codeguruprofiler.ProfilingGroupProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.codeguruprofiler.ProfilingGroupProps.Builder();
            }
            return this.props;
        }
    }
}
