package software.amazon.awscdk.services.codepipeline;

/**
 * The configuration that specifies the result, such as rollback, to occur upon stage failure.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * CodeStarConnectionsSourceAction sourceAction;
 * CodeBuildAction buildAction;
 * Pipeline.Builder.create(this, "Pipeline")
 *         .pipelineType(PipelineType.V2)
 *         .stages(List.of(StageProps.builder()
 *                 .stageName("Source")
 *                 .actions(List.of(sourceAction))
 *                 .build(), StageProps.builder()
 *                 .stageName("Build")
 *                 .actions(List.of(buildAction))
 *                 // BeforeEntry condition - checks before entering the stage
 *                 .beforeEntry(Conditions.builder()
 *                         .conditions(List.of(Condition.builder()
 *                                 .rules(List.of(Rule.Builder.create()
 *                                         .name("LambdaCheck")
 *                                         .provider("LambdaInvoke")
 *                                         .version("1")
 *                                         .configuration(Map.of(
 *                                                 "FunctionName", "LambdaFunctionName"))
 *                                         .build()))
 *                                 .result(Result.FAIL)
 *                                 .build()))
 *                         .build())
 *                 // OnSuccess condition - checks after successful stage completion
 *                 .onSuccess(Conditions.builder()
 *                         .conditions(List.of(Condition.builder()
 *                                 .result(Result.FAIL)
 *                                 .rules(List.of(Rule.Builder.create()
 *                                         .name("CloudWatchCheck")
 *                                         .provider("LambdaInvoke")
 *                                         .version("1")
 *                                         .configuration(Map.of(
 *                                                 "AlarmName", "AlarmName1",
 *                                                 "WaitTime", "300",  // 5 minutes
 *                                                 "FunctionName", "funcName2"))
 *                                         .build()))
 *                                 .build()))
 *                         .build())
 *                 // OnFailure condition - handles stage failure
 *                 .onFailure(FailureConditions.builder()
 *                         .conditions(List.of(Condition.builder()
 *                                 .result(Result.ROLLBACK)
 *                                 .rules(List.of(Rule.Builder.create()
 *                                         .name("RollBackOnFailure")
 *                                         .provider("LambdaInvoke")
 *                                         .version("1")
 *                                         .configuration(Map.of(
 *                                                 "AlarmName", "Alarm",
 *                                                 "WaitTime", "300",  // 5 minutes
 *                                                 "FunctionName", "funcName1"))
 *                                         .build()))
 *                                 .build()))
 *                         .build())
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:33.125Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.FailureConditions")
@software.amazon.jsii.Jsii.Proxy(FailureConditions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FailureConditions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codepipeline.Conditions {

    /**
     * The specified result for when the failure conditions are met, such as rolling back the stage.
     * <p>
     * Default: FAIL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codepipeline.Result getResult() {
        return null;
    }

    /**
     * The method that you want to configure for automatic stage retry on stage failure.
     * <p>
     * Default: ALL_ACTIONS
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codepipeline.RetryMode getRetryMode() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FailureConditions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FailureConditions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FailureConditions> {
        software.amazon.awscdk.services.codepipeline.Result result;
        software.amazon.awscdk.services.codepipeline.RetryMode retryMode;
        java.util.List<software.amazon.awscdk.services.codepipeline.Condition> conditions;

        /**
         * Sets the value of {@link FailureConditions#getResult}
         * @param result The specified result for when the failure conditions are met, such as rolling back the stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder result(software.amazon.awscdk.services.codepipeline.Result result) {
            this.result = result;
            return this;
        }

        /**
         * Sets the value of {@link FailureConditions#getRetryMode}
         * @param retryMode The method that you want to configure for automatic stage retry on stage failure.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryMode(software.amazon.awscdk.services.codepipeline.RetryMode retryMode) {
            this.retryMode = retryMode;
            return this;
        }

        /**
         * Sets the value of {@link FailureConditions#getConditions}
         * @param conditions The conditions that are configured as entry conditions, making check to succeed the stage, or fail the stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder conditions(java.util.List<? extends software.amazon.awscdk.services.codepipeline.Condition> conditions) {
            this.conditions = (java.util.List<software.amazon.awscdk.services.codepipeline.Condition>)conditions;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FailureConditions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FailureConditions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FailureConditions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FailureConditions {
        private final software.amazon.awscdk.services.codepipeline.Result result;
        private final software.amazon.awscdk.services.codepipeline.RetryMode retryMode;
        private final java.util.List<software.amazon.awscdk.services.codepipeline.Condition> conditions;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.result = software.amazon.jsii.Kernel.get(this, "result", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.Result.class));
            this.retryMode = software.amazon.jsii.Kernel.get(this, "retryMode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.RetryMode.class));
            this.conditions = software.amazon.jsii.Kernel.get(this, "conditions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.Condition.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.result = builder.result;
            this.retryMode = builder.retryMode;
            this.conditions = (java.util.List<software.amazon.awscdk.services.codepipeline.Condition>)builder.conditions;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.Result getResult() {
            return this.result;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.RetryMode getRetryMode() {
            return this.retryMode;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.codepipeline.Condition> getConditions() {
            return this.conditions;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getResult() != null) {
                data.set("result", om.valueToTree(this.getResult()));
            }
            if (this.getRetryMode() != null) {
                data.set("retryMode", om.valueToTree(this.getRetryMode()));
            }
            if (this.getConditions() != null) {
                data.set("conditions", om.valueToTree(this.getConditions()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.FailureConditions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FailureConditions.Jsii$Proxy that = (FailureConditions.Jsii$Proxy) o;

            if (this.result != null ? !this.result.equals(that.result) : that.result != null) return false;
            if (this.retryMode != null ? !this.retryMode.equals(that.retryMode) : that.retryMode != null) return false;
            return this.conditions != null ? this.conditions.equals(that.conditions) : that.conditions == null;
        }

        @Override
        public final int hashCode() {
            int result = this.result != null ? this.result.hashCode() : 0;
            result = 31 * result + (this.retryMode != null ? this.retryMode.hashCode() : 0);
            result = 31 * result + (this.conditions != null ? this.conditions.hashCode() : 0);
            return result;
        }
    }
}
