package software.amazon.awscdk.services.codepipeline;

/**
 * Construction properties of a Pipeline Stage.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codepipeline.*;
 * Action action;
 * Rule rule;
 * StageProps stageProps = StageProps.builder()
 *         .stageName("stageName")
 *         // the properties below are optional
 *         .actions(List.of(action))
 *         .beforeEntry(Conditions.builder()
 *                 .conditions(List.of(Condition.builder()
 *                         .result(Result.ROLLBACK)
 *                         .rules(List.of(rule))
 *                         .build()))
 *                 .build())
 *         .onFailure(FailureConditions.builder()
 *                 .conditions(List.of(Condition.builder()
 *                         .result(Result.ROLLBACK)
 *                         .rules(List.of(rule))
 *                         .build()))
 *                 .result(Result.ROLLBACK)
 *                 .retryMode(RetryMode.ALL_ACTIONS)
 *                 .build())
 *         .onSuccess(Conditions.builder()
 *                 .conditions(List.of(Condition.builder()
 *                         .result(Result.ROLLBACK)
 *                         .rules(List.of(rule))
 *                         .build()))
 *                 .build())
 *         .transitionDisabledReason("transitionDisabledReason")
 *         .transitionToEnabled(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:33.140Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.StageProps")
@software.amazon.jsii.Jsii.Proxy(StageProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StageProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The physical, human-readable name to assign to this Pipeline Stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStageName();

    /**
     * The list of Actions to create this Stage with.
     * <p>
     * You can always add more Actions later by calling <code>IStage#addAction</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.codepipeline.IAction> getActions() {
        return null;
    }

    /**
     * The method to use when a stage allows entry.
     * <p>
     * Default: - No conditions are applied before stage entry
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codepipeline.Conditions getBeforeEntry() {
        return null;
    }

    /**
     * The method to use when a stage has not completed successfully.
     * <p>
     * Default: - No failure conditions are applied
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codepipeline.FailureConditions getOnFailure() {
        return null;
    }

    /**
     * The method to use when a stage has succeeded.
     * <p>
     * Default: - No success conditions are applied
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codepipeline.Conditions getOnSuccess() {
        return null;
    }

    /**
     * The reason for disabling transition to this stage.
     * <p>
     * Only applicable
     * if <code>transitionToEnabled</code> is set to <code>false</code>.
     * <p>
     * Default: 'Transition disabled'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTransitionDisabledReason() {
        return null;
    }

    /**
     * Whether to enable transition to this stage.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getTransitionToEnabled() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link StageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StageProps> {
        java.lang.String stageName;
        java.util.List<software.amazon.awscdk.services.codepipeline.IAction> actions;
        software.amazon.awscdk.services.codepipeline.Conditions beforeEntry;
        software.amazon.awscdk.services.codepipeline.FailureConditions onFailure;
        software.amazon.awscdk.services.codepipeline.Conditions onSuccess;
        java.lang.String transitionDisabledReason;
        java.lang.Boolean transitionToEnabled;

        /**
         * Sets the value of {@link StageProps#getStageName}
         * @param stageName The physical, human-readable name to assign to this Pipeline Stage. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stageName(java.lang.String stageName) {
            this.stageName = stageName;
            return this;
        }

        /**
         * Sets the value of {@link StageProps#getActions}
         * @param actions The list of Actions to create this Stage with.
         *                You can always add more Actions later by calling <code>IStage#addAction</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder actions(java.util.List<? extends software.amazon.awscdk.services.codepipeline.IAction> actions) {
            this.actions = (java.util.List<software.amazon.awscdk.services.codepipeline.IAction>)actions;
            return this;
        }

        /**
         * Sets the value of {@link StageProps#getBeforeEntry}
         * @param beforeEntry The method to use when a stage allows entry.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder beforeEntry(software.amazon.awscdk.services.codepipeline.Conditions beforeEntry) {
            this.beforeEntry = beforeEntry;
            return this;
        }

        /**
         * Sets the value of {@link StageProps#getOnFailure}
         * @param onFailure The method to use when a stage has not completed successfully.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onFailure(software.amazon.awscdk.services.codepipeline.FailureConditions onFailure) {
            this.onFailure = onFailure;
            return this;
        }

        /**
         * Sets the value of {@link StageProps#getOnSuccess}
         * @param onSuccess The method to use when a stage has succeeded.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onSuccess(software.amazon.awscdk.services.codepipeline.Conditions onSuccess) {
            this.onSuccess = onSuccess;
            return this;
        }

        /**
         * Sets the value of {@link StageProps#getTransitionDisabledReason}
         * @param transitionDisabledReason The reason for disabling transition to this stage.
         *                                 Only applicable
         *                                 if <code>transitionToEnabled</code> is set to <code>false</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitionDisabledReason(java.lang.String transitionDisabledReason) {
            this.transitionDisabledReason = transitionDisabledReason;
            return this;
        }

        /**
         * Sets the value of {@link StageProps#getTransitionToEnabled}
         * @param transitionToEnabled Whether to enable transition to this stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitionToEnabled(java.lang.Boolean transitionToEnabled) {
            this.transitionToEnabled = transitionToEnabled;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StageProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StageProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link StageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StageProps {
        private final java.lang.String stageName;
        private final java.util.List<software.amazon.awscdk.services.codepipeline.IAction> actions;
        private final software.amazon.awscdk.services.codepipeline.Conditions beforeEntry;
        private final software.amazon.awscdk.services.codepipeline.FailureConditions onFailure;
        private final software.amazon.awscdk.services.codepipeline.Conditions onSuccess;
        private final java.lang.String transitionDisabledReason;
        private final java.lang.Boolean transitionToEnabled;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.stageName = software.amazon.jsii.Kernel.get(this, "stageName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.actions = software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.IAction.class)));
            this.beforeEntry = software.amazon.jsii.Kernel.get(this, "beforeEntry", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.Conditions.class));
            this.onFailure = software.amazon.jsii.Kernel.get(this, "onFailure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.FailureConditions.class));
            this.onSuccess = software.amazon.jsii.Kernel.get(this, "onSuccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.Conditions.class));
            this.transitionDisabledReason = software.amazon.jsii.Kernel.get(this, "transitionDisabledReason", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.transitionToEnabled = software.amazon.jsii.Kernel.get(this, "transitionToEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.stageName = java.util.Objects.requireNonNull(builder.stageName, "stageName is required");
            this.actions = (java.util.List<software.amazon.awscdk.services.codepipeline.IAction>)builder.actions;
            this.beforeEntry = builder.beforeEntry;
            this.onFailure = builder.onFailure;
            this.onSuccess = builder.onSuccess;
            this.transitionDisabledReason = builder.transitionDisabledReason;
            this.transitionToEnabled = builder.transitionToEnabled;
        }

        @Override
        public final java.lang.String getStageName() {
            return this.stageName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.codepipeline.IAction> getActions() {
            return this.actions;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.Conditions getBeforeEntry() {
            return this.beforeEntry;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.FailureConditions getOnFailure() {
            return this.onFailure;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.Conditions getOnSuccess() {
            return this.onSuccess;
        }

        @Override
        public final java.lang.String getTransitionDisabledReason() {
            return this.transitionDisabledReason;
        }

        @Override
        public final java.lang.Boolean getTransitionToEnabled() {
            return this.transitionToEnabled;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("stageName", om.valueToTree(this.getStageName()));
            if (this.getActions() != null) {
                data.set("actions", om.valueToTree(this.getActions()));
            }
            if (this.getBeforeEntry() != null) {
                data.set("beforeEntry", om.valueToTree(this.getBeforeEntry()));
            }
            if (this.getOnFailure() != null) {
                data.set("onFailure", om.valueToTree(this.getOnFailure()));
            }
            if (this.getOnSuccess() != null) {
                data.set("onSuccess", om.valueToTree(this.getOnSuccess()));
            }
            if (this.getTransitionDisabledReason() != null) {
                data.set("transitionDisabledReason", om.valueToTree(this.getTransitionDisabledReason()));
            }
            if (this.getTransitionToEnabled() != null) {
                data.set("transitionToEnabled", om.valueToTree(this.getTransitionToEnabled()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.StageProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StageProps.Jsii$Proxy that = (StageProps.Jsii$Proxy) o;

            if (!stageName.equals(that.stageName)) return false;
            if (this.actions != null ? !this.actions.equals(that.actions) : that.actions != null) return false;
            if (this.beforeEntry != null ? !this.beforeEntry.equals(that.beforeEntry) : that.beforeEntry != null) return false;
            if (this.onFailure != null ? !this.onFailure.equals(that.onFailure) : that.onFailure != null) return false;
            if (this.onSuccess != null ? !this.onSuccess.equals(that.onSuccess) : that.onSuccess != null) return false;
            if (this.transitionDisabledReason != null ? !this.transitionDisabledReason.equals(that.transitionDisabledReason) : that.transitionDisabledReason != null) return false;
            return this.transitionToEnabled != null ? this.transitionToEnabled.equals(that.transitionToEnabled) : that.transitionToEnabled == null;
        }

        @Override
        public final int hashCode() {
            int result = this.stageName.hashCode();
            result = 31 * result + (this.actions != null ? this.actions.hashCode() : 0);
            result = 31 * result + (this.beforeEntry != null ? this.beforeEntry.hashCode() : 0);
            result = 31 * result + (this.onFailure != null ? this.onFailure.hashCode() : 0);
            result = 31 * result + (this.onSuccess != null ? this.onSuccess.hashCode() : 0);
            result = 31 * result + (this.transitionDisabledReason != null ? this.transitionDisabledReason.hashCode() : 0);
            result = 31 * result + (this.transitionToEnabled != null ? this.transitionToEnabled.hashCode() : 0);
            return result;
        }
    }
}
