package software.amazon.awscdk.services.codepipeline.actions;

/**
 * Construction properties of the <code>EcrBuildAndPublishAction</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.ecr.*;
 * Pipeline pipeline;
 * IRepository repository;
 * Artifact sourceOutput = new Artifact();
 * // your source repository
 * CodeStarConnectionsSourceAction sourceAction = CodeStarConnectionsSourceAction.Builder.create()
 *         .actionName("CodeStarConnectionsSourceAction")
 *         .output(sourceOutput)
 *         .connectionArn("your-connection-arn")
 *         .owner("your-owner")
 *         .repo("your-repo")
 *         .build();
 * EcrBuildAndPublishAction buildAction = EcrBuildAndPublishAction.Builder.create()
 *         .actionName("EcrBuildAndPublishAction")
 *         .repositoryName(repository.getRepositoryName())
 *         .registryType(RegistryType.PRIVATE)
 *         .dockerfileDirectoryPath("./my-dir") // The path indicates ./my-dir/Dockerfile in the source repository
 *         .imageTags(List.of("my-tag-1", "my-tag-2"))
 *         .input(sourceOutput)
 *         .build();
 * pipeline.addStage(StageOptions.builder()
 *         .stageName("Source")
 *         .actions(List.of(sourceAction))
 *         .build());
 * pipeline.addStage(StageOptions.builder()
 *         .stageName("Build")
 *         .actions(List.of(buildAction))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:33.224Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.EcrBuildAndPublishActionProps")
@software.amazon.jsii.Jsii.Proxy(EcrBuildAndPublishActionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EcrBuildAndPublishActionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codepipeline.CommonAwsActionProps {

    /**
     * The artifact produced by the source action that contains the Dockerfile needed to build the image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.Artifact getInput();

    /**
     * The name of the ECR repository where the image is pushed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRepositoryName();

    /**
     * The directory path of Dockerfile used to build the image.
     * <p>
     * Optionally, you can provide an alternate directory path if Dockerfile is not at the root level.
     * <p>
     * Default: - the source repository root level
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDockerfileDirectoryPath() {
        return null;
    }

    /**
     * The tags used for the image.
     * <p>
     * Default: - latest
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getImageTags() {
        return null;
    }

    /**
     * Specifies whether the repository is public or private.
     * <p>
     * Default: - RegistryType.PRIVATE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codepipeline.actions.RegistryType getRegistryType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EcrBuildAndPublishActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EcrBuildAndPublishActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EcrBuildAndPublishActionProps> {
        software.amazon.awscdk.services.codepipeline.Artifact input;
        java.lang.String repositoryName;
        java.lang.String dockerfileDirectoryPath;
        java.util.List<java.lang.String> imageTags;
        software.amazon.awscdk.services.codepipeline.actions.RegistryType registryType;
        software.amazon.awscdk.services.iam.IRole role;
        java.lang.String actionName;
        java.lang.Number runOrder;
        java.lang.String variablesNamespace;

        /**
         * Sets the value of {@link EcrBuildAndPublishActionProps#getInput}
         * @param input The artifact produced by the source action that contains the Dockerfile needed to build the image. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder input(software.amazon.awscdk.services.codepipeline.Artifact input) {
            this.input = input;
            return this;
        }

        /**
         * Sets the value of {@link EcrBuildAndPublishActionProps#getRepositoryName}
         * @param repositoryName The name of the ECR repository where the image is pushed. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repositoryName(java.lang.String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        /**
         * Sets the value of {@link EcrBuildAndPublishActionProps#getDockerfileDirectoryPath}
         * @param dockerfileDirectoryPath The directory path of Dockerfile used to build the image.
         *                                Optionally, you can provide an alternate directory path if Dockerfile is not at the root level.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerfileDirectoryPath(java.lang.String dockerfileDirectoryPath) {
            this.dockerfileDirectoryPath = dockerfileDirectoryPath;
            return this;
        }

        /**
         * Sets the value of {@link EcrBuildAndPublishActionProps#getImageTags}
         * @param imageTags The tags used for the image.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageTags(java.util.List<java.lang.String> imageTags) {
            this.imageTags = imageTags;
            return this;
        }

        /**
         * Sets the value of {@link EcrBuildAndPublishActionProps#getRegistryType}
         * @param registryType Specifies whether the repository is public or private.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder registryType(software.amazon.awscdk.services.codepipeline.actions.RegistryType registryType) {
            this.registryType = registryType;
            return this;
        }

        /**
         * Sets the value of {@link EcrBuildAndPublishActionProps#getRole}
         * @param role The Role in which context's this Action will be executing in.
         *             The Pipeline's Role will assume this Role
         *             (the required permissions for that will be granted automatically)
         *             right before executing this Action.
         *             This Action will be passed into your <code>IAction.bind</code>
         *             method in the <code>ActionBindOptions.role</code> property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link EcrBuildAndPublishActionProps#getActionName}
         * @param actionName The physical, human-readable name of the Action. This parameter is required.
         *                   Note that Action names must be unique within a single Stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionName(java.lang.String actionName) {
            this.actionName = actionName;
            return this;
        }

        /**
         * Sets the value of {@link EcrBuildAndPublishActionProps#getRunOrder}
         * @param runOrder The runOrder property for this Action.
         *                 RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runOrder(java.lang.Number runOrder) {
            this.runOrder = runOrder;
            return this;
        }

        /**
         * Sets the value of {@link EcrBuildAndPublishActionProps#getVariablesNamespace}
         * @param variablesNamespace The name of the namespace to use for variables emitted by this action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variablesNamespace(java.lang.String variablesNamespace) {
            this.variablesNamespace = variablesNamespace;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EcrBuildAndPublishActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EcrBuildAndPublishActionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EcrBuildAndPublishActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EcrBuildAndPublishActionProps {
        private final software.amazon.awscdk.services.codepipeline.Artifact input;
        private final java.lang.String repositoryName;
        private final java.lang.String dockerfileDirectoryPath;
        private final java.util.List<java.lang.String> imageTags;
        private final software.amazon.awscdk.services.codepipeline.actions.RegistryType registryType;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final java.lang.String actionName;
        private final java.lang.Number runOrder;
        private final java.lang.String variablesNamespace;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.input = software.amazon.jsii.Kernel.get(this, "input", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.Artifact.class));
            this.repositoryName = software.amazon.jsii.Kernel.get(this, "repositoryName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dockerfileDirectoryPath = software.amazon.jsii.Kernel.get(this, "dockerfileDirectoryPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.imageTags = software.amazon.jsii.Kernel.get(this, "imageTags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.registryType = software.amazon.jsii.Kernel.get(this, "registryType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.RegistryType.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.actionName = software.amazon.jsii.Kernel.get(this, "actionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.runOrder = software.amazon.jsii.Kernel.get(this, "runOrder", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.variablesNamespace = software.amazon.jsii.Kernel.get(this, "variablesNamespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.input = java.util.Objects.requireNonNull(builder.input, "input is required");
            this.repositoryName = java.util.Objects.requireNonNull(builder.repositoryName, "repositoryName is required");
            this.dockerfileDirectoryPath = builder.dockerfileDirectoryPath;
            this.imageTags = builder.imageTags;
            this.registryType = builder.registryType;
            this.role = builder.role;
            this.actionName = java.util.Objects.requireNonNull(builder.actionName, "actionName is required");
            this.runOrder = builder.runOrder;
            this.variablesNamespace = builder.variablesNamespace;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.Artifact getInput() {
            return this.input;
        }

        @Override
        public final java.lang.String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final java.lang.String getDockerfileDirectoryPath() {
            return this.dockerfileDirectoryPath;
        }

        @Override
        public final java.util.List<java.lang.String> getImageTags() {
            return this.imageTags;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.actions.RegistryType getRegistryType() {
            return this.registryType;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final java.lang.String getActionName() {
            return this.actionName;
        }

        @Override
        public final java.lang.Number getRunOrder() {
            return this.runOrder;
        }

        @Override
        public final java.lang.String getVariablesNamespace() {
            return this.variablesNamespace;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("input", om.valueToTree(this.getInput()));
            data.set("repositoryName", om.valueToTree(this.getRepositoryName()));
            if (this.getDockerfileDirectoryPath() != null) {
                data.set("dockerfileDirectoryPath", om.valueToTree(this.getDockerfileDirectoryPath()));
            }
            if (this.getImageTags() != null) {
                data.set("imageTags", om.valueToTree(this.getImageTags()));
            }
            if (this.getRegistryType() != null) {
                data.set("registryType", om.valueToTree(this.getRegistryType()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            data.set("actionName", om.valueToTree(this.getActionName()));
            if (this.getRunOrder() != null) {
                data.set("runOrder", om.valueToTree(this.getRunOrder()));
            }
            if (this.getVariablesNamespace() != null) {
                data.set("variablesNamespace", om.valueToTree(this.getVariablesNamespace()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline_actions.EcrBuildAndPublishActionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EcrBuildAndPublishActionProps.Jsii$Proxy that = (EcrBuildAndPublishActionProps.Jsii$Proxy) o;

            if (!input.equals(that.input)) return false;
            if (!repositoryName.equals(that.repositoryName)) return false;
            if (this.dockerfileDirectoryPath != null ? !this.dockerfileDirectoryPath.equals(that.dockerfileDirectoryPath) : that.dockerfileDirectoryPath != null) return false;
            if (this.imageTags != null ? !this.imageTags.equals(that.imageTags) : that.imageTags != null) return false;
            if (this.registryType != null ? !this.registryType.equals(that.registryType) : that.registryType != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (!actionName.equals(that.actionName)) return false;
            if (this.runOrder != null ? !this.runOrder.equals(that.runOrder) : that.runOrder != null) return false;
            return this.variablesNamespace != null ? this.variablesNamespace.equals(that.variablesNamespace) : that.variablesNamespace == null;
        }

        @Override
        public final int hashCode() {
            int result = this.input.hashCode();
            result = 31 * result + (this.repositoryName.hashCode());
            result = 31 * result + (this.dockerfileDirectoryPath != null ? this.dockerfileDirectoryPath.hashCode() : 0);
            result = 31 * result + (this.imageTags != null ? this.imageTags.hashCode() : 0);
            result = 31 * result + (this.registryType != null ? this.registryType.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.actionName.hashCode());
            result = 31 * result + (this.runOrder != null ? this.runOrder.hashCode() : 0);
            result = 31 * result + (this.variablesNamespace != null ? this.variablesNamespace.hashCode() : 0);
            return result;
        }
    }
}
