package software.amazon.awscdk.services.codepipeline.actions;

/**
 * Properties for configuring service-managed (Organizations) permissions.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codepipeline.actions.*;
 * OrganizationsDeploymentProps organizationsDeploymentProps = OrganizationsDeploymentProps.builder()
 *         .autoDeployment(StackSetOrganizationsAutoDeployment.ENABLED)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:33.260Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.OrganizationsDeploymentProps")
@software.amazon.jsii.Jsii.Proxy(OrganizationsDeploymentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface OrganizationsDeploymentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Automatically deploy to new accounts added to Organizational Units.
     * <p>
     * Whether AWS CloudFormation StackSets automatically deploys to AWS
     * Organizations accounts that are added to a target organization or
     * organizational unit (OU).
     * <p>
     * Default: Disabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codepipeline.actions.StackSetOrganizationsAutoDeployment getAutoDeployment() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link OrganizationsDeploymentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link OrganizationsDeploymentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<OrganizationsDeploymentProps> {
        software.amazon.awscdk.services.codepipeline.actions.StackSetOrganizationsAutoDeployment autoDeployment;

        /**
         * Sets the value of {@link OrganizationsDeploymentProps#getAutoDeployment}
         * @param autoDeployment Automatically deploy to new accounts added to Organizational Units.
         *                       Whether AWS CloudFormation StackSets automatically deploys to AWS
         *                       Organizations accounts that are added to a target organization or
         *                       organizational unit (OU).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoDeployment(software.amazon.awscdk.services.codepipeline.actions.StackSetOrganizationsAutoDeployment autoDeployment) {
            this.autoDeployment = autoDeployment;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link OrganizationsDeploymentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public OrganizationsDeploymentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link OrganizationsDeploymentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OrganizationsDeploymentProps {
        private final software.amazon.awscdk.services.codepipeline.actions.StackSetOrganizationsAutoDeployment autoDeployment;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.autoDeployment = software.amazon.jsii.Kernel.get(this, "autoDeployment", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.StackSetOrganizationsAutoDeployment.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.autoDeployment = builder.autoDeployment;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.actions.StackSetOrganizationsAutoDeployment getAutoDeployment() {
            return this.autoDeployment;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAutoDeployment() != null) {
                data.set("autoDeployment", om.valueToTree(this.getAutoDeployment()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline_actions.OrganizationsDeploymentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            OrganizationsDeploymentProps.Jsii$Proxy that = (OrganizationsDeploymentProps.Jsii$Proxy) o;

            return this.autoDeployment != null ? this.autoDeployment.equals(that.autoDeployment) : that.autoDeployment == null;
        }

        @Override
        public final int hashCode() {
            int result = this.autoDeployment != null ? this.autoDeployment.hashCode() : 0;
            return result;
        }
    }
}
