package software.amazon.awscdk.services.codepipeline.actions;

/**
 * CodePipeline action to invoke a pipeline.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.codepipeline.actions.*;
 * Pipeline pipeline = new Pipeline(this, "MyPipeline");
 * IPipeline targetPipeline = Pipeline.fromPipelineArn(this, "Pipeline", "arn:aws:codepipeline:us-east-1:123456789012:InvokePipelineAction"); // If targetPipeline is not created by cdk, import from arn.
 * pipeline.addStage(StageOptions.builder()
 *         .stageName("stageName")
 *         .actions(List.of(PipelineInvokeAction.Builder.create()
 *                 .actionName("Invoke")
 *                 .targetPipeline(targetPipeline)
 *                 .variables(List.of(Variable.builder()
 *                         .name("name1")
 *                         .value("value1")
 *                         .build()))
 *                 .sourceRevisions(List.of(SourceRevision.builder()
 *                         .actionName("Source")
 *                         .revisionType(RevisionType.S3_OBJECT_VERSION_ID)
 *                         .revisionValue("testRevisionValue")
 *                         .build()))
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:33.260Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.PipelineInvokeAction")
public class PipelineInvokeAction extends software.amazon.awscdk.services.codepipeline.actions.Action {

    protected PipelineInvokeAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PipelineInvokeAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public PipelineInvokeAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.PipelineInvokeActionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * This is a renamed version of the <code>IAction.bind</code> method.
     * <p>
     * @param scope This parameter is required.
     * @param _stage This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionConfig bound(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.IStage _stage, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionBindOptions options) {
        return software.amazon.jsii.Kernel.call(this, "bound", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.ActionConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(_stage, "_stage is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codepipeline.actions.PipelineInvokeAction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codepipeline.actions.PipelineInvokeAction> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.codepipeline.actions.PipelineInvokeActionProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.codepipeline.actions.PipelineInvokeActionProps.Builder();
        }

        /**
         * The physical, human-readable name of the Action.
         * <p>
         * Note that Action names must be unique within a single Stage.
         * <p>
         * @return {@code this}
         * @param actionName The physical, human-readable name of the Action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionName(final java.lang.String actionName) {
            this.props.actionName(actionName);
            return this;
        }

        /**
         * The runOrder property for this Action.
         * <p>
         * RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html">https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html</a>
         * @param runOrder The runOrder property for this Action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runOrder(final java.lang.Number runOrder) {
            this.props.runOrder(runOrder);
            return this;
        }

        /**
         * The name of the namespace to use for variables emitted by this action.
         * <p>
         * Default: - a name will be generated, based on the stage and action names,
         * if any of the action's variables were referenced - otherwise,
         * no namespace will be set
         * <p>
         * @return {@code this}
         * @param variablesNamespace The name of the namespace to use for variables emitted by this action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variablesNamespace(final java.lang.String variablesNamespace) {
            this.props.variablesNamespace(variablesNamespace);
            return this;
        }

        /**
         * The Role in which context's this Action will be executing in.
         * <p>
         * The Pipeline's Role will assume this Role
         * (the required permissions for that will be granted automatically)
         * right before executing this Action.
         * This Action will be passed into your <code>IAction.bind</code>
         * method in the <code>ActionBindOptions.role</code> property.
         * <p>
         * Default: a new Role will be generated
         * <p>
         * @return {@code this}
         * @param role The Role in which context's this Action will be executing in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * The pipeline that will, upon running, start the current target pipeline.
         * <p>
         * You must have already created the invoking pipeline.
         * <p>
         * @return {@code this}
         * @param targetPipeline The pipeline that will, upon running, start the current target pipeline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetPipeline(final software.amazon.awscdk.services.codepipeline.IPipeline targetPipeline) {
            this.props.targetPipeline(targetPipeline);
            return this;
        }

        /**
         * The source revisions that you want the target pipeline to use when it is started by the invoking pipeline.
         * <p>
         * Default: - no specific revisions
         * <p>
         * @return {@code this}
         * @param sourceRevisions The source revisions that you want the target pipeline to use when it is started by the invoking pipeline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceRevisions(final java.util.List<? extends software.amazon.awscdk.services.codepipeline.actions.SourceRevision> sourceRevisions) {
            this.props.sourceRevisions(sourceRevisions);
            return this;
        }

        /**
         * The names and values of variables that you want the action to support.
         * <p>
         * Default: - no specific variable
         * <p>
         * @return {@code this}
         * @param variables The names and values of variables that you want the action to support. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variables(final java.util.List<? extends software.amazon.awscdk.services.codepipeline.actions.Variable> variables) {
            this.props.variables(variables);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.codepipeline.actions.PipelineInvokeAction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codepipeline.actions.PipelineInvokeAction build() {
            return new software.amazon.awscdk.services.codepipeline.actions.PipelineInvokeAction(
                this.props.build()
            );
        }
    }
}
