package software.amazon.awscdk.services.codepipeline.actions;

/**
 * Construction properties of the <code>PipelineInvokeAction</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.codepipeline.actions.*;
 * Pipeline pipeline = new Pipeline(this, "MyPipeline");
 * IPipeline targetPipeline = Pipeline.fromPipelineArn(this, "Pipeline", "arn:aws:codepipeline:us-east-1:123456789012:InvokePipelineAction"); // If targetPipeline is not created by cdk, import from arn.
 * pipeline.addStage(StageOptions.builder()
 *         .stageName("stageName")
 *         .actions(List.of(PipelineInvokeAction.Builder.create()
 *                 .actionName("Invoke")
 *                 .targetPipeline(targetPipeline)
 *                 .variables(List.of(Variable.builder()
 *                         .name("name1")
 *                         .value("value1")
 *                         .build()))
 *                 .sourceRevisions(List.of(SourceRevision.builder()
 *                         .actionName("Source")
 *                         .revisionType(RevisionType.S3_OBJECT_VERSION_ID)
 *                         .revisionValue("testRevisionValue")
 *                         .build()))
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:33.261Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.PipelineInvokeActionProps")
@software.amazon.jsii.Jsii.Proxy(PipelineInvokeActionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PipelineInvokeActionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codepipeline.CommonAwsActionProps {

    /**
     * The pipeline that will, upon running, start the current target pipeline.
     * <p>
     * You must have already created the invoking pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.IPipeline getTargetPipeline();

    /**
     * The source revisions that you want the target pipeline to use when it is started by the invoking pipeline.
     * <p>
     * Default: - no specific revisions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.codepipeline.actions.SourceRevision> getSourceRevisions() {
        return null;
    }

    /**
     * The names and values of variables that you want the action to support.
     * <p>
     * Default: - no specific variable
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.codepipeline.actions.Variable> getVariables() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link PipelineInvokeActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PipelineInvokeActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PipelineInvokeActionProps> {
        software.amazon.awscdk.services.codepipeline.IPipeline targetPipeline;
        java.util.List<software.amazon.awscdk.services.codepipeline.actions.SourceRevision> sourceRevisions;
        java.util.List<software.amazon.awscdk.services.codepipeline.actions.Variable> variables;
        software.amazon.awscdk.services.iam.IRole role;
        java.lang.String actionName;
        java.lang.Number runOrder;
        java.lang.String variablesNamespace;

        /**
         * Sets the value of {@link PipelineInvokeActionProps#getTargetPipeline}
         * @param targetPipeline The pipeline that will, upon running, start the current target pipeline. This parameter is required.
         *                       You must have already created the invoking pipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetPipeline(software.amazon.awscdk.services.codepipeline.IPipeline targetPipeline) {
            this.targetPipeline = targetPipeline;
            return this;
        }

        /**
         * Sets the value of {@link PipelineInvokeActionProps#getSourceRevisions}
         * @param sourceRevisions The source revisions that you want the target pipeline to use when it is started by the invoking pipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder sourceRevisions(java.util.List<? extends software.amazon.awscdk.services.codepipeline.actions.SourceRevision> sourceRevisions) {
            this.sourceRevisions = (java.util.List<software.amazon.awscdk.services.codepipeline.actions.SourceRevision>)sourceRevisions;
            return this;
        }

        /**
         * Sets the value of {@link PipelineInvokeActionProps#getVariables}
         * @param variables The names and values of variables that you want the action to support.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder variables(java.util.List<? extends software.amazon.awscdk.services.codepipeline.actions.Variable> variables) {
            this.variables = (java.util.List<software.amazon.awscdk.services.codepipeline.actions.Variable>)variables;
            return this;
        }

        /**
         * Sets the value of {@link PipelineInvokeActionProps#getRole}
         * @param role The Role in which context's this Action will be executing in.
         *             The Pipeline's Role will assume this Role
         *             (the required permissions for that will be granted automatically)
         *             right before executing this Action.
         *             This Action will be passed into your <code>IAction.bind</code>
         *             method in the <code>ActionBindOptions.role</code> property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link PipelineInvokeActionProps#getActionName}
         * @param actionName The physical, human-readable name of the Action. This parameter is required.
         *                   Note that Action names must be unique within a single Stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionName(java.lang.String actionName) {
            this.actionName = actionName;
            return this;
        }

        /**
         * Sets the value of {@link PipelineInvokeActionProps#getRunOrder}
         * @param runOrder The runOrder property for this Action.
         *                 RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runOrder(java.lang.Number runOrder) {
            this.runOrder = runOrder;
            return this;
        }

        /**
         * Sets the value of {@link PipelineInvokeActionProps#getVariablesNamespace}
         * @param variablesNamespace The name of the namespace to use for variables emitted by this action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variablesNamespace(java.lang.String variablesNamespace) {
            this.variablesNamespace = variablesNamespace;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PipelineInvokeActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PipelineInvokeActionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PipelineInvokeActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PipelineInvokeActionProps {
        private final software.amazon.awscdk.services.codepipeline.IPipeline targetPipeline;
        private final java.util.List<software.amazon.awscdk.services.codepipeline.actions.SourceRevision> sourceRevisions;
        private final java.util.List<software.amazon.awscdk.services.codepipeline.actions.Variable> variables;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final java.lang.String actionName;
        private final java.lang.Number runOrder;
        private final java.lang.String variablesNamespace;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.targetPipeline = software.amazon.jsii.Kernel.get(this, "targetPipeline", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.IPipeline.class));
            this.sourceRevisions = software.amazon.jsii.Kernel.get(this, "sourceRevisions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.SourceRevision.class)));
            this.variables = software.amazon.jsii.Kernel.get(this, "variables", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.Variable.class)));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.actionName = software.amazon.jsii.Kernel.get(this, "actionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.runOrder = software.amazon.jsii.Kernel.get(this, "runOrder", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.variablesNamespace = software.amazon.jsii.Kernel.get(this, "variablesNamespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.targetPipeline = java.util.Objects.requireNonNull(builder.targetPipeline, "targetPipeline is required");
            this.sourceRevisions = (java.util.List<software.amazon.awscdk.services.codepipeline.actions.SourceRevision>)builder.sourceRevisions;
            this.variables = (java.util.List<software.amazon.awscdk.services.codepipeline.actions.Variable>)builder.variables;
            this.role = builder.role;
            this.actionName = java.util.Objects.requireNonNull(builder.actionName, "actionName is required");
            this.runOrder = builder.runOrder;
            this.variablesNamespace = builder.variablesNamespace;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.IPipeline getTargetPipeline() {
            return this.targetPipeline;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.codepipeline.actions.SourceRevision> getSourceRevisions() {
            return this.sourceRevisions;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.codepipeline.actions.Variable> getVariables() {
            return this.variables;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final java.lang.String getActionName() {
            return this.actionName;
        }

        @Override
        public final java.lang.Number getRunOrder() {
            return this.runOrder;
        }

        @Override
        public final java.lang.String getVariablesNamespace() {
            return this.variablesNamespace;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("targetPipeline", om.valueToTree(this.getTargetPipeline()));
            if (this.getSourceRevisions() != null) {
                data.set("sourceRevisions", om.valueToTree(this.getSourceRevisions()));
            }
            if (this.getVariables() != null) {
                data.set("variables", om.valueToTree(this.getVariables()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            data.set("actionName", om.valueToTree(this.getActionName()));
            if (this.getRunOrder() != null) {
                data.set("runOrder", om.valueToTree(this.getRunOrder()));
            }
            if (this.getVariablesNamespace() != null) {
                data.set("variablesNamespace", om.valueToTree(this.getVariablesNamespace()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline_actions.PipelineInvokeActionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PipelineInvokeActionProps.Jsii$Proxy that = (PipelineInvokeActionProps.Jsii$Proxy) o;

            if (!targetPipeline.equals(that.targetPipeline)) return false;
            if (this.sourceRevisions != null ? !this.sourceRevisions.equals(that.sourceRevisions) : that.sourceRevisions != null) return false;
            if (this.variables != null ? !this.variables.equals(that.variables) : that.variables != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (!actionName.equals(that.actionName)) return false;
            if (this.runOrder != null ? !this.runOrder.equals(that.runOrder) : that.runOrder != null) return false;
            return this.variablesNamespace != null ? this.variablesNamespace.equals(that.variablesNamespace) : that.variablesNamespace == null;
        }

        @Override
        public final int hashCode() {
            int result = this.targetPipeline.hashCode();
            result = 31 * result + (this.sourceRevisions != null ? this.sourceRevisions.hashCode() : 0);
            result = 31 * result + (this.variables != null ? this.variables.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.actionName.hashCode());
            result = 31 * result + (this.runOrder != null ? this.runOrder.hashCode() : 0);
            result = 31 * result + (this.variablesNamespace != null ? this.variablesNamespace.hashCode() : 0);
            return result;
        }
    }
}
