package software.amazon.awscdk.services.codepipeline.actions;

/**
 * The type of registry to use for the EcrBuildAndPublish action.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.ecr.*;
 * Pipeline pipeline;
 * IRepository repository;
 * Artifact sourceOutput = new Artifact();
 * // your source repository
 * CodeStarConnectionsSourceAction sourceAction = CodeStarConnectionsSourceAction.Builder.create()
 *         .actionName("CodeStarConnectionsSourceAction")
 *         .output(sourceOutput)
 *         .connectionArn("your-connection-arn")
 *         .owner("your-owner")
 *         .repo("your-repo")
 *         .build();
 * EcrBuildAndPublishAction buildAction = EcrBuildAndPublishAction.Builder.create()
 *         .actionName("EcrBuildAndPublishAction")
 *         .repositoryName(repository.getRepositoryName())
 *         .registryType(RegistryType.PRIVATE)
 *         .dockerfileDirectoryPath("./my-dir") // The path indicates ./my-dir/Dockerfile in the source repository
 *         .imageTags(List.of("my-tag-1", "my-tag-2"))
 *         .input(sourceOutput)
 *         .build();
 * pipeline.addStage(StageOptions.builder()
 *         .stageName("Source")
 *         .actions(List.of(sourceAction))
 *         .build());
 * pipeline.addStage(StageOptions.builder()
 *         .stageName("Build")
 *         .actions(List.of(buildAction))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:33.261Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.RegistryType")
public enum RegistryType {
    /**
     * Private registry.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PRIVATE,
    /**
     * Public registry.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PUBLIC,
}
