package software.amazon.awscdk.services.cognito;

/**
 * The types of authentication that you want to allow for users' first authentication prompt.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool.Builder.create(this, "myuserpool")
 *         .signInPolicy(SignInPolicy.builder()
 *                 .allowedFirstAuthFactors(AllowedFirstAuthFactors.builder().password(true).passkey(true).build())
 *                 .build())
 *         .passkeyRelyingPartyId("auth.example.com")
 *         .passkeyUserVerification(PasskeyUserVerification.REQUIRED)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flows-selection-sdk.html#authentication-flows-selection-choice">https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flows-selection-sdk.html#authentication-flows-selection-choice</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:33.317Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.AllowedFirstAuthFactors")
@software.amazon.jsii.Jsii.Proxy(AllowedFirstAuthFactors.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AllowedFirstAuthFactors extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether the password authentication is allowed.
     * <p>
     * This must be true.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Boolean getPassword();

    /**
     * Whether the email message one-time password is allowed.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEmailOtp() {
        return null;
    }

    /**
     * Whether the Passkey (WebAuthn) is allowed.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPasskey() {
        return null;
    }

    /**
     * Whether the SMS message one-time password is allowed.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSmsOtp() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AllowedFirstAuthFactors}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AllowedFirstAuthFactors}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AllowedFirstAuthFactors> {
        java.lang.Boolean password;
        java.lang.Boolean emailOtp;
        java.lang.Boolean passkey;
        java.lang.Boolean smsOtp;

        /**
         * Sets the value of {@link AllowedFirstAuthFactors#getPassword}
         * @param password Whether the password authentication is allowed. This parameter is required.
         *                 This must be true.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder password(java.lang.Boolean password) {
            this.password = password;
            return this;
        }

        /**
         * Sets the value of {@link AllowedFirstAuthFactors#getEmailOtp}
         * @param emailOtp Whether the email message one-time password is allowed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder emailOtp(java.lang.Boolean emailOtp) {
            this.emailOtp = emailOtp;
            return this;
        }

        /**
         * Sets the value of {@link AllowedFirstAuthFactors#getPasskey}
         * @param passkey Whether the Passkey (WebAuthn) is allowed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder passkey(java.lang.Boolean passkey) {
            this.passkey = passkey;
            return this;
        }

        /**
         * Sets the value of {@link AllowedFirstAuthFactors#getSmsOtp}
         * @param smsOtp Whether the SMS message one-time password is allowed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder smsOtp(java.lang.Boolean smsOtp) {
            this.smsOtp = smsOtp;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AllowedFirstAuthFactors}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AllowedFirstAuthFactors build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AllowedFirstAuthFactors}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AllowedFirstAuthFactors {
        private final java.lang.Boolean password;
        private final java.lang.Boolean emailOtp;
        private final java.lang.Boolean passkey;
        private final java.lang.Boolean smsOtp;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.password = software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.emailOtp = software.amazon.jsii.Kernel.get(this, "emailOtp", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.passkey = software.amazon.jsii.Kernel.get(this, "passkey", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.smsOtp = software.amazon.jsii.Kernel.get(this, "smsOtp", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.password = java.util.Objects.requireNonNull(builder.password, "password is required");
            this.emailOtp = builder.emailOtp;
            this.passkey = builder.passkey;
            this.smsOtp = builder.smsOtp;
        }

        @Override
        public final java.lang.Boolean getPassword() {
            return this.password;
        }

        @Override
        public final java.lang.Boolean getEmailOtp() {
            return this.emailOtp;
        }

        @Override
        public final java.lang.Boolean getPasskey() {
            return this.passkey;
        }

        @Override
        public final java.lang.Boolean getSmsOtp() {
            return this.smsOtp;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("password", om.valueToTree(this.getPassword()));
            if (this.getEmailOtp() != null) {
                data.set("emailOtp", om.valueToTree(this.getEmailOtp()));
            }
            if (this.getPasskey() != null) {
                data.set("passkey", om.valueToTree(this.getPasskey()));
            }
            if (this.getSmsOtp() != null) {
                data.set("smsOtp", om.valueToTree(this.getSmsOtp()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.AllowedFirstAuthFactors"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AllowedFirstAuthFactors.Jsii$Proxy that = (AllowedFirstAuthFactors.Jsii$Proxy) o;

            if (!password.equals(that.password)) return false;
            if (this.emailOtp != null ? !this.emailOtp.equals(that.emailOtp) : that.emailOtp != null) return false;
            if (this.passkey != null ? !this.passkey.equals(that.passkey) : that.passkey != null) return false;
            return this.smsOtp != null ? this.smsOtp.equals(that.smsOtp) : that.smsOtp == null;
        }

        @Override
        public final int hashCode() {
            int result = this.password.hashCode();
            result = 31 * result + (this.emailOtp != null ? this.emailOtp.hashCode() : 0);
            result = 31 * result + (this.passkey != null ? this.passkey.hashCode() : 0);
            result = 31 * result + (this.smsOtp != null ? this.smsOtp.hashCode() : 0);
            return result;
        }
    }
}
