package software.amazon.awscdk.services.cognito;

/**
 * The settings for Amazon Pinpoint analytics configuration.
 * <p>
 * With an analytics configuration, your application can collect user-activity metrics for user notifications with an Amazon Pinpoint campaign.
 * Amazon Pinpoint isn't available in all AWS Regions.
 * For a list of available Regions, see Amazon Cognito and Amazon Pinpoint Region availability: https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-pinpoint-integration.html#cognito-user-pools-find-region-mappings.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.pinpoint.*;
 * UserPool userPool;
 * CfnApp pinpointApp;
 * Role pinpointRole;
 * UserPoolClient.Builder.create(this, "Client")
 *         .userPool(userPool)
 *         .analytics(AnalyticsConfiguration.builder()
 *                 // Your Pinpoint project
 *                 .application(pinpointApp)
 *                 // Whether to include user data in analytics events
 *                 .shareUserData(true)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:33.317Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.AnalyticsConfiguration")
@software.amazon.jsii.Jsii.Proxy(AnalyticsConfiguration.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AnalyticsConfiguration extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Pinpoint project that you want to connect to your user pool app client.
     * <p>
     * Amazon Cognito publishes events to the Amazon Pinpoint project.
     * You can also configure your application to pass an endpoint ID in the <code>AnalyticsMetadata</code> parameter of sign-in operations.
     * The endpoint ID is information about the destination for push notifications.
     * <p>
     * Default: - no configuration, you need to specify either `application` or all of `applicationId`, `externalId`, and `role`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.pinpoint.CfnApp getApplication() {
        return null;
    }

    /**
     * Your Amazon Pinpoint project ID.
     * <p>
     * Default: - no configuration, you need to specify either this property along with `externalId` and `role` or `application`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getApplicationId() {
        return null;
    }

    /**
     * The external ID of the role that Amazon Cognito assumes to send analytics data to Amazon Pinpoint.
     * <p>
     * More info here: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html
     * <p>
     * Default: - no configuration, you need to specify either this property along with `applicationId` and `role` or `application`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getExternalId() {
        return null;
    }

    /**
     * The IAM role that has the permissions required for Amazon Cognito to publish events to Amazon Pinpoint analytics.
     * <p>
     * Default: - no configuration, you need to specify either this property along with `applicationId` and `externalId` or `application`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * If <code>true</code>, Amazon Cognito includes user data in the events that it publishes to Amazon Pinpoint analytics.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getShareUserData() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AnalyticsConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AnalyticsConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AnalyticsConfiguration> {
        software.amazon.awscdk.services.pinpoint.CfnApp application;
        java.lang.String applicationId;
        java.lang.String externalId;
        software.amazon.awscdk.services.iam.IRole role;
        java.lang.Boolean shareUserData;

        /**
         * Sets the value of {@link AnalyticsConfiguration#getApplication}
         * @param application The Amazon Pinpoint project that you want to connect to your user pool app client.
         *                    Amazon Cognito publishes events to the Amazon Pinpoint project.
         *                    You can also configure your application to pass an endpoint ID in the <code>AnalyticsMetadata</code> parameter of sign-in operations.
         *                    The endpoint ID is information about the destination for push notifications.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder application(software.amazon.awscdk.services.pinpoint.CfnApp application) {
            this.application = application;
            return this;
        }

        /**
         * Sets the value of {@link AnalyticsConfiguration#getApplicationId}
         * @param applicationId Your Amazon Pinpoint project ID.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationId(java.lang.String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        /**
         * Sets the value of {@link AnalyticsConfiguration#getExternalId}
         * @param externalId The external ID of the role that Amazon Cognito assumes to send analytics data to Amazon Pinpoint.
         *                   More info here: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder externalId(java.lang.String externalId) {
            this.externalId = externalId;
            return this;
        }

        /**
         * Sets the value of {@link AnalyticsConfiguration#getRole}
         * @param role The IAM role that has the permissions required for Amazon Cognito to publish events to Amazon Pinpoint analytics.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link AnalyticsConfiguration#getShareUserData}
         * @param shareUserData If <code>true</code>, Amazon Cognito includes user data in the events that it publishes to Amazon Pinpoint analytics.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder shareUserData(java.lang.Boolean shareUserData) {
            this.shareUserData = shareUserData;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AnalyticsConfiguration}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AnalyticsConfiguration build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AnalyticsConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AnalyticsConfiguration {
        private final software.amazon.awscdk.services.pinpoint.CfnApp application;
        private final java.lang.String applicationId;
        private final java.lang.String externalId;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final java.lang.Boolean shareUserData;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.application = software.amazon.jsii.Kernel.get(this, "application", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.pinpoint.CfnApp.class));
            this.applicationId = software.amazon.jsii.Kernel.get(this, "applicationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.externalId = software.amazon.jsii.Kernel.get(this, "externalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.shareUserData = software.amazon.jsii.Kernel.get(this, "shareUserData", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.application = builder.application;
            this.applicationId = builder.applicationId;
            this.externalId = builder.externalId;
            this.role = builder.role;
            this.shareUserData = builder.shareUserData;
        }

        @Override
        public final software.amazon.awscdk.services.pinpoint.CfnApp getApplication() {
            return this.application;
        }

        @Override
        public final java.lang.String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final java.lang.String getExternalId() {
            return this.externalId;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final java.lang.Boolean getShareUserData() {
            return this.shareUserData;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getApplication() != null) {
                data.set("application", om.valueToTree(this.getApplication()));
            }
            if (this.getApplicationId() != null) {
                data.set("applicationId", om.valueToTree(this.getApplicationId()));
            }
            if (this.getExternalId() != null) {
                data.set("externalId", om.valueToTree(this.getExternalId()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getShareUserData() != null) {
                data.set("shareUserData", om.valueToTree(this.getShareUserData()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.AnalyticsConfiguration"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AnalyticsConfiguration.Jsii$Proxy that = (AnalyticsConfiguration.Jsii$Proxy) o;

            if (this.application != null ? !this.application.equals(that.application) : that.application != null) return false;
            if (this.applicationId != null ? !this.applicationId.equals(that.applicationId) : that.applicationId != null) return false;
            if (this.externalId != null ? !this.externalId.equals(that.externalId) : that.externalId != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            return this.shareUserData != null ? this.shareUserData.equals(that.shareUserData) : that.shareUserData == null;
        }

        @Override
        public final int hashCode() {
            int result = this.application != null ? this.application.hashCode() : 0;
            result = 31 * result + (this.applicationId != null ? this.applicationId.hashCode() : 0);
            result = 31 * result + (this.externalId != null ? this.externalId.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.shareUserData != null ? this.shareUserData.hashCode() : 0);
            return result;
        }
    }
}
