package software.amazon.awscdk.services.cognito;

/**
 * Attributes that can be automatically verified for users in a user pool.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool.Builder.create(this, "myuserpool")
 *         // ...
 *         // ...
 *         .signInAliases(SignInAliases.builder().username(true).email(true).build())
 *         .autoVerify(AutoVerifiedAttrs.builder().email(true).phone(true).build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:33.319Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.AutoVerifiedAttrs")
@software.amazon.jsii.Jsii.Proxy(AutoVerifiedAttrs.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AutoVerifiedAttrs extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether the email address of the user should be auto verified at sign up.
     * <p>
     * Note: If both <code>email</code> and <code>phone</code> is set, Cognito only verifies the phone number. To also verify email, see here -
     * https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html
     * <p>
     * Default: - true, if email is turned on for `signIn`. false, otherwise.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEmail() {
        return null;
    }

    /**
     * Whether the phone number of the user should be auto verified at sign up.
     * <p>
     * Default: - true, if phone is turned on for `signIn`. false, otherwise.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPhone() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AutoVerifiedAttrs}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AutoVerifiedAttrs}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AutoVerifiedAttrs> {
        java.lang.Boolean email;
        java.lang.Boolean phone;

        /**
         * Sets the value of {@link AutoVerifiedAttrs#getEmail}
         * @param email Whether the email address of the user should be auto verified at sign up.
         *              Note: If both <code>email</code> and <code>phone</code> is set, Cognito only verifies the phone number. To also verify email, see here -
         *              https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder email(java.lang.Boolean email) {
            this.email = email;
            return this;
        }

        /**
         * Sets the value of {@link AutoVerifiedAttrs#getPhone}
         * @param phone Whether the phone number of the user should be auto verified at sign up.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder phone(java.lang.Boolean phone) {
            this.phone = phone;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AutoVerifiedAttrs}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AutoVerifiedAttrs build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AutoVerifiedAttrs}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutoVerifiedAttrs {
        private final java.lang.Boolean email;
        private final java.lang.Boolean phone;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.email = software.amazon.jsii.Kernel.get(this, "email", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.phone = software.amazon.jsii.Kernel.get(this, "phone", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.email = builder.email;
            this.phone = builder.phone;
        }

        @Override
        public final java.lang.Boolean getEmail() {
            return this.email;
        }

        @Override
        public final java.lang.Boolean getPhone() {
            return this.phone;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getEmail() != null) {
                data.set("email", om.valueToTree(this.getEmail()));
            }
            if (this.getPhone() != null) {
                data.set("phone", om.valueToTree(this.getPhone()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.AutoVerifiedAttrs"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AutoVerifiedAttrs.Jsii$Proxy that = (AutoVerifiedAttrs.Jsii$Proxy) o;

            if (this.email != null ? !this.email.equals(that.email) : that.email != null) return false;
            return this.phone != null ? this.phone.equals(that.phone) : that.phone == null;
        }

        @Override
        public final int hashCode() {
            int result = this.email != null ? this.email.hashCode() : 0;
            result = 31 * result + (this.phone != null ? this.phone.hashCode() : 0);
            return result;
        }
    }
}
