package software.amazon.awscdk.services.cognito;

/**
 * Define a user pool group.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool userPool;
 * Role role;
 * UserPoolGroup.Builder.create(this, "UserPoolGroup")
 *         .userPool(userPool)
 *         .groupName("my-group-name")
 *         .precedence(1)
 *         .role(role)
 *         .build();
 * // You can also add a group by using addGroup method.
 * userPool.addGroup("AnotherUserPoolGroup", UserPoolGroupOptions.builder()
 *         .groupName("another-group-name")
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:33.453Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.UserPoolGroup")
public class UserPoolGroup extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.cognito.IUserPoolGroup {

    protected UserPoolGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected UserPoolGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.UserPoolGroup.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public UserPoolGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.UserPoolGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import a UserPoolGroup given its group name.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param groupName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.IUserPoolGroup fromGroupName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String groupName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cognito.UserPoolGroup.class, "fromGroupName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.IUserPoolGroup.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(groupName, "groupName is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * The user group name.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getGroupName() {
        return software.amazon.jsii.Kernel.get(this, "groupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cognito.UserPoolGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cognito.UserPoolGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cognito.UserPoolGroupProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cognito.UserPoolGroupProps.Builder();
        }

        /**
         * A string containing the description of the group.
         * <p>
         * Default: - no description
         * <p>
         * @return {@code this}
         * @param description A string containing the description of the group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The name of the group.
         * <p>
         * Must be unique.
         * <p>
         * Default: - auto generate a name
         * <p>
         * @return {@code this}
         * @param groupName The name of the group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupName(final java.lang.String groupName) {
            this.props.groupName(groupName);
            return this;
        }

        /**
         * A non-negative integer value that specifies the precedence of this group relative to the other groups that a user can belong to in the user pool.
         * <p>
         * Zero is the highest precedence value.
         * <p>
         * Groups with lower Precedence values take precedence over groups with higher or null Precedence values.
         * If a user belongs to two or more groups, it is the group with the lowest precedence value
         * whose role ARN is given in the user's tokens for the cognito:roles and cognito:preferred_role claims.
         * <p>
         * Two groups can have the same Precedence value. If this happens, neither group takes precedence over the other.
         * If two groups with the same Precedence have the same role ARN, that role is used in the cognito:preferred_role
         * claim in tokens for users in each group.
         * If the two groups have different role ARNs, the cognito:preferred_role claim isn't set in users' tokens.
         * <p>
         * Default: - null
         * <p>
         * @return {@code this}
         * @param precedence A non-negative integer value that specifies the precedence of this group relative to the other groups that a user can belong to in the user pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder precedence(final java.lang.Number precedence) {
            this.props.precedence(precedence);
            return this;
        }

        /**
         * The role for the group.
         * <p>
         * Default: - no description
         * <p>
         * @return {@code this}
         * @param role The role for the group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * The user pool to which this group is associated.
         * <p>
         * @return {@code this}
         * @param userPool The user pool to which this group is associated. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPool(final software.amazon.awscdk.services.cognito.IUserPool userPool) {
            this.props.userPool(userPool);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cognito.UserPoolGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cognito.UserPoolGroup build() {
            return new software.amazon.awscdk.services.cognito.UserPoolGroup(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
