package software.amazon.awscdk.services.comprehend;

/**
 * Properties for defining a <code>CfnFlywheel</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.comprehend.*;
 * CfnFlywheelProps cfnFlywheelProps = CfnFlywheelProps.builder()
 *         .dataAccessRoleArn("dataAccessRoleArn")
 *         .dataLakeS3Uri("dataLakeS3Uri")
 *         .flywheelName("flywheelName")
 *         // the properties below are optional
 *         .activeModelArn("activeModelArn")
 *         .dataSecurityConfig(DataSecurityConfigProperty.builder()
 *                 .dataLakeKmsKeyId("dataLakeKmsKeyId")
 *                 .modelKmsKeyId("modelKmsKeyId")
 *                 .volumeKmsKeyId("volumeKmsKeyId")
 *                 .vpcConfig(VpcConfigProperty.builder()
 *                         .securityGroupIds(List.of("securityGroupIds"))
 *                         .subnets(List.of("subnets"))
 *                         .build())
 *                 .build())
 *         .modelType("modelType")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .taskConfig(TaskConfigProperty.builder()
 *                 .languageCode("languageCode")
 *                 // the properties below are optional
 *                 .documentClassificationConfig(DocumentClassificationConfigProperty.builder()
 *                         .mode("mode")
 *                         // the properties below are optional
 *                         .labels(List.of("labels"))
 *                         .build())
 *                 .entityRecognitionConfig(EntityRecognitionConfigProperty.builder()
 *                         .entityTypes(List.of(EntityTypesListItemProperty.builder()
 *                                 .type("type")
 *                                 .build()))
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-flywheel.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-flywheel.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:33.517Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_comprehend.CfnFlywheelProps")
@software.amazon.jsii.Jsii.Proxy(CfnFlywheelProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnFlywheelProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend permission to access the flywheel data.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-flywheel.html#cfn-comprehend-flywheel-dataaccessrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-flywheel.html#cfn-comprehend-flywheel-dataaccessrolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDataAccessRoleArn();

    /**
     * Amazon S3 URI of the data lake location.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-flywheel.html#cfn-comprehend-flywheel-datalakes3uri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-flywheel.html#cfn-comprehend-flywheel-datalakes3uri</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDataLakeS3Uri();

    /**
     * Name for the flywheel.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-flywheel.html#cfn-comprehend-flywheel-flywheelname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-flywheel.html#cfn-comprehend-flywheel-flywheelname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFlywheelName();

    /**
     * The Amazon Resource Number (ARN) of the active model version.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-flywheel.html#cfn-comprehend-flywheel-activemodelarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-flywheel.html#cfn-comprehend-flywheel-activemodelarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getActiveModelArn() {
        return null;
    }

    /**
     * Data security configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-flywheel.html#cfn-comprehend-flywheel-datasecurityconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-flywheel.html#cfn-comprehend-flywheel-datasecurityconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDataSecurityConfig() {
        return null;
    }

    /**
     * Model type of the flywheel's model.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-flywheel.html#cfn-comprehend-flywheel-modeltype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-flywheel.html#cfn-comprehend-flywheel-modeltype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getModelType() {
        return null;
    }

    /**
     * Tags associated with the endpoint being created.
     * <p>
     * A tag is a key-value pair that adds metadata to the endpoint. For example, a tag with "Sales" as the key might be added to an endpoint to indicate its use by the sales department.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-flywheel.html#cfn-comprehend-flywheel-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-flywheel.html#cfn-comprehend-flywheel-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * Configuration about the model associated with a flywheel.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-flywheel.html#cfn-comprehend-flywheel-taskconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-flywheel.html#cfn-comprehend-flywheel-taskconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTaskConfig() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnFlywheelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnFlywheelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnFlywheelProps> {
        java.lang.String dataAccessRoleArn;
        java.lang.String dataLakeS3Uri;
        java.lang.String flywheelName;
        java.lang.String activeModelArn;
        java.lang.Object dataSecurityConfig;
        java.lang.String modelType;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object taskConfig;

        /**
         * Sets the value of {@link CfnFlywheelProps#getDataAccessRoleArn}
         * @param dataAccessRoleArn The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend permission to access the flywheel data. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataAccessRoleArn(java.lang.String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlywheelProps#getDataLakeS3Uri}
         * @param dataLakeS3Uri Amazon S3 URI of the data lake location. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataLakeS3Uri(java.lang.String dataLakeS3Uri) {
            this.dataLakeS3Uri = dataLakeS3Uri;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlywheelProps#getFlywheelName}
         * @param flywheelName Name for the flywheel. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder flywheelName(java.lang.String flywheelName) {
            this.flywheelName = flywheelName;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlywheelProps#getActiveModelArn}
         * @param activeModelArn The Amazon Resource Number (ARN) of the active model version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder activeModelArn(java.lang.String activeModelArn) {
            this.activeModelArn = activeModelArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlywheelProps#getDataSecurityConfig}
         * @param dataSecurityConfig Data security configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSecurityConfig(software.amazon.awscdk.IResolvable dataSecurityConfig) {
            this.dataSecurityConfig = dataSecurityConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlywheelProps#getDataSecurityConfig}
         * @param dataSecurityConfig Data security configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSecurityConfig(software.amazon.awscdk.services.comprehend.CfnFlywheel.DataSecurityConfigProperty dataSecurityConfig) {
            this.dataSecurityConfig = dataSecurityConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlywheelProps#getModelType}
         * @param modelType Model type of the flywheel's model.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelType(java.lang.String modelType) {
            this.modelType = modelType;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlywheelProps#getTags}
         * @param tags Tags associated with the endpoint being created.
         *             A tag is a key-value pair that adds metadata to the endpoint. For example, a tag with "Sales" as the key might be added to an endpoint to indicate its use by the sales department.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlywheelProps#getTaskConfig}
         * @param taskConfig Configuration about the model associated with a flywheel.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskConfig(software.amazon.awscdk.IResolvable taskConfig) {
            this.taskConfig = taskConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlywheelProps#getTaskConfig}
         * @param taskConfig Configuration about the model associated with a flywheel.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskConfig(software.amazon.awscdk.services.comprehend.CfnFlywheel.TaskConfigProperty taskConfig) {
            this.taskConfig = taskConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnFlywheelProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnFlywheelProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnFlywheelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnFlywheelProps {
        private final java.lang.String dataAccessRoleArn;
        private final java.lang.String dataLakeS3Uri;
        private final java.lang.String flywheelName;
        private final java.lang.String activeModelArn;
        private final java.lang.Object dataSecurityConfig;
        private final java.lang.String modelType;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object taskConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dataAccessRoleArn = software.amazon.jsii.Kernel.get(this, "dataAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dataLakeS3Uri = software.amazon.jsii.Kernel.get(this, "dataLakeS3Uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.flywheelName = software.amazon.jsii.Kernel.get(this, "flywheelName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.activeModelArn = software.amazon.jsii.Kernel.get(this, "activeModelArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dataSecurityConfig = software.amazon.jsii.Kernel.get(this, "dataSecurityConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.modelType = software.amazon.jsii.Kernel.get(this, "modelType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.taskConfig = software.amazon.jsii.Kernel.get(this, "taskConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dataAccessRoleArn = java.util.Objects.requireNonNull(builder.dataAccessRoleArn, "dataAccessRoleArn is required");
            this.dataLakeS3Uri = java.util.Objects.requireNonNull(builder.dataLakeS3Uri, "dataLakeS3Uri is required");
            this.flywheelName = java.util.Objects.requireNonNull(builder.flywheelName, "flywheelName is required");
            this.activeModelArn = builder.activeModelArn;
            this.dataSecurityConfig = builder.dataSecurityConfig;
            this.modelType = builder.modelType;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.taskConfig = builder.taskConfig;
        }

        @Override
        public final java.lang.String getDataAccessRoleArn() {
            return this.dataAccessRoleArn;
        }

        @Override
        public final java.lang.String getDataLakeS3Uri() {
            return this.dataLakeS3Uri;
        }

        @Override
        public final java.lang.String getFlywheelName() {
            return this.flywheelName;
        }

        @Override
        public final java.lang.String getActiveModelArn() {
            return this.activeModelArn;
        }

        @Override
        public final java.lang.Object getDataSecurityConfig() {
            return this.dataSecurityConfig;
        }

        @Override
        public final java.lang.String getModelType() {
            return this.modelType;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getTaskConfig() {
            return this.taskConfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("dataAccessRoleArn", om.valueToTree(this.getDataAccessRoleArn()));
            data.set("dataLakeS3Uri", om.valueToTree(this.getDataLakeS3Uri()));
            data.set("flywheelName", om.valueToTree(this.getFlywheelName()));
            if (this.getActiveModelArn() != null) {
                data.set("activeModelArn", om.valueToTree(this.getActiveModelArn()));
            }
            if (this.getDataSecurityConfig() != null) {
                data.set("dataSecurityConfig", om.valueToTree(this.getDataSecurityConfig()));
            }
            if (this.getModelType() != null) {
                data.set("modelType", om.valueToTree(this.getModelType()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTaskConfig() != null) {
                data.set("taskConfig", om.valueToTree(this.getTaskConfig()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_comprehend.CfnFlywheelProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnFlywheelProps.Jsii$Proxy that = (CfnFlywheelProps.Jsii$Proxy) o;

            if (!dataAccessRoleArn.equals(that.dataAccessRoleArn)) return false;
            if (!dataLakeS3Uri.equals(that.dataLakeS3Uri)) return false;
            if (!flywheelName.equals(that.flywheelName)) return false;
            if (this.activeModelArn != null ? !this.activeModelArn.equals(that.activeModelArn) : that.activeModelArn != null) return false;
            if (this.dataSecurityConfig != null ? !this.dataSecurityConfig.equals(that.dataSecurityConfig) : that.dataSecurityConfig != null) return false;
            if (this.modelType != null ? !this.modelType.equals(that.modelType) : that.modelType != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.taskConfig != null ? this.taskConfig.equals(that.taskConfig) : that.taskConfig == null;
        }

        @Override
        public final int hashCode() {
            int result = this.dataAccessRoleArn.hashCode();
            result = 31 * result + (this.dataLakeS3Uri.hashCode());
            result = 31 * result + (this.flywheelName.hashCode());
            result = 31 * result + (this.activeModelArn != null ? this.activeModelArn.hashCode() : 0);
            result = 31 * result + (this.dataSecurityConfig != null ? this.dataSecurityConfig.hashCode() : 0);
            result = 31 * result + (this.modelType != null ? this.modelType.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.taskConfig != null ? this.taskConfig.hashCode() : 0);
            return result;
        }
    }
}
