package software.amazon.awscdk.services.customerprofiles;

/**
 * Specifies an Amazon Connect Customer Profiles Domain.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.customerprofiles.*;
 * CfnDomain cfnDomain = CfnDomain.Builder.create(this, "MyCfnDomain")
 *         .defaultExpirationDays(123)
 *         .domainName("domainName")
 *         // the properties below are optional
 *         .deadLetterQueueUrl("deadLetterQueueUrl")
 *         .defaultEncryptionKey("defaultEncryptionKey")
 *         .matching(MatchingProperty.builder()
 *                 .enabled(false)
 *                 // the properties below are optional
 *                 .autoMerging(AutoMergingProperty.builder()
 *                         .enabled(false)
 *                         // the properties below are optional
 *                         .conflictResolution(ConflictResolutionProperty.builder()
 *                                 .conflictResolvingModel("conflictResolvingModel")
 *                                 // the properties below are optional
 *                                 .sourceName("sourceName")
 *                                 .build())
 *                         .consolidation(ConsolidationProperty.builder()
 *                                 .matchingAttributesList(List.of(List.of("matchingAttributesList")))
 *                                 .build())
 *                         .minAllowedConfidenceScoreForMerging(123)
 *                         .build())
 *                 .exportingConfig(ExportingConfigProperty.builder()
 *                         .s3Exporting(S3ExportingConfigProperty.builder()
 *                                 .s3BucketName("s3BucketName")
 *                                 // the properties below are optional
 *                                 .s3KeyName("s3KeyName")
 *                                 .build())
 *                         .build())
 *                 .jobSchedule(JobScheduleProperty.builder()
 *                         .dayOfTheWeek("dayOfTheWeek")
 *                         .time("time")
 *                         .build())
 *                 .build())
 *         .ruleBasedMatching(RuleBasedMatchingProperty.builder()
 *                 .enabled(false)
 *                 // the properties below are optional
 *                 .attributeTypesSelector(AttributeTypesSelectorProperty.builder()
 *                         .attributeMatchingModel("attributeMatchingModel")
 *                         // the properties below are optional
 *                         .address(List.of("address"))
 *                         .emailAddress(List.of("emailAddress"))
 *                         .phoneNumber(List.of("phoneNumber"))
 *                         .build())
 *                 .conflictResolution(ConflictResolutionProperty.builder()
 *                         .conflictResolvingModel("conflictResolvingModel")
 *                         // the properties below are optional
 *                         .sourceName("sourceName")
 *                         .build())
 *                 .exportingConfig(ExportingConfigProperty.builder()
 *                         .s3Exporting(S3ExportingConfigProperty.builder()
 *                                 .s3BucketName("s3BucketName")
 *                                 // the properties below are optional
 *                                 .s3KeyName("s3KeyName")
 *                                 .build())
 *                         .build())
 *                 .matchingRules(List.of(MatchingRuleProperty.builder()
 *                         .rule(List.of("rule"))
 *                         .build()))
 *                 .maxAllowedRuleLevelForMatching(123)
 *                 .maxAllowedRuleLevelForMerging(123)
 *                 .status("status")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:33.759Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnDomain")
public class CfnDomain extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnDomain(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDomain(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.customerprofiles.CfnDomain.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDomain(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.customerprofiles.CfnDomainProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The timestamp of when the domain was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The timestamp of when the domain was most recently edited.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLastUpdatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrLastUpdatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status of rule-based matching rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrRuleBasedMatchingStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrRuleBasedMatchingStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Usage-specific statistics about the domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrStats() {
        return software.amazon.jsii.Kernel.get(this, "attrStats", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The default number of days until the data within the domain expires.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getDefaultExpirationDays() {
        return software.amazon.jsii.Kernel.get(this, "defaultExpirationDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The default number of days until the data within the domain expires.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultExpirationDays(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "defaultExpirationDays", java.util.Objects.requireNonNull(value, "defaultExpirationDays is required"));
    }

    /**
     * The unique name of the domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDomainName() {
        return software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique name of the domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomainName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "domainName", java.util.Objects.requireNonNull(value, "domainName is required"));
    }

    /**
     * The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting data from third party applications.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDeadLetterQueueUrl() {
        return software.amazon.jsii.Kernel.get(this, "deadLetterQueueUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting data from third party applications.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeadLetterQueueUrl(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "deadLetterQueueUrl", value);
    }

    /**
     * The default encryption key, which is an AWS managed key, is used when no specific type of encryption key is specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDefaultEncryptionKey() {
        return software.amazon.jsii.Kernel.get(this, "defaultEncryptionKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The default encryption key, which is an AWS managed key, is used when no specific type of encryption key is specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultEncryptionKey(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "defaultEncryptionKey", value);
    }

    /**
     * The process of matching duplicate profiles.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMatching() {
        return software.amazon.jsii.Kernel.get(this, "matching", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The process of matching duplicate profiles.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMatching(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "matching", value);
    }

    /**
     * The process of matching duplicate profiles.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMatching(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.customerprofiles.CfnDomain.MatchingProperty value) {
        software.amazon.jsii.Kernel.set(this, "matching", value);
    }

    /**
     * The process of matching duplicate profiles using Rule-Based matching.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRuleBasedMatching() {
        return software.amazon.jsii.Kernel.get(this, "ruleBasedMatching", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The process of matching duplicate profiles using Rule-Based matching.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRuleBasedMatching(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "ruleBasedMatching", value);
    }

    /**
     * The process of matching duplicate profiles using Rule-Based matching.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRuleBasedMatching(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.customerprofiles.CfnDomain.RuleBasedMatchingProperty value) {
        software.amazon.jsii.Kernel.set(this, "ruleBasedMatching", value);
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * Configures information about the <code>AttributeTypesSelector</code> which rule-based identity resolution uses to match profiles.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.customerprofiles.*;
     * AttributeTypesSelectorProperty attributeTypesSelectorProperty = AttributeTypesSelectorProperty.builder()
     *         .attributeMatchingModel("attributeMatchingModel")
     *         // the properties below are optional
     *         .address(List.of("address"))
     *         .emailAddress(List.of("emailAddress"))
     *         .phoneNumber(List.of("phoneNumber"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-attributetypesselector.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-attributetypesselector.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnDomain.AttributeTypesSelectorProperty")
    @software.amazon.jsii.Jsii.Proxy(AttributeTypesSelectorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AttributeTypesSelectorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configures the <code>AttributeMatchingModel</code> , you can either choose <code>ONE_TO_ONE</code> or <code>MANY_TO_MANY</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-attributetypesselector.html#cfn-customerprofiles-domain-attributetypesselector-attributematchingmodel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-attributetypesselector.html#cfn-customerprofiles-domain-attributetypesselector-attributematchingmodel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAttributeMatchingModel();

        /**
         * The <code>Address</code> type.
         * <p>
         * You can choose from <code>Address</code> , <code>BusinessAddress</code> , <code>MaillingAddress</code> , and <code>ShippingAddress</code> . You only can use the <code>Address</code> type in the <code>MatchingRule</code> . For example, if you want to match a profile based on <code>BusinessAddress.City</code> or <code>MaillingAddress.City</code> , you can choose the <code>BusinessAddress</code> and the <code>MaillingAddress</code> to represent the <code>Address</code> type and specify the <code>Address.City</code> on the matching rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-attributetypesselector.html#cfn-customerprofiles-domain-attributetypesselector-address">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-attributetypesselector.html#cfn-customerprofiles-domain-attributetypesselector-address</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAddress() {
            return null;
        }

        /**
         * The Email type.
         * <p>
         * You can choose from <code>EmailAddress</code> , <code>BusinessEmailAddress</code> and <code>PersonalEmailAddress</code> . You only can use the <code>EmailAddress</code> type in the <code>MatchingRule</code> . For example, if you want to match profile based on <code>PersonalEmailAddress</code> or <code>BusinessEmailAddress</code> , you can choose the <code>PersonalEmailAddress</code> and the <code>BusinessEmailAddress</code> to represent the <code>EmailAddress</code> type and only specify the <code>EmailAddress</code> on the matching rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-attributetypesselector.html#cfn-customerprofiles-domain-attributetypesselector-emailaddress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-attributetypesselector.html#cfn-customerprofiles-domain-attributetypesselector-emailaddress</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEmailAddress() {
            return null;
        }

        /**
         * The <code>PhoneNumber</code> type.
         * <p>
         * You can choose from <code>PhoneNumber</code> , <code>HomePhoneNumber</code> , and <code>MobilePhoneNumber</code> . You only can use the <code>PhoneNumber</code> type in the <code>MatchingRule</code> . For example, if you want to match a profile based on <code>Phone</code> or <code>HomePhone</code> , you can choose the <code>Phone</code> and the <code>HomePhone</code> to represent the <code>PhoneNumber</code> type and only specify the <code>PhoneNumber</code> on the matching rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-attributetypesselector.html#cfn-customerprofiles-domain-attributetypesselector-phonenumber">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-attributetypesselector.html#cfn-customerprofiles-domain-attributetypesselector-phonenumber</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPhoneNumber() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AttributeTypesSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AttributeTypesSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AttributeTypesSelectorProperty> {
            java.lang.String attributeMatchingModel;
            java.util.List<java.lang.String> address;
            java.util.List<java.lang.String> emailAddress;
            java.util.List<java.lang.String> phoneNumber;

            /**
             * Sets the value of {@link AttributeTypesSelectorProperty#getAttributeMatchingModel}
             * @param attributeMatchingModel Configures the <code>AttributeMatchingModel</code> , you can either choose <code>ONE_TO_ONE</code> or <code>MANY_TO_MANY</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributeMatchingModel(java.lang.String attributeMatchingModel) {
                this.attributeMatchingModel = attributeMatchingModel;
                return this;
            }

            /**
             * Sets the value of {@link AttributeTypesSelectorProperty#getAddress}
             * @param address The <code>Address</code> type.
             *                You can choose from <code>Address</code> , <code>BusinessAddress</code> , <code>MaillingAddress</code> , and <code>ShippingAddress</code> . You only can use the <code>Address</code> type in the <code>MatchingRule</code> . For example, if you want to match a profile based on <code>BusinessAddress.City</code> or <code>MaillingAddress.City</code> , you can choose the <code>BusinessAddress</code> and the <code>MaillingAddress</code> to represent the <code>Address</code> type and specify the <code>Address.City</code> on the matching rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder address(java.util.List<java.lang.String> address) {
                this.address = address;
                return this;
            }

            /**
             * Sets the value of {@link AttributeTypesSelectorProperty#getEmailAddress}
             * @param emailAddress The Email type.
             *                     You can choose from <code>EmailAddress</code> , <code>BusinessEmailAddress</code> and <code>PersonalEmailAddress</code> . You only can use the <code>EmailAddress</code> type in the <code>MatchingRule</code> . For example, if you want to match profile based on <code>PersonalEmailAddress</code> or <code>BusinessEmailAddress</code> , you can choose the <code>PersonalEmailAddress</code> and the <code>BusinessEmailAddress</code> to represent the <code>EmailAddress</code> type and only specify the <code>EmailAddress</code> on the matching rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder emailAddress(java.util.List<java.lang.String> emailAddress) {
                this.emailAddress = emailAddress;
                return this;
            }

            /**
             * Sets the value of {@link AttributeTypesSelectorProperty#getPhoneNumber}
             * @param phoneNumber The <code>PhoneNumber</code> type.
             *                    You can choose from <code>PhoneNumber</code> , <code>HomePhoneNumber</code> , and <code>MobilePhoneNumber</code> . You only can use the <code>PhoneNumber</code> type in the <code>MatchingRule</code> . For example, if you want to match a profile based on <code>Phone</code> or <code>HomePhone</code> , you can choose the <code>Phone</code> and the <code>HomePhone</code> to represent the <code>PhoneNumber</code> type and only specify the <code>PhoneNumber</code> on the matching rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder phoneNumber(java.util.List<java.lang.String> phoneNumber) {
                this.phoneNumber = phoneNumber;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AttributeTypesSelectorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AttributeTypesSelectorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AttributeTypesSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AttributeTypesSelectorProperty {
            private final java.lang.String attributeMatchingModel;
            private final java.util.List<java.lang.String> address;
            private final java.util.List<java.lang.String> emailAddress;
            private final java.util.List<java.lang.String> phoneNumber;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attributeMatchingModel = software.amazon.jsii.Kernel.get(this, "attributeMatchingModel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.address = software.amazon.jsii.Kernel.get(this, "address", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.emailAddress = software.amazon.jsii.Kernel.get(this, "emailAddress", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.phoneNumber = software.amazon.jsii.Kernel.get(this, "phoneNumber", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attributeMatchingModel = java.util.Objects.requireNonNull(builder.attributeMatchingModel, "attributeMatchingModel is required");
                this.address = builder.address;
                this.emailAddress = builder.emailAddress;
                this.phoneNumber = builder.phoneNumber;
            }

            @Override
            public final java.lang.String getAttributeMatchingModel() {
                return this.attributeMatchingModel;
            }

            @Override
            public final java.util.List<java.lang.String> getAddress() {
                return this.address;
            }

            @Override
            public final java.util.List<java.lang.String> getEmailAddress() {
                return this.emailAddress;
            }

            @Override
            public final java.util.List<java.lang.String> getPhoneNumber() {
                return this.phoneNumber;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("attributeMatchingModel", om.valueToTree(this.getAttributeMatchingModel()));
                if (this.getAddress() != null) {
                    data.set("address", om.valueToTree(this.getAddress()));
                }
                if (this.getEmailAddress() != null) {
                    data.set("emailAddress", om.valueToTree(this.getEmailAddress()));
                }
                if (this.getPhoneNumber() != null) {
                    data.set("phoneNumber", om.valueToTree(this.getPhoneNumber()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnDomain.AttributeTypesSelectorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AttributeTypesSelectorProperty.Jsii$Proxy that = (AttributeTypesSelectorProperty.Jsii$Proxy) o;

                if (!attributeMatchingModel.equals(that.attributeMatchingModel)) return false;
                if (this.address != null ? !this.address.equals(that.address) : that.address != null) return false;
                if (this.emailAddress != null ? !this.emailAddress.equals(that.emailAddress) : that.emailAddress != null) return false;
                return this.phoneNumber != null ? this.phoneNumber.equals(that.phoneNumber) : that.phoneNumber == null;
            }

            @Override
            public final int hashCode() {
                int result = this.attributeMatchingModel.hashCode();
                result = 31 * result + (this.address != null ? this.address.hashCode() : 0);
                result = 31 * result + (this.emailAddress != null ? this.emailAddress.hashCode() : 0);
                result = 31 * result + (this.phoneNumber != null ? this.phoneNumber.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration information about the auto-merging process.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.customerprofiles.*;
     * AutoMergingProperty autoMergingProperty = AutoMergingProperty.builder()
     *         .enabled(false)
     *         // the properties below are optional
     *         .conflictResolution(ConflictResolutionProperty.builder()
     *                 .conflictResolvingModel("conflictResolvingModel")
     *                 // the properties below are optional
     *                 .sourceName("sourceName")
     *                 .build())
     *         .consolidation(ConsolidationProperty.builder()
     *                 .matchingAttributesList(List.of(List.of("matchingAttributesList")))
     *                 .build())
     *         .minAllowedConfidenceScoreForMerging(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-automerging.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-automerging.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnDomain.AutoMergingProperty")
    @software.amazon.jsii.Jsii.Proxy(AutoMergingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AutoMergingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The flag that enables the auto-merging of duplicate profiles.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-automerging.html#cfn-customerprofiles-domain-automerging-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-automerging.html#cfn-customerprofiles-domain-automerging-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * Determines how the auto-merging process should resolve conflicts between different profiles.
         * <p>
         * For example, if Profile A and Profile B have the same <code>FirstName</code> and <code>LastName</code> , <code>ConflictResolution</code> specifies which <code>EmailAddress</code> should be used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-automerging.html#cfn-customerprofiles-domain-automerging-conflictresolution">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-automerging.html#cfn-customerprofiles-domain-automerging-conflictresolution</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConflictResolution() {
            return null;
        }

        /**
         * A list of matching attributes that represent matching criteria.
         * <p>
         * If two profiles meet at least one of the requirements in the matching attributes list, they will be merged.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-automerging.html#cfn-customerprofiles-domain-automerging-consolidation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-automerging.html#cfn-customerprofiles-domain-automerging-consolidation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConsolidation() {
            return null;
        }

        /**
         * A number between 0 and 1 that represents the minimum confidence score required for profiles within a matching group to be merged during the auto-merge process.
         * <p>
         * A higher score means that a higher similarity is required to merge profiles.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-automerging.html#cfn-customerprofiles-domain-automerging-minallowedconfidencescoreformerging">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-automerging.html#cfn-customerprofiles-domain-automerging-minallowedconfidencescoreformerging</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinAllowedConfidenceScoreForMerging() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AutoMergingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AutoMergingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AutoMergingProperty> {
            java.lang.Object enabled;
            java.lang.Object conflictResolution;
            java.lang.Object consolidation;
            java.lang.Number minAllowedConfidenceScoreForMerging;

            /**
             * Sets the value of {@link AutoMergingProperty#getEnabled}
             * @param enabled The flag that enables the auto-merging of duplicate profiles. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link AutoMergingProperty#getEnabled}
             * @param enabled The flag that enables the auto-merging of duplicate profiles. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link AutoMergingProperty#getConflictResolution}
             * @param conflictResolution Determines how the auto-merging process should resolve conflicts between different profiles.
             *                           For example, if Profile A and Profile B have the same <code>FirstName</code> and <code>LastName</code> , <code>ConflictResolution</code> specifies which <code>EmailAddress</code> should be used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conflictResolution(software.amazon.awscdk.IResolvable conflictResolution) {
                this.conflictResolution = conflictResolution;
                return this;
            }

            /**
             * Sets the value of {@link AutoMergingProperty#getConflictResolution}
             * @param conflictResolution Determines how the auto-merging process should resolve conflicts between different profiles.
             *                           For example, if Profile A and Profile B have the same <code>FirstName</code> and <code>LastName</code> , <code>ConflictResolution</code> specifies which <code>EmailAddress</code> should be used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conflictResolution(software.amazon.awscdk.services.customerprofiles.CfnDomain.ConflictResolutionProperty conflictResolution) {
                this.conflictResolution = conflictResolution;
                return this;
            }

            /**
             * Sets the value of {@link AutoMergingProperty#getConsolidation}
             * @param consolidation A list of matching attributes that represent matching criteria.
             *                      If two profiles meet at least one of the requirements in the matching attributes list, they will be merged.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder consolidation(software.amazon.awscdk.IResolvable consolidation) {
                this.consolidation = consolidation;
                return this;
            }

            /**
             * Sets the value of {@link AutoMergingProperty#getConsolidation}
             * @param consolidation A list of matching attributes that represent matching criteria.
             *                      If two profiles meet at least one of the requirements in the matching attributes list, they will be merged.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder consolidation(software.amazon.awscdk.services.customerprofiles.CfnDomain.ConsolidationProperty consolidation) {
                this.consolidation = consolidation;
                return this;
            }

            /**
             * Sets the value of {@link AutoMergingProperty#getMinAllowedConfidenceScoreForMerging}
             * @param minAllowedConfidenceScoreForMerging A number between 0 and 1 that represents the minimum confidence score required for profiles within a matching group to be merged during the auto-merge process.
             *                                            A higher score means that a higher similarity is required to merge profiles.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minAllowedConfidenceScoreForMerging(java.lang.Number minAllowedConfidenceScoreForMerging) {
                this.minAllowedConfidenceScoreForMerging = minAllowedConfidenceScoreForMerging;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AutoMergingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AutoMergingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AutoMergingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutoMergingProperty {
            private final java.lang.Object enabled;
            private final java.lang.Object conflictResolution;
            private final java.lang.Object consolidation;
            private final java.lang.Number minAllowedConfidenceScoreForMerging;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.conflictResolution = software.amazon.jsii.Kernel.get(this, "conflictResolution", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.consolidation = software.amazon.jsii.Kernel.get(this, "consolidation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.minAllowedConfidenceScoreForMerging = software.amazon.jsii.Kernel.get(this, "minAllowedConfidenceScoreForMerging", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
                this.conflictResolution = builder.conflictResolution;
                this.consolidation = builder.consolidation;
                this.minAllowedConfidenceScoreForMerging = builder.minAllowedConfidenceScoreForMerging;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.Object getConflictResolution() {
                return this.conflictResolution;
            }

            @Override
            public final java.lang.Object getConsolidation() {
                return this.consolidation;
            }

            @Override
            public final java.lang.Number getMinAllowedConfidenceScoreForMerging() {
                return this.minAllowedConfidenceScoreForMerging;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enabled", om.valueToTree(this.getEnabled()));
                if (this.getConflictResolution() != null) {
                    data.set("conflictResolution", om.valueToTree(this.getConflictResolution()));
                }
                if (this.getConsolidation() != null) {
                    data.set("consolidation", om.valueToTree(this.getConsolidation()));
                }
                if (this.getMinAllowedConfidenceScoreForMerging() != null) {
                    data.set("minAllowedConfidenceScoreForMerging", om.valueToTree(this.getMinAllowedConfidenceScoreForMerging()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnDomain.AutoMergingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AutoMergingProperty.Jsii$Proxy that = (AutoMergingProperty.Jsii$Proxy) o;

                if (!enabled.equals(that.enabled)) return false;
                if (this.conflictResolution != null ? !this.conflictResolution.equals(that.conflictResolution) : that.conflictResolution != null) return false;
                if (this.consolidation != null ? !this.consolidation.equals(that.consolidation) : that.consolidation != null) return false;
                return this.minAllowedConfidenceScoreForMerging != null ? this.minAllowedConfidenceScoreForMerging.equals(that.minAllowedConfidenceScoreForMerging) : that.minAllowedConfidenceScoreForMerging == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled.hashCode();
                result = 31 * result + (this.conflictResolution != null ? this.conflictResolution.hashCode() : 0);
                result = 31 * result + (this.consolidation != null ? this.consolidation.hashCode() : 0);
                result = 31 * result + (this.minAllowedConfidenceScoreForMerging != null ? this.minAllowedConfidenceScoreForMerging.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Determines how the auto-merging process should resolve conflicts between different profiles.
     * <p>
     * For example, if Profile A and Profile B have the same <code>FirstName</code> and <code>LastName</code> , <code>ConflictResolution</code> specifies which <code>EmailAddress</code> should be used.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.customerprofiles.*;
     * ConflictResolutionProperty conflictResolutionProperty = ConflictResolutionProperty.builder()
     *         .conflictResolvingModel("conflictResolvingModel")
     *         // the properties below are optional
     *         .sourceName("sourceName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-conflictresolution.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-conflictresolution.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnDomain.ConflictResolutionProperty")
    @software.amazon.jsii.Jsii.Proxy(ConflictResolutionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConflictResolutionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * How the auto-merging process should resolve conflicts between different profiles.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-conflictresolution.html#cfn-customerprofiles-domain-conflictresolution-conflictresolvingmodel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-conflictresolution.html#cfn-customerprofiles-domain-conflictresolution-conflictresolvingmodel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getConflictResolvingModel();

        /**
         * The <code>ObjectType</code> name that is used to resolve profile merging conflicts when choosing <code>SOURCE</code> as the <code>ConflictResolvingModel</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-conflictresolution.html#cfn-customerprofiles-domain-conflictresolution-sourcename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-conflictresolution.html#cfn-customerprofiles-domain-conflictresolution-sourcename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConflictResolutionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConflictResolutionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConflictResolutionProperty> {
            java.lang.String conflictResolvingModel;
            java.lang.String sourceName;

            /**
             * Sets the value of {@link ConflictResolutionProperty#getConflictResolvingModel}
             * @param conflictResolvingModel How the auto-merging process should resolve conflicts between different profiles. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conflictResolvingModel(java.lang.String conflictResolvingModel) {
                this.conflictResolvingModel = conflictResolvingModel;
                return this;
            }

            /**
             * Sets the value of {@link ConflictResolutionProperty#getSourceName}
             * @param sourceName The <code>ObjectType</code> name that is used to resolve profile merging conflicts when choosing <code>SOURCE</code> as the <code>ConflictResolvingModel</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceName(java.lang.String sourceName) {
                this.sourceName = sourceName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConflictResolutionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConflictResolutionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConflictResolutionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConflictResolutionProperty {
            private final java.lang.String conflictResolvingModel;
            private final java.lang.String sourceName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.conflictResolvingModel = software.amazon.jsii.Kernel.get(this, "conflictResolvingModel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourceName = software.amazon.jsii.Kernel.get(this, "sourceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.conflictResolvingModel = java.util.Objects.requireNonNull(builder.conflictResolvingModel, "conflictResolvingModel is required");
                this.sourceName = builder.sourceName;
            }

            @Override
            public final java.lang.String getConflictResolvingModel() {
                return this.conflictResolvingModel;
            }

            @Override
            public final java.lang.String getSourceName() {
                return this.sourceName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("conflictResolvingModel", om.valueToTree(this.getConflictResolvingModel()));
                if (this.getSourceName() != null) {
                    data.set("sourceName", om.valueToTree(this.getSourceName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnDomain.ConflictResolutionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConflictResolutionProperty.Jsii$Proxy that = (ConflictResolutionProperty.Jsii$Proxy) o;

                if (!conflictResolvingModel.equals(that.conflictResolvingModel)) return false;
                return this.sourceName != null ? this.sourceName.equals(that.sourceName) : that.sourceName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.conflictResolvingModel.hashCode();
                result = 31 * result + (this.sourceName != null ? this.sourceName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A list of matching attributes that represent matching criteria.
     * <p>
     * If two profiles meet at least one of the requirements in the matching attributes list, they will be merged.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.customerprofiles.*;
     * ConsolidationProperty consolidationProperty = ConsolidationProperty.builder()
     *         .matchingAttributesList(List.of(List.of("matchingAttributesList")))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-consolidation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-consolidation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnDomain.ConsolidationProperty")
    @software.amazon.jsii.Jsii.Proxy(ConsolidationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConsolidationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of matching criteria.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-consolidation.html#cfn-customerprofiles-domain-consolidation-matchingattributeslist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-consolidation.html#cfn-customerprofiles-domain-consolidation-matchingattributeslist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMatchingAttributesList();

        /**
         * @return a {@link Builder} of {@link ConsolidationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConsolidationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConsolidationProperty> {
            java.lang.Object matchingAttributesList;

            /**
             * Sets the value of {@link ConsolidationProperty#getMatchingAttributesList}
             * @param matchingAttributesList A list of matching criteria. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchingAttributesList(software.amazon.awscdk.IResolvable matchingAttributesList) {
                this.matchingAttributesList = matchingAttributesList;
                return this;
            }

            /**
             * Sets the value of {@link ConsolidationProperty#getMatchingAttributesList}
             * @param matchingAttributesList A list of matching criteria. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchingAttributesList(java.util.List<? extends java.util.List<java.lang.String>> matchingAttributesList) {
                this.matchingAttributesList = matchingAttributesList;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConsolidationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConsolidationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConsolidationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConsolidationProperty {
            private final java.lang.Object matchingAttributesList;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.matchingAttributesList = software.amazon.jsii.Kernel.get(this, "matchingAttributesList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.matchingAttributesList = java.util.Objects.requireNonNull(builder.matchingAttributesList, "matchingAttributesList is required");
            }

            @Override
            public final java.lang.Object getMatchingAttributesList() {
                return this.matchingAttributesList;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("matchingAttributesList", om.valueToTree(this.getMatchingAttributesList()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnDomain.ConsolidationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConsolidationProperty.Jsii$Proxy that = (ConsolidationProperty.Jsii$Proxy) o;

                return this.matchingAttributesList.equals(that.matchingAttributesList);
            }

            @Override
            public final int hashCode() {
                int result = this.matchingAttributesList.hashCode();
                return result;
            }
        }
    }
    /**
     * Usage-specific statistics about the domain.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.customerprofiles.*;
     * DomainStatsProperty domainStatsProperty = DomainStatsProperty.builder()
     *         .meteringProfileCount(123)
     *         .objectCount(123)
     *         .profileCount(123)
     *         .totalSize(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-domainstats.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-domainstats.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnDomain.DomainStatsProperty")
    @software.amazon.jsii.Jsii.Proxy(DomainStatsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DomainStatsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of profiles that you are currently paying for in the domain.
         * <p>
         * If you have more than 100 objects associated with a single profile, that profile counts as two profiles. If you have more than 200 objects, that profile counts as three, and so on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-domainstats.html#cfn-customerprofiles-domain-domainstats-meteringprofilecount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-domainstats.html#cfn-customerprofiles-domain-domainstats-meteringprofilecount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMeteringProfileCount() {
            return null;
        }

        /**
         * The total number of objects in domain.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-domainstats.html#cfn-customerprofiles-domain-domainstats-objectcount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-domainstats.html#cfn-customerprofiles-domain-domainstats-objectcount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getObjectCount() {
            return null;
        }

        /**
         * The total number of profiles currently in the domain.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-domainstats.html#cfn-customerprofiles-domain-domainstats-profilecount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-domainstats.html#cfn-customerprofiles-domain-domainstats-profilecount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getProfileCount() {
            return null;
        }

        /**
         * The total size, in bytes, of all objects in the domain.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-domainstats.html#cfn-customerprofiles-domain-domainstats-totalsize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-domainstats.html#cfn-customerprofiles-domain-domainstats-totalsize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTotalSize() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DomainStatsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DomainStatsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DomainStatsProperty> {
            java.lang.Number meteringProfileCount;
            java.lang.Number objectCount;
            java.lang.Number profileCount;
            java.lang.Number totalSize;

            /**
             * Sets the value of {@link DomainStatsProperty#getMeteringProfileCount}
             * @param meteringProfileCount The number of profiles that you are currently paying for in the domain.
             *                             If you have more than 100 objects associated with a single profile, that profile counts as two profiles. If you have more than 200 objects, that profile counts as three, and so on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder meteringProfileCount(java.lang.Number meteringProfileCount) {
                this.meteringProfileCount = meteringProfileCount;
                return this;
            }

            /**
             * Sets the value of {@link DomainStatsProperty#getObjectCount}
             * @param objectCount The total number of objects in domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder objectCount(java.lang.Number objectCount) {
                this.objectCount = objectCount;
                return this;
            }

            /**
             * Sets the value of {@link DomainStatsProperty#getProfileCount}
             * @param profileCount The total number of profiles currently in the domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder profileCount(java.lang.Number profileCount) {
                this.profileCount = profileCount;
                return this;
            }

            /**
             * Sets the value of {@link DomainStatsProperty#getTotalSize}
             * @param totalSize The total size, in bytes, of all objects in the domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder totalSize(java.lang.Number totalSize) {
                this.totalSize = totalSize;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DomainStatsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DomainStatsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DomainStatsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DomainStatsProperty {
            private final java.lang.Number meteringProfileCount;
            private final java.lang.Number objectCount;
            private final java.lang.Number profileCount;
            private final java.lang.Number totalSize;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.meteringProfileCount = software.amazon.jsii.Kernel.get(this, "meteringProfileCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.objectCount = software.amazon.jsii.Kernel.get(this, "objectCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.profileCount = software.amazon.jsii.Kernel.get(this, "profileCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.totalSize = software.amazon.jsii.Kernel.get(this, "totalSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.meteringProfileCount = builder.meteringProfileCount;
                this.objectCount = builder.objectCount;
                this.profileCount = builder.profileCount;
                this.totalSize = builder.totalSize;
            }

            @Override
            public final java.lang.Number getMeteringProfileCount() {
                return this.meteringProfileCount;
            }

            @Override
            public final java.lang.Number getObjectCount() {
                return this.objectCount;
            }

            @Override
            public final java.lang.Number getProfileCount() {
                return this.profileCount;
            }

            @Override
            public final java.lang.Number getTotalSize() {
                return this.totalSize;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMeteringProfileCount() != null) {
                    data.set("meteringProfileCount", om.valueToTree(this.getMeteringProfileCount()));
                }
                if (this.getObjectCount() != null) {
                    data.set("objectCount", om.valueToTree(this.getObjectCount()));
                }
                if (this.getProfileCount() != null) {
                    data.set("profileCount", om.valueToTree(this.getProfileCount()));
                }
                if (this.getTotalSize() != null) {
                    data.set("totalSize", om.valueToTree(this.getTotalSize()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnDomain.DomainStatsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DomainStatsProperty.Jsii$Proxy that = (DomainStatsProperty.Jsii$Proxy) o;

                if (this.meteringProfileCount != null ? !this.meteringProfileCount.equals(that.meteringProfileCount) : that.meteringProfileCount != null) return false;
                if (this.objectCount != null ? !this.objectCount.equals(that.objectCount) : that.objectCount != null) return false;
                if (this.profileCount != null ? !this.profileCount.equals(that.profileCount) : that.profileCount != null) return false;
                return this.totalSize != null ? this.totalSize.equals(that.totalSize) : that.totalSize == null;
            }

            @Override
            public final int hashCode() {
                int result = this.meteringProfileCount != null ? this.meteringProfileCount.hashCode() : 0;
                result = 31 * result + (this.objectCount != null ? this.objectCount.hashCode() : 0);
                result = 31 * result + (this.profileCount != null ? this.profileCount.hashCode() : 0);
                result = 31 * result + (this.totalSize != null ? this.totalSize.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration information for exporting Identity Resolution results, for example, to an S3 bucket.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.customerprofiles.*;
     * ExportingConfigProperty exportingConfigProperty = ExportingConfigProperty.builder()
     *         .s3Exporting(S3ExportingConfigProperty.builder()
     *                 .s3BucketName("s3BucketName")
     *                 // the properties below are optional
     *                 .s3KeyName("s3KeyName")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-exportingconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-exportingconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnDomain.ExportingConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ExportingConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExportingConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The S3 location where Identity Resolution Jobs write result files.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-exportingconfig.html#cfn-customerprofiles-domain-exportingconfig-s3exporting">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-exportingconfig.html#cfn-customerprofiles-domain-exportingconfig-s3exporting</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3Exporting() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExportingConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExportingConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExportingConfigProperty> {
            java.lang.Object s3Exporting;

            /**
             * Sets the value of {@link ExportingConfigProperty#getS3Exporting}
             * @param s3Exporting The S3 location where Identity Resolution Jobs write result files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Exporting(software.amazon.awscdk.IResolvable s3Exporting) {
                this.s3Exporting = s3Exporting;
                return this;
            }

            /**
             * Sets the value of {@link ExportingConfigProperty#getS3Exporting}
             * @param s3Exporting The S3 location where Identity Resolution Jobs write result files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Exporting(software.amazon.awscdk.services.customerprofiles.CfnDomain.S3ExportingConfigProperty s3Exporting) {
                this.s3Exporting = s3Exporting;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExportingConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExportingConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExportingConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExportingConfigProperty {
            private final java.lang.Object s3Exporting;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3Exporting = software.amazon.jsii.Kernel.get(this, "s3Exporting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3Exporting = builder.s3Exporting;
            }

            @Override
            public final java.lang.Object getS3Exporting() {
                return this.s3Exporting;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getS3Exporting() != null) {
                    data.set("s3Exporting", om.valueToTree(this.getS3Exporting()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnDomain.ExportingConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExportingConfigProperty.Jsii$Proxy that = (ExportingConfigProperty.Jsii$Proxy) o;

                return this.s3Exporting != null ? this.s3Exporting.equals(that.s3Exporting) : that.s3Exporting == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3Exporting != null ? this.s3Exporting.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The day and time when do you want to start the Identity Resolution Job every week.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.customerprofiles.*;
     * JobScheduleProperty jobScheduleProperty = JobScheduleProperty.builder()
     *         .dayOfTheWeek("dayOfTheWeek")
     *         .time("time")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-jobschedule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-jobschedule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnDomain.JobScheduleProperty")
    @software.amazon.jsii.Jsii.Proxy(JobScheduleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JobScheduleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The day when the Identity Resolution Job should run every week.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-jobschedule.html#cfn-customerprofiles-domain-jobschedule-dayoftheweek">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-jobschedule.html#cfn-customerprofiles-domain-jobschedule-dayoftheweek</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDayOfTheWeek();

        /**
         * The time when the Identity Resolution Job should run every week.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-jobschedule.html#cfn-customerprofiles-domain-jobschedule-time">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-jobschedule.html#cfn-customerprofiles-domain-jobschedule-time</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTime();

        /**
         * @return a {@link Builder} of {@link JobScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JobScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JobScheduleProperty> {
            java.lang.String dayOfTheWeek;
            java.lang.String time;

            /**
             * Sets the value of {@link JobScheduleProperty#getDayOfTheWeek}
             * @param dayOfTheWeek The day when the Identity Resolution Job should run every week. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dayOfTheWeek(java.lang.String dayOfTheWeek) {
                this.dayOfTheWeek = dayOfTheWeek;
                return this;
            }

            /**
             * Sets the value of {@link JobScheduleProperty#getTime}
             * @param time The time when the Identity Resolution Job should run every week. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder time(java.lang.String time) {
                this.time = time;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JobScheduleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JobScheduleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JobScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JobScheduleProperty {
            private final java.lang.String dayOfTheWeek;
            private final java.lang.String time;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dayOfTheWeek = software.amazon.jsii.Kernel.get(this, "dayOfTheWeek", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.time = software.amazon.jsii.Kernel.get(this, "time", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dayOfTheWeek = java.util.Objects.requireNonNull(builder.dayOfTheWeek, "dayOfTheWeek is required");
                this.time = java.util.Objects.requireNonNull(builder.time, "time is required");
            }

            @Override
            public final java.lang.String getDayOfTheWeek() {
                return this.dayOfTheWeek;
            }

            @Override
            public final java.lang.String getTime() {
                return this.time;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dayOfTheWeek", om.valueToTree(this.getDayOfTheWeek()));
                data.set("time", om.valueToTree(this.getTime()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnDomain.JobScheduleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JobScheduleProperty.Jsii$Proxy that = (JobScheduleProperty.Jsii$Proxy) o;

                if (!dayOfTheWeek.equals(that.dayOfTheWeek)) return false;
                return this.time.equals(that.time);
            }

            @Override
            public final int hashCode() {
                int result = this.dayOfTheWeek.hashCode();
                result = 31 * result + (this.time.hashCode());
                return result;
            }
        }
    }
    /**
     * The process of matching duplicate profiles.
     * <p>
     * If <code>Matching = true</code> , Amazon Connect Customer Profiles starts a weekly batch process called <em>Identity Resolution Job</em> . If you do not specify a date and time for the <em>Identity Resolution Job</em> to run, by default it runs every Saturday at 12AM UTC to detect duplicate profiles in your domains. After the <em>Identity Resolution Job</em> completes, use the <code>GetMatches</code> API to return and review the results. Or, if you have configured <code>ExportingConfig</code> in the <code>MatchingRequest</code> , you can download the results from S3.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.customerprofiles.*;
     * MatchingProperty matchingProperty = MatchingProperty.builder()
     *         .enabled(false)
     *         // the properties below are optional
     *         .autoMerging(AutoMergingProperty.builder()
     *                 .enabled(false)
     *                 // the properties below are optional
     *                 .conflictResolution(ConflictResolutionProperty.builder()
     *                         .conflictResolvingModel("conflictResolvingModel")
     *                         // the properties below are optional
     *                         .sourceName("sourceName")
     *                         .build())
     *                 .consolidation(ConsolidationProperty.builder()
     *                         .matchingAttributesList(List.of(List.of("matchingAttributesList")))
     *                         .build())
     *                 .minAllowedConfidenceScoreForMerging(123)
     *                 .build())
     *         .exportingConfig(ExportingConfigProperty.builder()
     *                 .s3Exporting(S3ExportingConfigProperty.builder()
     *                         .s3BucketName("s3BucketName")
     *                         // the properties below are optional
     *                         .s3KeyName("s3KeyName")
     *                         .build())
     *                 .build())
     *         .jobSchedule(JobScheduleProperty.builder()
     *                 .dayOfTheWeek("dayOfTheWeek")
     *                 .time("time")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-matching.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-matching.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnDomain.MatchingProperty")
    @software.amazon.jsii.Jsii.Proxy(MatchingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MatchingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The flag that enables the matching process of duplicate profiles.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-matching.html#cfn-customerprofiles-domain-matching-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-matching.html#cfn-customerprofiles-domain-matching-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * Configuration information about the auto-merging process.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-matching.html#cfn-customerprofiles-domain-matching-automerging">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-matching.html#cfn-customerprofiles-domain-matching-automerging</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutoMerging() {
            return null;
        }

        /**
         * The S3 location where Identity Resolution Jobs write result files.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-matching.html#cfn-customerprofiles-domain-matching-exportingconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-matching.html#cfn-customerprofiles-domain-matching-exportingconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExportingConfig() {
            return null;
        }

        /**
         * The day and time when do you want to start the Identity Resolution Job every week.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-matching.html#cfn-customerprofiles-domain-matching-jobschedule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-matching.html#cfn-customerprofiles-domain-matching-jobschedule</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getJobSchedule() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MatchingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MatchingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MatchingProperty> {
            java.lang.Object enabled;
            java.lang.Object autoMerging;
            java.lang.Object exportingConfig;
            java.lang.Object jobSchedule;

            /**
             * Sets the value of {@link MatchingProperty#getEnabled}
             * @param enabled The flag that enables the matching process of duplicate profiles. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link MatchingProperty#getEnabled}
             * @param enabled The flag that enables the matching process of duplicate profiles. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link MatchingProperty#getAutoMerging}
             * @param autoMerging Configuration information about the auto-merging process.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoMerging(software.amazon.awscdk.IResolvable autoMerging) {
                this.autoMerging = autoMerging;
                return this;
            }

            /**
             * Sets the value of {@link MatchingProperty#getAutoMerging}
             * @param autoMerging Configuration information about the auto-merging process.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoMerging(software.amazon.awscdk.services.customerprofiles.CfnDomain.AutoMergingProperty autoMerging) {
                this.autoMerging = autoMerging;
                return this;
            }

            /**
             * Sets the value of {@link MatchingProperty#getExportingConfig}
             * @param exportingConfig The S3 location where Identity Resolution Jobs write result files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exportingConfig(software.amazon.awscdk.IResolvable exportingConfig) {
                this.exportingConfig = exportingConfig;
                return this;
            }

            /**
             * Sets the value of {@link MatchingProperty#getExportingConfig}
             * @param exportingConfig The S3 location where Identity Resolution Jobs write result files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exportingConfig(software.amazon.awscdk.services.customerprofiles.CfnDomain.ExportingConfigProperty exportingConfig) {
                this.exportingConfig = exportingConfig;
                return this;
            }

            /**
             * Sets the value of {@link MatchingProperty#getJobSchedule}
             * @param jobSchedule The day and time when do you want to start the Identity Resolution Job every week.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jobSchedule(software.amazon.awscdk.IResolvable jobSchedule) {
                this.jobSchedule = jobSchedule;
                return this;
            }

            /**
             * Sets the value of {@link MatchingProperty#getJobSchedule}
             * @param jobSchedule The day and time when do you want to start the Identity Resolution Job every week.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jobSchedule(software.amazon.awscdk.services.customerprofiles.CfnDomain.JobScheduleProperty jobSchedule) {
                this.jobSchedule = jobSchedule;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MatchingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MatchingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MatchingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MatchingProperty {
            private final java.lang.Object enabled;
            private final java.lang.Object autoMerging;
            private final java.lang.Object exportingConfig;
            private final java.lang.Object jobSchedule;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.autoMerging = software.amazon.jsii.Kernel.get(this, "autoMerging", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.exportingConfig = software.amazon.jsii.Kernel.get(this, "exportingConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.jobSchedule = software.amazon.jsii.Kernel.get(this, "jobSchedule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
                this.autoMerging = builder.autoMerging;
                this.exportingConfig = builder.exportingConfig;
                this.jobSchedule = builder.jobSchedule;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.Object getAutoMerging() {
                return this.autoMerging;
            }

            @Override
            public final java.lang.Object getExportingConfig() {
                return this.exportingConfig;
            }

            @Override
            public final java.lang.Object getJobSchedule() {
                return this.jobSchedule;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enabled", om.valueToTree(this.getEnabled()));
                if (this.getAutoMerging() != null) {
                    data.set("autoMerging", om.valueToTree(this.getAutoMerging()));
                }
                if (this.getExportingConfig() != null) {
                    data.set("exportingConfig", om.valueToTree(this.getExportingConfig()));
                }
                if (this.getJobSchedule() != null) {
                    data.set("jobSchedule", om.valueToTree(this.getJobSchedule()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnDomain.MatchingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MatchingProperty.Jsii$Proxy that = (MatchingProperty.Jsii$Proxy) o;

                if (!enabled.equals(that.enabled)) return false;
                if (this.autoMerging != null ? !this.autoMerging.equals(that.autoMerging) : that.autoMerging != null) return false;
                if (this.exportingConfig != null ? !this.exportingConfig.equals(that.exportingConfig) : that.exportingConfig != null) return false;
                return this.jobSchedule != null ? this.jobSchedule.equals(that.jobSchedule) : that.jobSchedule == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled.hashCode();
                result = 31 * result + (this.autoMerging != null ? this.autoMerging.hashCode() : 0);
                result = 31 * result + (this.exportingConfig != null ? this.exportingConfig.hashCode() : 0);
                result = 31 * result + (this.jobSchedule != null ? this.jobSchedule.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies how the rule-based matching process should match profiles.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.customerprofiles.*;
     * MatchingRuleProperty matchingRuleProperty = MatchingRuleProperty.builder()
     *         .rule(List.of("rule"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-matchingrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-matchingrule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnDomain.MatchingRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(MatchingRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MatchingRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A single rule level of the <code>MatchRules</code> .
         * <p>
         * Configures how the rule-based matching process should match profiles.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-matchingrule.html#cfn-customerprofiles-domain-matchingrule-rule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-matchingrule.html#cfn-customerprofiles-domain-matchingrule-rule</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getRule();

        /**
         * @return a {@link Builder} of {@link MatchingRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MatchingRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MatchingRuleProperty> {
            java.util.List<java.lang.String> rule;

            /**
             * Sets the value of {@link MatchingRuleProperty#getRule}
             * @param rule A single rule level of the <code>MatchRules</code> . This parameter is required.
             *             Configures how the rule-based matching process should match profiles.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rule(java.util.List<java.lang.String> rule) {
                this.rule = rule;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MatchingRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MatchingRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MatchingRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MatchingRuleProperty {
            private final java.util.List<java.lang.String> rule;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.rule = software.amazon.jsii.Kernel.get(this, "rule", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.rule = java.util.Objects.requireNonNull(builder.rule, "rule is required");
            }

            @Override
            public final java.util.List<java.lang.String> getRule() {
                return this.rule;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("rule", om.valueToTree(this.getRule()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnDomain.MatchingRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MatchingRuleProperty.Jsii$Proxy that = (MatchingRuleProperty.Jsii$Proxy) o;

                return this.rule.equals(that.rule);
            }

            @Override
            public final int hashCode() {
                int result = this.rule.hashCode();
                return result;
            }
        }
    }
    /**
     * The process of matching duplicate profiles using Rule-Based matching.
     * <p>
     * If <code>RuleBasedMatching = true</code> , Amazon Connect Customer Profiles will start to match and merge your profiles according to your configuration in the <code>RuleBasedMatchingRequest</code> . You can use the <code>ListRuleBasedMatches</code> and <code>GetSimilarProfiles</code> API to return and review the results. Also, if you have configured <code>ExportingConfig</code> in the <code>RuleBasedMatchingRequest</code> , you can download the results from S3.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.customerprofiles.*;
     * RuleBasedMatchingProperty ruleBasedMatchingProperty = RuleBasedMatchingProperty.builder()
     *         .enabled(false)
     *         // the properties below are optional
     *         .attributeTypesSelector(AttributeTypesSelectorProperty.builder()
     *                 .attributeMatchingModel("attributeMatchingModel")
     *                 // the properties below are optional
     *                 .address(List.of("address"))
     *                 .emailAddress(List.of("emailAddress"))
     *                 .phoneNumber(List.of("phoneNumber"))
     *                 .build())
     *         .conflictResolution(ConflictResolutionProperty.builder()
     *                 .conflictResolvingModel("conflictResolvingModel")
     *                 // the properties below are optional
     *                 .sourceName("sourceName")
     *                 .build())
     *         .exportingConfig(ExportingConfigProperty.builder()
     *                 .s3Exporting(S3ExportingConfigProperty.builder()
     *                         .s3BucketName("s3BucketName")
     *                         // the properties below are optional
     *                         .s3KeyName("s3KeyName")
     *                         .build())
     *                 .build())
     *         .matchingRules(List.of(MatchingRuleProperty.builder()
     *                 .rule(List.of("rule"))
     *                 .build()))
     *         .maxAllowedRuleLevelForMatching(123)
     *         .maxAllowedRuleLevelForMerging(123)
     *         .status("status")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-rulebasedmatching.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-rulebasedmatching.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnDomain.RuleBasedMatchingProperty")
    @software.amazon.jsii.Jsii.Proxy(RuleBasedMatchingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RuleBasedMatchingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The flag that enables the matching process of duplicate profiles.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-rulebasedmatching.html#cfn-customerprofiles-domain-rulebasedmatching-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-rulebasedmatching.html#cfn-customerprofiles-domain-rulebasedmatching-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * Configures information about the <code>AttributeTypesSelector</code> where the rule-based identity resolution uses to match profiles.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-rulebasedmatching.html#cfn-customerprofiles-domain-rulebasedmatching-attributetypesselector">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-rulebasedmatching.html#cfn-customerprofiles-domain-rulebasedmatching-attributetypesselector</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAttributeTypesSelector() {
            return null;
        }

        /**
         * Determines how the auto-merging process should resolve conflicts between different profiles.
         * <p>
         * For example, if Profile A and Profile B have the same <code>FirstName</code> and <code>LastName</code> , <code>ConflictResolution</code> specifies which <code>EmailAddress</code> should be used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-rulebasedmatching.html#cfn-customerprofiles-domain-rulebasedmatching-conflictresolution">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-rulebasedmatching.html#cfn-customerprofiles-domain-rulebasedmatching-conflictresolution</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConflictResolution() {
            return null;
        }

        /**
         * The S3 location where Identity Resolution Jobs write result files.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-rulebasedmatching.html#cfn-customerprofiles-domain-rulebasedmatching-exportingconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-rulebasedmatching.html#cfn-customerprofiles-domain-rulebasedmatching-exportingconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExportingConfig() {
            return null;
        }

        /**
         * Configures how the rule-based matching process should match profiles.
         * <p>
         * You can have up to 15 <code>MatchingRule</code> in the <code>MatchingRules</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-rulebasedmatching.html#cfn-customerprofiles-domain-rulebasedmatching-matchingrules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-rulebasedmatching.html#cfn-customerprofiles-domain-rulebasedmatching-matchingrules</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMatchingRules() {
            return null;
        }

        /**
         * Indicates the maximum allowed rule level for matching.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-rulebasedmatching.html#cfn-customerprofiles-domain-rulebasedmatching-maxallowedrulelevelformatching">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-rulebasedmatching.html#cfn-customerprofiles-domain-rulebasedmatching-maxallowedrulelevelformatching</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxAllowedRuleLevelForMatching() {
            return null;
        }

        /**
         * Indicates the maximum allowed rule level for merging.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-rulebasedmatching.html#cfn-customerprofiles-domain-rulebasedmatching-maxallowedrulelevelformerging">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-rulebasedmatching.html#cfn-customerprofiles-domain-rulebasedmatching-maxallowedrulelevelformerging</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxAllowedRuleLevelForMerging() {
            return null;
        }

        /**
         * The status of rule-based matching rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-rulebasedmatching.html#cfn-customerprofiles-domain-rulebasedmatching-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-rulebasedmatching.html#cfn-customerprofiles-domain-rulebasedmatching-status</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RuleBasedMatchingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RuleBasedMatchingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RuleBasedMatchingProperty> {
            java.lang.Object enabled;
            java.lang.Object attributeTypesSelector;
            java.lang.Object conflictResolution;
            java.lang.Object exportingConfig;
            java.lang.Object matchingRules;
            java.lang.Number maxAllowedRuleLevelForMatching;
            java.lang.Number maxAllowedRuleLevelForMerging;
            java.lang.String status;

            /**
             * Sets the value of {@link RuleBasedMatchingProperty#getEnabled}
             * @param enabled The flag that enables the matching process of duplicate profiles. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link RuleBasedMatchingProperty#getEnabled}
             * @param enabled The flag that enables the matching process of duplicate profiles. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link RuleBasedMatchingProperty#getAttributeTypesSelector}
             * @param attributeTypesSelector Configures information about the <code>AttributeTypesSelector</code> where the rule-based identity resolution uses to match profiles.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributeTypesSelector(software.amazon.awscdk.IResolvable attributeTypesSelector) {
                this.attributeTypesSelector = attributeTypesSelector;
                return this;
            }

            /**
             * Sets the value of {@link RuleBasedMatchingProperty#getAttributeTypesSelector}
             * @param attributeTypesSelector Configures information about the <code>AttributeTypesSelector</code> where the rule-based identity resolution uses to match profiles.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributeTypesSelector(software.amazon.awscdk.services.customerprofiles.CfnDomain.AttributeTypesSelectorProperty attributeTypesSelector) {
                this.attributeTypesSelector = attributeTypesSelector;
                return this;
            }

            /**
             * Sets the value of {@link RuleBasedMatchingProperty#getConflictResolution}
             * @param conflictResolution Determines how the auto-merging process should resolve conflicts between different profiles.
             *                           For example, if Profile A and Profile B have the same <code>FirstName</code> and <code>LastName</code> , <code>ConflictResolution</code> specifies which <code>EmailAddress</code> should be used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conflictResolution(software.amazon.awscdk.IResolvable conflictResolution) {
                this.conflictResolution = conflictResolution;
                return this;
            }

            /**
             * Sets the value of {@link RuleBasedMatchingProperty#getConflictResolution}
             * @param conflictResolution Determines how the auto-merging process should resolve conflicts between different profiles.
             *                           For example, if Profile A and Profile B have the same <code>FirstName</code> and <code>LastName</code> , <code>ConflictResolution</code> specifies which <code>EmailAddress</code> should be used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conflictResolution(software.amazon.awscdk.services.customerprofiles.CfnDomain.ConflictResolutionProperty conflictResolution) {
                this.conflictResolution = conflictResolution;
                return this;
            }

            /**
             * Sets the value of {@link RuleBasedMatchingProperty#getExportingConfig}
             * @param exportingConfig The S3 location where Identity Resolution Jobs write result files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exportingConfig(software.amazon.awscdk.IResolvable exportingConfig) {
                this.exportingConfig = exportingConfig;
                return this;
            }

            /**
             * Sets the value of {@link RuleBasedMatchingProperty#getExportingConfig}
             * @param exportingConfig The S3 location where Identity Resolution Jobs write result files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exportingConfig(software.amazon.awscdk.services.customerprofiles.CfnDomain.ExportingConfigProperty exportingConfig) {
                this.exportingConfig = exportingConfig;
                return this;
            }

            /**
             * Sets the value of {@link RuleBasedMatchingProperty#getMatchingRules}
             * @param matchingRules Configures how the rule-based matching process should match profiles.
             *                      You can have up to 15 <code>MatchingRule</code> in the <code>MatchingRules</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchingRules(software.amazon.awscdk.IResolvable matchingRules) {
                this.matchingRules = matchingRules;
                return this;
            }

            /**
             * Sets the value of {@link RuleBasedMatchingProperty#getMatchingRules}
             * @param matchingRules Configures how the rule-based matching process should match profiles.
             *                      You can have up to 15 <code>MatchingRule</code> in the <code>MatchingRules</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchingRules(java.util.List<? extends java.lang.Object> matchingRules) {
                this.matchingRules = matchingRules;
                return this;
            }

            /**
             * Sets the value of {@link RuleBasedMatchingProperty#getMaxAllowedRuleLevelForMatching}
             * @param maxAllowedRuleLevelForMatching Indicates the maximum allowed rule level for matching.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxAllowedRuleLevelForMatching(java.lang.Number maxAllowedRuleLevelForMatching) {
                this.maxAllowedRuleLevelForMatching = maxAllowedRuleLevelForMatching;
                return this;
            }

            /**
             * Sets the value of {@link RuleBasedMatchingProperty#getMaxAllowedRuleLevelForMerging}
             * @param maxAllowedRuleLevelForMerging Indicates the maximum allowed rule level for merging.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxAllowedRuleLevelForMerging(java.lang.Number maxAllowedRuleLevelForMerging) {
                this.maxAllowedRuleLevelForMerging = maxAllowedRuleLevelForMerging;
                return this;
            }

            /**
             * Sets the value of {@link RuleBasedMatchingProperty#getStatus}
             * @param status The status of rule-based matching rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuleBasedMatchingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RuleBasedMatchingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RuleBasedMatchingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleBasedMatchingProperty {
            private final java.lang.Object enabled;
            private final java.lang.Object attributeTypesSelector;
            private final java.lang.Object conflictResolution;
            private final java.lang.Object exportingConfig;
            private final java.lang.Object matchingRules;
            private final java.lang.Number maxAllowedRuleLevelForMatching;
            private final java.lang.Number maxAllowedRuleLevelForMerging;
            private final java.lang.String status;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.attributeTypesSelector = software.amazon.jsii.Kernel.get(this, "attributeTypesSelector", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.conflictResolution = software.amazon.jsii.Kernel.get(this, "conflictResolution", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.exportingConfig = software.amazon.jsii.Kernel.get(this, "exportingConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.matchingRules = software.amazon.jsii.Kernel.get(this, "matchingRules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maxAllowedRuleLevelForMatching = software.amazon.jsii.Kernel.get(this, "maxAllowedRuleLevelForMatching", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxAllowedRuleLevelForMerging = software.amazon.jsii.Kernel.get(this, "maxAllowedRuleLevelForMerging", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
                this.attributeTypesSelector = builder.attributeTypesSelector;
                this.conflictResolution = builder.conflictResolution;
                this.exportingConfig = builder.exportingConfig;
                this.matchingRules = builder.matchingRules;
                this.maxAllowedRuleLevelForMatching = builder.maxAllowedRuleLevelForMatching;
                this.maxAllowedRuleLevelForMerging = builder.maxAllowedRuleLevelForMerging;
                this.status = builder.status;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.Object getAttributeTypesSelector() {
                return this.attributeTypesSelector;
            }

            @Override
            public final java.lang.Object getConflictResolution() {
                return this.conflictResolution;
            }

            @Override
            public final java.lang.Object getExportingConfig() {
                return this.exportingConfig;
            }

            @Override
            public final java.lang.Object getMatchingRules() {
                return this.matchingRules;
            }

            @Override
            public final java.lang.Number getMaxAllowedRuleLevelForMatching() {
                return this.maxAllowedRuleLevelForMatching;
            }

            @Override
            public final java.lang.Number getMaxAllowedRuleLevelForMerging() {
                return this.maxAllowedRuleLevelForMerging;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enabled", om.valueToTree(this.getEnabled()));
                if (this.getAttributeTypesSelector() != null) {
                    data.set("attributeTypesSelector", om.valueToTree(this.getAttributeTypesSelector()));
                }
                if (this.getConflictResolution() != null) {
                    data.set("conflictResolution", om.valueToTree(this.getConflictResolution()));
                }
                if (this.getExportingConfig() != null) {
                    data.set("exportingConfig", om.valueToTree(this.getExportingConfig()));
                }
                if (this.getMatchingRules() != null) {
                    data.set("matchingRules", om.valueToTree(this.getMatchingRules()));
                }
                if (this.getMaxAllowedRuleLevelForMatching() != null) {
                    data.set("maxAllowedRuleLevelForMatching", om.valueToTree(this.getMaxAllowedRuleLevelForMatching()));
                }
                if (this.getMaxAllowedRuleLevelForMerging() != null) {
                    data.set("maxAllowedRuleLevelForMerging", om.valueToTree(this.getMaxAllowedRuleLevelForMerging()));
                }
                if (this.getStatus() != null) {
                    data.set("status", om.valueToTree(this.getStatus()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnDomain.RuleBasedMatchingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RuleBasedMatchingProperty.Jsii$Proxy that = (RuleBasedMatchingProperty.Jsii$Proxy) o;

                if (!enabled.equals(that.enabled)) return false;
                if (this.attributeTypesSelector != null ? !this.attributeTypesSelector.equals(that.attributeTypesSelector) : that.attributeTypesSelector != null) return false;
                if (this.conflictResolution != null ? !this.conflictResolution.equals(that.conflictResolution) : that.conflictResolution != null) return false;
                if (this.exportingConfig != null ? !this.exportingConfig.equals(that.exportingConfig) : that.exportingConfig != null) return false;
                if (this.matchingRules != null ? !this.matchingRules.equals(that.matchingRules) : that.matchingRules != null) return false;
                if (this.maxAllowedRuleLevelForMatching != null ? !this.maxAllowedRuleLevelForMatching.equals(that.maxAllowedRuleLevelForMatching) : that.maxAllowedRuleLevelForMatching != null) return false;
                if (this.maxAllowedRuleLevelForMerging != null ? !this.maxAllowedRuleLevelForMerging.equals(that.maxAllowedRuleLevelForMerging) : that.maxAllowedRuleLevelForMerging != null) return false;
                return this.status != null ? this.status.equals(that.status) : that.status == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled.hashCode();
                result = 31 * result + (this.attributeTypesSelector != null ? this.attributeTypesSelector.hashCode() : 0);
                result = 31 * result + (this.conflictResolution != null ? this.conflictResolution.hashCode() : 0);
                result = 31 * result + (this.exportingConfig != null ? this.exportingConfig.hashCode() : 0);
                result = 31 * result + (this.matchingRules != null ? this.matchingRules.hashCode() : 0);
                result = 31 * result + (this.maxAllowedRuleLevelForMatching != null ? this.maxAllowedRuleLevelForMatching.hashCode() : 0);
                result = 31 * result + (this.maxAllowedRuleLevelForMerging != null ? this.maxAllowedRuleLevelForMerging.hashCode() : 0);
                result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The S3 location where Identity Resolution Jobs write result files.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.customerprofiles.*;
     * S3ExportingConfigProperty s3ExportingConfigProperty = S3ExportingConfigProperty.builder()
     *         .s3BucketName("s3BucketName")
     *         // the properties below are optional
     *         .s3KeyName("s3KeyName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-s3exportingconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-s3exportingconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnDomain.S3ExportingConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(S3ExportingConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3ExportingConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the S3 bucket where Identity Resolution Jobs write result files.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-s3exportingconfig.html#cfn-customerprofiles-domain-s3exportingconfig-s3bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-s3exportingconfig.html#cfn-customerprofiles-domain-s3exportingconfig-s3bucketname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3BucketName();

        /**
         * The S3 key name of the location where Identity Resolution Jobs write result files.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-s3exportingconfig.html#cfn-customerprofiles-domain-s3exportingconfig-s3keyname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-domain-s3exportingconfig.html#cfn-customerprofiles-domain-s3exportingconfig-s3keyname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3KeyName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3ExportingConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3ExportingConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3ExportingConfigProperty> {
            java.lang.String s3BucketName;
            java.lang.String s3KeyName;

            /**
             * Sets the value of {@link S3ExportingConfigProperty#getS3BucketName}
             * @param s3BucketName The name of the S3 bucket where Identity Resolution Jobs write result files. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BucketName(java.lang.String s3BucketName) {
                this.s3BucketName = s3BucketName;
                return this;
            }

            /**
             * Sets the value of {@link S3ExportingConfigProperty#getS3KeyName}
             * @param s3KeyName The S3 key name of the location where Identity Resolution Jobs write result files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3KeyName(java.lang.String s3KeyName) {
                this.s3KeyName = s3KeyName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3ExportingConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3ExportingConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3ExportingConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3ExportingConfigProperty {
            private final java.lang.String s3BucketName;
            private final java.lang.String s3KeyName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3BucketName = software.amazon.jsii.Kernel.get(this, "s3BucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3KeyName = software.amazon.jsii.Kernel.get(this, "s3KeyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3BucketName = java.util.Objects.requireNonNull(builder.s3BucketName, "s3BucketName is required");
                this.s3KeyName = builder.s3KeyName;
            }

            @Override
            public final java.lang.String getS3BucketName() {
                return this.s3BucketName;
            }

            @Override
            public final java.lang.String getS3KeyName() {
                return this.s3KeyName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("s3BucketName", om.valueToTree(this.getS3BucketName()));
                if (this.getS3KeyName() != null) {
                    data.set("s3KeyName", om.valueToTree(this.getS3KeyName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnDomain.S3ExportingConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3ExportingConfigProperty.Jsii$Proxy that = (S3ExportingConfigProperty.Jsii$Proxy) o;

                if (!s3BucketName.equals(that.s3BucketName)) return false;
                return this.s3KeyName != null ? this.s3KeyName.equals(that.s3KeyName) : that.s3KeyName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3BucketName.hashCode();
                result = 31 * result + (this.s3KeyName != null ? this.s3KeyName.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.customerprofiles.CfnDomain}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.customerprofiles.CfnDomain> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.customerprofiles.CfnDomainProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.customerprofiles.CfnDomainProps.Builder();
        }

        /**
         * The default number of days until the data within the domain expires.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html#cfn-customerprofiles-domain-defaultexpirationdays">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html#cfn-customerprofiles-domain-defaultexpirationdays</a>
         * @param defaultExpirationDays The default number of days until the data within the domain expires. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultExpirationDays(final java.lang.Number defaultExpirationDays) {
            this.props.defaultExpirationDays(defaultExpirationDays);
            return this;
        }

        /**
         * The unique name of the domain.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html#cfn-customerprofiles-domain-domainname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html#cfn-customerprofiles-domain-domainname</a>
         * @param domainName The unique name of the domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(final java.lang.String domainName) {
            this.props.domainName(domainName);
            return this;
        }

        /**
         * The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting data from third party applications.
         * <p>
         * You must set up a policy on the <code>DeadLetterQueue</code> for the <code>SendMessage</code> operation to enable Amazon Connect Customer Profiles to send messages to the <code>DeadLetterQueue</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html#cfn-customerprofiles-domain-deadletterqueueurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html#cfn-customerprofiles-domain-deadletterqueueurl</a>
         * @param deadLetterQueueUrl The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting data from third party applications. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueueUrl(final java.lang.String deadLetterQueueUrl) {
            this.props.deadLetterQueueUrl(deadLetterQueueUrl);
            return this;
        }

        /**
         * The default encryption key, which is an AWS managed key, is used when no specific type of encryption key is specified.
         * <p>
         * It is used to encrypt all data before it is placed in permanent or semi-permanent storage.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html#cfn-customerprofiles-domain-defaultencryptionkey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html#cfn-customerprofiles-domain-defaultencryptionkey</a>
         * @param defaultEncryptionKey The default encryption key, which is an AWS managed key, is used when no specific type of encryption key is specified. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultEncryptionKey(final java.lang.String defaultEncryptionKey) {
            this.props.defaultEncryptionKey(defaultEncryptionKey);
            return this;
        }

        /**
         * The process of matching duplicate profiles.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html#cfn-customerprofiles-domain-matching">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html#cfn-customerprofiles-domain-matching</a>
         * @param matching The process of matching duplicate profiles. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder matching(final software.amazon.awscdk.IResolvable matching) {
            this.props.matching(matching);
            return this;
        }
        /**
         * The process of matching duplicate profiles.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html#cfn-customerprofiles-domain-matching">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html#cfn-customerprofiles-domain-matching</a>
         * @param matching The process of matching duplicate profiles. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder matching(final software.amazon.awscdk.services.customerprofiles.CfnDomain.MatchingProperty matching) {
            this.props.matching(matching);
            return this;
        }

        /**
         * The process of matching duplicate profiles using Rule-Based matching.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html#cfn-customerprofiles-domain-rulebasedmatching">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html#cfn-customerprofiles-domain-rulebasedmatching</a>
         * @param ruleBasedMatching The process of matching duplicate profiles using Rule-Based matching. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleBasedMatching(final software.amazon.awscdk.IResolvable ruleBasedMatching) {
            this.props.ruleBasedMatching(ruleBasedMatching);
            return this;
        }
        /**
         * The process of matching duplicate profiles using Rule-Based matching.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html#cfn-customerprofiles-domain-rulebasedmatching">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html#cfn-customerprofiles-domain-rulebasedmatching</a>
         * @param ruleBasedMatching The process of matching duplicate profiles using Rule-Based matching. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleBasedMatching(final software.amazon.awscdk.services.customerprofiles.CfnDomain.RuleBasedMatchingProperty ruleBasedMatching) {
            this.props.ruleBasedMatching(ruleBasedMatching);
            return this;
        }

        /**
         * The tags used to organize, track, or control access for this resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html#cfn-customerprofiles-domain-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html#cfn-customerprofiles-domain-tags</a>
         * @param tags The tags used to organize, track, or control access for this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.customerprofiles.CfnDomain}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.customerprofiles.CfnDomain build() {
            return new software.amazon.awscdk.services.customerprofiles.CfnDomain(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
