package software.amazon.awscdk.services.deadline;

/**
 * Properties for defining a <code>CfnLimit</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.deadline.*;
 * CfnLimitProps cfnLimitProps = CfnLimitProps.builder()
 *         .amountRequirementName("amountRequirementName")
 *         .displayName("displayName")
 *         .farmId("farmId")
 *         .maxCount(123)
 *         // the properties below are optional
 *         .description("description")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-limit.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-limit.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:34.081Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_deadline.CfnLimitProps")
@software.amazon.jsii.Jsii.Proxy(CfnLimitProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnLimitProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The value that you specify as the <code>name</code> in the <code>amounts</code> field of the <code>hostRequirements</code> in a step of a job template to declare the limit requirement.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-limit.html#cfn-deadline-limit-amountrequirementname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-limit.html#cfn-deadline-limit-amountrequirementname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAmountRequirementName();

    /**
     * The name of the limit used in lists to identify the limit.
     * <p>
     * <blockquote>
     * <p>
     * This field can store any content. Escape or encode this content before displaying it on a webpage or any other system that might interpret the content of this field.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-limit.html#cfn-deadline-limit-displayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-limit.html#cfn-deadline-limit-displayname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDisplayName();

    /**
     * The unique identifier of the farm that contains the limit.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-limit.html#cfn-deadline-limit-farmid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-limit.html#cfn-deadline-limit-farmid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFarmId();

    /**
     * The maximum number of resources constrained by this limit.
     * <p>
     * When all of the resources are in use, steps that require the limit won't be scheduled until the resource is available.
     * <p>
     * The <code>maxValue</code> must not be 0. If the value is -1, there is no restriction on the number of resources that can be acquired for this limit.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-limit.html#cfn-deadline-limit-maxcount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-limit.html#cfn-deadline-limit-maxcount</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getMaxCount();

    /**
     * A description of the limit. A clear description helps you identify the purpose of the limit.
     * <p>
     * <blockquote>
     * <p>
     * This field can store any content. Escape or encode this content before displaying it on a webpage or any other system that might interpret the content of this field.
     * <p>
     * </blockquote>
     * <p>
     * Default: - ""
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-limit.html#cfn-deadline-limit-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-limit.html#cfn-deadline-limit-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnLimitProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnLimitProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnLimitProps> {
        java.lang.String amountRequirementName;
        java.lang.String displayName;
        java.lang.String farmId;
        java.lang.Number maxCount;
        java.lang.String description;

        /**
         * Sets the value of {@link CfnLimitProps#getAmountRequirementName}
         * @param amountRequirementName The value that you specify as the <code>name</code> in the <code>amounts</code> field of the <code>hostRequirements</code> in a step of a job template to declare the limit requirement. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder amountRequirementName(java.lang.String amountRequirementName) {
            this.amountRequirementName = amountRequirementName;
            return this;
        }

        /**
         * Sets the value of {@link CfnLimitProps#getDisplayName}
         * @param displayName The name of the limit used in lists to identify the limit. This parameter is required.
         *                    <blockquote>
         *                    <p>
         *                    This field can store any content. Escape or encode this content before displaying it on a webpage or any other system that might interpret the content of this field.
         *                    <p>
         *                    </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Sets the value of {@link CfnLimitProps#getFarmId}
         * @param farmId The unique identifier of the farm that contains the limit. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder farmId(java.lang.String farmId) {
            this.farmId = farmId;
            return this;
        }

        /**
         * Sets the value of {@link CfnLimitProps#getMaxCount}
         * @param maxCount The maximum number of resources constrained by this limit. This parameter is required.
         *                 When all of the resources are in use, steps that require the limit won't be scheduled until the resource is available.
         *                 <p>
         *                 The <code>maxValue</code> must not be 0. If the value is -1, there is no restriction on the number of resources that can be acquired for this limit.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxCount(java.lang.Number maxCount) {
            this.maxCount = maxCount;
            return this;
        }

        /**
         * Sets the value of {@link CfnLimitProps#getDescription}
         * @param description A description of the limit. A clear description helps you identify the purpose of the limit.
         *                    <blockquote>
         *                    <p>
         *                    This field can store any content. Escape or encode this content before displaying it on a webpage or any other system that might interpret the content of this field.
         *                    <p>
         *                    </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnLimitProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnLimitProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnLimitProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnLimitProps {
        private final java.lang.String amountRequirementName;
        private final java.lang.String displayName;
        private final java.lang.String farmId;
        private final java.lang.Number maxCount;
        private final java.lang.String description;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.amountRequirementName = software.amazon.jsii.Kernel.get(this, "amountRequirementName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.displayName = software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.farmId = software.amazon.jsii.Kernel.get(this, "farmId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxCount = software.amazon.jsii.Kernel.get(this, "maxCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.amountRequirementName = java.util.Objects.requireNonNull(builder.amountRequirementName, "amountRequirementName is required");
            this.displayName = java.util.Objects.requireNonNull(builder.displayName, "displayName is required");
            this.farmId = java.util.Objects.requireNonNull(builder.farmId, "farmId is required");
            this.maxCount = java.util.Objects.requireNonNull(builder.maxCount, "maxCount is required");
            this.description = builder.description;
        }

        @Override
        public final java.lang.String getAmountRequirementName() {
            return this.amountRequirementName;
        }

        @Override
        public final java.lang.String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final java.lang.String getFarmId() {
            return this.farmId;
        }

        @Override
        public final java.lang.Number getMaxCount() {
            return this.maxCount;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("amountRequirementName", om.valueToTree(this.getAmountRequirementName()));
            data.set("displayName", om.valueToTree(this.getDisplayName()));
            data.set("farmId", om.valueToTree(this.getFarmId()));
            data.set("maxCount", om.valueToTree(this.getMaxCount()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_deadline.CfnLimitProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnLimitProps.Jsii$Proxy that = (CfnLimitProps.Jsii$Proxy) o;

            if (!amountRequirementName.equals(that.amountRequirementName)) return false;
            if (!displayName.equals(that.displayName)) return false;
            if (!farmId.equals(that.farmId)) return false;
            if (!maxCount.equals(that.maxCount)) return false;
            return this.description != null ? this.description.equals(that.description) : that.description == null;
        }

        @Override
        public final int hashCode() {
            int result = this.amountRequirementName.hashCode();
            result = 31 * result + (this.displayName.hashCode());
            result = 31 * result + (this.farmId.hashCode());
            result = 31 * result + (this.maxCount.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            return result;
        }
    }
}
