package software.amazon.awscdk.services.dms;

/**
 * Properties for defining a <code>CfnMigrationProject</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.dms.*;
 * CfnMigrationProjectProps cfnMigrationProjectProps = CfnMigrationProjectProps.builder()
 *         .description("description")
 *         .instanceProfileArn("instanceProfileArn")
 *         .instanceProfileIdentifier("instanceProfileIdentifier")
 *         .instanceProfileName("instanceProfileName")
 *         .migrationProjectCreationTime("migrationProjectCreationTime")
 *         .migrationProjectIdentifier("migrationProjectIdentifier")
 *         .migrationProjectName("migrationProjectName")
 *         .schemaConversionApplicationAttributes(SchemaConversionApplicationAttributesProperty.builder()
 *                 .s3BucketPath("s3BucketPath")
 *                 .s3BucketRoleArn("s3BucketRoleArn")
 *                 .build())
 *         .sourceDataProviderDescriptors(List.of(DataProviderDescriptorProperty.builder()
 *                 .dataProviderArn("dataProviderArn")
 *                 .dataProviderIdentifier("dataProviderIdentifier")
 *                 .dataProviderName("dataProviderName")
 *                 .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
 *                 .secretsManagerSecretId("secretsManagerSecretId")
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .targetDataProviderDescriptors(List.of(DataProviderDescriptorProperty.builder()
 *                 .dataProviderArn("dataProviderArn")
 *                 .dataProviderIdentifier("dataProviderIdentifier")
 *                 .dataProviderName("dataProviderName")
 *                 .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
 *                 .secretsManagerSecretId("secretsManagerSecretId")
 *                 .build()))
 *         .transformationRules("transformationRules")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:34.263Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnMigrationProjectProps")
@software.amazon.jsii.Jsii.Proxy(CfnMigrationProjectProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnMigrationProjectProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A user-friendly description of the migration project.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the instance profile for your migration project.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-instanceprofilearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-instanceprofilearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInstanceProfileArn() {
        return null;
    }

    /**
     * The identifier of the instance profile for your migration project.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-instanceprofileidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-instanceprofileidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInstanceProfileIdentifier() {
        return null;
    }

    /**
     * The name of the associated instance profile.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-instanceprofilename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-instanceprofilename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInstanceProfileName() {
        return null;
    }

    /**
     * (deprecated) The property describes a creating time of the migration project.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-migrationprojectcreationtime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-migrationprojectcreationtime</a>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.String getMigrationProjectCreationTime() {
        return null;
    }

    /**
     * The identifier of the migration project.
     * <p>
     * Identifiers must begin with a letter and must contain only ASCII letters, digits, and hyphens. They can't end with a hyphen, or contain two consecutive hyphens.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-migrationprojectidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-migrationprojectidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMigrationProjectIdentifier() {
        return null;
    }

    /**
     * The name of the migration project.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-migrationprojectname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-migrationprojectname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMigrationProjectName() {
        return null;
    }

    /**
     * The schema conversion application attributes, including the Amazon S3 bucket name and Amazon S3 role ARN.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-schemaconversionapplicationattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-schemaconversionapplicationattributes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSchemaConversionApplicationAttributes() {
        return null;
    }

    /**
     * Information about the source data provider, including the name or ARN, and AWS Secrets Manager parameters.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-sourcedataproviderdescriptors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-sourcedataproviderdescriptors</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSourceDataProviderDescriptors() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * Information about the target data provider, including the name or ARN, and AWS Secrets Manager parameters.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-targetdataproviderdescriptors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-targetdataproviderdescriptors</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTargetDataProviderDescriptors() {
        return null;
    }

    /**
     * The settings in JSON format for migration rules.
     * <p>
     * Migration rules make it possible for you to change the object names according to the rules that you specify. For example, you can change an object name to lowercase or uppercase, add or remove a prefix or suffix, or rename objects.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-transformationrules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-migrationproject.html#cfn-dms-migrationproject-transformationrules</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTransformationRules() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnMigrationProjectProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnMigrationProjectProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnMigrationProjectProps> {
        java.lang.String description;
        java.lang.String instanceProfileArn;
        java.lang.String instanceProfileIdentifier;
        java.lang.String instanceProfileName;
        java.lang.String migrationProjectCreationTime;
        java.lang.String migrationProjectIdentifier;
        java.lang.String migrationProjectName;
        java.lang.Object schemaConversionApplicationAttributes;
        java.lang.Object sourceDataProviderDescriptors;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object targetDataProviderDescriptors;
        java.lang.String transformationRules;

        /**
         * Sets the value of {@link CfnMigrationProjectProps#getDescription}
         * @param description A user-friendly description of the migration project.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnMigrationProjectProps#getInstanceProfileArn}
         * @param instanceProfileArn The Amazon Resource Name (ARN) of the instance profile for your migration project.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceProfileArn(java.lang.String instanceProfileArn) {
            this.instanceProfileArn = instanceProfileArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnMigrationProjectProps#getInstanceProfileIdentifier}
         * @param instanceProfileIdentifier The identifier of the instance profile for your migration project.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceProfileIdentifier(java.lang.String instanceProfileIdentifier) {
            this.instanceProfileIdentifier = instanceProfileIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnMigrationProjectProps#getInstanceProfileName}
         * @param instanceProfileName The name of the associated instance profile.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceProfileName(java.lang.String instanceProfileName) {
            this.instanceProfileName = instanceProfileName;
            return this;
        }

        /**
         * Sets the value of {@link CfnMigrationProjectProps#getMigrationProjectCreationTime}
         * @param migrationProjectCreationTime The property describes a creating time of the migration project.
         * @return {@code this}
         * @deprecated this property has been deprecated
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder migrationProjectCreationTime(java.lang.String migrationProjectCreationTime) {
            this.migrationProjectCreationTime = migrationProjectCreationTime;
            return this;
        }

        /**
         * Sets the value of {@link CfnMigrationProjectProps#getMigrationProjectIdentifier}
         * @param migrationProjectIdentifier The identifier of the migration project.
         *                                   Identifiers must begin with a letter and must contain only ASCII letters, digits, and hyphens. They can't end with a hyphen, or contain two consecutive hyphens.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder migrationProjectIdentifier(java.lang.String migrationProjectIdentifier) {
            this.migrationProjectIdentifier = migrationProjectIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnMigrationProjectProps#getMigrationProjectName}
         * @param migrationProjectName The name of the migration project.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder migrationProjectName(java.lang.String migrationProjectName) {
            this.migrationProjectName = migrationProjectName;
            return this;
        }

        /**
         * Sets the value of {@link CfnMigrationProjectProps#getSchemaConversionApplicationAttributes}
         * @param schemaConversionApplicationAttributes The schema conversion application attributes, including the Amazon S3 bucket name and Amazon S3 role ARN.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schemaConversionApplicationAttributes(software.amazon.awscdk.IResolvable schemaConversionApplicationAttributes) {
            this.schemaConversionApplicationAttributes = schemaConversionApplicationAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnMigrationProjectProps#getSchemaConversionApplicationAttributes}
         * @param schemaConversionApplicationAttributes The schema conversion application attributes, including the Amazon S3 bucket name and Amazon S3 role ARN.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schemaConversionApplicationAttributes(software.amazon.awscdk.services.dms.CfnMigrationProject.SchemaConversionApplicationAttributesProperty schemaConversionApplicationAttributes) {
            this.schemaConversionApplicationAttributes = schemaConversionApplicationAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnMigrationProjectProps#getSourceDataProviderDescriptors}
         * @param sourceDataProviderDescriptors Information about the source data provider, including the name or ARN, and AWS Secrets Manager parameters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceDataProviderDescriptors(software.amazon.awscdk.IResolvable sourceDataProviderDescriptors) {
            this.sourceDataProviderDescriptors = sourceDataProviderDescriptors;
            return this;
        }

        /**
         * Sets the value of {@link CfnMigrationProjectProps#getSourceDataProviderDescriptors}
         * @param sourceDataProviderDescriptors Information about the source data provider, including the name or ARN, and AWS Secrets Manager parameters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceDataProviderDescriptors(java.util.List<? extends java.lang.Object> sourceDataProviderDescriptors) {
            this.sourceDataProviderDescriptors = sourceDataProviderDescriptors;
            return this;
        }

        /**
         * Sets the value of {@link CfnMigrationProjectProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnMigrationProjectProps#getTargetDataProviderDescriptors}
         * @param targetDataProviderDescriptors Information about the target data provider, including the name or ARN, and AWS Secrets Manager parameters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetDataProviderDescriptors(software.amazon.awscdk.IResolvable targetDataProviderDescriptors) {
            this.targetDataProviderDescriptors = targetDataProviderDescriptors;
            return this;
        }

        /**
         * Sets the value of {@link CfnMigrationProjectProps#getTargetDataProviderDescriptors}
         * @param targetDataProviderDescriptors Information about the target data provider, including the name or ARN, and AWS Secrets Manager parameters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetDataProviderDescriptors(java.util.List<? extends java.lang.Object> targetDataProviderDescriptors) {
            this.targetDataProviderDescriptors = targetDataProviderDescriptors;
            return this;
        }

        /**
         * Sets the value of {@link CfnMigrationProjectProps#getTransformationRules}
         * @param transformationRules The settings in JSON format for migration rules.
         *                            Migration rules make it possible for you to change the object names according to the rules that you specify. For example, you can change an object name to lowercase or uppercase, add or remove a prefix or suffix, or rename objects.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transformationRules(java.lang.String transformationRules) {
            this.transformationRules = transformationRules;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnMigrationProjectProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnMigrationProjectProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnMigrationProjectProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnMigrationProjectProps {
        private final java.lang.String description;
        private final java.lang.String instanceProfileArn;
        private final java.lang.String instanceProfileIdentifier;
        private final java.lang.String instanceProfileName;
        private final java.lang.String migrationProjectCreationTime;
        private final java.lang.String migrationProjectIdentifier;
        private final java.lang.String migrationProjectName;
        private final java.lang.Object schemaConversionApplicationAttributes;
        private final java.lang.Object sourceDataProviderDescriptors;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object targetDataProviderDescriptors;
        private final java.lang.String transformationRules;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceProfileArn = software.amazon.jsii.Kernel.get(this, "instanceProfileArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceProfileIdentifier = software.amazon.jsii.Kernel.get(this, "instanceProfileIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceProfileName = software.amazon.jsii.Kernel.get(this, "instanceProfileName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.migrationProjectCreationTime = software.amazon.jsii.Kernel.get(this, "migrationProjectCreationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.migrationProjectIdentifier = software.amazon.jsii.Kernel.get(this, "migrationProjectIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.migrationProjectName = software.amazon.jsii.Kernel.get(this, "migrationProjectName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.schemaConversionApplicationAttributes = software.amazon.jsii.Kernel.get(this, "schemaConversionApplicationAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.sourceDataProviderDescriptors = software.amazon.jsii.Kernel.get(this, "sourceDataProviderDescriptors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.targetDataProviderDescriptors = software.amazon.jsii.Kernel.get(this, "targetDataProviderDescriptors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.transformationRules = software.amazon.jsii.Kernel.get(this, "transformationRules", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.description = builder.description;
            this.instanceProfileArn = builder.instanceProfileArn;
            this.instanceProfileIdentifier = builder.instanceProfileIdentifier;
            this.instanceProfileName = builder.instanceProfileName;
            this.migrationProjectCreationTime = builder.migrationProjectCreationTime;
            this.migrationProjectIdentifier = builder.migrationProjectIdentifier;
            this.migrationProjectName = builder.migrationProjectName;
            this.schemaConversionApplicationAttributes = builder.schemaConversionApplicationAttributes;
            this.sourceDataProviderDescriptors = builder.sourceDataProviderDescriptors;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.targetDataProviderDescriptors = builder.targetDataProviderDescriptors;
            this.transformationRules = builder.transformationRules;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getInstanceProfileArn() {
            return this.instanceProfileArn;
        }

        @Override
        public final java.lang.String getInstanceProfileIdentifier() {
            return this.instanceProfileIdentifier;
        }

        @Override
        public final java.lang.String getInstanceProfileName() {
            return this.instanceProfileName;
        }

        @Override
        public final java.lang.String getMigrationProjectCreationTime() {
            return this.migrationProjectCreationTime;
        }

        @Override
        public final java.lang.String getMigrationProjectIdentifier() {
            return this.migrationProjectIdentifier;
        }

        @Override
        public final java.lang.String getMigrationProjectName() {
            return this.migrationProjectName;
        }

        @Override
        public final java.lang.Object getSchemaConversionApplicationAttributes() {
            return this.schemaConversionApplicationAttributes;
        }

        @Override
        public final java.lang.Object getSourceDataProviderDescriptors() {
            return this.sourceDataProviderDescriptors;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getTargetDataProviderDescriptors() {
            return this.targetDataProviderDescriptors;
        }

        @Override
        public final java.lang.String getTransformationRules() {
            return this.transformationRules;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getInstanceProfileArn() != null) {
                data.set("instanceProfileArn", om.valueToTree(this.getInstanceProfileArn()));
            }
            if (this.getInstanceProfileIdentifier() != null) {
                data.set("instanceProfileIdentifier", om.valueToTree(this.getInstanceProfileIdentifier()));
            }
            if (this.getInstanceProfileName() != null) {
                data.set("instanceProfileName", om.valueToTree(this.getInstanceProfileName()));
            }
            if (this.getMigrationProjectCreationTime() != null) {
                data.set("migrationProjectCreationTime", om.valueToTree(this.getMigrationProjectCreationTime()));
            }
            if (this.getMigrationProjectIdentifier() != null) {
                data.set("migrationProjectIdentifier", om.valueToTree(this.getMigrationProjectIdentifier()));
            }
            if (this.getMigrationProjectName() != null) {
                data.set("migrationProjectName", om.valueToTree(this.getMigrationProjectName()));
            }
            if (this.getSchemaConversionApplicationAttributes() != null) {
                data.set("schemaConversionApplicationAttributes", om.valueToTree(this.getSchemaConversionApplicationAttributes()));
            }
            if (this.getSourceDataProviderDescriptors() != null) {
                data.set("sourceDataProviderDescriptors", om.valueToTree(this.getSourceDataProviderDescriptors()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTargetDataProviderDescriptors() != null) {
                data.set("targetDataProviderDescriptors", om.valueToTree(this.getTargetDataProviderDescriptors()));
            }
            if (this.getTransformationRules() != null) {
                data.set("transformationRules", om.valueToTree(this.getTransformationRules()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnMigrationProjectProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnMigrationProjectProps.Jsii$Proxy that = (CfnMigrationProjectProps.Jsii$Proxy) o;

            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.instanceProfileArn != null ? !this.instanceProfileArn.equals(that.instanceProfileArn) : that.instanceProfileArn != null) return false;
            if (this.instanceProfileIdentifier != null ? !this.instanceProfileIdentifier.equals(that.instanceProfileIdentifier) : that.instanceProfileIdentifier != null) return false;
            if (this.instanceProfileName != null ? !this.instanceProfileName.equals(that.instanceProfileName) : that.instanceProfileName != null) return false;
            if (this.migrationProjectCreationTime != null ? !this.migrationProjectCreationTime.equals(that.migrationProjectCreationTime) : that.migrationProjectCreationTime != null) return false;
            if (this.migrationProjectIdentifier != null ? !this.migrationProjectIdentifier.equals(that.migrationProjectIdentifier) : that.migrationProjectIdentifier != null) return false;
            if (this.migrationProjectName != null ? !this.migrationProjectName.equals(that.migrationProjectName) : that.migrationProjectName != null) return false;
            if (this.schemaConversionApplicationAttributes != null ? !this.schemaConversionApplicationAttributes.equals(that.schemaConversionApplicationAttributes) : that.schemaConversionApplicationAttributes != null) return false;
            if (this.sourceDataProviderDescriptors != null ? !this.sourceDataProviderDescriptors.equals(that.sourceDataProviderDescriptors) : that.sourceDataProviderDescriptors != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.targetDataProviderDescriptors != null ? !this.targetDataProviderDescriptors.equals(that.targetDataProviderDescriptors) : that.targetDataProviderDescriptors != null) return false;
            return this.transformationRules != null ? this.transformationRules.equals(that.transformationRules) : that.transformationRules == null;
        }

        @Override
        public final int hashCode() {
            int result = this.description != null ? this.description.hashCode() : 0;
            result = 31 * result + (this.instanceProfileArn != null ? this.instanceProfileArn.hashCode() : 0);
            result = 31 * result + (this.instanceProfileIdentifier != null ? this.instanceProfileIdentifier.hashCode() : 0);
            result = 31 * result + (this.instanceProfileName != null ? this.instanceProfileName.hashCode() : 0);
            result = 31 * result + (this.migrationProjectCreationTime != null ? this.migrationProjectCreationTime.hashCode() : 0);
            result = 31 * result + (this.migrationProjectIdentifier != null ? this.migrationProjectIdentifier.hashCode() : 0);
            result = 31 * result + (this.migrationProjectName != null ? this.migrationProjectName.hashCode() : 0);
            result = 31 * result + (this.schemaConversionApplicationAttributes != null ? this.schemaConversionApplicationAttributes.hashCode() : 0);
            result = 31 * result + (this.sourceDataProviderDescriptors != null ? this.sourceDataProviderDescriptors.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.targetDataProviderDescriptors != null ? this.targetDataProviderDescriptors.hashCode() : 0);
            result = 31 * result + (this.transformationRules != null ? this.transformationRules.hashCode() : 0);
            return result;
        }
    }
}
