package software.amazon.awscdk.services.dynamodb;

/**
 * Properties used to configure a DynamoDB table.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * App app = new App();
 * Stack stack = Stack.Builder.create(app, "Stack").env(Environment.builder().region("us-west-2").build()).build();
 * TableV2 globalTable = TableV2.Builder.create(stack, "GlobalTable")
 *         .partitionKey(Attribute.builder().name("pk").type(AttributeType.STRING).build())
 *         // applies to all replicas, i.e., us-west-2, us-east-1, us-east-2
 *         .removalPolicy(RemovalPolicy.DESTROY)
 *         .replicas(List.of(ReplicaTableProps.builder().region("us-east-1").build(), ReplicaTableProps.builder().region("us-east-2").build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:34.443Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.TablePropsV2")
@software.amazon.jsii.Jsii.Proxy(TablePropsV2.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TablePropsV2 extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.dynamodb.TableOptionsV2 {

    /**
     * Partition key attribute definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.Attribute getPartitionKey();

    /**
     * The billing mode and capacity settings to apply to the table.
     * <p>
     * Default: Billing.onDemand()
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.Billing getBilling() {
        return null;
    }

    /**
     * When an item in the table is modified, StreamViewType determines what information is written to the stream.
     * <p>
     * Default: - streams are disabled if replicas are not configured and this property is
     * not specified. If this property is not specified when replicas are configured, then
     * NEW_AND_OLD_IMAGES will be the StreamViewType for all replicas
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.StreamViewType getDynamoStream() {
        return null;
    }

    /**
     * The server-side encryption.
     * <p>
     * Default: TableEncryptionV2.dynamoOwnedKey()
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.TableEncryptionV2 getEncryption() {
        return null;
    }

    /**
     * Global secondary indexes.
     * <p>
     * Note: You can provide a maximum of 20 global secondary indexes.
     * <p>
     * Default: - no global secondary indexes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.dynamodb.GlobalSecondaryIndexPropsV2> getGlobalSecondaryIndexes() {
        return null;
    }

    /**
     * Local secondary indexes.
     * <p>
     * Note: You can only provide a maximum of 5 local secondary indexes.
     * <p>
     * Default: - no local secondary indexes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.dynamodb.LocalSecondaryIndexProps> getLocalSecondaryIndexes() {
        return null;
    }

    /**
     * The removal policy applied to the table.
     * <p>
     * Default: RemovalPolicy.RETAIN
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * Replica tables to deploy with the primary table.
     * <p>
     * Note: Adding replica tables allows you to use your table as a global table. You
     * cannot specify a replica table in the region that the primary table will be deployed
     * to. Replica tables will only be supported if the stack deployment region is defined.
     * <p>
     * Default: - no replica tables
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.dynamodb.ReplicaTableProps> getReplicas() {
        return null;
    }

    /**
     * Sort key attribute definition.
     * <p>
     * Default: - no sort key
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.Attribute getSortKey() {
        return null;
    }

    /**
     * The name of the table.
     * <p>
     * Default: - generated by CloudFormation
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTableName() {
        return null;
    }

    /**
     * The name of the TTL attribute.
     * <p>
     * Default: - TTL is disabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTimeToLiveAttribute() {
        return null;
    }

    /**
     * The warm throughput configuration for the table.
     * <p>
     * Default: - no warm throughput is configured
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.WarmThroughput getWarmThroughput() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TablePropsV2}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TablePropsV2}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TablePropsV2> {
        software.amazon.awscdk.services.dynamodb.Attribute partitionKey;
        software.amazon.awscdk.services.dynamodb.Billing billing;
        software.amazon.awscdk.services.dynamodb.StreamViewType dynamoStream;
        software.amazon.awscdk.services.dynamodb.TableEncryptionV2 encryption;
        java.util.List<software.amazon.awscdk.services.dynamodb.GlobalSecondaryIndexPropsV2> globalSecondaryIndexes;
        java.util.List<software.amazon.awscdk.services.dynamodb.LocalSecondaryIndexProps> localSecondaryIndexes;
        software.amazon.awscdk.RemovalPolicy removalPolicy;
        java.util.List<software.amazon.awscdk.services.dynamodb.ReplicaTableProps> replicas;
        software.amazon.awscdk.services.dynamodb.Attribute sortKey;
        java.lang.String tableName;
        java.lang.String timeToLiveAttribute;
        software.amazon.awscdk.services.dynamodb.WarmThroughput warmThroughput;
        java.lang.Boolean contributorInsights;
        java.lang.Boolean deletionProtection;
        software.amazon.awscdk.services.kinesis.IStream kinesisStream;
        java.lang.Boolean pointInTimeRecovery;
        software.amazon.awscdk.services.dynamodb.PointInTimeRecoverySpecification pointInTimeRecoverySpecification;
        software.amazon.awscdk.services.iam.PolicyDocument resourcePolicy;
        software.amazon.awscdk.services.dynamodb.TableClass tableClass;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link TablePropsV2#getPartitionKey}
         * @param partitionKey Partition key attribute definition. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder partitionKey(software.amazon.awscdk.services.dynamodb.Attribute partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        /**
         * Sets the value of {@link TablePropsV2#getBilling}
         * @param billing The billing mode and capacity settings to apply to the table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder billing(software.amazon.awscdk.services.dynamodb.Billing billing) {
            this.billing = billing;
            return this;
        }

        /**
         * Sets the value of {@link TablePropsV2#getDynamoStream}
         * @param dynamoStream When an item in the table is modified, StreamViewType determines what information is written to the stream.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dynamoStream(software.amazon.awscdk.services.dynamodb.StreamViewType dynamoStream) {
            this.dynamoStream = dynamoStream;
            return this;
        }

        /**
         * Sets the value of {@link TablePropsV2#getEncryption}
         * @param encryption The server-side encryption.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryption(software.amazon.awscdk.services.dynamodb.TableEncryptionV2 encryption) {
            this.encryption = encryption;
            return this;
        }

        /**
         * Sets the value of {@link TablePropsV2#getGlobalSecondaryIndexes}
         * @param globalSecondaryIndexes Global secondary indexes.
         *                               Note: You can provide a maximum of 20 global secondary indexes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder globalSecondaryIndexes(java.util.List<? extends software.amazon.awscdk.services.dynamodb.GlobalSecondaryIndexPropsV2> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = (java.util.List<software.amazon.awscdk.services.dynamodb.GlobalSecondaryIndexPropsV2>)globalSecondaryIndexes;
            return this;
        }

        /**
         * Sets the value of {@link TablePropsV2#getLocalSecondaryIndexes}
         * @param localSecondaryIndexes Local secondary indexes.
         *                              Note: You can only provide a maximum of 5 local secondary indexes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder localSecondaryIndexes(java.util.List<? extends software.amazon.awscdk.services.dynamodb.LocalSecondaryIndexProps> localSecondaryIndexes) {
            this.localSecondaryIndexes = (java.util.List<software.amazon.awscdk.services.dynamodb.LocalSecondaryIndexProps>)localSecondaryIndexes;
            return this;
        }

        /**
         * Sets the value of {@link TablePropsV2#getRemovalPolicy}
         * @param removalPolicy The removal policy applied to the table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link TablePropsV2#getReplicas}
         * @param replicas Replica tables to deploy with the primary table.
         *                 Note: Adding replica tables allows you to use your table as a global table. You
         *                 cannot specify a replica table in the region that the primary table will be deployed
         *                 to. Replica tables will only be supported if the stack deployment region is defined.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder replicas(java.util.List<? extends software.amazon.awscdk.services.dynamodb.ReplicaTableProps> replicas) {
            this.replicas = (java.util.List<software.amazon.awscdk.services.dynamodb.ReplicaTableProps>)replicas;
            return this;
        }

        /**
         * Sets the value of {@link TablePropsV2#getSortKey}
         * @param sortKey Sort key attribute definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sortKey(software.amazon.awscdk.services.dynamodb.Attribute sortKey) {
            this.sortKey = sortKey;
            return this;
        }

        /**
         * Sets the value of {@link TablePropsV2#getTableName}
         * @param tableName The name of the table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableName(java.lang.String tableName) {
            this.tableName = tableName;
            return this;
        }

        /**
         * Sets the value of {@link TablePropsV2#getTimeToLiveAttribute}
         * @param timeToLiveAttribute The name of the TTL attribute.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeToLiveAttribute(java.lang.String timeToLiveAttribute) {
            this.timeToLiveAttribute = timeToLiveAttribute;
            return this;
        }

        /**
         * Sets the value of {@link TablePropsV2#getWarmThroughput}
         * @param warmThroughput The warm throughput configuration for the table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder warmThroughput(software.amazon.awscdk.services.dynamodb.WarmThroughput warmThroughput) {
            this.warmThroughput = warmThroughput;
            return this;
        }

        /**
         * Sets the value of {@link TablePropsV2#getContributorInsights}
         * @param contributorInsights Whether CloudWatch contributor insights is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contributorInsights(java.lang.Boolean contributorInsights) {
            this.contributorInsights = contributorInsights;
            return this;
        }

        /**
         * Sets the value of {@link TablePropsV2#getDeletionProtection}
         * @param deletionProtection Whether deletion protection is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(java.lang.Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        /**
         * Sets the value of {@link TablePropsV2#getKinesisStream}
         * @param kinesisStream Kinesis Data Stream to capture item level changes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisStream(software.amazon.awscdk.services.kinesis.IStream kinesisStream) {
            this.kinesisStream = kinesisStream;
            return this;
        }

        /**
         * Sets the value of {@link TablePropsV2#getPointInTimeRecovery}
         * @param pointInTimeRecovery Whether point-in-time recovery is enabled.
         * @return {@code this}
         * @deprecated use `pointInTimeRecoverySpecification` instead
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder pointInTimeRecovery(java.lang.Boolean pointInTimeRecovery) {
            this.pointInTimeRecovery = pointInTimeRecovery;
            return this;
        }

        /**
         * Sets the value of {@link TablePropsV2#getPointInTimeRecoverySpecification}
         * @param pointInTimeRecoverySpecification Whether point-in-time recovery is enabled and recoveryPeriodInDays is set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pointInTimeRecoverySpecification(software.amazon.awscdk.services.dynamodb.PointInTimeRecoverySpecification pointInTimeRecoverySpecification) {
            this.pointInTimeRecoverySpecification = pointInTimeRecoverySpecification;
            return this;
        }

        /**
         * Sets the value of {@link TablePropsV2#getResourcePolicy}
         * @param resourcePolicy Resource policy to assign to DynamoDB Table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourcePolicy(software.amazon.awscdk.services.iam.PolicyDocument resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
            return this;
        }

        /**
         * Sets the value of {@link TablePropsV2#getTableClass}
         * @param tableClass The table class.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableClass(software.amazon.awscdk.services.dynamodb.TableClass tableClass) {
            this.tableClass = tableClass;
            return this;
        }

        /**
         * Sets the value of {@link TablePropsV2#getTags}
         * @param tags Tags to be applied to the primary table (default replica table).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TablePropsV2}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TablePropsV2 build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TablePropsV2}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TablePropsV2 {
        private final software.amazon.awscdk.services.dynamodb.Attribute partitionKey;
        private final software.amazon.awscdk.services.dynamodb.Billing billing;
        private final software.amazon.awscdk.services.dynamodb.StreamViewType dynamoStream;
        private final software.amazon.awscdk.services.dynamodb.TableEncryptionV2 encryption;
        private final java.util.List<software.amazon.awscdk.services.dynamodb.GlobalSecondaryIndexPropsV2> globalSecondaryIndexes;
        private final java.util.List<software.amazon.awscdk.services.dynamodb.LocalSecondaryIndexProps> localSecondaryIndexes;
        private final software.amazon.awscdk.RemovalPolicy removalPolicy;
        private final java.util.List<software.amazon.awscdk.services.dynamodb.ReplicaTableProps> replicas;
        private final software.amazon.awscdk.services.dynamodb.Attribute sortKey;
        private final java.lang.String tableName;
        private final java.lang.String timeToLiveAttribute;
        private final software.amazon.awscdk.services.dynamodb.WarmThroughput warmThroughput;
        private final java.lang.Boolean contributorInsights;
        private final java.lang.Boolean deletionProtection;
        private final software.amazon.awscdk.services.kinesis.IStream kinesisStream;
        private final java.lang.Boolean pointInTimeRecovery;
        private final software.amazon.awscdk.services.dynamodb.PointInTimeRecoverySpecification pointInTimeRecoverySpecification;
        private final software.amazon.awscdk.services.iam.PolicyDocument resourcePolicy;
        private final software.amazon.awscdk.services.dynamodb.TableClass tableClass;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.partitionKey = software.amazon.jsii.Kernel.get(this, "partitionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.Attribute.class));
            this.billing = software.amazon.jsii.Kernel.get(this, "billing", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.Billing.class));
            this.dynamoStream = software.amazon.jsii.Kernel.get(this, "dynamoStream", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.StreamViewType.class));
            this.encryption = software.amazon.jsii.Kernel.get(this, "encryption", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.TableEncryptionV2.class));
            this.globalSecondaryIndexes = software.amazon.jsii.Kernel.get(this, "globalSecondaryIndexes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.GlobalSecondaryIndexPropsV2.class)));
            this.localSecondaryIndexes = software.amazon.jsii.Kernel.get(this, "localSecondaryIndexes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.LocalSecondaryIndexProps.class)));
            this.removalPolicy = software.amazon.jsii.Kernel.get(this, "removalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.RemovalPolicy.class));
            this.replicas = software.amazon.jsii.Kernel.get(this, "replicas", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.ReplicaTableProps.class)));
            this.sortKey = software.amazon.jsii.Kernel.get(this, "sortKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.Attribute.class));
            this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.timeToLiveAttribute = software.amazon.jsii.Kernel.get(this, "timeToLiveAttribute", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.warmThroughput = software.amazon.jsii.Kernel.get(this, "warmThroughput", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.WarmThroughput.class));
            this.contributorInsights = software.amazon.jsii.Kernel.get(this, "contributorInsights", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.deletionProtection = software.amazon.jsii.Kernel.get(this, "deletionProtection", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.kinesisStream = software.amazon.jsii.Kernel.get(this, "kinesisStream", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesis.IStream.class));
            this.pointInTimeRecovery = software.amazon.jsii.Kernel.get(this, "pointInTimeRecovery", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.pointInTimeRecoverySpecification = software.amazon.jsii.Kernel.get(this, "pointInTimeRecoverySpecification", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.PointInTimeRecoverySpecification.class));
            this.resourcePolicy = software.amazon.jsii.Kernel.get(this, "resourcePolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyDocument.class));
            this.tableClass = software.amazon.jsii.Kernel.get(this, "tableClass", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.TableClass.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.partitionKey = java.util.Objects.requireNonNull(builder.partitionKey, "partitionKey is required");
            this.billing = builder.billing;
            this.dynamoStream = builder.dynamoStream;
            this.encryption = builder.encryption;
            this.globalSecondaryIndexes = (java.util.List<software.amazon.awscdk.services.dynamodb.GlobalSecondaryIndexPropsV2>)builder.globalSecondaryIndexes;
            this.localSecondaryIndexes = (java.util.List<software.amazon.awscdk.services.dynamodb.LocalSecondaryIndexProps>)builder.localSecondaryIndexes;
            this.removalPolicy = builder.removalPolicy;
            this.replicas = (java.util.List<software.amazon.awscdk.services.dynamodb.ReplicaTableProps>)builder.replicas;
            this.sortKey = builder.sortKey;
            this.tableName = builder.tableName;
            this.timeToLiveAttribute = builder.timeToLiveAttribute;
            this.warmThroughput = builder.warmThroughput;
            this.contributorInsights = builder.contributorInsights;
            this.deletionProtection = builder.deletionProtection;
            this.kinesisStream = builder.kinesisStream;
            this.pointInTimeRecovery = builder.pointInTimeRecovery;
            this.pointInTimeRecoverySpecification = builder.pointInTimeRecoverySpecification;
            this.resourcePolicy = builder.resourcePolicy;
            this.tableClass = builder.tableClass;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.Attribute getPartitionKey() {
            return this.partitionKey;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.Billing getBilling() {
            return this.billing;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.StreamViewType getDynamoStream() {
            return this.dynamoStream;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.TableEncryptionV2 getEncryption() {
            return this.encryption;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.dynamodb.GlobalSecondaryIndexPropsV2> getGlobalSecondaryIndexes() {
            return this.globalSecondaryIndexes;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.dynamodb.LocalSecondaryIndexProps> getLocalSecondaryIndexes() {
            return this.localSecondaryIndexes;
        }

        @Override
        public final software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.dynamodb.ReplicaTableProps> getReplicas() {
            return this.replicas;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.Attribute getSortKey() {
            return this.sortKey;
        }

        @Override
        public final java.lang.String getTableName() {
            return this.tableName;
        }

        @Override
        public final java.lang.String getTimeToLiveAttribute() {
            return this.timeToLiveAttribute;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.WarmThroughput getWarmThroughput() {
            return this.warmThroughput;
        }

        @Override
        public final java.lang.Boolean getContributorInsights() {
            return this.contributorInsights;
        }

        @Override
        public final java.lang.Boolean getDeletionProtection() {
            return this.deletionProtection;
        }

        @Override
        public final software.amazon.awscdk.services.kinesis.IStream getKinesisStream() {
            return this.kinesisStream;
        }

        @Override
        public final java.lang.Boolean getPointInTimeRecovery() {
            return this.pointInTimeRecovery;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.PointInTimeRecoverySpecification getPointInTimeRecoverySpecification() {
            return this.pointInTimeRecoverySpecification;
        }

        @Override
        public final software.amazon.awscdk.services.iam.PolicyDocument getResourcePolicy() {
            return this.resourcePolicy;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.TableClass getTableClass() {
            return this.tableClass;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("partitionKey", om.valueToTree(this.getPartitionKey()));
            if (this.getBilling() != null) {
                data.set("billing", om.valueToTree(this.getBilling()));
            }
            if (this.getDynamoStream() != null) {
                data.set("dynamoStream", om.valueToTree(this.getDynamoStream()));
            }
            if (this.getEncryption() != null) {
                data.set("encryption", om.valueToTree(this.getEncryption()));
            }
            if (this.getGlobalSecondaryIndexes() != null) {
                data.set("globalSecondaryIndexes", om.valueToTree(this.getGlobalSecondaryIndexes()));
            }
            if (this.getLocalSecondaryIndexes() != null) {
                data.set("localSecondaryIndexes", om.valueToTree(this.getLocalSecondaryIndexes()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getReplicas() != null) {
                data.set("replicas", om.valueToTree(this.getReplicas()));
            }
            if (this.getSortKey() != null) {
                data.set("sortKey", om.valueToTree(this.getSortKey()));
            }
            if (this.getTableName() != null) {
                data.set("tableName", om.valueToTree(this.getTableName()));
            }
            if (this.getTimeToLiveAttribute() != null) {
                data.set("timeToLiveAttribute", om.valueToTree(this.getTimeToLiveAttribute()));
            }
            if (this.getWarmThroughput() != null) {
                data.set("warmThroughput", om.valueToTree(this.getWarmThroughput()));
            }
            if (this.getContributorInsights() != null) {
                data.set("contributorInsights", om.valueToTree(this.getContributorInsights()));
            }
            if (this.getDeletionProtection() != null) {
                data.set("deletionProtection", om.valueToTree(this.getDeletionProtection()));
            }
            if (this.getKinesisStream() != null) {
                data.set("kinesisStream", om.valueToTree(this.getKinesisStream()));
            }
            if (this.getPointInTimeRecovery() != null) {
                data.set("pointInTimeRecovery", om.valueToTree(this.getPointInTimeRecovery()));
            }
            if (this.getPointInTimeRecoverySpecification() != null) {
                data.set("pointInTimeRecoverySpecification", om.valueToTree(this.getPointInTimeRecoverySpecification()));
            }
            if (this.getResourcePolicy() != null) {
                data.set("resourcePolicy", om.valueToTree(this.getResourcePolicy()));
            }
            if (this.getTableClass() != null) {
                data.set("tableClass", om.valueToTree(this.getTableClass()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.TablePropsV2"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TablePropsV2.Jsii$Proxy that = (TablePropsV2.Jsii$Proxy) o;

            if (!partitionKey.equals(that.partitionKey)) return false;
            if (this.billing != null ? !this.billing.equals(that.billing) : that.billing != null) return false;
            if (this.dynamoStream != null ? !this.dynamoStream.equals(that.dynamoStream) : that.dynamoStream != null) return false;
            if (this.encryption != null ? !this.encryption.equals(that.encryption) : that.encryption != null) return false;
            if (this.globalSecondaryIndexes != null ? !this.globalSecondaryIndexes.equals(that.globalSecondaryIndexes) : that.globalSecondaryIndexes != null) return false;
            if (this.localSecondaryIndexes != null ? !this.localSecondaryIndexes.equals(that.localSecondaryIndexes) : that.localSecondaryIndexes != null) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            if (this.replicas != null ? !this.replicas.equals(that.replicas) : that.replicas != null) return false;
            if (this.sortKey != null ? !this.sortKey.equals(that.sortKey) : that.sortKey != null) return false;
            if (this.tableName != null ? !this.tableName.equals(that.tableName) : that.tableName != null) return false;
            if (this.timeToLiveAttribute != null ? !this.timeToLiveAttribute.equals(that.timeToLiveAttribute) : that.timeToLiveAttribute != null) return false;
            if (this.warmThroughput != null ? !this.warmThroughput.equals(that.warmThroughput) : that.warmThroughput != null) return false;
            if (this.contributorInsights != null ? !this.contributorInsights.equals(that.contributorInsights) : that.contributorInsights != null) return false;
            if (this.deletionProtection != null ? !this.deletionProtection.equals(that.deletionProtection) : that.deletionProtection != null) return false;
            if (this.kinesisStream != null ? !this.kinesisStream.equals(that.kinesisStream) : that.kinesisStream != null) return false;
            if (this.pointInTimeRecovery != null ? !this.pointInTimeRecovery.equals(that.pointInTimeRecovery) : that.pointInTimeRecovery != null) return false;
            if (this.pointInTimeRecoverySpecification != null ? !this.pointInTimeRecoverySpecification.equals(that.pointInTimeRecoverySpecification) : that.pointInTimeRecoverySpecification != null) return false;
            if (this.resourcePolicy != null ? !this.resourcePolicy.equals(that.resourcePolicy) : that.resourcePolicy != null) return false;
            if (this.tableClass != null ? !this.tableClass.equals(that.tableClass) : that.tableClass != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.partitionKey.hashCode();
            result = 31 * result + (this.billing != null ? this.billing.hashCode() : 0);
            result = 31 * result + (this.dynamoStream != null ? this.dynamoStream.hashCode() : 0);
            result = 31 * result + (this.encryption != null ? this.encryption.hashCode() : 0);
            result = 31 * result + (this.globalSecondaryIndexes != null ? this.globalSecondaryIndexes.hashCode() : 0);
            result = 31 * result + (this.localSecondaryIndexes != null ? this.localSecondaryIndexes.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.replicas != null ? this.replicas.hashCode() : 0);
            result = 31 * result + (this.sortKey != null ? this.sortKey.hashCode() : 0);
            result = 31 * result + (this.tableName != null ? this.tableName.hashCode() : 0);
            result = 31 * result + (this.timeToLiveAttribute != null ? this.timeToLiveAttribute.hashCode() : 0);
            result = 31 * result + (this.warmThroughput != null ? this.warmThroughput.hashCode() : 0);
            result = 31 * result + (this.contributorInsights != null ? this.contributorInsights.hashCode() : 0);
            result = 31 * result + (this.deletionProtection != null ? this.deletionProtection.hashCode() : 0);
            result = 31 * result + (this.kinesisStream != null ? this.kinesisStream.hashCode() : 0);
            result = 31 * result + (this.pointInTimeRecovery != null ? this.pointInTimeRecovery.hashCode() : 0);
            result = 31 * result + (this.pointInTimeRecoverySpecification != null ? this.pointInTimeRecoverySpecification.hashCode() : 0);
            result = 31 * result + (this.resourcePolicy != null ? this.resourcePolicy.hashCode() : 0);
            result = 31 * result + (this.tableClass != null ? this.tableClass.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
