package software.amazon.awscdk.services.ec2;

/**
 * Subnet requested for allocation.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * RequestedSubnet requestedSubnet = RequestedSubnet.builder()
 *         .availabilityZone("availabilityZone")
 *         .configuration(SubnetConfiguration.builder()
 *                 .name("name")
 *                 .subnetType(SubnetType.PRIVATE_ISOLATED)
 *                 // the properties below are optional
 *                 .cidrMask(123)
 *                 .ipv6AssignAddressOnCreation(false)
 *                 .mapPublicIpOnLaunch(false)
 *                 .reserved(false)
 *                 .build())
 *         .subnetConstructId("subnetConstructId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:35.153Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.RequestedSubnet")
@software.amazon.jsii.Jsii.Proxy(RequestedSubnet.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RequestedSubnet extends software.amazon.jsii.JsiiSerializable {

    /**
     * The availability zone for the subnet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAvailabilityZone();

    /**
     * Specify configuration parameters for a single subnet group in a VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.SubnetConfiguration getConfiguration();

    /**
     * Id for the Subnet construct.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSubnetConstructId();

    /**
     * @return a {@link Builder} of {@link RequestedSubnet}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RequestedSubnet}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RequestedSubnet> {
        java.lang.String availabilityZone;
        software.amazon.awscdk.services.ec2.SubnetConfiguration configuration;
        java.lang.String subnetConstructId;

        /**
         * Sets the value of {@link RequestedSubnet#getAvailabilityZone}
         * @param availabilityZone The availability zone for the subnet. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(java.lang.String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * Sets the value of {@link RequestedSubnet#getConfiguration}
         * @param configuration Specify configuration parameters for a single subnet group in a VPC. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(software.amazon.awscdk.services.ec2.SubnetConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        /**
         * Sets the value of {@link RequestedSubnet#getSubnetConstructId}
         * @param subnetConstructId Id for the Subnet construct. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetConstructId(java.lang.String subnetConstructId) {
            this.subnetConstructId = subnetConstructId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RequestedSubnet}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RequestedSubnet build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RequestedSubnet}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RequestedSubnet {
        private final java.lang.String availabilityZone;
        private final software.amazon.awscdk.services.ec2.SubnetConfiguration configuration;
        private final java.lang.String subnetConstructId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.configuration = software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetConfiguration.class));
            this.subnetConstructId = software.amazon.jsii.Kernel.get(this, "subnetConstructId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.availabilityZone = java.util.Objects.requireNonNull(builder.availabilityZone, "availabilityZone is required");
            this.configuration = java.util.Objects.requireNonNull(builder.configuration, "configuration is required");
            this.subnetConstructId = java.util.Objects.requireNonNull(builder.subnetConstructId, "subnetConstructId is required");
        }

        @Override
        public final java.lang.String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetConfiguration getConfiguration() {
            return this.configuration;
        }

        @Override
        public final java.lang.String getSubnetConstructId() {
            return this.subnetConstructId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
            data.set("configuration", om.valueToTree(this.getConfiguration()));
            data.set("subnetConstructId", om.valueToTree(this.getSubnetConstructId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.RequestedSubnet"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RequestedSubnet.Jsii$Proxy that = (RequestedSubnet.Jsii$Proxy) o;

            if (!availabilityZone.equals(that.availabilityZone)) return false;
            if (!configuration.equals(that.configuration)) return false;
            return this.subnetConstructId.equals(that.subnetConstructId);
        }

        @Override
        public final int hashCode() {
            int result = this.availabilityZone.hashCode();
            result = 31 * result + (this.configuration.hashCode());
            result = 31 * result + (this.subnetConstructId.hashCode());
            return result;
        }
    }
}
