package software.amazon.awscdk.services.ecs;

/**
 * Credential specification (CredSpec) file.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Make sure the task definition's execution role has permissions to read from the S3 bucket or SSM parameter where the CredSpec file is stored.
 * IParameter parameter;
 * TaskDefinition taskDefinition;
 * // Domain-joined gMSA container from a SSM parameter
 * taskDefinition.addContainer("gmsa-domain-joined-container", ContainerDefinitionOptions.builder()
 *         .image(ContainerImage.fromRegistry("amazon/amazon-ecs-sample"))
 *         .cpu(128)
 *         .memoryLimitMiB(256)
 *         .credentialSpecs(List.of(DomainJoinedCredentialSpec.fromSsmParameter(parameter)))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:35.466Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.DomainJoinedCredentialSpec")
public class DomainJoinedCredentialSpec extends software.amazon.awscdk.services.ecs.CredentialSpec {

    protected DomainJoinedCredentialSpec(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DomainJoinedCredentialSpec(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param fileLocation Location or ARN from where to retrieve the CredSpec file. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DomainJoinedCredentialSpec(final @org.jetbrains.annotations.NotNull java.lang.String fileLocation) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(fileLocation, "fileLocation is required") });
    }

    /**
     * Loads the CredSpec from a S3 bucket object.
     * <p>
     * @return CredSpec with it's locations set to the S3 object's ARN.
     * @param bucket The S3 bucket. This parameter is required.
     * @param key The object key. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.DomainJoinedCredentialSpec fromS3Bucket(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.NotNull java.lang.String key) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.DomainJoinedCredentialSpec.class, "fromS3Bucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.DomainJoinedCredentialSpec.class), new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), java.util.Objects.requireNonNull(key, "key is required") });
    }

    /**
     * Loads the CredSpec from a SSM parameter.
     * <p>
     * @return CredSpec with it's locations set to the SSM parameter's ARN.
     * @param parameter The SSM parameter. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.DomainJoinedCredentialSpec fromSsmParameter(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ssm.IParameter parameter) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.DomainJoinedCredentialSpec.class, "fromSsmParameter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.DomainJoinedCredentialSpec.class), new Object[] { java.util.Objects.requireNonNull(parameter, "parameter is required") });
    }
}
