package software.amazon.awscdk.services.ecs;

/**
 * The details of data volume mount points for a container.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecs.*;
 * MountPoint mountPoint = MountPoint.builder()
 *         .containerPath("containerPath")
 *         .readOnly(false)
 *         .sourceVolume("sourceVolume")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:35.544Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.MountPoint")
@software.amazon.jsii.Jsii.Proxy(MountPoint.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MountPoint extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ecs.BaseMountPoint {

    /**
     * The name of the volume to mount.
     * <p>
     * Must be a volume name referenced in the name parameter of task definition volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSourceVolume();

    /**
     * @return a {@link Builder} of {@link MountPoint}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MountPoint}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MountPoint> {
        java.lang.String sourceVolume;
        java.lang.String containerPath;
        java.lang.Boolean readOnly;

        /**
         * Sets the value of {@link MountPoint#getSourceVolume}
         * @param sourceVolume The name of the volume to mount. This parameter is required.
         *                     Must be a volume name referenced in the name parameter of task definition volume.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceVolume(java.lang.String sourceVolume) {
            this.sourceVolume = sourceVolume;
            return this;
        }

        /**
         * Sets the value of {@link MountPoint#getContainerPath}
         * @param containerPath The path on the container to mount the host volume at. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerPath(java.lang.String containerPath) {
            this.containerPath = containerPath;
            return this;
        }

        /**
         * Sets the value of {@link MountPoint#getReadOnly}
         * @param readOnly Specifies whether to give the container read-only access to the volume. This parameter is required.
         *                 If this value is true, the container has read-only access to the volume.
         *                 If this value is false, then the container can write to the volume.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readOnly(java.lang.Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MountPoint}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MountPoint build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link MountPoint}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MountPoint {
        private final java.lang.String sourceVolume;
        private final java.lang.String containerPath;
        private final java.lang.Boolean readOnly;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.sourceVolume = software.amazon.jsii.Kernel.get(this, "sourceVolume", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.containerPath = software.amazon.jsii.Kernel.get(this, "containerPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.readOnly = software.amazon.jsii.Kernel.get(this, "readOnly", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.sourceVolume = java.util.Objects.requireNonNull(builder.sourceVolume, "sourceVolume is required");
            this.containerPath = java.util.Objects.requireNonNull(builder.containerPath, "containerPath is required");
            this.readOnly = java.util.Objects.requireNonNull(builder.readOnly, "readOnly is required");
        }

        @Override
        public final java.lang.String getSourceVolume() {
            return this.sourceVolume;
        }

        @Override
        public final java.lang.String getContainerPath() {
            return this.containerPath;
        }

        @Override
        public final java.lang.Boolean getReadOnly() {
            return this.readOnly;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("sourceVolume", om.valueToTree(this.getSourceVolume()));
            data.set("containerPath", om.valueToTree(this.getContainerPath()));
            data.set("readOnly", om.valueToTree(this.getReadOnly()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.MountPoint"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MountPoint.Jsii$Proxy that = (MountPoint.Jsii$Proxy) o;

            if (!sourceVolume.equals(that.sourceVolume)) return false;
            if (!containerPath.equals(that.containerPath)) return false;
            return this.readOnly.equals(that.readOnly);
        }

        @Override
        public final int hashCode() {
            int result = this.sourceVolume.hashCode();
            result = 31 * result + (this.containerPath.hashCode());
            result = 31 * result + (this.readOnly.hashCode());
            return result;
        }
    }
}
