package software.amazon.awscdk.services.efs;

/**
 * The Elastic File System implementation of IFileSystem.
 * <p>
 * It creates a new, empty file system in Amazon Elastic File System (Amazon EFS).
 * It also creates mount target (AWS::EFS::MountTarget) implicitly to mount the
 * EFS file system on an Amazon Elastic Compute Cloud (Amazon EC2) instance or another resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.iam.*;
 * Role role = Role.Builder.create(this, "ClientRole")
 *         .assumedBy(new AnyPrincipal())
 *         .build();
 * FileSystem fileSystem = FileSystem.Builder.create(this, "MyEfsFileSystem")
 *         .vpc(new Vpc(this, "VPC"))
 *         .allowAnonymousAccess(true)
 *         .build();
 * fileSystem.grantRead(role);
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:35.722Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_efs.FileSystem")
public class FileSystem extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.efs.IFileSystem {

    protected FileSystem(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FileSystem(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        DEFAULT_PORT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.efs.FileSystem.class, "DEFAULT_PORT", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.efs.FileSystem.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Constructor for creating a new EFS FileSystem.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public FileSystem(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.efs.FileSystemProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import an existing File System from the given properties.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.efs.IFileSystem fromFileSystemAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.efs.FileSystemAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.efs.FileSystem.class, "fromFileSystemAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.efs.IFileSystem.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * create access point from this filesystem.
     * <p>
     * @param id This parameter is required.
     * @param accessPointOptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.efs.AccessPoint addAccessPoint(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.efs.AccessPointOptions accessPointOptions) {
        return software.amazon.jsii.Kernel.call(this, "addAccessPoint", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.efs.AccessPoint.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), accessPointOptions });
    }

    /**
     * create access point from this filesystem.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.efs.AccessPoint addAccessPoint(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "addAccessPoint", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.efs.AccessPoint.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Adds a statement to the resource policy associated with this file system.
     * <p>
     * A resource policy will be automatically created upon the first call to <code>addToResourcePolicy</code>.
     * <p>
     * Note that this does not work with imported file systems.
     * <p>
     * @param statement The policy statement to add. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.AddToResourcePolicyResult addToResourcePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
        return software.amazon.jsii.Kernel.call(this, "addToResourcePolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.AddToResourcePolicyResult.class), new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * Grant the actions defined in actions to the given grantee on this File System resource.
     * <p>
     * @param grantee Principal to grant right to. This parameter is required.
     * @param actions The actions to grant. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... actions) {
        return software.amazon.jsii.Kernel.call(this, "grant", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
    }

    /**
     * Grant read permissions for this file system to an IAM principal.
     * <p>
     * @param grantee The principal to grant read to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantRead", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Grant read and write permissions for this file system to an IAM principal.
     * <p>
     * @param grantee The principal to grant read and write to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantReadWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantReadWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * As root user, grant read and write permissions for this file system to an IAM principal.
     * <p>
     * @param grantee The principal to grant root access to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRootAccess(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantRootAccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * The default port File System listens on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.Number DEFAULT_PORT;

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * The security groups/rules used to allow network connections to the file system.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
    }

    /**
     * The ARN of the file system.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFileSystemArn() {
        return software.amazon.jsii.Kernel.get(this, "fileSystemArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the file system, assigned by Amazon EFS.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFileSystemId() {
        return software.amazon.jsii.Kernel.get(this, "fileSystemId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Dependable that can be depended upon to ensure the mount targets of the filesystem are ready.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.constructs.IDependable getMountTargetsAvailable() {
        return software.amazon.jsii.Kernel.get(this, "mountTargetsAvailable", software.amazon.jsii.NativeType.forClass(software.constructs.IDependable.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.efs.FileSystem}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.efs.FileSystem> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.efs.FileSystemProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.efs.FileSystemProps.Builder();
        }

        /**
         * VPC to launch the file system in.
         * <p>
         * @return {@code this}
         * @param vpc VPC to launch the file system in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * Allow access from anonymous client that doesn't use IAM authentication.
         * <p>
         * Default: false when using `grantRead`, `grantWrite`, `grantRootAccess`
         * or set `@aws-cdk/aws-efs:denyAnonymousAccess` feature flag, otherwise true
         * <p>
         * @return {@code this}
         * @param allowAnonymousAccess Allow access from anonymous client that doesn't use IAM authentication. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowAnonymousAccess(final java.lang.Boolean allowAnonymousAccess) {
            this.props.allowAnonymousAccess(allowAnonymousAccess);
            return this;
        }

        /**
         * Whether to enable automatic backups for the file system.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param enableAutomaticBackups Whether to enable automatic backups for the file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableAutomaticBackups(final java.lang.Boolean enableAutomaticBackups) {
            this.props.enableAutomaticBackups(enableAutomaticBackups);
            return this;
        }

        /**
         * Defines if the data at rest in the file system is encrypted or not.
         * <p>
         * Default: - If your application has the '@aws-cdk/aws-efs:defaultEncryptionAtRest' feature flag set, the default is true, otherwise, the default is false.
         * <p>
         * @return {@code this}
         * @param encrypted Defines if the data at rest in the file system is encrypted or not. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encrypted(final java.lang.Boolean encrypted) {
            this.props.encrypted(encrypted);
            return this;
        }

        /**
         * The file system's name.
         * <p>
         * Default: - CDK generated name
         * <p>
         * @return {@code this}
         * @param fileSystemName The file system's name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemName(final java.lang.String fileSystemName) {
            this.props.fileSystemName(fileSystemName);
            return this;
        }

        /**
         * File system policy is an IAM resource policy used to control NFS access to an EFS file system.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param fileSystemPolicy File system policy is an IAM resource policy used to control NFS access to an EFS file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemPolicy(final software.amazon.awscdk.services.iam.PolicyDocument fileSystemPolicy) {
            this.props.fileSystemPolicy(fileSystemPolicy);
            return this;
        }

        /**
         * The KMS key used for encryption.
         * <p>
         * This is required to encrypt the data at rest if
         * <p>
         * Default: - if 'encrypted' is true, the default key for EFS (/aws/elasticfilesystem) is used
         * <p>
         * @return {@code this}
         * @param kmsKey The KMS key used for encryption. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKey(final software.amazon.awscdk.services.kms.IKey kmsKey) {
            this.props.kmsKey(kmsKey);
            return this;
        }

        /**
         * A policy used by EFS lifecycle management to transition files to the Infrequent Access (IA) storage class.
         * <p>
         * Default: - None. EFS will not transition files to the IA storage class.
         * <p>
         * @return {@code this}
         * @param lifecyclePolicy A policy used by EFS lifecycle management to transition files to the Infrequent Access (IA) storage class. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecyclePolicy(final software.amazon.awscdk.services.efs.LifecyclePolicy lifecyclePolicy) {
            this.props.lifecyclePolicy(lifecyclePolicy);
            return this;
        }

        /**
         * Whether this is a One Zone file system.
         * <p>
         * If enabled, <code>performanceMode</code> must be set to <code>GENERAL_PURPOSE</code> and <code>vpcSubnets</code> cannot be set.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param oneZone Whether this is a One Zone file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder oneZone(final java.lang.Boolean oneZone) {
            this.props.oneZone(oneZone);
            return this;
        }

        /**
         * A policy used by EFS lifecycle management to transition files from Infrequent Access (IA) storage class to primary storage class.
         * <p>
         * Default: - None. EFS will not transition files from IA storage to primary storage.
         * <p>
         * @return {@code this}
         * @param outOfInfrequentAccessPolicy A policy used by EFS lifecycle management to transition files from Infrequent Access (IA) storage class to primary storage class. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outOfInfrequentAccessPolicy(final software.amazon.awscdk.services.efs.OutOfInfrequentAccessPolicy outOfInfrequentAccessPolicy) {
            this.props.outOfInfrequentAccessPolicy(outOfInfrequentAccessPolicy);
            return this;
        }

        /**
         * The performance mode that the file system will operate under.
         * <p>
         * An Amazon EFS file system's performance mode can't be changed after the file system has been created.
         * Updating this property will replace the file system.
         * <p>
         * Default: PerformanceMode.GENERAL_PURPOSE
         * <p>
         * @return {@code this}
         * @param performanceMode The performance mode that the file system will operate under. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder performanceMode(final software.amazon.awscdk.services.efs.PerformanceMode performanceMode) {
            this.props.performanceMode(performanceMode);
            return this;
        }

        /**
         * Provisioned throughput for the file system.
         * <p>
         * This is a required property if the throughput mode is set to PROVISIONED.
         * Must be at least 1MiB/s.
         * <p>
         * Default: - none, errors out
         * <p>
         * @return {@code this}
         * @param provisionedThroughputPerSecond Provisioned throughput for the file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisionedThroughputPerSecond(final software.amazon.awscdk.Size provisionedThroughputPerSecond) {
            this.props.provisionedThroughputPerSecond(provisionedThroughputPerSecond);
            return this;
        }

        /**
         * The removal policy to apply to the file system.
         * <p>
         * Default: RemovalPolicy.RETAIN
         * <p>
         * @return {@code this}
         * @param removalPolicy The removal policy to apply to the file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(final software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        /**
         * Replication configuration for the file system.
         * <p>
         * Default: - no replication
         * <p>
         * @return {@code this}
         * @param replicationConfiguration Replication configuration for the file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationConfiguration(final software.amazon.awscdk.services.efs.ReplicationConfiguration replicationConfiguration) {
            this.props.replicationConfiguration(replicationConfiguration);
            return this;
        }

        /**
         * Whether to enable the filesystem's replication overwrite protection or not.
         * <p>
         * Set false if you want to create a read-only filesystem for use as a replication destination.
         * <p>
         * Default: ReplicationOverwriteProtection.ENABLED
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/efs/latest/ug/replication-use-cases.html#replicate-existing-destination">https://docs.aws.amazon.com/efs/latest/ug/replication-use-cases.html#replicate-existing-destination</a>
         * @param replicationOverwriteProtection Whether to enable the filesystem's replication overwrite protection or not. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationOverwriteProtection(final software.amazon.awscdk.services.efs.ReplicationOverwriteProtection replicationOverwriteProtection) {
            this.props.replicationOverwriteProtection(replicationOverwriteProtection);
            return this;
        }

        /**
         * Security Group to assign to this file system.
         * <p>
         * Default: - creates new security group which allows all outbound traffic
         * <p>
         * @return {@code this}
         * @param securityGroup Security Group to assign to this file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroup(final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.props.securityGroup(securityGroup);
            return this;
        }

        /**
         * Enum to mention the throughput mode of the file system.
         * <p>
         * Default: ThroughputMode.BURSTING
         * <p>
         * @return {@code this}
         * @param throughputMode Enum to mention the throughput mode of the file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder throughputMode(final software.amazon.awscdk.services.efs.ThroughputMode throughputMode) {
            this.props.throughputMode(throughputMode);
            return this;
        }

        /**
         * The number of days after files were last accessed in primary storage (the Standard storage class) at which to move them to Archive storage.
         * <p>
         * Metadata operations such as listing the contents of a directory don't count as file access events.
         * <p>
         * Default: - None. EFS will not transition files to Archive storage class.
         * <p>
         * @return {@code this}
         * @param transitionToArchivePolicy The number of days after files were last accessed in primary storage (the Standard storage class) at which to move them to Archive storage. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitionToArchivePolicy(final software.amazon.awscdk.services.efs.LifecyclePolicy transitionToArchivePolicy) {
            this.props.transitionToArchivePolicy(transitionToArchivePolicy);
            return this;
        }

        /**
         * Which subnets to place the mount target in the VPC.
         * <p>
         * Default: - the Vpc default strategy if not specified
         * <p>
         * @return {@code this}
         * @param vpcSubnets Which subnets to place the mount target in the VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.efs.FileSystem}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.efs.FileSystem build() {
            return new software.amazon.awscdk.services.efs.FileSystem(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
