package software.amazon.awscdk.services.eks;

/**
 * Represents an Amazon EKS Add-On.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * Addon.Builder.create(this, "Addon")
 *         .cluster(cluster)
 *         .addonName("coredns")
 *         .addonVersion("v1.11.4-eksbuild.2")
 *         // whether to preserve the add-on software on your cluster but Amazon EKS stops managing any settings for the add-on.
 *         .preserveOnDelete(false)
 *         .configurationValues(Map.of(
 *                 "replicaCount", 2))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:35.771Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.Addon")
public class Addon extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.eks.IAddon {

    protected Addon(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Addon(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.Addon.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Creates a new Amazon EKS Add-On.
     * <p>
     * @param scope The parent construct. This parameter is required.
     * @param id The construct ID. This parameter is required.
     * @param props The properties for the Add-On. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Addon(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.AddonProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Creates an <code>IAddon</code> from an existing addon ARN.
     * <p>
     * @return An <code>IAddon</code> implementation.
     * @param scope <ul><li>The parent construct.</li></ul> This parameter is required.
     * @param id <ul><li>The ID of the construct.</li></ul> This parameter is required.
     * @param addonArn <ul><li>The ARN of the addon.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.IAddon fromAddonArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String addonArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.eks.Addon.class, "fromAddonArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.IAddon.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(addonArn, "addonArn is required") });
    }

    /**
     * Creates an <code>IAddon</code> instance from the given addon attributes.
     * <p>
     * @return An <code>IAddon</code> instance.
     * @param scope <ul><li>The parent construct.</li></ul> This parameter is required.
     * @param id <ul><li>The construct ID.</li></ul> This parameter is required.
     * @param attrs <ul><li>The attributes of the addon, including the addon name and the cluster name.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.IAddon fromAddonAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.AddonAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.eks.Addon.class, "fromAddonAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.IAddon.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * Arn of the addon.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAddonArn() {
        return software.amazon.jsii.Kernel.get(this, "addonArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Name of the addon.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAddonName() {
        return software.amazon.jsii.Kernel.get(this, "addonName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.eks.Addon}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.eks.Addon> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope The parent construct. This parameter is required.
         * @param id The construct ID. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.eks.AddonProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.eks.AddonProps.Builder();
        }

        /**
         * Name of the Add-On.
         * <p>
         * @return {@code this}
         * @param addonName Name of the Add-On. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder addonName(final java.lang.String addonName) {
            this.props.addonName(addonName);
            return this;
        }

        /**
         * The EKS cluster the Add-On is associated with.
         * <p>
         * @return {@code this}
         * @param cluster The EKS cluster the Add-On is associated with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(final software.amazon.awscdk.services.eks.ICluster cluster) {
            this.props.cluster(cluster);
            return this;
        }

        /**
         * Version of the Add-On.
         * <p>
         * You can check all available versions with describe-addon-versions.
         * For example, this lists all available versions for the <code>eks-pod-identity-agent</code> addon:
         * $ aws eks describe-addon-versions --addon-name eks-pod-identity-agent \
         * --query 'addons[<em>].addonVersions[</em>].addonVersion'
         * <p>
         * Default: the latest version.
         * <p>
         * @return {@code this}
         * @param addonVersion Version of the Add-On. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder addonVersion(final java.lang.String addonVersion) {
            this.props.addonVersion(addonVersion);
            return this;
        }

        /**
         * The configuration values for the Add-on.
         * <p>
         * Default: - Use default configuration.
         * <p>
         * @return {@code this}
         * @param configurationValues The configuration values for the Add-on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationValues(final java.util.Map<java.lang.String, ? extends java.lang.Object> configurationValues) {
            this.props.configurationValues(configurationValues);
            return this;
        }

        /**
         * Specifying this option preserves the add-on software on your cluster but Amazon EKS stops managing any settings for the add-on.
         * <p>
         * If an IAM account is associated with the add-on, it isn't removed.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param preserveOnDelete Specifying this option preserves the add-on software on your cluster but Amazon EKS stops managing any settings for the add-on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preserveOnDelete(final java.lang.Boolean preserveOnDelete) {
            this.props.preserveOnDelete(preserveOnDelete);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.eks.Addon}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.eks.Addon build() {
            return new software.amazon.awscdk.services.eks.Addon(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
