package software.amazon.awscdk.services.eks;

/**
 * Helm Chart properties.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * // option 1: use a construct
 * // option 1: use a construct
 * HelmChart.Builder.create(this, "MyOCIChart")
 *         .cluster(cluster)
 *         .chart("some-chart")
 *         .repository("oci://${ACCOUNT_ID}.dkr.ecr.${ACCOUNT_REGION}.amazonaws.com/${REPO_NAME}")
 *         .namespace("oci")
 *         .version("0.0.1")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:35.869Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.HelmChartProps")
@software.amazon.jsii.Jsii.Proxy(HelmChartProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface HelmChartProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.eks.HelmChartOptions {

    /**
     * The EKS cluster to apply this configuration to.
     * <p>
     * [disable-awslint:ref-via-interface]
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.ICluster getCluster();

    /**
     * @return a {@link Builder} of {@link HelmChartProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link HelmChartProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<HelmChartProps> {
        software.amazon.awscdk.services.eks.ICluster cluster;
        java.lang.Boolean atomic;
        java.lang.String chart;
        software.amazon.awscdk.services.s3.assets.Asset chartAsset;
        java.lang.Boolean createNamespace;
        java.lang.String namespace;
        java.lang.String release;
        java.lang.String repository;
        java.lang.Boolean skipCrds;
        software.amazon.awscdk.Duration timeout;
        java.util.Map<java.lang.String, java.lang.Object> values;
        java.lang.String version;
        java.lang.Boolean wait;

        /**
         * Sets the value of {@link HelmChartProps#getCluster}
         * @param cluster The EKS cluster to apply this configuration to. This parameter is required.
         *                [disable-awslint:ref-via-interface]
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(software.amazon.awscdk.services.eks.ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        /**
         * Sets the value of {@link HelmChartProps#getAtomic}
         * @param atomic Whether or not Helm should treat this operation as atomic;.
         *               if set, upgrade process rolls back changes
         *               made in case of failed upgrade. The --wait flag will be set automatically if --atomic is used.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder atomic(java.lang.Boolean atomic) {
            this.atomic = atomic;
            return this;
        }

        /**
         * Sets the value of {@link HelmChartProps#getChart}
         * @param chart The name of the chart.
         *              Either this or <code>chartAsset</code> must be specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder chart(java.lang.String chart) {
            this.chart = chart;
            return this;
        }

        /**
         * Sets the value of {@link HelmChartProps#getChartAsset}
         * @param chartAsset The chart in the form of an asset.
         *                   Either this or <code>chart</code> must be specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder chartAsset(software.amazon.awscdk.services.s3.assets.Asset chartAsset) {
            this.chartAsset = chartAsset;
            return this;
        }

        /**
         * Sets the value of {@link HelmChartProps#getCreateNamespace}
         * @param createNamespace create namespace if not exist.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder createNamespace(java.lang.Boolean createNamespace) {
            this.createNamespace = createNamespace;
            return this;
        }

        /**
         * Sets the value of {@link HelmChartProps#getNamespace}
         * @param namespace The Kubernetes namespace scope of the requests.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder namespace(java.lang.String namespace) {
            this.namespace = namespace;
            return this;
        }

        /**
         * Sets the value of {@link HelmChartProps#getRelease}
         * @param release The name of the release.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder release(java.lang.String release) {
            this.release = release;
            return this;
        }

        /**
         * Sets the value of {@link HelmChartProps#getRepository}
         * @param repository The repository which contains the chart.
         *                   For example: https://charts.helm.sh/stable/
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repository(java.lang.String repository) {
            this.repository = repository;
            return this;
        }

        /**
         * Sets the value of {@link HelmChartProps#getSkipCrds}
         * @param skipCrds if set, no CRDs will be installed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder skipCrds(java.lang.Boolean skipCrds) {
            this.skipCrds = skipCrds;
            return this;
        }

        /**
         * Sets the value of {@link HelmChartProps#getTimeout}
         * @param timeout Amount of time to wait for any individual Kubernetes operation.
         *                Maximum 15 minutes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of {@link HelmChartProps#getValues}
         * @param values The values to be used by the chart.
         *               For nested values use a nested dictionary. For example:
         *               values: {
         *               installationCRDs: true,
         *               webhook: { port: 9443 }
         *               }
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder values(java.util.Map<java.lang.String, ? extends java.lang.Object> values) {
            this.values = (java.util.Map<java.lang.String, java.lang.Object>)values;
            return this;
        }

        /**
         * Sets the value of {@link HelmChartProps#getVersion}
         * @param version The chart version to install.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder version(java.lang.String version) {
            this.version = version;
            return this;
        }

        /**
         * Sets the value of {@link HelmChartProps#getWait}
         * @param wait Whether or not Helm should wait until all Pods, PVCs, Services, and minimum number of Pods of a Deployment, StatefulSet, or ReplicaSet are in a ready state before marking the release as successful.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder wait(java.lang.Boolean wait) {
            this.wait = wait;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HelmChartProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public HelmChartProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link HelmChartProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HelmChartProps {
        private final software.amazon.awscdk.services.eks.ICluster cluster;
        private final java.lang.Boolean atomic;
        private final java.lang.String chart;
        private final software.amazon.awscdk.services.s3.assets.Asset chartAsset;
        private final java.lang.Boolean createNamespace;
        private final java.lang.String namespace;
        private final java.lang.String release;
        private final java.lang.String repository;
        private final java.lang.Boolean skipCrds;
        private final software.amazon.awscdk.Duration timeout;
        private final java.util.Map<java.lang.String, java.lang.Object> values;
        private final java.lang.String version;
        private final java.lang.Boolean wait;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cluster = software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.ICluster.class));
            this.atomic = software.amazon.jsii.Kernel.get(this, "atomic", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.chart = software.amazon.jsii.Kernel.get(this, "chart", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.chartAsset = software.amazon.jsii.Kernel.get(this, "chartAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.assets.Asset.class));
            this.createNamespace = software.amazon.jsii.Kernel.get(this, "createNamespace", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.namespace = software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.release = software.amazon.jsii.Kernel.get(this, "release", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.repository = software.amazon.jsii.Kernel.get(this, "repository", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.skipCrds = software.amazon.jsii.Kernel.get(this, "skipCrds", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.wait = software.amazon.jsii.Kernel.get(this, "wait", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cluster = java.util.Objects.requireNonNull(builder.cluster, "cluster is required");
            this.atomic = builder.atomic;
            this.chart = builder.chart;
            this.chartAsset = builder.chartAsset;
            this.createNamespace = builder.createNamespace;
            this.namespace = builder.namespace;
            this.release = builder.release;
            this.repository = builder.repository;
            this.skipCrds = builder.skipCrds;
            this.timeout = builder.timeout;
            this.values = (java.util.Map<java.lang.String, java.lang.Object>)builder.values;
            this.version = builder.version;
            this.wait = builder.wait;
        }

        @Override
        public final software.amazon.awscdk.services.eks.ICluster getCluster() {
            return this.cluster;
        }

        @Override
        public final java.lang.Boolean getAtomic() {
            return this.atomic;
        }

        @Override
        public final java.lang.String getChart() {
            return this.chart;
        }

        @Override
        public final software.amazon.awscdk.services.s3.assets.Asset getChartAsset() {
            return this.chartAsset;
        }

        @Override
        public final java.lang.Boolean getCreateNamespace() {
            return this.createNamespace;
        }

        @Override
        public final java.lang.String getNamespace() {
            return this.namespace;
        }

        @Override
        public final java.lang.String getRelease() {
            return this.release;
        }

        @Override
        public final java.lang.String getRepository() {
            return this.repository;
        }

        @Override
        public final java.lang.Boolean getSkipCrds() {
            return this.skipCrds;
        }

        @Override
        public final software.amazon.awscdk.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getValues() {
            return this.values;
        }

        @Override
        public final java.lang.String getVersion() {
            return this.version;
        }

        @Override
        public final java.lang.Boolean getWait() {
            return this.wait;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("cluster", om.valueToTree(this.getCluster()));
            if (this.getAtomic() != null) {
                data.set("atomic", om.valueToTree(this.getAtomic()));
            }
            if (this.getChart() != null) {
                data.set("chart", om.valueToTree(this.getChart()));
            }
            if (this.getChartAsset() != null) {
                data.set("chartAsset", om.valueToTree(this.getChartAsset()));
            }
            if (this.getCreateNamespace() != null) {
                data.set("createNamespace", om.valueToTree(this.getCreateNamespace()));
            }
            if (this.getNamespace() != null) {
                data.set("namespace", om.valueToTree(this.getNamespace()));
            }
            if (this.getRelease() != null) {
                data.set("release", om.valueToTree(this.getRelease()));
            }
            if (this.getRepository() != null) {
                data.set("repository", om.valueToTree(this.getRepository()));
            }
            if (this.getSkipCrds() != null) {
                data.set("skipCrds", om.valueToTree(this.getSkipCrds()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }
            if (this.getValues() != null) {
                data.set("values", om.valueToTree(this.getValues()));
            }
            if (this.getVersion() != null) {
                data.set("version", om.valueToTree(this.getVersion()));
            }
            if (this.getWait() != null) {
                data.set("wait", om.valueToTree(this.getWait()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.HelmChartProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            HelmChartProps.Jsii$Proxy that = (HelmChartProps.Jsii$Proxy) o;

            if (!cluster.equals(that.cluster)) return false;
            if (this.atomic != null ? !this.atomic.equals(that.atomic) : that.atomic != null) return false;
            if (this.chart != null ? !this.chart.equals(that.chart) : that.chart != null) return false;
            if (this.chartAsset != null ? !this.chartAsset.equals(that.chartAsset) : that.chartAsset != null) return false;
            if (this.createNamespace != null ? !this.createNamespace.equals(that.createNamespace) : that.createNamespace != null) return false;
            if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) return false;
            if (this.release != null ? !this.release.equals(that.release) : that.release != null) return false;
            if (this.repository != null ? !this.repository.equals(that.repository) : that.repository != null) return false;
            if (this.skipCrds != null ? !this.skipCrds.equals(that.skipCrds) : that.skipCrds != null) return false;
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
            if (this.values != null ? !this.values.equals(that.values) : that.values != null) return false;
            if (this.version != null ? !this.version.equals(that.version) : that.version != null) return false;
            return this.wait != null ? this.wait.equals(that.wait) : that.wait == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cluster.hashCode();
            result = 31 * result + (this.atomic != null ? this.atomic.hashCode() : 0);
            result = 31 * result + (this.chart != null ? this.chart.hashCode() : 0);
            result = 31 * result + (this.chartAsset != null ? this.chartAsset.hashCode() : 0);
            result = 31 * result + (this.createNamespace != null ? this.createNamespace.hashCode() : 0);
            result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
            result = 31 * result + (this.release != null ? this.release.hashCode() : 0);
            result = 31 * result + (this.repository != null ? this.repository.hashCode() : 0);
            result = 31 * result + (this.skipCrds != null ? this.skipCrds.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.values != null ? this.values.hashCode() : 0);
            result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
            result = 31 * result + (this.wait != null ? this.wait.hashCode() : 0);
            return result;
        }
    }
}
