package software.amazon.awscdk.services.eks;

/**
 * The Nodegroup resource class.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.eks.*;
 * import software.amazon.awscdk.services.iam.*;
 * Cluster cluster;
 * InstanceType instanceType;
 * Role role;
 * SecurityGroup securityGroup;
 * Subnet subnet;
 * SubnetFilter subnetFilter;
 * Nodegroup nodegroup = Nodegroup.Builder.create(this, "MyNodegroup")
 *         .cluster(cluster)
 *         // the properties below are optional
 *         .amiType(NodegroupAmiType.AL2_X86_64)
 *         .capacityType(CapacityType.SPOT)
 *         .desiredSize(123)
 *         .diskSize(123)
 *         .enableNodeAutoRepair(false)
 *         .forceUpdate(false)
 *         .instanceTypes(List.of(instanceType))
 *         .labels(Map.of(
 *                 "labelsKey", "labels"))
 *         .launchTemplateSpec(LaunchTemplateSpec.builder()
 *                 .id("id")
 *                 // the properties below are optional
 *                 .version("version")
 *                 .build())
 *         .maxSize(123)
 *         .maxUnavailable(123)
 *         .maxUnavailablePercentage(123)
 *         .minSize(123)
 *         .nodegroupName("nodegroupName")
 *         .nodeRole(role)
 *         .releaseVersion("releaseVersion")
 *         .remoteAccess(NodegroupRemoteAccess.builder()
 *                 .sshKeyName("sshKeyName")
 *                 // the properties below are optional
 *                 .sourceSecurityGroups(List.of(securityGroup))
 *                 .build())
 *         .subnets(SubnetSelection.builder()
 *                 .availabilityZones(List.of("availabilityZones"))
 *                 .onePerAz(false)
 *                 .subnetFilters(List.of(subnetFilter))
 *                 .subnetGroupName("subnetGroupName")
 *                 .subnets(List.of(subnet))
 *                 .subnetType(SubnetType.PRIVATE_ISOLATED)
 *                 .build())
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .taints(List.of(TaintSpec.builder()
 *                 .effect(TaintEffect.NO_SCHEDULE)
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:35.896Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.Nodegroup")
public class Nodegroup extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.eks.INodegroup {

    protected Nodegroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Nodegroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.Nodegroup.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Nodegroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.NodegroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import the Nodegroup from attributes.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param nodegroupName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.INodegroup fromNodegroupName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String nodegroupName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.eks.Nodegroup.class, "fromNodegroupName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.INodegroup.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(nodegroupName, "nodegroupName is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * the Amazon EKS cluster resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.ICluster getCluster() {
        return software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.ICluster.class));
    }

    /**
     * ARN of the nodegroup.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getNodegroupArn() {
        return software.amazon.jsii.Kernel.get(this, "nodegroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Nodegroup name.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getNodegroupName() {
        return software.amazon.jsii.Kernel.get(this, "nodegroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * IAM role of the instance profile for the nodegroup.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getRole() {
        return software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.eks.Nodegroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.eks.Nodegroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.eks.NodegroupProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.eks.NodegroupProps.Builder();
        }

        /**
         * The AMI type for your node group.
         * <p>
         * If you explicitly specify the launchTemplate with custom AMI, do not specify this property, or
         * the node group deployment will fail. In other cases, you will need to specify correct amiType for the nodegroup.
         * <p>
         * Default: - auto-determined from the instanceTypes property when launchTemplateSpec property is not specified
         * <p>
         * @return {@code this}
         * @param amiType The AMI type for your node group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder amiType(final software.amazon.awscdk.services.eks.NodegroupAmiType amiType) {
            this.props.amiType(amiType);
            return this;
        }

        /**
         * The capacity type of the nodegroup.
         * <p>
         * Default: - ON_DEMAND
         * <p>
         * @return {@code this}
         * @param capacityType The capacity type of the nodegroup. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacityType(final software.amazon.awscdk.services.eks.CapacityType capacityType) {
            this.props.capacityType(capacityType);
            return this;
        }

        /**
         * The current number of worker nodes that the managed node group should maintain.
         * <p>
         * If not specified,
         * the nodewgroup will initially create <code>minSize</code> instances.
         * <p>
         * Default: 2
         * <p>
         * @return {@code this}
         * @param desiredSize The current number of worker nodes that the managed node group should maintain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desiredSize(final java.lang.Number desiredSize) {
            this.props.desiredSize(desiredSize);
            return this;
        }

        /**
         * The root device disk size (in GiB) for your node group instances.
         * <p>
         * Default: 20
         * <p>
         * @return {@code this}
         * @param diskSize The root device disk size (in GiB) for your node group instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder diskSize(final java.lang.Number diskSize) {
            this.props.diskSize(diskSize);
            return this;
        }

        /**
         * Specifies whether to enable node auto repair for the node group.
         * <p>
         * Node auto repair is disabled by default.
         * <p>
         * Default: - disabled
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/eks/latest/userguide/node-health.html#node-auto-repair">https://docs.aws.amazon.com/eks/latest/userguide/node-health.html#node-auto-repair</a>
         * @param enableNodeAutoRepair Specifies whether to enable node auto repair for the node group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableNodeAutoRepair(final java.lang.Boolean enableNodeAutoRepair) {
            this.props.enableNodeAutoRepair(enableNodeAutoRepair);
            return this;
        }

        /**
         * Force the update if the existing node group's pods are unable to be drained due to a pod disruption budget issue.
         * <p>
         * If an update fails because pods could not be drained, you can force the update after it fails to terminate the old
         * node whether or not any pods are
         * running on the node.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param forceUpdate Force the update if the existing node group's pods are unable to be drained due to a pod disruption budget issue. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder forceUpdate(final java.lang.Boolean forceUpdate) {
            this.props.forceUpdate(forceUpdate);
            return this;
        }

        /**
         * The instance types to use for your node group.
         * <p>
         * Default: t3.medium will be used according to the cloudformation document.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-instancetypes">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-instancetypes</a>
         * @param instanceTypes The instance types to use for your node group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceTypes(final java.util.List<? extends software.amazon.awscdk.services.ec2.InstanceType> instanceTypes) {
            this.props.instanceTypes(instanceTypes);
            return this;
        }

        /**
         * The Kubernetes labels to be applied to the nodes in the node group when they are created.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param labels The Kubernetes labels to be applied to the nodes in the node group when they are created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder labels(final java.util.Map<java.lang.String, java.lang.String> labels) {
            this.props.labels(labels);
            return this;
        }

        /**
         * Launch template specification used for the nodegroup.
         * <p>
         * Default: - no launch template
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html</a>
         * @param launchTemplateSpec Launch template specification used for the nodegroup. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchTemplateSpec(final software.amazon.awscdk.services.eks.LaunchTemplateSpec launchTemplateSpec) {
            this.props.launchTemplateSpec(launchTemplateSpec);
            return this;
        }

        /**
         * The maximum number of worker nodes that the managed node group can scale out to.
         * <p>
         * Managed node groups can support up to 100 nodes by default.
         * <p>
         * Default: - desiredSize
         * <p>
         * @return {@code this}
         * @param maxSize The maximum number of worker nodes that the managed node group can scale out to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxSize(final java.lang.Number maxSize) {
            this.props.maxSize(maxSize);
            return this;
        }

        /**
         * The maximum number of nodes unavailable at once during a version update.
         * <p>
         * Nodes will be updated in parallel. The maximum number is 100.
         * <p>
         * This value or <code>maxUnavailablePercentage</code> is required to have a value for custom update configurations to be applied.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-nodegroup-updateconfig.html#cfn-eks-nodegroup-updateconfig-maxunavailable">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-nodegroup-updateconfig.html#cfn-eks-nodegroup-updateconfig-maxunavailable</a>
         * @param maxUnavailable The maximum number of nodes unavailable at once during a version update. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxUnavailable(final java.lang.Number maxUnavailable) {
            this.props.maxUnavailable(maxUnavailable);
            return this;
        }

        /**
         * The maximum percentage of nodes unavailable during a version update.
         * <p>
         * This percentage of nodes will be updated in parallel, up to 100 nodes at once.
         * <p>
         * This value or <code>maxUnavailable</code> is required to have a value for custom update configurations to be applied.
         * <p>
         * Default: undefined - node groups will update instances one at a time
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-nodegroup-updateconfig.html#cfn-eks-nodegroup-updateconfig-maxunavailablepercentage">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-nodegroup-updateconfig.html#cfn-eks-nodegroup-updateconfig-maxunavailablepercentage</a>
         * @param maxUnavailablePercentage The maximum percentage of nodes unavailable during a version update. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxUnavailablePercentage(final java.lang.Number maxUnavailablePercentage) {
            this.props.maxUnavailablePercentage(maxUnavailablePercentage);
            return this;
        }

        /**
         * The minimum number of worker nodes that the managed node group can scale in to.
         * <p>
         * This number must be greater than or equal to zero.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param minSize The minimum number of worker nodes that the managed node group can scale in to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minSize(final java.lang.Number minSize) {
            this.props.minSize(minSize);
            return this;
        }

        /**
         * Name of the Nodegroup.
         * <p>
         * Default: - resource ID
         * <p>
         * @return {@code this}
         * @param nodegroupName Name of the Nodegroup. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodegroupName(final java.lang.String nodegroupName) {
            this.props.nodegroupName(nodegroupName);
            return this;
        }

        /**
         * The IAM role to associate with your node group.
         * <p>
         * The Amazon EKS worker node kubelet daemon
         * makes calls to AWS APIs on your behalf. Worker nodes receive permissions for these API calls through
         * an IAM instance profile and associated policies. Before you can launch worker nodes and register them
         * into a cluster, you must create an IAM role for those worker nodes to use when they are launched.
         * <p>
         * Default: - None. Auto-generated if not specified.
         * <p>
         * @return {@code this}
         * @param nodeRole The IAM role to associate with your node group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeRole(final software.amazon.awscdk.services.iam.IRole nodeRole) {
            this.props.nodeRole(nodeRole);
            return this;
        }

        /**
         * The AMI version of the Amazon EKS-optimized AMI to use with your node group (for example, <code>1.14.7-YYYYMMDD</code>).
         * <p>
         * Default: - The latest available AMI version for the node group's current Kubernetes version is used.
         * <p>
         * @return {@code this}
         * @param releaseVersion The AMI version of the Amazon EKS-optimized AMI to use with your node group (for example, <code>1.14.7-YYYYMMDD</code>). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder releaseVersion(final java.lang.String releaseVersion) {
            this.props.releaseVersion(releaseVersion);
            return this;
        }

        /**
         * The remote access (SSH) configuration to use with your node group.
         * <p>
         * Disabled by default, however, if you
         * specify an Amazon EC2 SSH key but do not specify a source security group when you create a managed node group,
         * then port 22 on the worker nodes is opened to the internet (0.0.0.0/0)
         * <p>
         * Default: - disabled
         * <p>
         * @return {@code this}
         * @param remoteAccess The remote access (SSH) configuration to use with your node group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder remoteAccess(final software.amazon.awscdk.services.eks.NodegroupRemoteAccess remoteAccess) {
            this.props.remoteAccess(remoteAccess);
            return this;
        }

        /**
         * The subnets to use for the Auto Scaling group that is created for your node group.
         * <p>
         * By specifying the
         * SubnetSelection, the selected subnets will automatically apply required tags i.e.
         * <code>kubernetes.io/cluster/CLUSTER_NAME</code> with a value of <code>shared</code>, where <code>CLUSTER_NAME</code> is replaced with
         * the name of your cluster.
         * <p>
         * Default: - private subnets
         * <p>
         * @return {@code this}
         * @param subnets The subnets to use for the Auto Scaling group that is created for your node group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnets(final software.amazon.awscdk.services.ec2.SubnetSelection subnets) {
            this.props.subnets(subnets);
            return this;
        }

        /**
         * The metadata to apply to the node group to assist with categorization and organization.
         * <p>
         * Each tag consists of
         * a key and an optional value, both of which you define. Node group tags do not propagate to any other resources
         * associated with the node group, such as the Amazon EC2 instances or subnets.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param tags The metadata to apply to the node group to assist with categorization and organization. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The Kubernetes taints to be applied to the nodes in the node group when they are created.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param taints The Kubernetes taints to be applied to the nodes in the node group when they are created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taints(final java.util.List<? extends software.amazon.awscdk.services.eks.TaintSpec> taints) {
            this.props.taints(taints);
            return this;
        }

        /**
         * Cluster resource.
         * <p>
         * @return {@code this}
         * @param cluster Cluster resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(final software.amazon.awscdk.services.eks.ICluster cluster) {
            this.props.cluster(cluster);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.eks.Nodegroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.eks.Nodegroup build() {
            return new software.amazon.awscdk.services.eks.Nodegroup(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
