package software.amazon.awscdk.services.events.targets;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.events.targets.*;
 * ContainerOverride containerOverride = ContainerOverride.builder()
 *         .containerName("containerName")
 *         // the properties below are optional
 *         .command(List.of("command"))
 *         .cpu(123)
 *         .environment(List.of(TaskEnvironmentVariable.builder()
 *                 .name("name")
 *                 .value("value")
 *                 .build()))
 *         .memoryLimit(123)
 *         .memoryReservation(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:36.480Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events_targets.ContainerOverride")
@software.amazon.jsii.Jsii.Proxy(ContainerOverride.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ContainerOverride extends software.amazon.jsii.JsiiSerializable {

    /**
     * Name of the container inside the task definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getContainerName();

    /**
     * Command to run inside the container.
     * <p>
     * Default: Default command
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCommand() {
        return null;
    }

    /**
     * The number of cpu units reserved for the container.
     * <p>
     * Default: The default value from the task definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getCpu() {
        return null;
    }

    /**
     * Variables to set in the container's environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.events.targets.TaskEnvironmentVariable> getEnvironment() {
        return null;
    }

    /**
     * Hard memory limit on the container.
     * <p>
     * Default: The default value from the task definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMemoryLimit() {
        return null;
    }

    /**
     * Soft memory limit on the container.
     * <p>
     * Default: The default value from the task definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMemoryReservation() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ContainerOverride}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ContainerOverride}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ContainerOverride> {
        java.lang.String containerName;
        java.util.List<java.lang.String> command;
        java.lang.Number cpu;
        java.util.List<software.amazon.awscdk.services.events.targets.TaskEnvironmentVariable> environment;
        java.lang.Number memoryLimit;
        java.lang.Number memoryReservation;

        /**
         * Sets the value of {@link ContainerOverride#getContainerName}
         * @param containerName Name of the container inside the task definition. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerName(java.lang.String containerName) {
            this.containerName = containerName;
            return this;
        }

        /**
         * Sets the value of {@link ContainerOverride#getCommand}
         * @param command Command to run inside the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder command(java.util.List<java.lang.String> command) {
            this.command = command;
            return this;
        }

        /**
         * Sets the value of {@link ContainerOverride#getCpu}
         * @param cpu The number of cpu units reserved for the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpu(java.lang.Number cpu) {
            this.cpu = cpu;
            return this;
        }

        /**
         * Sets the value of {@link ContainerOverride#getEnvironment}
         * @param environment Variables to set in the container's environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder environment(java.util.List<? extends software.amazon.awscdk.services.events.targets.TaskEnvironmentVariable> environment) {
            this.environment = (java.util.List<software.amazon.awscdk.services.events.targets.TaskEnvironmentVariable>)environment;
            return this;
        }

        /**
         * Sets the value of {@link ContainerOverride#getMemoryLimit}
         * @param memoryLimit Hard memory limit on the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memoryLimit(java.lang.Number memoryLimit) {
            this.memoryLimit = memoryLimit;
            return this;
        }

        /**
         * Sets the value of {@link ContainerOverride#getMemoryReservation}
         * @param memoryReservation Soft memory limit on the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memoryReservation(java.lang.Number memoryReservation) {
            this.memoryReservation = memoryReservation;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ContainerOverride}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ContainerOverride build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ContainerOverride}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContainerOverride {
        private final java.lang.String containerName;
        private final java.util.List<java.lang.String> command;
        private final java.lang.Number cpu;
        private final java.util.List<software.amazon.awscdk.services.events.targets.TaskEnvironmentVariable> environment;
        private final java.lang.Number memoryLimit;
        private final java.lang.Number memoryReservation;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.containerName = software.amazon.jsii.Kernel.get(this, "containerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.command = software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.cpu = software.amazon.jsii.Kernel.get(this, "cpu", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.targets.TaskEnvironmentVariable.class)));
            this.memoryLimit = software.amazon.jsii.Kernel.get(this, "memoryLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.memoryReservation = software.amazon.jsii.Kernel.get(this, "memoryReservation", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.containerName = java.util.Objects.requireNonNull(builder.containerName, "containerName is required");
            this.command = builder.command;
            this.cpu = builder.cpu;
            this.environment = (java.util.List<software.amazon.awscdk.services.events.targets.TaskEnvironmentVariable>)builder.environment;
            this.memoryLimit = builder.memoryLimit;
            this.memoryReservation = builder.memoryReservation;
        }

        @Override
        public final java.lang.String getContainerName() {
            return this.containerName;
        }

        @Override
        public final java.util.List<java.lang.String> getCommand() {
            return this.command;
        }

        @Override
        public final java.lang.Number getCpu() {
            return this.cpu;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.events.targets.TaskEnvironmentVariable> getEnvironment() {
            return this.environment;
        }

        @Override
        public final java.lang.Number getMemoryLimit() {
            return this.memoryLimit;
        }

        @Override
        public final java.lang.Number getMemoryReservation() {
            return this.memoryReservation;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("containerName", om.valueToTree(this.getContainerName()));
            if (this.getCommand() != null) {
                data.set("command", om.valueToTree(this.getCommand()));
            }
            if (this.getCpu() != null) {
                data.set("cpu", om.valueToTree(this.getCpu()));
            }
            if (this.getEnvironment() != null) {
                data.set("environment", om.valueToTree(this.getEnvironment()));
            }
            if (this.getMemoryLimit() != null) {
                data.set("memoryLimit", om.valueToTree(this.getMemoryLimit()));
            }
            if (this.getMemoryReservation() != null) {
                data.set("memoryReservation", om.valueToTree(this.getMemoryReservation()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events_targets.ContainerOverride"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ContainerOverride.Jsii$Proxy that = (ContainerOverride.Jsii$Proxy) o;

            if (!containerName.equals(that.containerName)) return false;
            if (this.command != null ? !this.command.equals(that.command) : that.command != null) return false;
            if (this.cpu != null ? !this.cpu.equals(that.cpu) : that.cpu != null) return false;
            if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
            if (this.memoryLimit != null ? !this.memoryLimit.equals(that.memoryLimit) : that.memoryLimit != null) return false;
            return this.memoryReservation != null ? this.memoryReservation.equals(that.memoryReservation) : that.memoryReservation == null;
        }

        @Override
        public final int hashCode() {
            int result = this.containerName.hashCode();
            result = 31 * result + (this.command != null ? this.command.hashCode() : 0);
            result = 31 * result + (this.cpu != null ? this.cpu.hashCode() : 0);
            result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
            result = 31 * result + (this.memoryLimit != null ? this.memoryLimit.hashCode() : 0);
            result = 31 * result + (this.memoryReservation != null ? this.memoryReservation.hashCode() : 0);
            return result;
        }
    }
}
