package software.amazon.awscdk.services.greengrassv2;

/**
 * Properties for defining a <code>CfnDeployment</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.greengrassv2.*;
 * Object rateIncreaseCriteria;
 * CfnDeploymentProps cfnDeploymentProps = CfnDeploymentProps.builder()
 *         .targetArn("targetArn")
 *         // the properties below are optional
 *         .components(Map.of(
 *                 "componentsKey", ComponentDeploymentSpecificationProperty.builder()
 *                         .componentVersion("componentVersion")
 *                         .configurationUpdate(ComponentConfigurationUpdateProperty.builder()
 *                                 .merge("merge")
 *                                 .reset(List.of("reset"))
 *                                 .build())
 *                         .runWith(ComponentRunWithProperty.builder()
 *                                 .posixUser("posixUser")
 *                                 .systemResourceLimits(SystemResourceLimitsProperty.builder()
 *                                         .cpus(123)
 *                                         .memory(123)
 *                                         .build())
 *                                 .windowsUser("windowsUser")
 *                                 .build())
 *                         .build()))
 *         .deploymentName("deploymentName")
 *         .deploymentPolicies(DeploymentPoliciesProperty.builder()
 *                 .componentUpdatePolicy(DeploymentComponentUpdatePolicyProperty.builder()
 *                         .action("action")
 *                         .timeoutInSeconds(123)
 *                         .build())
 *                 .configurationValidationPolicy(DeploymentConfigurationValidationPolicyProperty.builder()
 *                         .timeoutInSeconds(123)
 *                         .build())
 *                 .failureHandlingPolicy("failureHandlingPolicy")
 *                 .build())
 *         .iotJobConfiguration(DeploymentIoTJobConfigurationProperty.builder()
 *                 .abortConfig(IoTJobAbortConfigProperty.builder()
 *                         .criteriaList(List.of(IoTJobAbortCriteriaProperty.builder()
 *                                 .action("action")
 *                                 .failureType("failureType")
 *                                 .minNumberOfExecutedThings(123)
 *                                 .thresholdPercentage(123)
 *                                 .build()))
 *                         .build())
 *                 .jobExecutionsRolloutConfig(IoTJobExecutionsRolloutConfigProperty.builder()
 *                         .exponentialRate(IoTJobExponentialRolloutRateProperty.builder()
 *                                 .baseRatePerMinute(123)
 *                                 .incrementFactor(123)
 *                                 .rateIncreaseCriteria(rateIncreaseCriteria)
 *                                 .build())
 *                         .maximumPerMinute(123)
 *                         .build())
 *                 .timeoutConfig(IoTJobTimeoutConfigProperty.builder()
 *                         .inProgressTimeoutInMinutes(123)
 *                         .build())
 *                 .build())
 *         .parentTargetArn("parentTargetArn")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-deployment.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-deployment.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:37.085Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrassv2.CfnDeploymentProps")
@software.amazon.jsii.Jsii.Proxy(CfnDeploymentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDeploymentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the target AWS IoT thing or thing group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-deployment.html#cfn-greengrassv2-deployment-targetarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-deployment.html#cfn-greengrassv2-deployment-targetarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTargetArn();

    /**
     * The components to deploy.
     * <p>
     * This is a dictionary, where each key is the name of a component, and each key's value is the version and configuration to deploy for that component.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-deployment.html#cfn-greengrassv2-deployment-components">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-deployment.html#cfn-greengrassv2-deployment-components</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getComponents() {
        return null;
    }

    /**
     * The name of the deployment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-deployment.html#cfn-greengrassv2-deployment-deploymentname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-deployment.html#cfn-greengrassv2-deployment-deploymentname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeploymentName() {
        return null;
    }

    /**
     * The deployment policies for the deployment.
     * <p>
     * These policies define how the deployment updates components and handles failure.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-deployment.html#cfn-greengrassv2-deployment-deploymentpolicies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-deployment.html#cfn-greengrassv2-deployment-deploymentpolicies</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDeploymentPolicies() {
        return null;
    }

    /**
     * The job configuration for the deployment configuration.
     * <p>
     * The job configuration specifies the rollout, timeout, and stop configurations for the deployment configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-deployment.html#cfn-greengrassv2-deployment-iotjobconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-deployment.html#cfn-greengrassv2-deployment-iotjobconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIotJobConfiguration() {
        return null;
    }

    /**
     * The parent deployment's <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> for a subdeployment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-deployment.html#cfn-greengrassv2-deployment-parenttargetarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-deployment.html#cfn-greengrassv2-deployment-parenttargetarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getParentTargetArn() {
        return null;
    }

    /**
     * Application-specific metadata to attach to the deployment.
     * <p>
     * You can use tags in IAM policies to control access to AWS IoT Greengrass resources. You can also use tags to categorize your resources. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your AWS IoT Greengrass Version 2 resources</a> in the <em>AWS IoT Greengrass V2 Developer Guide</em> .
     * <p>
     * This <code>Json</code> property type is processed as a map of key-value pairs. It uses the following format, which is different from most <code>Tags</code> implementations in AWS CloudFormation templates.
     * <p>
     * <blockquote><pre>
     * "Tags": { "KeyName0": "value", "KeyName1": "value", "KeyName2": "value"
     * }
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-deployment.html#cfn-greengrassv2-deployment-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-deployment.html#cfn-greengrassv2-deployment-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDeploymentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDeploymentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDeploymentProps> {
        java.lang.String targetArn;
        java.lang.Object components;
        java.lang.String deploymentName;
        java.lang.Object deploymentPolicies;
        java.lang.Object iotJobConfiguration;
        java.lang.String parentTargetArn;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link CfnDeploymentProps#getTargetArn}
         * @param targetArn The ARN of the target AWS IoT thing or thing group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetArn(java.lang.String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentProps#getComponents}
         * @param components The components to deploy.
         *                   This is a dictionary, where each key is the name of a component, and each key's value is the version and configuration to deploy for that component.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder components(software.amazon.awscdk.IResolvable components) {
            this.components = components;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentProps#getComponents}
         * @param components The components to deploy.
         *                   This is a dictionary, where each key is the name of a component, and each key's value is the version and configuration to deploy for that component.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder components(java.util.Map<java.lang.String, ? extends java.lang.Object> components) {
            this.components = components;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentProps#getDeploymentName}
         * @param deploymentName The name of the deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentName(java.lang.String deploymentName) {
            this.deploymentName = deploymentName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentProps#getDeploymentPolicies}
         * @param deploymentPolicies The deployment policies for the deployment.
         *                           These policies define how the deployment updates components and handles failure.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentPolicies(software.amazon.awscdk.IResolvable deploymentPolicies) {
            this.deploymentPolicies = deploymentPolicies;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentProps#getDeploymentPolicies}
         * @param deploymentPolicies The deployment policies for the deployment.
         *                           These policies define how the deployment updates components and handles failure.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentPolicies(software.amazon.awscdk.services.greengrassv2.CfnDeployment.DeploymentPoliciesProperty deploymentPolicies) {
            this.deploymentPolicies = deploymentPolicies;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentProps#getIotJobConfiguration}
         * @param iotJobConfiguration The job configuration for the deployment configuration.
         *                            The job configuration specifies the rollout, timeout, and stop configurations for the deployment configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iotJobConfiguration(software.amazon.awscdk.IResolvable iotJobConfiguration) {
            this.iotJobConfiguration = iotJobConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentProps#getIotJobConfiguration}
         * @param iotJobConfiguration The job configuration for the deployment configuration.
         *                            The job configuration specifies the rollout, timeout, and stop configurations for the deployment configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iotJobConfiguration(software.amazon.awscdk.services.greengrassv2.CfnDeployment.DeploymentIoTJobConfigurationProperty iotJobConfiguration) {
            this.iotJobConfiguration = iotJobConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentProps#getParentTargetArn}
         * @param parentTargetArn The parent deployment's <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> for a subdeployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parentTargetArn(java.lang.String parentTargetArn) {
            this.parentTargetArn = parentTargetArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentProps#getTags}
         * @param tags Application-specific metadata to attach to the deployment.
         *             You can use tags in IAM policies to control access to AWS IoT Greengrass resources. You can also use tags to categorize your resources. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your AWS IoT Greengrass Version 2 resources</a> in the <em>AWS IoT Greengrass V2 Developer Guide</em> .
         *             <p>
         *             This <code>Json</code> property type is processed as a map of key-value pairs. It uses the following format, which is different from most <code>Tags</code> implementations in AWS CloudFormation templates.
         *             <p>
         *             <blockquote><pre>
         *             "Tags": { "KeyName0": "value", "KeyName1": "value", "KeyName2": "value"
         *             }
         *             </pre></blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDeploymentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDeploymentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDeploymentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDeploymentProps {
        private final java.lang.String targetArn;
        private final java.lang.Object components;
        private final java.lang.String deploymentName;
        private final java.lang.Object deploymentPolicies;
        private final java.lang.Object iotJobConfiguration;
        private final java.lang.String parentTargetArn;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.targetArn = software.amazon.jsii.Kernel.get(this, "targetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.components = software.amazon.jsii.Kernel.get(this, "components", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.deploymentName = software.amazon.jsii.Kernel.get(this, "deploymentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deploymentPolicies = software.amazon.jsii.Kernel.get(this, "deploymentPolicies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.iotJobConfiguration = software.amazon.jsii.Kernel.get(this, "iotJobConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.parentTargetArn = software.amazon.jsii.Kernel.get(this, "parentTargetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.targetArn = java.util.Objects.requireNonNull(builder.targetArn, "targetArn is required");
            this.components = builder.components;
            this.deploymentName = builder.deploymentName;
            this.deploymentPolicies = builder.deploymentPolicies;
            this.iotJobConfiguration = builder.iotJobConfiguration;
            this.parentTargetArn = builder.parentTargetArn;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.String getTargetArn() {
            return this.targetArn;
        }

        @Override
        public final java.lang.Object getComponents() {
            return this.components;
        }

        @Override
        public final java.lang.String getDeploymentName() {
            return this.deploymentName;
        }

        @Override
        public final java.lang.Object getDeploymentPolicies() {
            return this.deploymentPolicies;
        }

        @Override
        public final java.lang.Object getIotJobConfiguration() {
            return this.iotJobConfiguration;
        }

        @Override
        public final java.lang.String getParentTargetArn() {
            return this.parentTargetArn;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("targetArn", om.valueToTree(this.getTargetArn()));
            if (this.getComponents() != null) {
                data.set("components", om.valueToTree(this.getComponents()));
            }
            if (this.getDeploymentName() != null) {
                data.set("deploymentName", om.valueToTree(this.getDeploymentName()));
            }
            if (this.getDeploymentPolicies() != null) {
                data.set("deploymentPolicies", om.valueToTree(this.getDeploymentPolicies()));
            }
            if (this.getIotJobConfiguration() != null) {
                data.set("iotJobConfiguration", om.valueToTree(this.getIotJobConfiguration()));
            }
            if (this.getParentTargetArn() != null) {
                data.set("parentTargetArn", om.valueToTree(this.getParentTargetArn()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrassv2.CfnDeploymentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDeploymentProps.Jsii$Proxy that = (CfnDeploymentProps.Jsii$Proxy) o;

            if (!targetArn.equals(that.targetArn)) return false;
            if (this.components != null ? !this.components.equals(that.components) : that.components != null) return false;
            if (this.deploymentName != null ? !this.deploymentName.equals(that.deploymentName) : that.deploymentName != null) return false;
            if (this.deploymentPolicies != null ? !this.deploymentPolicies.equals(that.deploymentPolicies) : that.deploymentPolicies != null) return false;
            if (this.iotJobConfiguration != null ? !this.iotJobConfiguration.equals(that.iotJobConfiguration) : that.iotJobConfiguration != null) return false;
            if (this.parentTargetArn != null ? !this.parentTargetArn.equals(that.parentTargetArn) : that.parentTargetArn != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.targetArn.hashCode();
            result = 31 * result + (this.components != null ? this.components.hashCode() : 0);
            result = 31 * result + (this.deploymentName != null ? this.deploymentName.hashCode() : 0);
            result = 31 * result + (this.deploymentPolicies != null ? this.deploymentPolicies.hashCode() : 0);
            result = 31 * result + (this.iotJobConfiguration != null ? this.iotJobConfiguration.hashCode() : 0);
            result = 31 * result + (this.parentTargetArn != null ? this.parentTargetArn.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
