package software.amazon.awscdk.services.iam;

/**
 * IAM Role.
 * <p>
 * Defines an IAM role. The role is created with an assume policy document associated with
 * the specified AWS service principal defined in <code>serviceAssumeRole</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Option 3: Create a new role that allows the account root principal to assume. Add this role in the `system:masters` and witch to this role from the AWS console.
 * Cluster cluster;
 * Role consoleReadOnlyRole = Role.Builder.create(this, "ConsoleReadOnlyRole")
 *         .assumedBy(new ArnPrincipal("arn_for_trusted_principal"))
 *         .build();
 * consoleReadOnlyRole.addToPolicy(PolicyStatement.Builder.create()
 *         .actions(List.of("eks:AccessKubernetesApi", "eks:Describe*", "eks:List*"))
 *         .resources(List.of(cluster.getClusterArn()))
 *         .build());
 * // Add this role to system:masters RBAC group
 * cluster.awsAuth.addMastersRole(consoleReadOnlyRole);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:37.285Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iam.Role")
public class Role extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.iam.IRole {

    protected Role(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Role(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iam.Role.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Role(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.RoleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Customize the creation of IAM roles within the given scope.
     * <p>
     * It is recommended that you <strong>do not</strong> use this method and instead allow
     * CDK to manage role creation. This should only be used
     * in environments where CDK applications are not allowed to created IAM roles.
     * <p>
     * This can be used to prevent the CDK application from creating roles
     * within the given scope and instead replace the references to the roles with
     * precreated role names. A report will be synthesized in the cloud assembly (i.e. cdk.out)
     * that will contain the list of IAM roles that would have been created along with the
     * IAM policy statements that the role should contain. This report can then be used
     * to create the IAM roles outside of CDK and then the created role names can be provided
     * in <code>usePrecreatedRoles</code>.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * App app;
     * Role.customizeRoles(app, CustomizeRolesOptions.builder()
     *         .usePrecreatedRoles(Map.of(
     *                 "ConstructPath/To/Role", "my-precreated-role-name"))
     *         .build());
     * </pre></blockquote>
     * <p>
     * @param scope construct scope to customize role creation. This parameter is required.
     * @param options options for configuring role creation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static void customizeRoles(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.CustomizeRolesOptions options) {
        software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.Role.class, "customizeRoles", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), options });
    }

    /**
     * Customize the creation of IAM roles within the given scope.
     * <p>
     * It is recommended that you <strong>do not</strong> use this method and instead allow
     * CDK to manage role creation. This should only be used
     * in environments where CDK applications are not allowed to created IAM roles.
     * <p>
     * This can be used to prevent the CDK application from creating roles
     * within the given scope and instead replace the references to the roles with
     * precreated role names. A report will be synthesized in the cloud assembly (i.e. cdk.out)
     * that will contain the list of IAM roles that would have been created along with the
     * IAM policy statements that the role should contain. This report can then be used
     * to create the IAM roles outside of CDK and then the created role names can be provided
     * in <code>usePrecreatedRoles</code>.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * App app;
     * Role.customizeRoles(app, CustomizeRolesOptions.builder()
     *         .usePrecreatedRoles(Map.of(
     *                 "ConstructPath/To/Role", "my-precreated-role-name"))
     *         .build());
     * </pre></blockquote>
     * <p>
     * @param scope construct scope to customize role creation. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static void customizeRoles(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope) {
        software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.Role.class, "customizeRoles", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
    }

    /**
     * Lookup an existing Role.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole fromLookup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.RoleLookupOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.Role.class, "fromLookup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Import an external role by ARN.
     * <p>
     * If the imported Role ARN is a Token (such as a
     * <code>CfnParameter.valueAsString</code> or a <code>Fn.importValue()</code>) <em>and</em> the referenced
     * role has a <code>path</code> (like <code>arn:...:role/AdminRoles/Alice</code>), the
     * <code>roleName</code> property will not resolve to the correct value. Instead it
     * will resolve to the first path component. We unfortunately cannot express
     * the correct calculation of the full path name as a CloudFormation
     * expression. In this scenario the Role ARN should be supplied without the
     * <code>path</code> in order to resolve the correct role resource.
     * <p>
     * @param scope construct scope. This parameter is required.
     * @param id construct id. This parameter is required.
     * @param roleArn the ARN of the role to import. This parameter is required.
     * @param options allow customizing the behavior of the returned role.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole fromRoleArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String roleArn, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.FromRoleArnOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.Role.class, "fromRoleArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(roleArn, "roleArn is required"), options });
    }

    /**
     * Import an external role by ARN.
     * <p>
     * If the imported Role ARN is a Token (such as a
     * <code>CfnParameter.valueAsString</code> or a <code>Fn.importValue()</code>) <em>and</em> the referenced
     * role has a <code>path</code> (like <code>arn:...:role/AdminRoles/Alice</code>), the
     * <code>roleName</code> property will not resolve to the correct value. Instead it
     * will resolve to the first path component. We unfortunately cannot express
     * the correct calculation of the full path name as a CloudFormation
     * expression. In this scenario the Role ARN should be supplied without the
     * <code>path</code> in order to resolve the correct role resource.
     * <p>
     * @param scope construct scope. This parameter is required.
     * @param id construct id. This parameter is required.
     * @param roleArn the ARN of the role to import. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole fromRoleArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String roleArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.Role.class, "fromRoleArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(roleArn, "roleArn is required") });
    }

    /**
     * Import an external role by name.
     * <p>
     * The imported role is assumed to exist in the same account as the account
     * the scope's containing Stack is being deployed to.
     * <p>
     * @param scope construct scope. This parameter is required.
     * @param id construct id. This parameter is required.
     * @param roleName the name of the role to import. This parameter is required.
     * @param options allow customizing the behavior of the returned role.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole fromRoleName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String roleName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.FromRoleNameOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.Role.class, "fromRoleName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(roleName, "roleName is required"), options });
    }

    /**
     * Import an external role by name.
     * <p>
     * The imported role is assumed to exist in the same account as the account
     * the scope's containing Stack is being deployed to.
     * <p>
     * @param scope construct scope. This parameter is required.
     * @param id construct id. This parameter is required.
     * @param roleName the name of the role to import. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole fromRoleName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String roleName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.Role.class, "fromRoleName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(roleName, "roleName is required") });
    }

    /**
     * Return whether the given object is a Role.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isRole(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.Role.class, "isRole", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * Attaches a managed policy to this role.
     * <p>
     * @param policy The the managed policy to attach. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addManagedPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IManagedPolicy policy) {
        software.amazon.jsii.Kernel.call(this, "addManagedPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
    }

    /**
     * Add to the policy of this principal.
     * <p>
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean addToPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
        return software.amazon.jsii.Kernel.call(this, "addToPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * Adds a permission to the role's default policy document.
     * <p>
     * If there is no default policy attached to this role, it will be created.
     * <p>
     * @param statement The permission statement to add to the policy document. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.AddToPrincipalPolicyResult addToPrincipalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
        return software.amazon.jsii.Kernel.call(this, "addToPrincipalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.AddToPrincipalPolicyResult.class), new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * Skip applyRemovalPolicy if role synthesis is prevented by customizeRoles.
     * <p>
     * Because in this case, this construct does not have a CfnResource in the tree.
     * <p>
     * @param policy RemovalPolicy. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void applyRemovalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.RemovalPolicy policy) {
        software.amazon.jsii.Kernel.call(this, "applyRemovalPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
    }

    /**
     * Attaches a policy to this role.
     * <p>
     * @param policy The policy to attach. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void attachInlinePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Policy policy) {
        software.amazon.jsii.Kernel.call(this, "attachInlinePolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
    }

    /**
     * Grant the actions defined in actions to the identity Principal on this resource.
     * <p>
     * @param grantee This parameter is required.
     * @param actions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal grantee, final @org.jetbrains.annotations.NotNull java.lang.String... actions) {
        return software.amazon.jsii.Kernel.call(this, "grant", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
    }

    /**
     * Grant permissions to the given principal to assume this role.
     * <p>
     * @param identity This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantAssumeRole(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal identity) {
        return software.amazon.jsii.Kernel.call(this, "grantAssumeRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * Grant permissions to the given principal to pass this role.
     * <p>
     * @param identity This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPassRole(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal identity) {
        return software.amazon.jsii.Kernel.call(this, "grantPassRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * Return a copy of this Role object whose Policies will not be updated.
     * <p>
     * Use the object returned by this method if you want this Role to be used by
     * a construct without it automatically updating the Role's Policies.
     * <p>
     * If you do, you are responsible for adding the correct statements to the
     * Role's policies yourself.
     * <p>
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole withoutPolicyUpdates(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.WithoutPolicyUpdatesOptions options) {
        return software.amazon.jsii.Kernel.call(this, "withoutPolicyUpdates", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class), new Object[] { options });
    }

    /**
     * Return a copy of this Role object whose Policies will not be updated.
     * <p>
     * Use the object returned by this method if you want this Role to be used by
     * a construct without it automatically updating the Role's Policies.
     * <p>
     * If you do, you are responsible for adding the correct statements to the
     * Role's policies yourself.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole withoutPolicyUpdates() {
        return software.amazon.jsii.Kernel.call(this, "withoutPolicyUpdates", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * When this Principal is used in an AssumeRole policy, the action to use.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAssumeRoleAction() {
        return software.amazon.jsii.Kernel.get(this, "assumeRoleAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The principal to grant permissions to.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
        return software.amazon.jsii.Kernel.get(this, "grantPrincipal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IPrincipal.class));
    }

    /**
     * Returns the role.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PrincipalPolicyFragment getPolicyFragment() {
        return software.amazon.jsii.Kernel.get(this, "policyFragment", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PrincipalPolicyFragment.class));
    }

    /**
     * Returns the ARN of this role.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the stable and unique string identifying the role.
     * <p>
     * For example,
     * AIDAJQABLZS4A3QDU576Q.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleId() {
        return software.amazon.jsii.Kernel.get(this, "roleId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the name of the role.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleName() {
        return software.amazon.jsii.Kernel.get(this, "roleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The assume role policy document associated with this role.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.PolicyDocument getAssumeRolePolicy() {
        return software.amazon.jsii.Kernel.get(this, "assumeRolePolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyDocument.class));
    }

    /**
     * Returns the permissions boundary attached to this role.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IManagedPolicy getPermissionsBoundary() {
        return software.amazon.jsii.Kernel.get(this, "permissionsBoundary", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IManagedPolicy.class));
    }

    /**
     * The AWS account ID of this principal.
     * <p>
     * Can be undefined when the account is not known
     * (for example, for service principals).
     * Can be a Token - in that case,
     * it's assumed to be AWS::AccountId.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPrincipalAccount() {
        return software.amazon.jsii.Kernel.get(this, "principalAccount", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iam.Role}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iam.Role> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.iam.RoleProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.iam.RoleProps.Builder();
        }

        /**
         * The IAM principal (i.e. <code>new ServicePrincipal('sns.amazonaws.com')</code>) which can assume this role.
         * <p>
         * You can later modify the assume role policy document by accessing it via
         * the <code>assumeRolePolicy</code> property.
         * <p>
         * @return {@code this}
         * @param assumedBy The IAM principal (i.e. <code>new ServicePrincipal('sns.amazonaws.com')</code>) which can assume this role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assumedBy(final software.amazon.awscdk.services.iam.IPrincipal assumedBy) {
            this.props.assumedBy(assumedBy);
            return this;
        }

        /**
         * A description of the role.
         * <p>
         * It can be up to 1000 characters long.
         * <p>
         * Default: - No description.
         * <p>
         * @return {@code this}
         * @param description A description of the role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * List of IDs that the role assumer needs to provide one of when assuming this role.
         * <p>
         * If the configured and provided external IDs do not match, the
         * AssumeRole operation will fail.
         * <p>
         * Default: No external ID required
         * <p>
         * @return {@code this}
         * @param externalIds List of IDs that the role assumer needs to provide one of when assuming this role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder externalIds(final java.util.List<java.lang.String> externalIds) {
            this.props.externalIds(externalIds);
            return this;
        }

        /**
         * A list of named policies to inline into this role.
         * <p>
         * These policies will be
         * created with the role, whereas those added by <code>addToPolicy</code> are added
         * using a separate CloudFormation resource (allowing a way around circular
         * dependencies that could otherwise be introduced).
         * <p>
         * Default: - No policy is inlined in the Role resource.
         * <p>
         * @return {@code this}
         * @param inlinePolicies A list of named policies to inline into this role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inlinePolicies(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.iam.PolicyDocument> inlinePolicies) {
            this.props.inlinePolicies(inlinePolicies);
            return this;
        }

        /**
         * A list of managed policies associated with this role.
         * <p>
         * You can add managed policies later using
         * <code>addManagedPolicy(ManagedPolicy.fromAwsManagedPolicyName(policyName))</code>.
         * <p>
         * Default: - No managed policies.
         * <p>
         * @return {@code this}
         * @param managedPolicies A list of managed policies associated with this role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder managedPolicies(final java.util.List<? extends software.amazon.awscdk.services.iam.IManagedPolicy> managedPolicies) {
            this.props.managedPolicies(managedPolicies);
            return this;
        }

        /**
         * The maximum session duration that you want to set for the specified role.
         * <p>
         * This setting can have a value from 1 hour (3600sec) to 12 (43200sec) hours.
         * <p>
         * Anyone who assumes the role from the AWS CLI or API can use the
         * DurationSeconds API parameter or the duration-seconds CLI parameter to
         * request a longer session. The MaxSessionDuration setting determines the
         * maximum duration that can be requested using the DurationSeconds
         * parameter.
         * <p>
         * If users don't specify a value for the DurationSeconds parameter, their
         * security credentials are valid for one hour by default. This applies when
         * you use the AssumeRole* API operations or the assume-role* CLI operations
         * but does not apply when you use those operations to create a console URL.
         * <p>
         * Default: Duration.hours(1)
         * <p>
         * @return {@code this}
         * @param maxSessionDuration The maximum session duration that you want to set for the specified role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxSessionDuration(final software.amazon.awscdk.Duration maxSessionDuration) {
            this.props.maxSessionDuration(maxSessionDuration);
            return this;
        }

        /**
         * The path associated with this role.
         * <p>
         * For information about IAM paths, see
         * Friendly Names and Paths in IAM User Guide.
         * <p>
         * Default: /
         * <p>
         * @return {@code this}
         * @param path The path associated with this role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder path(final java.lang.String path) {
            this.props.path(path);
            return this;
        }

        /**
         * AWS supports permissions boundaries for IAM entities (users or roles).
         * <p>
         * A permissions boundary is an advanced feature for using a managed policy
         * to set the maximum permissions that an identity-based policy can grant to
         * an IAM entity. An entity's permissions boundary allows it to perform only
         * the actions that are allowed by both its identity-based policies and its
         * permissions boundaries.
         * <p>
         * Default: - No permissions boundary.
         * <p>
         * @return {@code this}
         * @param permissionsBoundary AWS supports permissions boundaries for IAM entities (users or roles). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissionsBoundary(final software.amazon.awscdk.services.iam.IManagedPolicy permissionsBoundary) {
            this.props.permissionsBoundary(permissionsBoundary);
            return this;
        }

        /**
         * A name for the IAM role.
         * <p>
         * For valid values, see the RoleName parameter for
         * the CreateRole action in the IAM API Reference.
         * <p>
         * IMPORTANT: If you specify a name, you cannot perform updates that require
         * replacement of this resource. You can perform updates that require no or
         * some interruption. If you must replace the resource, specify a new name.
         * <p>
         * If you specify a name, you must specify the CAPABILITY_NAMED_IAM value to
         * acknowledge your template's capabilities. For more information, see
         * Acknowledging IAM Resources in AWS CloudFormation Templates.
         * <p>
         * Default: - AWS CloudFormation generates a unique physical ID and uses that ID
         * for the role name.
         * <p>
         * @return {@code this}
         * @param roleName A name for the IAM role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleName(final java.lang.String roleName) {
            this.props.roleName(roleName);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.iam.Role}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iam.Role build() {
            return new software.amazon.awscdk.services.iam.Role(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
