package software.amazon.awscdk.services.internetmonitor;

/**
 * Properties for defining a <code>CfnMonitor</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.internetmonitor.*;
 * CfnMonitorProps cfnMonitorProps = CfnMonitorProps.builder()
 *         .monitorName("monitorName")
 *         // the properties below are optional
 *         .healthEventsConfig(HealthEventsConfigProperty.builder()
 *                 .availabilityLocalHealthEventsConfig(LocalHealthEventsConfigProperty.builder()
 *                         .healthScoreThreshold(123)
 *                         .minTrafficImpact(123)
 *                         .status("status")
 *                         .build())
 *                 .availabilityScoreThreshold(123)
 *                 .performanceLocalHealthEventsConfig(LocalHealthEventsConfigProperty.builder()
 *                         .healthScoreThreshold(123)
 *                         .minTrafficImpact(123)
 *                         .status("status")
 *                         .build())
 *                 .performanceScoreThreshold(123)
 *                 .build())
 *         .includeLinkedAccounts(false)
 *         .internetMeasurementsLogDelivery(InternetMeasurementsLogDeliveryProperty.builder()
 *                 .s3Config(S3ConfigProperty.builder()
 *                         .bucketName("bucketName")
 *                         .bucketPrefix("bucketPrefix")
 *                         .logDeliveryStatus("logDeliveryStatus")
 *                         .build())
 *                 .build())
 *         .linkedAccountId("linkedAccountId")
 *         .maxCityNetworksToMonitor(123)
 *         .resources(List.of("resources"))
 *         .resourcesToAdd(List.of("resourcesToAdd"))
 *         .resourcesToRemove(List.of("resourcesToRemove"))
 *         .status("status")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .trafficPercentageToMonitor(123)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:37.402Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_internetmonitor.CfnMonitorProps")
@software.amazon.jsii.Jsii.Proxy(CfnMonitorProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnMonitorProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the monitor.
     * <p>
     * A monitor name can contain only alphanumeric characters, dashes (-), periods (.), and underscores (_).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-monitorname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-monitorname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMonitorName();

    /**
     * A complex type with the configuration information that determines the threshold and other conditions for when Internet Monitor creates a health event for an overall performance or availability issue, across an application's geographies.
     * <p>
     * Defines the percentages, for overall performance scores and availability scores for an application, that are the thresholds for when Internet Monitor creates a health event. You can override the defaults to set a custom threshold for overall performance or availability scores, or both.
     * <p>
     * You can also set thresholds for local health scores,, where Internet Monitor creates a health event when scores cross a threshold for one or more city-networks, in addition to creating an event when an overall score crosses a threshold.
     * <p>
     * If you don't set a health event threshold, the default value is 95%.
     * <p>
     * For local thresholds, you also set a minimum percentage of overall traffic that is impacted by an issue before Internet Monitor creates an event. In addition, you can disable local thresholds, for performance scores, availability scores, or both.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-overview.html#IMUpdateThresholdFromOverview">Change health event thresholds</a> in the Internet Monitor section of the <em>CloudWatch User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-healtheventsconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-healtheventsconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getHealthEventsConfig() {
        return null;
    }

    /**
     * A boolean option that you can set to <code>TRUE</code> to include monitors for linked accounts in a list of monitors, when you've set up cross-account sharing in Internet Monitor.
     * <p>
     * You configure cross-account sharing by using Amazon CloudWatch Observability Access Manager. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cwim-cross-account.html">Internet Monitor cross-account observability</a> in the Amazon CloudWatch User Guide.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-includelinkedaccounts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-includelinkedaccounts</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeLinkedAccounts() {
        return null;
    }

    /**
     * Publish internet measurements for a monitor for all city-networks (up to the 500,000 service limit) to another location, such as an Amazon S3 bucket.
     * <p>
     * Measurements are also published to Amazon CloudWatch Logs for the first 500 (by traffic volume) city-networks (client locations and ASNs, typically internet service providers or ISPs).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-internetmeasurementslogdelivery">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-internetmeasurementslogdelivery</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getInternetMeasurementsLogDelivery() {
        return null;
    }

    /**
     * The account ID for an account that you've set up cross-account sharing for in Internet Monitor.
     * <p>
     * You configure cross-account sharing by using Amazon CloudWatch Observability Access Manager. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cwim-cross-account.html">Internet Monitor cross-account observability</a> in the Amazon CloudWatch User Guide.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-linkedaccountid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-linkedaccountid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLinkedAccountId() {
        return null;
    }

    /**
     * The maximum number of city-networks to monitor for your resources.
     * <p>
     * A city-network is the location (city) where clients access your application resources from and the network, such as an internet service provider, that clients access the resources through.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/IMCityNetworksMaximum.html">Choosing a city-network maximum value</a> in <em>Using Amazon CloudWatch Internet Monitor</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-maxcitynetworkstomonitor">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-maxcitynetworkstomonitor</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxCityNetworksToMonitor() {
        return null;
    }

    /**
     * The resources that have been added for the monitor, listed by their Amazon Resource Names (ARNs).
     * <p>
     * Use this option to add or remove resources when making an update.
     * <p>
     * <blockquote>
     * <p>
     * Be aware that if you include content in the <code>Resources</code> field when you update a monitor, the <code>ResourcesToAdd</code> and <code>ResourcesToRemove</code> fields must be empty.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-resources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-resources</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getResources() {
        return null;
    }

    /**
     * The resources to include in a monitor, which you provide as a set of Amazon Resource Names (ARNs).
     * <p>
     * Resources can be Amazon Virtual Private Cloud VPCs, Network Load Balancers (NLBs), Amazon CloudFront distributions, or Amazon WorkSpaces directories.
     * <p>
     * You can add a combination of VPCs and CloudFront distributions, or you can add WorkSpaces directories, or you can add NLBs. You can't add NLBs or WorkSpaces directories together with any other resources.
     * <p>
     * If you add only VPC resources, at least one VPC must have an Internet Gateway attached to it, to make sure that it has internet connectivity.
     * <p>
     * <blockquote>
     * <p>
     * You can specify this field for a monitor update only if the <code>Resources</code> field is empty.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-resourcestoadd">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-resourcestoadd</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getResourcesToAdd() {
        return null;
    }

    /**
     * The resources to remove from a monitor, which you provide as a set of Amazon Resource Names (ARNs).
     * <p>
     * <blockquote>
     * <p>
     * You can specify this field for a monitor update only if the <code>Resources</code> field is empty.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-resourcestoremove">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-resourcestoremove</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getResourcesToRemove() {
        return null;
    }

    /**
     * The status of a monitor.
     * <p>
     * The accepted values that you can specify for <code>Status</code> are <code>ACTIVE</code> and <code>INACTIVE</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-status</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
        return null;
    }

    /**
     * The tags for a monitor, listed as a set of <em>key:value</em> pairs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The percentage of the internet-facing traffic for your application that you want to monitor.
     * <p>
     * You can also, optionally, set a limit for the number of city-networks (client locations and ASNs, typically internet service providers) that Internet Monitor will monitor traffic for. The city-networks maximum limit caps the number of city-networks that Internet Monitor monitors for your application, regardless of the percentage of traffic that you choose to monitor.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-trafficpercentagetomonitor">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-trafficpercentagetomonitor</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getTrafficPercentageToMonitor() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnMonitorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnMonitorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnMonitorProps> {
        java.lang.String monitorName;
        java.lang.Object healthEventsConfig;
        java.lang.Object includeLinkedAccounts;
        java.lang.Object internetMeasurementsLogDelivery;
        java.lang.String linkedAccountId;
        java.lang.Number maxCityNetworksToMonitor;
        java.util.List<java.lang.String> resources;
        java.util.List<java.lang.String> resourcesToAdd;
        java.util.List<java.lang.String> resourcesToRemove;
        java.lang.String status;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Number trafficPercentageToMonitor;

        /**
         * Sets the value of {@link CfnMonitorProps#getMonitorName}
         * @param monitorName The name of the monitor. This parameter is required.
         *                    A monitor name can contain only alphanumeric characters, dashes (-), periods (.), and underscores (_).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitorName(java.lang.String monitorName) {
            this.monitorName = monitorName;
            return this;
        }

        /**
         * Sets the value of {@link CfnMonitorProps#getHealthEventsConfig}
         * @param healthEventsConfig A complex type with the configuration information that determines the threshold and other conditions for when Internet Monitor creates a health event for an overall performance or availability issue, across an application's geographies.
         *                           Defines the percentages, for overall performance scores and availability scores for an application, that are the thresholds for when Internet Monitor creates a health event. You can override the defaults to set a custom threshold for overall performance or availability scores, or both.
         *                           <p>
         *                           You can also set thresholds for local health scores,, where Internet Monitor creates a health event when scores cross a threshold for one or more city-networks, in addition to creating an event when an overall score crosses a threshold.
         *                           <p>
         *                           If you don't set a health event threshold, the default value is 95%.
         *                           <p>
         *                           For local thresholds, you also set a minimum percentage of overall traffic that is impacted by an issue before Internet Monitor creates an event. In addition, you can disable local thresholds, for performance scores, availability scores, or both.
         *                           <p>
         *                           For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-overview.html#IMUpdateThresholdFromOverview">Change health event thresholds</a> in the Internet Monitor section of the <em>CloudWatch User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthEventsConfig(software.amazon.awscdk.IResolvable healthEventsConfig) {
            this.healthEventsConfig = healthEventsConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnMonitorProps#getHealthEventsConfig}
         * @param healthEventsConfig A complex type with the configuration information that determines the threshold and other conditions for when Internet Monitor creates a health event for an overall performance or availability issue, across an application's geographies.
         *                           Defines the percentages, for overall performance scores and availability scores for an application, that are the thresholds for when Internet Monitor creates a health event. You can override the defaults to set a custom threshold for overall performance or availability scores, or both.
         *                           <p>
         *                           You can also set thresholds for local health scores,, where Internet Monitor creates a health event when scores cross a threshold for one or more city-networks, in addition to creating an event when an overall score crosses a threshold.
         *                           <p>
         *                           If you don't set a health event threshold, the default value is 95%.
         *                           <p>
         *                           For local thresholds, you also set a minimum percentage of overall traffic that is impacted by an issue before Internet Monitor creates an event. In addition, you can disable local thresholds, for performance scores, availability scores, or both.
         *                           <p>
         *                           For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-overview.html#IMUpdateThresholdFromOverview">Change health event thresholds</a> in the Internet Monitor section of the <em>CloudWatch User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthEventsConfig(software.amazon.awscdk.services.internetmonitor.CfnMonitor.HealthEventsConfigProperty healthEventsConfig) {
            this.healthEventsConfig = healthEventsConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnMonitorProps#getIncludeLinkedAccounts}
         * @param includeLinkedAccounts A boolean option that you can set to <code>TRUE</code> to include monitors for linked accounts in a list of monitors, when you've set up cross-account sharing in Internet Monitor.
         *                              You configure cross-account sharing by using Amazon CloudWatch Observability Access Manager. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cwim-cross-account.html">Internet Monitor cross-account observability</a> in the Amazon CloudWatch User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includeLinkedAccounts(java.lang.Boolean includeLinkedAccounts) {
            this.includeLinkedAccounts = includeLinkedAccounts;
            return this;
        }

        /**
         * Sets the value of {@link CfnMonitorProps#getIncludeLinkedAccounts}
         * @param includeLinkedAccounts A boolean option that you can set to <code>TRUE</code> to include monitors for linked accounts in a list of monitors, when you've set up cross-account sharing in Internet Monitor.
         *                              You configure cross-account sharing by using Amazon CloudWatch Observability Access Manager. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cwim-cross-account.html">Internet Monitor cross-account observability</a> in the Amazon CloudWatch User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includeLinkedAccounts(software.amazon.awscdk.IResolvable includeLinkedAccounts) {
            this.includeLinkedAccounts = includeLinkedAccounts;
            return this;
        }

        /**
         * Sets the value of {@link CfnMonitorProps#getInternetMeasurementsLogDelivery}
         * @param internetMeasurementsLogDelivery Publish internet measurements for a monitor for all city-networks (up to the 500,000 service limit) to another location, such as an Amazon S3 bucket.
         *                                        Measurements are also published to Amazon CloudWatch Logs for the first 500 (by traffic volume) city-networks (client locations and ASNs, typically internet service providers or ISPs).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder internetMeasurementsLogDelivery(software.amazon.awscdk.IResolvable internetMeasurementsLogDelivery) {
            this.internetMeasurementsLogDelivery = internetMeasurementsLogDelivery;
            return this;
        }

        /**
         * Sets the value of {@link CfnMonitorProps#getInternetMeasurementsLogDelivery}
         * @param internetMeasurementsLogDelivery Publish internet measurements for a monitor for all city-networks (up to the 500,000 service limit) to another location, such as an Amazon S3 bucket.
         *                                        Measurements are also published to Amazon CloudWatch Logs for the first 500 (by traffic volume) city-networks (client locations and ASNs, typically internet service providers or ISPs).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder internetMeasurementsLogDelivery(software.amazon.awscdk.services.internetmonitor.CfnMonitor.InternetMeasurementsLogDeliveryProperty internetMeasurementsLogDelivery) {
            this.internetMeasurementsLogDelivery = internetMeasurementsLogDelivery;
            return this;
        }

        /**
         * Sets the value of {@link CfnMonitorProps#getLinkedAccountId}
         * @param linkedAccountId The account ID for an account that you've set up cross-account sharing for in Internet Monitor.
         *                        You configure cross-account sharing by using Amazon CloudWatch Observability Access Manager. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cwim-cross-account.html">Internet Monitor cross-account observability</a> in the Amazon CloudWatch User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder linkedAccountId(java.lang.String linkedAccountId) {
            this.linkedAccountId = linkedAccountId;
            return this;
        }

        /**
         * Sets the value of {@link CfnMonitorProps#getMaxCityNetworksToMonitor}
         * @param maxCityNetworksToMonitor The maximum number of city-networks to monitor for your resources.
         *                                 A city-network is the location (city) where clients access your application resources from and the network, such as an internet service provider, that clients access the resources through.
         *                                 <p>
         *                                 For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/IMCityNetworksMaximum.html">Choosing a city-network maximum value</a> in <em>Using Amazon CloudWatch Internet Monitor</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxCityNetworksToMonitor(java.lang.Number maxCityNetworksToMonitor) {
            this.maxCityNetworksToMonitor = maxCityNetworksToMonitor;
            return this;
        }

        /**
         * Sets the value of {@link CfnMonitorProps#getResources}
         * @param resources The resources that have been added for the monitor, listed by their Amazon Resource Names (ARNs).
         *                  Use this option to add or remove resources when making an update.
         *                  <p>
         *                  <blockquote>
         *                  <p>
         *                  Be aware that if you include content in the <code>Resources</code> field when you update a monitor, the <code>ResourcesToAdd</code> and <code>ResourcesToRemove</code> fields must be empty.
         *                  <p>
         *                  </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resources(java.util.List<java.lang.String> resources) {
            this.resources = resources;
            return this;
        }

        /**
         * Sets the value of {@link CfnMonitorProps#getResourcesToAdd}
         * @param resourcesToAdd The resources to include in a monitor, which you provide as a set of Amazon Resource Names (ARNs).
         *                       Resources can be Amazon Virtual Private Cloud VPCs, Network Load Balancers (NLBs), Amazon CloudFront distributions, or Amazon WorkSpaces directories.
         *                       <p>
         *                       You can add a combination of VPCs and CloudFront distributions, or you can add WorkSpaces directories, or you can add NLBs. You can't add NLBs or WorkSpaces directories together with any other resources.
         *                       <p>
         *                       If you add only VPC resources, at least one VPC must have an Internet Gateway attached to it, to make sure that it has internet connectivity.
         *                       <p>
         *                       <blockquote>
         *                       <p>
         *                       You can specify this field for a monitor update only if the <code>Resources</code> field is empty.
         *                       <p>
         *                       </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourcesToAdd(java.util.List<java.lang.String> resourcesToAdd) {
            this.resourcesToAdd = resourcesToAdd;
            return this;
        }

        /**
         * Sets the value of {@link CfnMonitorProps#getResourcesToRemove}
         * @param resourcesToRemove The resources to remove from a monitor, which you provide as a set of Amazon Resource Names (ARNs).
         *                          <blockquote>
         *                          <p>
         *                          You can specify this field for a monitor update only if the <code>Resources</code> field is empty.
         *                          <p>
         *                          </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourcesToRemove(java.util.List<java.lang.String> resourcesToRemove) {
            this.resourcesToRemove = resourcesToRemove;
            return this;
        }

        /**
         * Sets the value of {@link CfnMonitorProps#getStatus}
         * @param status The status of a monitor.
         *               The accepted values that you can specify for <code>Status</code> are <code>ACTIVE</code> and <code>INACTIVE</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder status(java.lang.String status) {
            this.status = status;
            return this;
        }

        /**
         * Sets the value of {@link CfnMonitorProps#getTags}
         * @param tags The tags for a monitor, listed as a set of <em>key:value</em> pairs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnMonitorProps#getTrafficPercentageToMonitor}
         * @param trafficPercentageToMonitor The percentage of the internet-facing traffic for your application that you want to monitor.
         *                                   You can also, optionally, set a limit for the number of city-networks (client locations and ASNs, typically internet service providers) that Internet Monitor will monitor traffic for. The city-networks maximum limit caps the number of city-networks that Internet Monitor monitors for your application, regardless of the percentage of traffic that you choose to monitor.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trafficPercentageToMonitor(java.lang.Number trafficPercentageToMonitor) {
            this.trafficPercentageToMonitor = trafficPercentageToMonitor;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnMonitorProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnMonitorProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnMonitorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnMonitorProps {
        private final java.lang.String monitorName;
        private final java.lang.Object healthEventsConfig;
        private final java.lang.Object includeLinkedAccounts;
        private final java.lang.Object internetMeasurementsLogDelivery;
        private final java.lang.String linkedAccountId;
        private final java.lang.Number maxCityNetworksToMonitor;
        private final java.util.List<java.lang.String> resources;
        private final java.util.List<java.lang.String> resourcesToAdd;
        private final java.util.List<java.lang.String> resourcesToRemove;
        private final java.lang.String status;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Number trafficPercentageToMonitor;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.monitorName = software.amazon.jsii.Kernel.get(this, "monitorName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.healthEventsConfig = software.amazon.jsii.Kernel.get(this, "healthEventsConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.includeLinkedAccounts = software.amazon.jsii.Kernel.get(this, "includeLinkedAccounts", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.internetMeasurementsLogDelivery = software.amazon.jsii.Kernel.get(this, "internetMeasurementsLogDelivery", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.linkedAccountId = software.amazon.jsii.Kernel.get(this, "linkedAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxCityNetworksToMonitor = software.amazon.jsii.Kernel.get(this, "maxCityNetworksToMonitor", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.resources = software.amazon.jsii.Kernel.get(this, "resources", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.resourcesToAdd = software.amazon.jsii.Kernel.get(this, "resourcesToAdd", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.resourcesToRemove = software.amazon.jsii.Kernel.get(this, "resourcesToRemove", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.trafficPercentageToMonitor = software.amazon.jsii.Kernel.get(this, "trafficPercentageToMonitor", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.monitorName = java.util.Objects.requireNonNull(builder.monitorName, "monitorName is required");
            this.healthEventsConfig = builder.healthEventsConfig;
            this.includeLinkedAccounts = builder.includeLinkedAccounts;
            this.internetMeasurementsLogDelivery = builder.internetMeasurementsLogDelivery;
            this.linkedAccountId = builder.linkedAccountId;
            this.maxCityNetworksToMonitor = builder.maxCityNetworksToMonitor;
            this.resources = builder.resources;
            this.resourcesToAdd = builder.resourcesToAdd;
            this.resourcesToRemove = builder.resourcesToRemove;
            this.status = builder.status;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.trafficPercentageToMonitor = builder.trafficPercentageToMonitor;
        }

        @Override
        public final java.lang.String getMonitorName() {
            return this.monitorName;
        }

        @Override
        public final java.lang.Object getHealthEventsConfig() {
            return this.healthEventsConfig;
        }

        @Override
        public final java.lang.Object getIncludeLinkedAccounts() {
            return this.includeLinkedAccounts;
        }

        @Override
        public final java.lang.Object getInternetMeasurementsLogDelivery() {
            return this.internetMeasurementsLogDelivery;
        }

        @Override
        public final java.lang.String getLinkedAccountId() {
            return this.linkedAccountId;
        }

        @Override
        public final java.lang.Number getMaxCityNetworksToMonitor() {
            return this.maxCityNetworksToMonitor;
        }

        @Override
        public final java.util.List<java.lang.String> getResources() {
            return this.resources;
        }

        @Override
        public final java.util.List<java.lang.String> getResourcesToAdd() {
            return this.resourcesToAdd;
        }

        @Override
        public final java.util.List<java.lang.String> getResourcesToRemove() {
            return this.resourcesToRemove;
        }

        @Override
        public final java.lang.String getStatus() {
            return this.status;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Number getTrafficPercentageToMonitor() {
            return this.trafficPercentageToMonitor;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("monitorName", om.valueToTree(this.getMonitorName()));
            if (this.getHealthEventsConfig() != null) {
                data.set("healthEventsConfig", om.valueToTree(this.getHealthEventsConfig()));
            }
            if (this.getIncludeLinkedAccounts() != null) {
                data.set("includeLinkedAccounts", om.valueToTree(this.getIncludeLinkedAccounts()));
            }
            if (this.getInternetMeasurementsLogDelivery() != null) {
                data.set("internetMeasurementsLogDelivery", om.valueToTree(this.getInternetMeasurementsLogDelivery()));
            }
            if (this.getLinkedAccountId() != null) {
                data.set("linkedAccountId", om.valueToTree(this.getLinkedAccountId()));
            }
            if (this.getMaxCityNetworksToMonitor() != null) {
                data.set("maxCityNetworksToMonitor", om.valueToTree(this.getMaxCityNetworksToMonitor()));
            }
            if (this.getResources() != null) {
                data.set("resources", om.valueToTree(this.getResources()));
            }
            if (this.getResourcesToAdd() != null) {
                data.set("resourcesToAdd", om.valueToTree(this.getResourcesToAdd()));
            }
            if (this.getResourcesToRemove() != null) {
                data.set("resourcesToRemove", om.valueToTree(this.getResourcesToRemove()));
            }
            if (this.getStatus() != null) {
                data.set("status", om.valueToTree(this.getStatus()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTrafficPercentageToMonitor() != null) {
                data.set("trafficPercentageToMonitor", om.valueToTree(this.getTrafficPercentageToMonitor()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_internetmonitor.CfnMonitorProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnMonitorProps.Jsii$Proxy that = (CfnMonitorProps.Jsii$Proxy) o;

            if (!monitorName.equals(that.monitorName)) return false;
            if (this.healthEventsConfig != null ? !this.healthEventsConfig.equals(that.healthEventsConfig) : that.healthEventsConfig != null) return false;
            if (this.includeLinkedAccounts != null ? !this.includeLinkedAccounts.equals(that.includeLinkedAccounts) : that.includeLinkedAccounts != null) return false;
            if (this.internetMeasurementsLogDelivery != null ? !this.internetMeasurementsLogDelivery.equals(that.internetMeasurementsLogDelivery) : that.internetMeasurementsLogDelivery != null) return false;
            if (this.linkedAccountId != null ? !this.linkedAccountId.equals(that.linkedAccountId) : that.linkedAccountId != null) return false;
            if (this.maxCityNetworksToMonitor != null ? !this.maxCityNetworksToMonitor.equals(that.maxCityNetworksToMonitor) : that.maxCityNetworksToMonitor != null) return false;
            if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) return false;
            if (this.resourcesToAdd != null ? !this.resourcesToAdd.equals(that.resourcesToAdd) : that.resourcesToAdd != null) return false;
            if (this.resourcesToRemove != null ? !this.resourcesToRemove.equals(that.resourcesToRemove) : that.resourcesToRemove != null) return false;
            if (this.status != null ? !this.status.equals(that.status) : that.status != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.trafficPercentageToMonitor != null ? this.trafficPercentageToMonitor.equals(that.trafficPercentageToMonitor) : that.trafficPercentageToMonitor == null;
        }

        @Override
        public final int hashCode() {
            int result = this.monitorName.hashCode();
            result = 31 * result + (this.healthEventsConfig != null ? this.healthEventsConfig.hashCode() : 0);
            result = 31 * result + (this.includeLinkedAccounts != null ? this.includeLinkedAccounts.hashCode() : 0);
            result = 31 * result + (this.internetMeasurementsLogDelivery != null ? this.internetMeasurementsLogDelivery.hashCode() : 0);
            result = 31 * result + (this.linkedAccountId != null ? this.linkedAccountId.hashCode() : 0);
            result = 31 * result + (this.maxCityNetworksToMonitor != null ? this.maxCityNetworksToMonitor.hashCode() : 0);
            result = 31 * result + (this.resources != null ? this.resources.hashCode() : 0);
            result = 31 * result + (this.resourcesToAdd != null ? this.resourcesToAdd.hashCode() : 0);
            result = 31 * result + (this.resourcesToRemove != null ? this.resourcesToRemove.hashCode() : 0);
            result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.trafficPercentageToMonitor != null ? this.trafficPercentageToMonitor.hashCode() : 0);
            return result;
        }
    }
}
