package software.amazon.awscdk.services.iotsitewise;

/**
 * Creates an asset from an existing asset model.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-assets.html">Creating assets</a> in the <em>AWS IoT SiteWise User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotsitewise.*;
 * CfnAsset cfnAsset = CfnAsset.Builder.create(this, "MyCfnAsset")
 *         .assetModelId("assetModelId")
 *         .assetName("assetName")
 *         // the properties below are optional
 *         .assetDescription("assetDescription")
 *         .assetExternalId("assetExternalId")
 *         .assetHierarchies(List.of(AssetHierarchyProperty.builder()
 *                 .childAssetId("childAssetId")
 *                 // the properties below are optional
 *                 .externalId("externalId")
 *                 .id("id")
 *                 .logicalId("logicalId")
 *                 .build()))
 *         .assetProperties(List.of(AssetPropertyProperty.builder()
 *                 .alias("alias")
 *                 .externalId("externalId")
 *                 .id("id")
 *                 .logicalId("logicalId")
 *                 .notificationState("notificationState")
 *                 .unit("unit")
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-asset.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-asset.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:37.716Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotsitewise.CfnAsset")
public class CfnAsset extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnAsset(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAsset(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iotsitewise.CfnAsset.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnAsset(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotsitewise.CfnAssetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN of the asset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAssetArn() {
        return software.amazon.jsii.Kernel.get(this, "attrAssetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the asset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAssetId() {
        return software.amazon.jsii.Kernel.get(this, "attrAssetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The ID of the asset model from which to create the asset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAssetModelId() {
        return software.amazon.jsii.Kernel.get(this, "assetModelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the asset model from which to create the asset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssetModelId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "assetModelId", java.util.Objects.requireNonNull(value, "assetModelId is required"));
    }

    /**
     * A friendly name for the asset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAssetName() {
        return software.amazon.jsii.Kernel.get(this, "assetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A friendly name for the asset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssetName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "assetName", java.util.Objects.requireNonNull(value, "assetName is required"));
    }

    /**
     * The ID of the asset, in UUID format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAssetDescription() {
        return software.amazon.jsii.Kernel.get(this, "assetDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the asset, in UUID format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssetDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "assetDescription", value);
    }

    /**
     * The external ID of the asset model composite model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAssetExternalId() {
        return software.amazon.jsii.Kernel.get(this, "assetExternalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The external ID of the asset model composite model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssetExternalId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "assetExternalId", value);
    }

    /**
     * A list of asset hierarchies that each contain a <code>hierarchyId</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAssetHierarchies() {
        return software.amazon.jsii.Kernel.get(this, "assetHierarchies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of asset hierarchies that each contain a <code>hierarchyId</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssetHierarchies(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "assetHierarchies", value);
    }

    /**
     * A list of asset hierarchies that each contain a <code>hierarchyId</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssetHierarchies(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.iotsitewise.CfnAsset.AssetHierarchyProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.iotsitewise.CfnAsset.AssetHierarchyProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "assetHierarchies", value);
    }

    /**
     * The list of asset properties for the asset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAssetProperties() {
        return software.amazon.jsii.Kernel.get(this, "assetProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The list of asset properties for the asset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssetProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "assetProperties", value);
    }

    /**
     * The list of asset properties for the asset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssetProperties(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.iotsitewise.CfnAsset.AssetPropertyProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.iotsitewise.CfnAsset.AssetPropertyProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "assetProperties", value);
    }

    /**
     * A list of key-value pairs that contain metadata for the asset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of key-value pairs that contain metadata for the asset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * Describes an asset hierarchy that contains a hierarchy's name and ID.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotsitewise.*;
     * AssetHierarchyProperty assetHierarchyProperty = AssetHierarchyProperty.builder()
     *         .childAssetId("childAssetId")
     *         // the properties below are optional
     *         .externalId("externalId")
     *         .id("id")
     *         .logicalId("logicalId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-asset-assethierarchy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-asset-assethierarchy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotsitewise.CfnAsset.AssetHierarchyProperty")
    @software.amazon.jsii.Jsii.Proxy(AssetHierarchyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AssetHierarchyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Id of the child asset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-asset-assethierarchy.html#cfn-iotsitewise-asset-assethierarchy-childassetid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-asset-assethierarchy.html#cfn-iotsitewise-asset-assethierarchy-childassetid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getChildAssetId();

        /**
         * The external ID of the hierarchy, if it has one.
         * <p>
         * When you update an asset hierarchy, you may assign an external ID if it doesn't already have one. You can't change the external ID of an asset hierarchy that already has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-asset-assethierarchy.html#cfn-iotsitewise-asset-assethierarchy-externalid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-asset-assethierarchy.html#cfn-iotsitewise-asset-assethierarchy-externalid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExternalId() {
            return null;
        }

        /**
         * The ID of the hierarchy. This ID is a <code>hierarchyId</code> .
         * <p>
         * <blockquote>
         * <p>
         * This is a return value and can't be set.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-asset-assethierarchy.html#cfn-iotsitewise-asset-assethierarchy-id">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-asset-assethierarchy.html#cfn-iotsitewise-asset-assethierarchy-id</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getId() {
            return null;
        }

        /**
         * The ID of the hierarchy.
         * <p>
         * This ID is a <code>hierarchyId</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-asset-assethierarchy.html#cfn-iotsitewise-asset-assethierarchy-logicalid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-asset-assethierarchy.html#cfn-iotsitewise-asset-assethierarchy-logicalid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLogicalId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AssetHierarchyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AssetHierarchyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AssetHierarchyProperty> {
            java.lang.String childAssetId;
            java.lang.String externalId;
            java.lang.String id;
            java.lang.String logicalId;

            /**
             * Sets the value of {@link AssetHierarchyProperty#getChildAssetId}
             * @param childAssetId The Id of the child asset. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder childAssetId(java.lang.String childAssetId) {
                this.childAssetId = childAssetId;
                return this;
            }

            /**
             * Sets the value of {@link AssetHierarchyProperty#getExternalId}
             * @param externalId The external ID of the hierarchy, if it has one.
             *                   When you update an asset hierarchy, you may assign an external ID if it doesn't already have one. You can't change the external ID of an asset hierarchy that already has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <em>AWS IoT SiteWise User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder externalId(java.lang.String externalId) {
                this.externalId = externalId;
                return this;
            }

            /**
             * Sets the value of {@link AssetHierarchyProperty#getId}
             * @param id The ID of the hierarchy. This ID is a <code>hierarchyId</code> .
             *           <blockquote>
             *           <p>
             *           This is a return value and can't be set.
             *           <p>
             *           </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link AssetHierarchyProperty#getLogicalId}
             * @param logicalId The ID of the hierarchy.
             *                  This ID is a <code>hierarchyId</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logicalId(java.lang.String logicalId) {
                this.logicalId = logicalId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AssetHierarchyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AssetHierarchyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AssetHierarchyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssetHierarchyProperty {
            private final java.lang.String childAssetId;
            private final java.lang.String externalId;
            private final java.lang.String id;
            private final java.lang.String logicalId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.childAssetId = software.amazon.jsii.Kernel.get(this, "childAssetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.externalId = software.amazon.jsii.Kernel.get(this, "externalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.logicalId = software.amazon.jsii.Kernel.get(this, "logicalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.childAssetId = java.util.Objects.requireNonNull(builder.childAssetId, "childAssetId is required");
                this.externalId = builder.externalId;
                this.id = builder.id;
                this.logicalId = builder.logicalId;
            }

            @Override
            public final java.lang.String getChildAssetId() {
                return this.childAssetId;
            }

            @Override
            public final java.lang.String getExternalId() {
                return this.externalId;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.String getLogicalId() {
                return this.logicalId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("childAssetId", om.valueToTree(this.getChildAssetId()));
                if (this.getExternalId() != null) {
                    data.set("externalId", om.valueToTree(this.getExternalId()));
                }
                if (this.getId() != null) {
                    data.set("id", om.valueToTree(this.getId()));
                }
                if (this.getLogicalId() != null) {
                    data.set("logicalId", om.valueToTree(this.getLogicalId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotsitewise.CfnAsset.AssetHierarchyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AssetHierarchyProperty.Jsii$Proxy that = (AssetHierarchyProperty.Jsii$Proxy) o;

                if (!childAssetId.equals(that.childAssetId)) return false;
                if (this.externalId != null ? !this.externalId.equals(that.externalId) : that.externalId != null) return false;
                if (this.id != null ? !this.id.equals(that.id) : that.id != null) return false;
                return this.logicalId != null ? this.logicalId.equals(that.logicalId) : that.logicalId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.childAssetId.hashCode();
                result = 31 * result + (this.externalId != null ? this.externalId.hashCode() : 0);
                result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
                result = 31 * result + (this.logicalId != null ? this.logicalId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains asset property information.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotsitewise.*;
     * AssetPropertyProperty assetPropertyProperty = AssetPropertyProperty.builder()
     *         .alias("alias")
     *         .externalId("externalId")
     *         .id("id")
     *         .logicalId("logicalId")
     *         .notificationState("notificationState")
     *         .unit("unit")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-asset-assetproperty.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-asset-assetproperty.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotsitewise.CfnAsset.AssetPropertyProperty")
    @software.amazon.jsii.Jsii.Proxy(AssetPropertyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AssetPropertyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The alias that identifies the property, such as an OPC-UA server data stream path (for example, <code>/company/windfarm/3/turbine/7/temperature</code> ).
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-asset-assetproperty.html#cfn-iotsitewise-asset-assetproperty-alias">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-asset-assetproperty.html#cfn-iotsitewise-asset-assetproperty-alias</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAlias() {
            return null;
        }

        /**
         * The external ID of the property.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-asset-assetproperty.html#cfn-iotsitewise-asset-assetproperty-externalid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-asset-assetproperty.html#cfn-iotsitewise-asset-assetproperty-externalid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExternalId() {
            return null;
        }

        /**
         * The ID of the asset property.
         * <p>
         * <blockquote>
         * <p>
         * This is a return value and can't be set.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-asset-assetproperty.html#cfn-iotsitewise-asset-assetproperty-id">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-asset-assetproperty.html#cfn-iotsitewise-asset-assetproperty-id</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getId() {
            return null;
        }

        /**
         * The <code>LogicalID</code> of the asset property.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-asset-assetproperty.html#cfn-iotsitewise-asset-assetproperty-logicalid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-asset-assetproperty.html#cfn-iotsitewise-asset-assetproperty-logicalid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLogicalId() {
            return null;
        }

        /**
         * The MQTT notification state (enabled or disabled) for this asset property.
         * <p>
         * When the notification state is enabled, AWS IoT SiteWise publishes property value updates to a unique MQTT topic. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/interact-with-other-services.html">Interacting with other services</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * <p>
         * If you omit this parameter, the notification state is set to <code>DISABLED</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-asset-assetproperty.html#cfn-iotsitewise-asset-assetproperty-notificationstate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-asset-assetproperty.html#cfn-iotsitewise-asset-assetproperty-notificationstate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNotificationState() {
            return null;
        }

        /**
         * The unit (such as <code>Newtons</code> or <code>RPM</code> ) of the asset property.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-asset-assetproperty.html#cfn-iotsitewise-asset-assetproperty-unit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-asset-assetproperty.html#cfn-iotsitewise-asset-assetproperty-unit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUnit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AssetPropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AssetPropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AssetPropertyProperty> {
            java.lang.String alias;
            java.lang.String externalId;
            java.lang.String id;
            java.lang.String logicalId;
            java.lang.String notificationState;
            java.lang.String unit;

            /**
             * Sets the value of {@link AssetPropertyProperty#getAlias}
             * @param alias The alias that identifies the property, such as an OPC-UA server data stream path (for example, <code>/company/windfarm/3/turbine/7/temperature</code> ).
             *              For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the <em>AWS IoT SiteWise User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alias(java.lang.String alias) {
                this.alias = alias;
                return this;
            }

            /**
             * Sets the value of {@link AssetPropertyProperty#getExternalId}
             * @param externalId The external ID of the property.
             *                   For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <em>AWS IoT SiteWise User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder externalId(java.lang.String externalId) {
                this.externalId = externalId;
                return this;
            }

            /**
             * Sets the value of {@link AssetPropertyProperty#getId}
             * @param id The ID of the asset property.
             *           <blockquote>
             *           <p>
             *           This is a return value and can't be set.
             *           <p>
             *           </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link AssetPropertyProperty#getLogicalId}
             * @param logicalId The <code>LogicalID</code> of the asset property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logicalId(java.lang.String logicalId) {
                this.logicalId = logicalId;
                return this;
            }

            /**
             * Sets the value of {@link AssetPropertyProperty#getNotificationState}
             * @param notificationState The MQTT notification state (enabled or disabled) for this asset property.
             *                          When the notification state is enabled, AWS IoT SiteWise publishes property value updates to a unique MQTT topic. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/interact-with-other-services.html">Interacting with other services</a> in the <em>AWS IoT SiteWise User Guide</em> .
             *                          <p>
             *                          If you omit this parameter, the notification state is set to <code>DISABLED</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notificationState(java.lang.String notificationState) {
                this.notificationState = notificationState;
                return this;
            }

            /**
             * Sets the value of {@link AssetPropertyProperty#getUnit}
             * @param unit The unit (such as <code>Newtons</code> or <code>RPM</code> ) of the asset property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unit(java.lang.String unit) {
                this.unit = unit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AssetPropertyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AssetPropertyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AssetPropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssetPropertyProperty {
            private final java.lang.String alias;
            private final java.lang.String externalId;
            private final java.lang.String id;
            private final java.lang.String logicalId;
            private final java.lang.String notificationState;
            private final java.lang.String unit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.alias = software.amazon.jsii.Kernel.get(this, "alias", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.externalId = software.amazon.jsii.Kernel.get(this, "externalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.logicalId = software.amazon.jsii.Kernel.get(this, "logicalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.notificationState = software.amazon.jsii.Kernel.get(this, "notificationState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.unit = software.amazon.jsii.Kernel.get(this, "unit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.alias = builder.alias;
                this.externalId = builder.externalId;
                this.id = builder.id;
                this.logicalId = builder.logicalId;
                this.notificationState = builder.notificationState;
                this.unit = builder.unit;
            }

            @Override
            public final java.lang.String getAlias() {
                return this.alias;
            }

            @Override
            public final java.lang.String getExternalId() {
                return this.externalId;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.String getLogicalId() {
                return this.logicalId;
            }

            @Override
            public final java.lang.String getNotificationState() {
                return this.notificationState;
            }

            @Override
            public final java.lang.String getUnit() {
                return this.unit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAlias() != null) {
                    data.set("alias", om.valueToTree(this.getAlias()));
                }
                if (this.getExternalId() != null) {
                    data.set("externalId", om.valueToTree(this.getExternalId()));
                }
                if (this.getId() != null) {
                    data.set("id", om.valueToTree(this.getId()));
                }
                if (this.getLogicalId() != null) {
                    data.set("logicalId", om.valueToTree(this.getLogicalId()));
                }
                if (this.getNotificationState() != null) {
                    data.set("notificationState", om.valueToTree(this.getNotificationState()));
                }
                if (this.getUnit() != null) {
                    data.set("unit", om.valueToTree(this.getUnit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotsitewise.CfnAsset.AssetPropertyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AssetPropertyProperty.Jsii$Proxy that = (AssetPropertyProperty.Jsii$Proxy) o;

                if (this.alias != null ? !this.alias.equals(that.alias) : that.alias != null) return false;
                if (this.externalId != null ? !this.externalId.equals(that.externalId) : that.externalId != null) return false;
                if (this.id != null ? !this.id.equals(that.id) : that.id != null) return false;
                if (this.logicalId != null ? !this.logicalId.equals(that.logicalId) : that.logicalId != null) return false;
                if (this.notificationState != null ? !this.notificationState.equals(that.notificationState) : that.notificationState != null) return false;
                return this.unit != null ? this.unit.equals(that.unit) : that.unit == null;
            }

            @Override
            public final int hashCode() {
                int result = this.alias != null ? this.alias.hashCode() : 0;
                result = 31 * result + (this.externalId != null ? this.externalId.hashCode() : 0);
                result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
                result = 31 * result + (this.logicalId != null ? this.logicalId.hashCode() : 0);
                result = 31 * result + (this.notificationState != null ? this.notificationState.hashCode() : 0);
                result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iotsitewise.CfnAsset}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iotsitewise.CfnAsset> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.iotsitewise.CfnAssetProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.iotsitewise.CfnAssetProps.Builder();
        }

        /**
         * The ID of the asset model from which to create the asset.
         * <p>
         * This can be either the actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">Referencing objects with external IDs</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-asset.html#cfn-iotsitewise-asset-assetmodelid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-asset.html#cfn-iotsitewise-asset-assetmodelid</a>
         * @param assetModelId The ID of the asset model from which to create the asset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetModelId(final java.lang.String assetModelId) {
            this.props.assetModelId(assetModelId);
            return this;
        }

        /**
         * A friendly name for the asset.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-asset.html#cfn-iotsitewise-asset-assetname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-asset.html#cfn-iotsitewise-asset-assetname</a>
         * @param assetName A friendly name for the asset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetName(final java.lang.String assetName) {
            this.props.assetName(assetName);
            return this;
        }

        /**
         * The ID of the asset, in UUID format.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-asset.html#cfn-iotsitewise-asset-assetdescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-asset.html#cfn-iotsitewise-asset-assetdescription</a>
         * @param assetDescription The ID of the asset, in UUID format. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetDescription(final java.lang.String assetDescription) {
            this.props.assetDescription(assetDescription);
            return this;
        }

        /**
         * The external ID of the asset model composite model.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-asset.html#cfn-iotsitewise-asset-assetexternalid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-asset.html#cfn-iotsitewise-asset-assetexternalid</a>
         * @param assetExternalId The external ID of the asset model composite model. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetExternalId(final java.lang.String assetExternalId) {
            this.props.assetExternalId(assetExternalId);
            return this;
        }

        /**
         * A list of asset hierarchies that each contain a <code>hierarchyId</code> .
         * <p>
         * A hierarchy specifies allowed parent/child asset relationships.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-asset.html#cfn-iotsitewise-asset-assethierarchies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-asset.html#cfn-iotsitewise-asset-assethierarchies</a>
         * @param assetHierarchies A list of asset hierarchies that each contain a <code>hierarchyId</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetHierarchies(final software.amazon.awscdk.IResolvable assetHierarchies) {
            this.props.assetHierarchies(assetHierarchies);
            return this;
        }
        /**
         * A list of asset hierarchies that each contain a <code>hierarchyId</code> .
         * <p>
         * A hierarchy specifies allowed parent/child asset relationships.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-asset.html#cfn-iotsitewise-asset-assethierarchies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-asset.html#cfn-iotsitewise-asset-assethierarchies</a>
         * @param assetHierarchies A list of asset hierarchies that each contain a <code>hierarchyId</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetHierarchies(final java.util.List<? extends java.lang.Object> assetHierarchies) {
            this.props.assetHierarchies(assetHierarchies);
            return this;
        }

        /**
         * The list of asset properties for the asset.
         * <p>
         * This object doesn't include properties that you define in composite models. You can find composite model properties in the <code>assetCompositeModels</code> object.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-asset.html#cfn-iotsitewise-asset-assetproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-asset.html#cfn-iotsitewise-asset-assetproperties</a>
         * @param assetProperties The list of asset properties for the asset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetProperties(final software.amazon.awscdk.IResolvable assetProperties) {
            this.props.assetProperties(assetProperties);
            return this;
        }
        /**
         * The list of asset properties for the asset.
         * <p>
         * This object doesn't include properties that you define in composite models. You can find composite model properties in the <code>assetCompositeModels</code> object.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-asset.html#cfn-iotsitewise-asset-assetproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-asset.html#cfn-iotsitewise-asset-assetproperties</a>
         * @param assetProperties The list of asset properties for the asset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetProperties(final java.util.List<? extends java.lang.Object> assetProperties) {
            this.props.assetProperties(assetProperties);
            return this;
        }

        /**
         * A list of key-value pairs that contain metadata for the asset.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your AWS IoT SiteWise resources</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-asset.html#cfn-iotsitewise-asset-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-asset.html#cfn-iotsitewise-asset-tags</a>
         * @param tags A list of key-value pairs that contain metadata for the asset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.iotsitewise.CfnAsset}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iotsitewise.CfnAsset build() {
            return new software.amazon.awscdk.services.iotsitewise.CfnAsset(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
