package software.amazon.awscdk.services.iotwireless;

/**
 * Properties for defining a <code>CfnWirelessDevice</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotwireless.*;
 * CfnWirelessDeviceProps cfnWirelessDeviceProps = CfnWirelessDeviceProps.builder()
 *         .destinationName("destinationName")
 *         .type("type")
 *         // the properties below are optional
 *         .description("description")
 *         .lastUplinkReceivedAt("lastUplinkReceivedAt")
 *         .loRaWan(LoRaWANDeviceProperty.builder()
 *                 .abpV10X(AbpV10xProperty.builder()
 *                         .devAddr("devAddr")
 *                         .sessionKeys(SessionKeysAbpV10xProperty.builder()
 *                                 .appSKey("appSKey")
 *                                 .nwkSKey("nwkSKey")
 *                                 .build())
 *                         .build())
 *                 .abpV11(AbpV11Property.builder()
 *                         .devAddr("devAddr")
 *                         .sessionKeys(SessionKeysAbpV11Property.builder()
 *                                 .appSKey("appSKey")
 *                                 .fNwkSIntKey("fNwkSIntKey")
 *                                 .nwkSEncKey("nwkSEncKey")
 *                                 .sNwkSIntKey("sNwkSIntKey")
 *                                 .build())
 *                         .build())
 *                 .devEui("devEui")
 *                 .deviceProfileId("deviceProfileId")
 *                 .fPorts(FPortsProperty.builder()
 *                         .applications(List.of(ApplicationProperty.builder()
 *                                 .destinationName("destinationName")
 *                                 .fPort(123)
 *                                 .type("type")
 *                                 .build()))
 *                         .build())
 *                 .otaaV10X(OtaaV10xProperty.builder()
 *                         .appEui("appEui")
 *                         .appKey("appKey")
 *                         .build())
 *                 .otaaV11(OtaaV11Property.builder()
 *                         .appKey("appKey")
 *                         .joinEui("joinEui")
 *                         .nwkKey("nwkKey")
 *                         .build())
 *                 .serviceProfileId("serviceProfileId")
 *                 .build())
 *         .name("name")
 *         .positioning("positioning")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .thingArn("thingArn")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:37.834Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotwireless.CfnWirelessDeviceProps")
@software.amazon.jsii.Jsii.Proxy(CfnWirelessDeviceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnWirelessDeviceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the destination to assign to the new wireless device.
     * <p>
     * Can have only have alphanumeric, - (hyphen) and _ (underscore) characters and it can't have any spaces.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-destinationname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-destinationname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDestinationName();

    /**
     * The wireless device type.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-type</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * The description of the new resource.
     * <p>
     * Maximum length is 2048.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The date and time when the most recent uplink was received.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-lastuplinkreceivedat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-lastuplinkreceivedat</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLastUplinkReceivedAt() {
        return null;
    }

    /**
     * The device configuration information to use to create the wireless device.
     * <p>
     * Must be at least one of OtaaV10x, OtaaV11, AbpV11, or AbpV10x.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-lorawan">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-lorawan</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLoRaWan() {
        return null;
    }

    /**
     * The name of the new resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * FPort values for the GNSS, Stream, and ClockSync functions of the positioning information.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-positioning">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-positioning</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPositioning() {
        return null;
    }

    /**
     * The tags are an array of key-value pairs to attach to the specified resource.
     * <p>
     * Tags can have a minimum of 0 and a maximum of 50 items.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The ARN of the thing to associate with the wireless device.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-thingarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-thingarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getThingArn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnWirelessDeviceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnWirelessDeviceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnWirelessDeviceProps> {
        java.lang.String destinationName;
        java.lang.String type;
        java.lang.String description;
        java.lang.String lastUplinkReceivedAt;
        java.lang.Object loRaWan;
        java.lang.String name;
        java.lang.String positioning;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String thingArn;

        /**
         * Sets the value of {@link CfnWirelessDeviceProps#getDestinationName}
         * @param destinationName The name of the destination to assign to the new wireless device. This parameter is required.
         *                        Can have only have alphanumeric, - (hyphen) and _ (underscore) characters and it can't have any spaces.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationName(java.lang.String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        /**
         * Sets the value of {@link CfnWirelessDeviceProps#getType}
         * @param type The wireless device type. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link CfnWirelessDeviceProps#getDescription}
         * @param description The description of the new resource.
         *                    Maximum length is 2048.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnWirelessDeviceProps#getLastUplinkReceivedAt}
         * @param lastUplinkReceivedAt The date and time when the most recent uplink was received.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lastUplinkReceivedAt(java.lang.String lastUplinkReceivedAt) {
            this.lastUplinkReceivedAt = lastUplinkReceivedAt;
            return this;
        }

        /**
         * Sets the value of {@link CfnWirelessDeviceProps#getLoRaWan}
         * @param loRaWan The device configuration information to use to create the wireless device.
         *                Must be at least one of OtaaV10x, OtaaV11, AbpV11, or AbpV10x.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loRaWan(software.amazon.awscdk.IResolvable loRaWan) {
            this.loRaWan = loRaWan;
            return this;
        }

        /**
         * Sets the value of {@link CfnWirelessDeviceProps#getLoRaWan}
         * @param loRaWan The device configuration information to use to create the wireless device.
         *                Must be at least one of OtaaV10x, OtaaV11, AbpV11, or AbpV10x.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loRaWan(software.amazon.awscdk.services.iotwireless.CfnWirelessDevice.LoRaWANDeviceProperty loRaWan) {
            this.loRaWan = loRaWan;
            return this;
        }

        /**
         * Sets the value of {@link CfnWirelessDeviceProps#getName}
         * @param name The name of the new resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnWirelessDeviceProps#getPositioning}
         * @param positioning FPort values for the GNSS, Stream, and ClockSync functions of the positioning information.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder positioning(java.lang.String positioning) {
            this.positioning = positioning;
            return this;
        }

        /**
         * Sets the value of {@link CfnWirelessDeviceProps#getTags}
         * @param tags The tags are an array of key-value pairs to attach to the specified resource.
         *             Tags can have a minimum of 0 and a maximum of 50 items.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnWirelessDeviceProps#getThingArn}
         * @param thingArn The ARN of the thing to associate with the wireless device.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder thingArn(java.lang.String thingArn) {
            this.thingArn = thingArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnWirelessDeviceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnWirelessDeviceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnWirelessDeviceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnWirelessDeviceProps {
        private final java.lang.String destinationName;
        private final java.lang.String type;
        private final java.lang.String description;
        private final java.lang.String lastUplinkReceivedAt;
        private final java.lang.Object loRaWan;
        private final java.lang.String name;
        private final java.lang.String positioning;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String thingArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.destinationName = software.amazon.jsii.Kernel.get(this, "destinationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.lastUplinkReceivedAt = software.amazon.jsii.Kernel.get(this, "lastUplinkReceivedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.loRaWan = software.amazon.jsii.Kernel.get(this, "loRaWan", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.positioning = software.amazon.jsii.Kernel.get(this, "positioning", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.thingArn = software.amazon.jsii.Kernel.get(this, "thingArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.destinationName = java.util.Objects.requireNonNull(builder.destinationName, "destinationName is required");
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.description = builder.description;
            this.lastUplinkReceivedAt = builder.lastUplinkReceivedAt;
            this.loRaWan = builder.loRaWan;
            this.name = builder.name;
            this.positioning = builder.positioning;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.thingArn = builder.thingArn;
        }

        @Override
        public final java.lang.String getDestinationName() {
            return this.destinationName;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getLastUplinkReceivedAt() {
            return this.lastUplinkReceivedAt;
        }

        @Override
        public final java.lang.Object getLoRaWan() {
            return this.loRaWan;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getPositioning() {
            return this.positioning;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getThingArn() {
            return this.thingArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("destinationName", om.valueToTree(this.getDestinationName()));
            data.set("type", om.valueToTree(this.getType()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getLastUplinkReceivedAt() != null) {
                data.set("lastUplinkReceivedAt", om.valueToTree(this.getLastUplinkReceivedAt()));
            }
            if (this.getLoRaWan() != null) {
                data.set("loRaWan", om.valueToTree(this.getLoRaWan()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getPositioning() != null) {
                data.set("positioning", om.valueToTree(this.getPositioning()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getThingArn() != null) {
                data.set("thingArn", om.valueToTree(this.getThingArn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotwireless.CfnWirelessDeviceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnWirelessDeviceProps.Jsii$Proxy that = (CfnWirelessDeviceProps.Jsii$Proxy) o;

            if (!destinationName.equals(that.destinationName)) return false;
            if (!type.equals(that.type)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.lastUplinkReceivedAt != null ? !this.lastUplinkReceivedAt.equals(that.lastUplinkReceivedAt) : that.lastUplinkReceivedAt != null) return false;
            if (this.loRaWan != null ? !this.loRaWan.equals(that.loRaWan) : that.loRaWan != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.positioning != null ? !this.positioning.equals(that.positioning) : that.positioning != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.thingArn != null ? this.thingArn.equals(that.thingArn) : that.thingArn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.destinationName.hashCode();
            result = 31 * result + (this.type.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.lastUplinkReceivedAt != null ? this.lastUplinkReceivedAt.hashCode() : 0);
            result = 31 * result + (this.loRaWan != null ? this.loRaWan.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.positioning != null ? this.positioning.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.thingArn != null ? this.thingArn.hashCode() : 0);
            return result;
        }
    }
}
