package software.amazon.awscdk.services.ivs;

/**
 * Properties for defining a <code>CfnChannel</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ivs.*;
 * CfnChannelProps cfnChannelProps = CfnChannelProps.builder()
 *         .authorized(false)
 *         .containerFormat("containerFormat")
 *         .insecureIngest(false)
 *         .latencyMode("latencyMode")
 *         .multitrackInputConfiguration(MultitrackInputConfigurationProperty.builder()
 *                 .enabled(false)
 *                 .maximumResolution("maximumResolution")
 *                 .policy("policy")
 *                 .build())
 *         .name("name")
 *         .preset("preset")
 *         .recordingConfigurationArn("recordingConfigurationArn")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .type("type")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-channel.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-channel.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:37.839Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ivs.CfnChannelProps")
@software.amazon.jsii.Jsii.Proxy(CfnChannelProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnChannelProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether the channel is authorized.
     * <p>
     * Default: - false
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-channel.html#cfn-ivs-channel-authorized">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-channel.html#cfn-ivs-channel-authorized</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAuthorized() {
        return null;
    }

    /**
     * Indicates which content-packaging format is used (MPEG-TS or fMP4).
     * <p>
     * If multitrackInputConfiguration is specified and enabled is true, then containerFormat is required and must be set to FRAGMENTED_MP4. Otherwise, containerFormat may be set to TS or FRAGMENTED_MP4. Default: TS.
     * <p>
     * Default: - "TS"
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-channel.html#cfn-ivs-channel-containerformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-channel.html#cfn-ivs-channel-containerformat</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getContainerFormat() {
        return null;
    }

    /**
     * Whether the channel allows insecure ingest.
     * <p>
     * Default: - false
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-channel.html#cfn-ivs-channel-insecureingest">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-channel.html#cfn-ivs-channel-insecureingest</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getInsecureIngest() {
        return null;
    }

    /**
     * Channel latency mode.
     * <p>
     * Default: - "LOW"
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-channel.html#cfn-ivs-channel-latencymode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-channel.html#cfn-ivs-channel-latencymode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLatencyMode() {
        return null;
    }

    /**
     * Object specifying multitrack input configuration.
     * <p>
     * Default: no multitrack input configuration is specified.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-channel.html#cfn-ivs-channel-multitrackinputconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-channel.html#cfn-ivs-channel-multitrackinputconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMultitrackInputConfiguration() {
        return null;
    }

    /**
     * Channel.
     * <p>
     * Default: - "-"
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-channel.html#cfn-ivs-channel-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-channel.html#cfn-ivs-channel-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * Optional transcode preset for the channel.
     * <p>
     * This is selectable only for ADVANCED_HD and ADVANCED_SD channel types. For those channel types, the default preset is HIGHER_BANDWIDTH_DELIVERY. For other channel types (BASIC and STANDARD), preset is the empty string ("").
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-channel.html#cfn-ivs-channel-preset">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-channel.html#cfn-ivs-channel-preset</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPreset() {
        return null;
    }

    /**
     * Recording Configuration ARN.
     * <p>
     * A value other than an empty string indicates that recording is enabled. Default: "" (recording is disabled).
     * <p>
     * Default: - ""
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-channel.html#cfn-ivs-channel-recordingconfigurationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-channel.html#cfn-ivs-channel-recordingconfigurationarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRecordingConfigurationArn() {
        return null;
    }

    /**
     * A list of key-value pairs that contain metadata for the asset model.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-channel.html#cfn-ivs-channel-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-channel.html#cfn-ivs-channel-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * Channel type, which determines the allowable resolution and bitrate.
     * <p>
     * If you exceed the allowable resolution or bitrate, the stream probably will disconnect immediately.
     * <p>
     * Default: - "STANDARD"
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-channel.html#cfn-ivs-channel-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-channel.html#cfn-ivs-channel-type</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnChannelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnChannelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnChannelProps> {
        java.lang.Object authorized;
        java.lang.String containerFormat;
        java.lang.Object insecureIngest;
        java.lang.String latencyMode;
        java.lang.Object multitrackInputConfiguration;
        java.lang.String name;
        java.lang.String preset;
        java.lang.String recordingConfigurationArn;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String type;

        /**
         * Sets the value of {@link CfnChannelProps#getAuthorized}
         * @param authorized Whether the channel is authorized.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorized(java.lang.Boolean authorized) {
            this.authorized = authorized;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getAuthorized}
         * @param authorized Whether the channel is authorized.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorized(software.amazon.awscdk.IResolvable authorized) {
            this.authorized = authorized;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getContainerFormat}
         * @param containerFormat Indicates which content-packaging format is used (MPEG-TS or fMP4).
         *                        If multitrackInputConfiguration is specified and enabled is true, then containerFormat is required and must be set to FRAGMENTED_MP4. Otherwise, containerFormat may be set to TS or FRAGMENTED_MP4. Default: TS.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerFormat(java.lang.String containerFormat) {
            this.containerFormat = containerFormat;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getInsecureIngest}
         * @param insecureIngest Whether the channel allows insecure ingest.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder insecureIngest(java.lang.Boolean insecureIngest) {
            this.insecureIngest = insecureIngest;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getInsecureIngest}
         * @param insecureIngest Whether the channel allows insecure ingest.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder insecureIngest(software.amazon.awscdk.IResolvable insecureIngest) {
            this.insecureIngest = insecureIngest;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getLatencyMode}
         * @param latencyMode Channel latency mode.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder latencyMode(java.lang.String latencyMode) {
            this.latencyMode = latencyMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getMultitrackInputConfiguration}
         * @param multitrackInputConfiguration Object specifying multitrack input configuration.
         *                                     Default: no multitrack input configuration is specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multitrackInputConfiguration(software.amazon.awscdk.IResolvable multitrackInputConfiguration) {
            this.multitrackInputConfiguration = multitrackInputConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getMultitrackInputConfiguration}
         * @param multitrackInputConfiguration Object specifying multitrack input configuration.
         *                                     Default: no multitrack input configuration is specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multitrackInputConfiguration(software.amazon.awscdk.services.ivs.CfnChannel.MultitrackInputConfigurationProperty multitrackInputConfiguration) {
            this.multitrackInputConfiguration = multitrackInputConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getName}
         * @param name Channel.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getPreset}
         * @param preset Optional transcode preset for the channel.
         *               This is selectable only for ADVANCED_HD and ADVANCED_SD channel types. For those channel types, the default preset is HIGHER_BANDWIDTH_DELIVERY. For other channel types (BASIC and STANDARD), preset is the empty string ("").
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preset(java.lang.String preset) {
            this.preset = preset;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getRecordingConfigurationArn}
         * @param recordingConfigurationArn Recording Configuration ARN.
         *                                  A value other than an empty string indicates that recording is enabled. Default: "" (recording is disabled).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recordingConfigurationArn(java.lang.String recordingConfigurationArn) {
            this.recordingConfigurationArn = recordingConfigurationArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getTags}
         * @param tags A list of key-value pairs that contain metadata for the asset model.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getType}
         * @param type Channel type, which determines the allowable resolution and bitrate.
         *             If you exceed the allowable resolution or bitrate, the stream probably will disconnect immediately.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnChannelProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnChannelProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnChannelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnChannelProps {
        private final java.lang.Object authorized;
        private final java.lang.String containerFormat;
        private final java.lang.Object insecureIngest;
        private final java.lang.String latencyMode;
        private final java.lang.Object multitrackInputConfiguration;
        private final java.lang.String name;
        private final java.lang.String preset;
        private final java.lang.String recordingConfigurationArn;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String type;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.authorized = software.amazon.jsii.Kernel.get(this, "authorized", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.containerFormat = software.amazon.jsii.Kernel.get(this, "containerFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.insecureIngest = software.amazon.jsii.Kernel.get(this, "insecureIngest", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.latencyMode = software.amazon.jsii.Kernel.get(this, "latencyMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.multitrackInputConfiguration = software.amazon.jsii.Kernel.get(this, "multitrackInputConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.preset = software.amazon.jsii.Kernel.get(this, "preset", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.recordingConfigurationArn = software.amazon.jsii.Kernel.get(this, "recordingConfigurationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.authorized = builder.authorized;
            this.containerFormat = builder.containerFormat;
            this.insecureIngest = builder.insecureIngest;
            this.latencyMode = builder.latencyMode;
            this.multitrackInputConfiguration = builder.multitrackInputConfiguration;
            this.name = builder.name;
            this.preset = builder.preset;
            this.recordingConfigurationArn = builder.recordingConfigurationArn;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.type = builder.type;
        }

        @Override
        public final java.lang.Object getAuthorized() {
            return this.authorized;
        }

        @Override
        public final java.lang.String getContainerFormat() {
            return this.containerFormat;
        }

        @Override
        public final java.lang.Object getInsecureIngest() {
            return this.insecureIngest;
        }

        @Override
        public final java.lang.String getLatencyMode() {
            return this.latencyMode;
        }

        @Override
        public final java.lang.Object getMultitrackInputConfiguration() {
            return this.multitrackInputConfiguration;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getPreset() {
            return this.preset;
        }

        @Override
        public final java.lang.String getRecordingConfigurationArn() {
            return this.recordingConfigurationArn;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAuthorized() != null) {
                data.set("authorized", om.valueToTree(this.getAuthorized()));
            }
            if (this.getContainerFormat() != null) {
                data.set("containerFormat", om.valueToTree(this.getContainerFormat()));
            }
            if (this.getInsecureIngest() != null) {
                data.set("insecureIngest", om.valueToTree(this.getInsecureIngest()));
            }
            if (this.getLatencyMode() != null) {
                data.set("latencyMode", om.valueToTree(this.getLatencyMode()));
            }
            if (this.getMultitrackInputConfiguration() != null) {
                data.set("multitrackInputConfiguration", om.valueToTree(this.getMultitrackInputConfiguration()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getPreset() != null) {
                data.set("preset", om.valueToTree(this.getPreset()));
            }
            if (this.getRecordingConfigurationArn() != null) {
                data.set("recordingConfigurationArn", om.valueToTree(this.getRecordingConfigurationArn()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getType() != null) {
                data.set("type", om.valueToTree(this.getType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ivs.CfnChannelProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnChannelProps.Jsii$Proxy that = (CfnChannelProps.Jsii$Proxy) o;

            if (this.authorized != null ? !this.authorized.equals(that.authorized) : that.authorized != null) return false;
            if (this.containerFormat != null ? !this.containerFormat.equals(that.containerFormat) : that.containerFormat != null) return false;
            if (this.insecureIngest != null ? !this.insecureIngest.equals(that.insecureIngest) : that.insecureIngest != null) return false;
            if (this.latencyMode != null ? !this.latencyMode.equals(that.latencyMode) : that.latencyMode != null) return false;
            if (this.multitrackInputConfiguration != null ? !this.multitrackInputConfiguration.equals(that.multitrackInputConfiguration) : that.multitrackInputConfiguration != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.preset != null ? !this.preset.equals(that.preset) : that.preset != null) return false;
            if (this.recordingConfigurationArn != null ? !this.recordingConfigurationArn.equals(that.recordingConfigurationArn) : that.recordingConfigurationArn != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.type != null ? this.type.equals(that.type) : that.type == null;
        }

        @Override
        public final int hashCode() {
            int result = this.authorized != null ? this.authorized.hashCode() : 0;
            result = 31 * result + (this.containerFormat != null ? this.containerFormat.hashCode() : 0);
            result = 31 * result + (this.insecureIngest != null ? this.insecureIngest.hashCode() : 0);
            result = 31 * result + (this.latencyMode != null ? this.latencyMode.hashCode() : 0);
            result = 31 * result + (this.multitrackInputConfiguration != null ? this.multitrackInputConfiguration.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.preset != null ? this.preset.hashCode() : 0);
            result = 31 * result + (this.recordingConfigurationArn != null ? this.recordingConfigurationArn.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            return result;
        }
    }
}
