package software.amazon.awscdk.services.kinesisfirehose;

/**
 * Options for S3 record backup of a delivery stream.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Enable backup of all source records (to an S3 bucket created by CDK).
 * Bucket bucket;
 * // Explicitly provide an S3 bucket to which all source records will be backed up.
 * Bucket backupBucket;
 * DeliveryStream.Builder.create(this, "Delivery Stream Backup All")
 *         .destination(
 *         S3Bucket.Builder.create(bucket)
 *                 .s3Backup(DestinationS3BackupProps.builder()
 *                         .mode(BackupMode.ALL)
 *                         .build())
 *                 .build())
 *         .build();
 * DeliveryStream.Builder.create(this, "Delivery Stream Backup All Explicit Bucket")
 *         .destination(
 *         S3Bucket.Builder.create(bucket)
 *                 .s3Backup(DestinationS3BackupProps.builder()
 *                         .bucket(backupBucket)
 *                         .build())
 *                 .build())
 *         .build();
 * // Explicitly provide an S3 prefix under which all source records will be backed up.
 * // Explicitly provide an S3 prefix under which all source records will be backed up.
 * DeliveryStream.Builder.create(this, "Delivery Stream Backup All Explicit Prefix")
 *         .destination(
 *         S3Bucket.Builder.create(bucket)
 *                 .s3Backup(DestinationS3BackupProps.builder()
 *                         .mode(BackupMode.ALL)
 *                         .dataOutputPrefix("mybackup")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:38.122Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.BackupMode")
public enum BackupMode {
    /**
     * All records are backed up.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ALL,
    /**
     * Only records that failed to deliver or transform are backed up.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FAILED,
}
