package software.amazon.awscdk.services.kinesisfirehose;

/**
 * Properties for a new delivery stream.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket bucket;
 * // Provide a Lambda function that will transform records before delivery, with custom
 * // buffering and retry configuration
 * Function lambdaFunction = Function.Builder.create(this, "Processor")
 *         .runtime(Runtime.NODEJS_LATEST)
 *         .handler("index.handler")
 *         .code(Code.fromAsset(join(__dirname, "process-records")))
 *         .build();
 * LambdaFunctionProcessor lambdaProcessor = LambdaFunctionProcessor.Builder.create(lambdaFunction)
 *         .bufferInterval(Duration.minutes(5))
 *         .bufferSize(Size.mebibytes(5))
 *         .retries(5)
 *         .build();
 * S3Bucket s3Destination = S3Bucket.Builder.create(bucket)
 *         .processor(lambdaProcessor)
 *         .build();
 * DeliveryStream.Builder.create(this, "Delivery Stream")
 *         .destination(s3Destination)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:38.194Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.DeliveryStreamProps")
@software.amazon.jsii.Jsii.Proxy(DeliveryStreamProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DeliveryStreamProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The destination that this delivery stream will deliver data to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.IDestination getDestination();

    /**
     * A name for the delivery stream.
     * <p>
     * Default: - a name is generated by CloudFormation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeliveryStreamName() {
        return null;
    }

    /**
     * Indicates the type of customer master key (CMK) to use for server-side encryption, if any.
     * <p>
     * Default: StreamEncryption.unencrypted()
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.StreamEncryption getEncryption() {
        return null;
    }

    /**
     * The IAM role associated with this delivery stream.
     * <p>
     * Assumed by Amazon Data Firehose to read from sources and encrypt data server-side.
     * <p>
     * Default: - a role will be created with default permissions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * The Kinesis data stream to use as a source for this delivery stream.
     * <p>
     * Default: - data must be written to the delivery stream via a direct put.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.ISource getSource() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DeliveryStreamProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DeliveryStreamProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DeliveryStreamProps> {
        software.amazon.awscdk.services.kinesisfirehose.IDestination destination;
        java.lang.String deliveryStreamName;
        software.amazon.awscdk.services.kinesisfirehose.StreamEncryption encryption;
        software.amazon.awscdk.services.iam.IRole role;
        software.amazon.awscdk.services.kinesisfirehose.ISource source;

        /**
         * Sets the value of {@link DeliveryStreamProps#getDestination}
         * @param destination The destination that this delivery stream will deliver data to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destination(software.amazon.awscdk.services.kinesisfirehose.IDestination destination) {
            this.destination = destination;
            return this;
        }

        /**
         * Sets the value of {@link DeliveryStreamProps#getDeliveryStreamName}
         * @param deliveryStreamName A name for the delivery stream.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryStreamName(java.lang.String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        /**
         * Sets the value of {@link DeliveryStreamProps#getEncryption}
         * @param encryption Indicates the type of customer master key (CMK) to use for server-side encryption, if any.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryption(software.amazon.awscdk.services.kinesisfirehose.StreamEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        /**
         * Sets the value of {@link DeliveryStreamProps#getRole}
         * @param role The IAM role associated with this delivery stream.
         *             Assumed by Amazon Data Firehose to read from sources and encrypt data server-side.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link DeliveryStreamProps#getSource}
         * @param source The Kinesis data stream to use as a source for this delivery stream.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(software.amazon.awscdk.services.kinesisfirehose.ISource source) {
            this.source = source;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DeliveryStreamProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DeliveryStreamProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DeliveryStreamProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeliveryStreamProps {
        private final software.amazon.awscdk.services.kinesisfirehose.IDestination destination;
        private final java.lang.String deliveryStreamName;
        private final software.amazon.awscdk.services.kinesisfirehose.StreamEncryption encryption;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final software.amazon.awscdk.services.kinesisfirehose.ISource source;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.destination = software.amazon.jsii.Kernel.get(this, "destination", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.IDestination.class));
            this.deliveryStreamName = software.amazon.jsii.Kernel.get(this, "deliveryStreamName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.encryption = software.amazon.jsii.Kernel.get(this, "encryption", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.StreamEncryption.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.ISource.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.destination = java.util.Objects.requireNonNull(builder.destination, "destination is required");
            this.deliveryStreamName = builder.deliveryStreamName;
            this.encryption = builder.encryption;
            this.role = builder.role;
            this.source = builder.source;
        }

        @Override
        public final software.amazon.awscdk.services.kinesisfirehose.IDestination getDestination() {
            return this.destination;
        }

        @Override
        public final java.lang.String getDeliveryStreamName() {
            return this.deliveryStreamName;
        }

        @Override
        public final software.amazon.awscdk.services.kinesisfirehose.StreamEncryption getEncryption() {
            return this.encryption;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final software.amazon.awscdk.services.kinesisfirehose.ISource getSource() {
            return this.source;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("destination", om.valueToTree(this.getDestination()));
            if (this.getDeliveryStreamName() != null) {
                data.set("deliveryStreamName", om.valueToTree(this.getDeliveryStreamName()));
            }
            if (this.getEncryption() != null) {
                data.set("encryption", om.valueToTree(this.getEncryption()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getSource() != null) {
                data.set("source", om.valueToTree(this.getSource()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.DeliveryStreamProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DeliveryStreamProps.Jsii$Proxy that = (DeliveryStreamProps.Jsii$Proxy) o;

            if (!destination.equals(that.destination)) return false;
            if (this.deliveryStreamName != null ? !this.deliveryStreamName.equals(that.deliveryStreamName) : that.deliveryStreamName != null) return false;
            if (this.encryption != null ? !this.encryption.equals(that.encryption) : that.encryption != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            return this.source != null ? this.source.equals(that.source) : that.source == null;
        }

        @Override
        public final int hashCode() {
            int result = this.destination.hashCode();
            result = 31 * result + (this.deliveryStreamName != null ? this.deliveryStreamName.hashCode() : 0);
            result = 31 * result + (this.encryption != null ? this.encryption.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
            return result;
        }
    }
}
