package software.amazon.awscdk.services.lambda;

/**
 * Code property for the DockerImageFunction construct.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * DockerImageFunction.Builder.create(this, "AssetFunction")
 *         .code(DockerImageCode.fromImageAsset(join(__dirname, "docker-handler")))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:38.411Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.DockerImageCode")
public abstract class DockerImageCode extends software.amazon.jsii.JsiiObject {

    protected DockerImageCode(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DockerImageCode(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected DockerImageCode() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Use an existing ECR image as the Lambda code.
     * <p>
     * @param repository the ECR repository that the image is in. This parameter is required.
     * @param props properties to further configure the selected image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.DockerImageCode fromEcr(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.IRepository repository, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.EcrImageCodeProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.DockerImageCode.class, "fromEcr", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.DockerImageCode.class), new Object[] { java.util.Objects.requireNonNull(repository, "repository is required"), props });
    }

    /**
     * Use an existing ECR image as the Lambda code.
     * <p>
     * @param repository the ECR repository that the image is in. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.DockerImageCode fromEcr(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.IRepository repository) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.DockerImageCode.class, "fromEcr", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.DockerImageCode.class), new Object[] { java.util.Objects.requireNonNull(repository, "repository is required") });
    }

    /**
     * Create an ECR image from the specified asset and bind it as the Lambda code.
     * <p>
     * @param directory the directory from which the asset must be created. This parameter is required.
     * @param props properties to further configure the selected image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.DockerImageCode fromImageAsset(final @org.jetbrains.annotations.NotNull java.lang.String directory, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.AssetImageCodeProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.DockerImageCode.class, "fromImageAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.DockerImageCode.class), new Object[] { java.util.Objects.requireNonNull(directory, "directory is required"), props });
    }

    /**
     * Create an ECR image from the specified asset and bind it as the Lambda code.
     * <p>
     * @param directory the directory from which the asset must be created. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.DockerImageCode fromImageAsset(final @org.jetbrains.annotations.NotNull java.lang.String directory) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.DockerImageCode.class, "fromImageAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.DockerImageCode.class), new Object[] { java.util.Objects.requireNonNull(directory, "directory is required") });
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.lambda.DockerImageCode {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
