package software.amazon.awscdk.services.logs;

/**
 * Properties for defining a <code>CfnIntegration</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.logs.*;
 * CfnIntegrationProps cfnIntegrationProps = CfnIntegrationProps.builder()
 *         .integrationName("integrationName")
 *         .integrationType("integrationType")
 *         .resourceConfig(ResourceConfigProperty.builder()
 *                 .openSearchResourceConfig(OpenSearchResourceConfigProperty.builder()
 *                         .dashboardViewerPrincipals(List.of("dashboardViewerPrincipals"))
 *                         .dataSourceRoleArn("dataSourceRoleArn")
 *                         // the properties below are optional
 *                         .applicationArn("applicationArn")
 *                         .kmsKeyArn("kmsKeyArn")
 *                         .retentionDays(123)
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-integration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-integration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:38.826Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CfnIntegrationProps")
@software.amazon.jsii.Jsii.Proxy(CfnIntegrationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnIntegrationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of this integration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-integration.html#cfn-logs-integration-integrationname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-integration.html#cfn-logs-integration-integrationname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIntegrationName();

    /**
     * The type of integration.
     * <p>
     * Integrations with OpenSearch Service have the type <code>OPENSEARCH</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-integration.html#cfn-logs-integration-integrationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-integration.html#cfn-logs-integration-integrationtype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIntegrationType();

    /**
     * This structure contains configuration details about an integration between CloudWatch Logs and another entity.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-integration.html#cfn-logs-integration-resourceconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-integration.html#cfn-logs-integration-resourceconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getResourceConfig();

    /**
     * @return a {@link Builder} of {@link CfnIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnIntegrationProps> {
        java.lang.String integrationName;
        java.lang.String integrationType;
        java.lang.Object resourceConfig;

        /**
         * Sets the value of {@link CfnIntegrationProps#getIntegrationName}
         * @param integrationName The name of this integration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationName(java.lang.String integrationName) {
            this.integrationName = integrationName;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationProps#getIntegrationType}
         * @param integrationType The type of integration. This parameter is required.
         *                        Integrations with OpenSearch Service have the type <code>OPENSEARCH</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationType(java.lang.String integrationType) {
            this.integrationType = integrationType;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationProps#getResourceConfig}
         * @param resourceConfig This structure contains configuration details about an integration between CloudWatch Logs and another entity. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceConfig(software.amazon.awscdk.IResolvable resourceConfig) {
            this.resourceConfig = resourceConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationProps#getResourceConfig}
         * @param resourceConfig This structure contains configuration details about an integration between CloudWatch Logs and another entity. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceConfig(software.amazon.awscdk.services.logs.CfnIntegration.ResourceConfigProperty resourceConfig) {
            this.resourceConfig = resourceConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnIntegrationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnIntegrationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnIntegrationProps {
        private final java.lang.String integrationName;
        private final java.lang.String integrationType;
        private final java.lang.Object resourceConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.integrationName = software.amazon.jsii.Kernel.get(this, "integrationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.integrationType = software.amazon.jsii.Kernel.get(this, "integrationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resourceConfig = software.amazon.jsii.Kernel.get(this, "resourceConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.integrationName = java.util.Objects.requireNonNull(builder.integrationName, "integrationName is required");
            this.integrationType = java.util.Objects.requireNonNull(builder.integrationType, "integrationType is required");
            this.resourceConfig = java.util.Objects.requireNonNull(builder.resourceConfig, "resourceConfig is required");
        }

        @Override
        public final java.lang.String getIntegrationName() {
            return this.integrationName;
        }

        @Override
        public final java.lang.String getIntegrationType() {
            return this.integrationType;
        }

        @Override
        public final java.lang.Object getResourceConfig() {
            return this.resourceConfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("integrationName", om.valueToTree(this.getIntegrationName()));
            data.set("integrationType", om.valueToTree(this.getIntegrationType()));
            data.set("resourceConfig", om.valueToTree(this.getResourceConfig()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CfnIntegrationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnIntegrationProps.Jsii$Proxy that = (CfnIntegrationProps.Jsii$Proxy) o;

            if (!integrationName.equals(that.integrationName)) return false;
            if (!integrationType.equals(that.integrationType)) return false;
            return this.resourceConfig.equals(that.resourceConfig);
        }

        @Override
        public final int hashCode() {
            int result = this.integrationName.hashCode();
            result = 31 * result + (this.integrationType.hashCode());
            result = 31 * result + (this.resourceConfig.hashCode());
            return result;
        }
    }
}
