package software.amazon.awscdk.services.logs;

/**
 * Properties for defining a <code>CfnSubscriptionFilter</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.logs.*;
 * CfnSubscriptionFilterProps cfnSubscriptionFilterProps = CfnSubscriptionFilterProps.builder()
 *         .destinationArn("destinationArn")
 *         .filterPattern("filterPattern")
 *         .logGroupName("logGroupName")
 *         // the properties below are optional
 *         .applyOnTransformedLogs(false)
 *         .distribution("distribution")
 *         .filterName("filterName")
 *         .roleArn("roleArn")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-subscriptionfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-subscriptionfilter.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:38.849Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CfnSubscriptionFilterProps")
@software.amazon.jsii.Jsii.Proxy(CfnSubscriptionFilterProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnSubscriptionFilterProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of the destination.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-subscriptionfilter.html#cfn-logs-subscriptionfilter-destinationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-subscriptionfilter.html#cfn-logs-subscriptionfilter-destinationarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDestinationArn();

    /**
     * The filtering expressions that restrict what gets delivered to the destination AWS resource.
     * <p>
     * For more information about the filter pattern syntax, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html">Filter and Pattern Syntax</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-subscriptionfilter.html#cfn-logs-subscriptionfilter-filterpattern">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-subscriptionfilter.html#cfn-logs-subscriptionfilter-filterpattern</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFilterPattern();

    /**
     * The log group to associate with the subscription filter.
     * <p>
     * All log events that are uploaded to this log group are filtered and delivered to the specified AWS resource if the filter pattern matches the log events.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-subscriptionfilter.html#cfn-logs-subscriptionfilter-loggroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-subscriptionfilter.html#cfn-logs-subscriptionfilter-loggroupname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLogGroupName();

    /**
     * This parameter is valid only for log groups that have an active log transformer.
     * <p>
     * For more information about log transformers, see <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutTransformer.html">PutTransformer</a> .
     * <p>
     * If this value is <code>true</code> , the subscription filter is applied on the transformed version of the log events instead of the original ingested log events.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-subscriptionfilter.html#cfn-logs-subscriptionfilter-applyontransformedlogs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-subscriptionfilter.html#cfn-logs-subscriptionfilter-applyontransformedlogs</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getApplyOnTransformedLogs() {
        return null;
    }

    /**
     * The method used to distribute log data to the destination, which can be either random or grouped by log stream.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-subscriptionfilter.html#cfn-logs-subscriptionfilter-distribution">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-subscriptionfilter.html#cfn-logs-subscriptionfilter-distribution</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDistribution() {
        return null;
    }

    /**
     * The name of the subscription filter.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-subscriptionfilter.html#cfn-logs-subscriptionfilter-filtername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-subscriptionfilter.html#cfn-logs-subscriptionfilter-filtername</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFilterName() {
        return null;
    }

    /**
     * The ARN of an IAM role that grants CloudWatch Logs permissions to deliver ingested log events to the destination stream.
     * <p>
     * You don't need to provide the ARN when you are working with a logical destination for cross-account delivery.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-subscriptionfilter.html#cfn-logs-subscriptionfilter-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-subscriptionfilter.html#cfn-logs-subscriptionfilter-rolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnSubscriptionFilterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSubscriptionFilterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnSubscriptionFilterProps> {
        java.lang.String destinationArn;
        java.lang.String filterPattern;
        java.lang.String logGroupName;
        java.lang.Object applyOnTransformedLogs;
        java.lang.String distribution;
        java.lang.String filterName;
        java.lang.String roleArn;

        /**
         * Sets the value of {@link CfnSubscriptionFilterProps#getDestinationArn}
         * @param destinationArn The Amazon Resource Name (ARN) of the destination. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationArn(java.lang.String destinationArn) {
            this.destinationArn = destinationArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriptionFilterProps#getFilterPattern}
         * @param filterPattern The filtering expressions that restrict what gets delivered to the destination AWS resource. This parameter is required.
         *                      For more information about the filter pattern syntax, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html">Filter and Pattern Syntax</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterPattern(java.lang.String filterPattern) {
            this.filterPattern = filterPattern;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriptionFilterProps#getLogGroupName}
         * @param logGroupName The log group to associate with the subscription filter. This parameter is required.
         *                     All log events that are uploaded to this log group are filtered and delivered to the specified AWS resource if the filter pattern matches the log events.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroupName(java.lang.String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriptionFilterProps#getApplyOnTransformedLogs}
         * @param applyOnTransformedLogs This parameter is valid only for log groups that have an active log transformer.
         *                               For more information about log transformers, see <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutTransformer.html">PutTransformer</a> .
         *                               <p>
         *                               If this value is <code>true</code> , the subscription filter is applied on the transformed version of the log events instead of the original ingested log events.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applyOnTransformedLogs(java.lang.Boolean applyOnTransformedLogs) {
            this.applyOnTransformedLogs = applyOnTransformedLogs;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriptionFilterProps#getApplyOnTransformedLogs}
         * @param applyOnTransformedLogs This parameter is valid only for log groups that have an active log transformer.
         *                               For more information about log transformers, see <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutTransformer.html">PutTransformer</a> .
         *                               <p>
         *                               If this value is <code>true</code> , the subscription filter is applied on the transformed version of the log events instead of the original ingested log events.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applyOnTransformedLogs(software.amazon.awscdk.IResolvable applyOnTransformedLogs) {
            this.applyOnTransformedLogs = applyOnTransformedLogs;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriptionFilterProps#getDistribution}
         * @param distribution The method used to distribute log data to the destination, which can be either random or grouped by log stream.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder distribution(java.lang.String distribution) {
            this.distribution = distribution;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriptionFilterProps#getFilterName}
         * @param filterName The name of the subscription filter.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterName(java.lang.String filterName) {
            this.filterName = filterName;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriptionFilterProps#getRoleArn}
         * @param roleArn The ARN of an IAM role that grants CloudWatch Logs permissions to deliver ingested log events to the destination stream.
         *                You don't need to provide the ARN when you are working with a logical destination for cross-account delivery.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSubscriptionFilterProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnSubscriptionFilterProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnSubscriptionFilterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSubscriptionFilterProps {
        private final java.lang.String destinationArn;
        private final java.lang.String filterPattern;
        private final java.lang.String logGroupName;
        private final java.lang.Object applyOnTransformedLogs;
        private final java.lang.String distribution;
        private final java.lang.String filterName;
        private final java.lang.String roleArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.destinationArn = software.amazon.jsii.Kernel.get(this, "destinationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.filterPattern = software.amazon.jsii.Kernel.get(this, "filterPattern", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.logGroupName = software.amazon.jsii.Kernel.get(this, "logGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.applyOnTransformedLogs = software.amazon.jsii.Kernel.get(this, "applyOnTransformedLogs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.distribution = software.amazon.jsii.Kernel.get(this, "distribution", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.filterName = software.amazon.jsii.Kernel.get(this, "filterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.destinationArn = java.util.Objects.requireNonNull(builder.destinationArn, "destinationArn is required");
            this.filterPattern = java.util.Objects.requireNonNull(builder.filterPattern, "filterPattern is required");
            this.logGroupName = java.util.Objects.requireNonNull(builder.logGroupName, "logGroupName is required");
            this.applyOnTransformedLogs = builder.applyOnTransformedLogs;
            this.distribution = builder.distribution;
            this.filterName = builder.filterName;
            this.roleArn = builder.roleArn;
        }

        @Override
        public final java.lang.String getDestinationArn() {
            return this.destinationArn;
        }

        @Override
        public final java.lang.String getFilterPattern() {
            return this.filterPattern;
        }

        @Override
        public final java.lang.String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public final java.lang.Object getApplyOnTransformedLogs() {
            return this.applyOnTransformedLogs;
        }

        @Override
        public final java.lang.String getDistribution() {
            return this.distribution;
        }

        @Override
        public final java.lang.String getFilterName() {
            return this.filterName;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("destinationArn", om.valueToTree(this.getDestinationArn()));
            data.set("filterPattern", om.valueToTree(this.getFilterPattern()));
            data.set("logGroupName", om.valueToTree(this.getLogGroupName()));
            if (this.getApplyOnTransformedLogs() != null) {
                data.set("applyOnTransformedLogs", om.valueToTree(this.getApplyOnTransformedLogs()));
            }
            if (this.getDistribution() != null) {
                data.set("distribution", om.valueToTree(this.getDistribution()));
            }
            if (this.getFilterName() != null) {
                data.set("filterName", om.valueToTree(this.getFilterName()));
            }
            if (this.getRoleArn() != null) {
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CfnSubscriptionFilterProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSubscriptionFilterProps.Jsii$Proxy that = (CfnSubscriptionFilterProps.Jsii$Proxy) o;

            if (!destinationArn.equals(that.destinationArn)) return false;
            if (!filterPattern.equals(that.filterPattern)) return false;
            if (!logGroupName.equals(that.logGroupName)) return false;
            if (this.applyOnTransformedLogs != null ? !this.applyOnTransformedLogs.equals(that.applyOnTransformedLogs) : that.applyOnTransformedLogs != null) return false;
            if (this.distribution != null ? !this.distribution.equals(that.distribution) : that.distribution != null) return false;
            if (this.filterName != null ? !this.filterName.equals(that.filterName) : that.filterName != null) return false;
            return this.roleArn != null ? this.roleArn.equals(that.roleArn) : that.roleArn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.destinationArn.hashCode();
            result = 31 * result + (this.filterPattern.hashCode());
            result = 31 * result + (this.logGroupName.hashCode());
            result = 31 * result + (this.applyOnTransformedLogs != null ? this.applyOnTransformedLogs.hashCode() : 0);
            result = 31 * result + (this.distribution != null ? this.distribution.hashCode() : 0);
            result = 31 * result + (this.filterName != null ? this.filterName.hashCode() : 0);
            result = 31 * result + (this.roleArn != null ? this.roleArn.hashCode() : 0);
            return result;
        }
    }
}
