package software.amazon.awscdk.services.mediaconnect;

/**
 * The <code>AWS::MediaConnect::FlowOutput</code> resource defines the destination address, protocol, and port that AWS Elemental MediaConnect sends the ingested video to.
 * <p>
 * Each flow can have up to 50 outputs. An output can have the same protocol or a different protocol from the source. The following protocols are supported: RIST, RTP, RTP-FEC, SRT-listener, SRT-caller, Zixi pull, and Zixi push. CDI and ST 2110 JPEG XS protocols are not currently supported by AWS CloudFormation.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.mediaconnect.*;
 * CfnFlowOutput cfnFlowOutput = CfnFlowOutput.Builder.create(this, "MyCfnFlowOutput")
 *         .flowArn("flowArn")
 *         .protocol("protocol")
 *         // the properties below are optional
 *         .cidrAllowList(List.of("cidrAllowList"))
 *         .description("description")
 *         .destination("destination")
 *         .encryption(EncryptionProperty.builder()
 *                 .roleArn("roleArn")
 *                 .secretArn("secretArn")
 *                 // the properties below are optional
 *                 .algorithm("algorithm")
 *                 .keyType("keyType")
 *                 .build())
 *         .maxLatency(123)
 *         .mediaStreamOutputConfigurations(List.of(MediaStreamOutputConfigurationProperty.builder()
 *                 .encodingName("encodingName")
 *                 .mediaStreamName("mediaStreamName")
 *                 // the properties below are optional
 *                 .destinationConfigurations(List.of(DestinationConfigurationProperty.builder()
 *                         .destinationIp("destinationIp")
 *                         .destinationPort(123)
 *                         .interface(InterfaceProperty.builder()
 *                                 .name("name")
 *                                 .build())
 *                         .build()))
 *                 .encodingParameters(EncodingParametersProperty.builder()
 *                         .compressionFactor(123)
 *                         // the properties below are optional
 *                         .encoderProfile("encoderProfile")
 *                         .build())
 *                 .build()))
 *         .minLatency(123)
 *         .name("name")
 *         .ndiProgramName("ndiProgramName")
 *         .ndiSpeedHqQuality(123)
 *         .outputStatus("outputStatus")
 *         .port(123)
 *         .remoteId("remoteId")
 *         .smoothingLatency(123)
 *         .streamId("streamId")
 *         .vpcInterfaceAttachment(VpcInterfaceAttachmentProperty.builder()
 *                 .vpcInterfaceName("vpcInterfaceName")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:39.184Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnFlowOutput")
public class CfnFlowOutput extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnFlowOutput(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFlowOutput(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.mediaconnect.CfnFlowOutput.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnFlowOutput(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.mediaconnect.CfnFlowOutputProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN of the output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrOutputArn() {
        return software.amazon.jsii.Kernel.get(this, "attrOutputArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The Amazon Resource Name (ARN) of the flow this output is attached to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFlowArn() {
        return software.amazon.jsii.Kernel.get(this, "flowArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the flow this output is attached to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFlowArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "flowArn", java.util.Objects.requireNonNull(value, "flowArn is required"));
    }

    /**
     * The protocol to use for the output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getProtocol() {
        return software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The protocol to use for the output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProtocol(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "protocol", java.util.Objects.requireNonNull(value, "protocol is required"));
    }

    /**
     * The range of IP addresses that should be allowed to initiate output requests to this flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCidrAllowList() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "cidrAllowList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The range of IP addresses that should be allowed to initiate output requests to this flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCidrAllowList(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "cidrAllowList", value);
    }

    /**
     * A description of the output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description of the output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The IP address where you want to send the output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDestination() {
        return software.amazon.jsii.Kernel.get(this, "destination", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IP address where you want to send the output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDestination(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "destination", value);
    }

    /**
     * The type of key used for the encryption.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEncryption() {
        return software.amazon.jsii.Kernel.get(this, "encryption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The type of key used for the encryption.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncryption(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "encryption", value);
    }

    /**
     * The type of key used for the encryption.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncryption(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.mediaconnect.CfnFlowOutput.EncryptionProperty value) {
        software.amazon.jsii.Kernel.set(this, "encryption", value);
    }

    /**
     * The maximum latency in milliseconds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMaxLatency() {
        return software.amazon.jsii.Kernel.get(this, "maxLatency", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The maximum latency in milliseconds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaxLatency(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "maxLatency", value);
    }

    /**
     * The media streams that are associated with the output, and the parameters for those associations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMediaStreamOutputConfigurations() {
        return software.amazon.jsii.Kernel.get(this, "mediaStreamOutputConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The media streams that are associated with the output, and the parameters for those associations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMediaStreamOutputConfigurations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "mediaStreamOutputConfigurations", value);
    }

    /**
     * The media streams that are associated with the output, and the parameters for those associations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMediaStreamOutputConfigurations(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.mediaconnect.CfnFlowOutput.MediaStreamOutputConfigurationProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.mediaconnect.CfnFlowOutput.MediaStreamOutputConfigurationProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "mediaStreamOutputConfigurations", value);
    }

    /**
     * The minimum latency in milliseconds for SRT-based streams.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMinLatency() {
        return software.amazon.jsii.Kernel.get(this, "minLatency", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The minimum latency in milliseconds for SRT-based streams.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMinLatency(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "minLatency", value);
    }

    /**
     * The name of the bridge's output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the bridge's output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * A suffix for the names of the NDI sources that the flow creates.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getNdiProgramName() {
        return software.amazon.jsii.Kernel.get(this, "ndiProgramName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A suffix for the names of the NDI sources that the flow creates.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNdiProgramName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "ndiProgramName", value);
    }

    /**
     * A quality setting for the NDI Speed HQ encoder.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getNdiSpeedHqQuality() {
        return software.amazon.jsii.Kernel.get(this, "ndiSpeedHqQuality", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * A quality setting for the NDI Speed HQ encoder.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNdiSpeedHqQuality(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "ndiSpeedHqQuality", value);
    }

    /**
     * An indication of whether the output should transmit data or not.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getOutputStatus() {
        return software.amazon.jsii.Kernel.get(this, "outputStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An indication of whether the output should transmit data or not.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOutputStatus(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "outputStatus", value);
    }

    /**
     * The port to use when content is distributed to this output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The port to use when content is distributed to this output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPort(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "port", value);
    }

    /**
     * The remote ID for the Zixi-pull stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRemoteId() {
        return software.amazon.jsii.Kernel.get(this, "remoteId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The remote ID for the Zixi-pull stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRemoteId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "remoteId", value);
    }

    /**
     * The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getSmoothingLatency() {
        return software.amazon.jsii.Kernel.get(this, "smoothingLatency", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSmoothingLatency(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "smoothingLatency", value);
    }

    /**
     * The stream ID that you want to use for this transport.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getStreamId() {
        return software.amazon.jsii.Kernel.get(this, "streamId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The stream ID that you want to use for this transport.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStreamId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "streamId", value);
    }

    /**
     * The name of the VPC interface attachment to use for this output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVpcInterfaceAttachment() {
        return software.amazon.jsii.Kernel.get(this, "vpcInterfaceAttachment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The name of the VPC interface attachment to use for this output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcInterfaceAttachment(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "vpcInterfaceAttachment", value);
    }

    /**
     * The name of the VPC interface attachment to use for this output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcInterfaceAttachment(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.mediaconnect.CfnFlowOutput.VpcInterfaceAttachmentProperty value) {
        software.amazon.jsii.Kernel.set(this, "vpcInterfaceAttachment", value);
    }
    /**
     * The transport parameters that you want to associate with an outbound media stream.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * DestinationConfigurationProperty destinationConfigurationProperty = DestinationConfigurationProperty.builder()
     *         .destinationIp("destinationIp")
     *         .destinationPort(123)
     *         .interface(InterfaceProperty.builder()
     *                 .name("name")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-destinationconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-destinationconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnFlowOutput.DestinationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DestinationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DestinationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The IP address where you want MediaConnect to send contents of the media stream.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-destinationconfiguration.html#cfn-mediaconnect-flowoutput-destinationconfiguration-destinationip">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-destinationconfiguration.html#cfn-mediaconnect-flowoutput-destinationconfiguration-destinationip</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDestinationIp();

        /**
         * The port that you want MediaConnect to use when it distributes the media stream to the output.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-destinationconfiguration.html#cfn-mediaconnect-flowoutput-destinationconfiguration-destinationport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-destinationconfiguration.html#cfn-mediaconnect-flowoutput-destinationconfiguration-destinationport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getDestinationPort();

        /**
         * The VPC interface that you want to use for the media stream associated with the output.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-destinationconfiguration.html#cfn-mediaconnect-flowoutput-destinationconfiguration-interface">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-destinationconfiguration.html#cfn-mediaconnect-flowoutput-destinationconfiguration-interface</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getInterfaceValue();

        /**
         * @return a {@link Builder} of {@link DestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DestinationConfigurationProperty> {
            java.lang.String destinationIp;
            java.lang.Number destinationPort;
            java.lang.Object interfaceValue;

            /**
             * Sets the value of {@link DestinationConfigurationProperty#getDestinationIp}
             * @param destinationIp The IP address where you want MediaConnect to send contents of the media stream. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationIp(java.lang.String destinationIp) {
                this.destinationIp = destinationIp;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConfigurationProperty#getDestinationPort}
             * @param destinationPort The port that you want MediaConnect to use when it distributes the media stream to the output. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationPort(java.lang.Number destinationPort) {
                this.destinationPort = destinationPort;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConfigurationProperty#getInterfaceValue}
             * @param interfaceValue The VPC interface that you want to use for the media stream associated with the output. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interfaceValue(software.amazon.awscdk.IResolvable interfaceValue) {
                this.interfaceValue = interfaceValue;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConfigurationProperty#getInterfaceValue}
             * @param interfaceValue The VPC interface that you want to use for the media stream associated with the output. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interfaceValue(software.amazon.awscdk.services.mediaconnect.CfnFlowOutput.InterfaceProperty interfaceValue) {
                this.interfaceValue = interfaceValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DestinationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DestinationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DestinationConfigurationProperty {
            private final java.lang.String destinationIp;
            private final java.lang.Number destinationPort;
            private final java.lang.Object interfaceValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destinationIp = software.amazon.jsii.Kernel.get(this, "destinationIp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.destinationPort = software.amazon.jsii.Kernel.get(this, "destinationPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.interfaceValue = software.amazon.jsii.Kernel.get(this, "interface", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinationIp = java.util.Objects.requireNonNull(builder.destinationIp, "destinationIp is required");
                this.destinationPort = java.util.Objects.requireNonNull(builder.destinationPort, "destinationPort is required");
                this.interfaceValue = java.util.Objects.requireNonNull(builder.interfaceValue, "interfaceValue is required");
            }

            @Override
            public final java.lang.String getDestinationIp() {
                return this.destinationIp;
            }

            @Override
            public final java.lang.Number getDestinationPort() {
                return this.destinationPort;
            }

            @Override
            public final java.lang.Object getInterfaceValue() {
                return this.interfaceValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("destinationIp", om.valueToTree(this.getDestinationIp()));
                data.set("destinationPort", om.valueToTree(this.getDestinationPort()));
                data.set("interface", om.valueToTree(this.getInterfaceValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnFlowOutput.DestinationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DestinationConfigurationProperty.Jsii$Proxy that = (DestinationConfigurationProperty.Jsii$Proxy) o;

                if (!destinationIp.equals(that.destinationIp)) return false;
                if (!destinationPort.equals(that.destinationPort)) return false;
                return this.interfaceValue.equals(that.interfaceValue);
            }

            @Override
            public final int hashCode() {
                int result = this.destinationIp.hashCode();
                result = 31 * result + (this.destinationPort.hashCode());
                result = 31 * result + (this.interfaceValue.hashCode());
                return result;
            }
        }
    }
    /**
     * A collection of parameters that determine how MediaConnect will convert the content.
     * <p>
     * These fields only apply to outputs on flows that have a CDI source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * EncodingParametersProperty encodingParametersProperty = EncodingParametersProperty.builder()
     *         .compressionFactor(123)
     *         // the properties below are optional
     *         .encoderProfile("encoderProfile")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-encodingparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-encodingparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnFlowOutput.EncodingParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(EncodingParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EncodingParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A value that is used to calculate compression for an output.
         * <p>
         * The bitrate of the output is calculated as follows: Output bitrate = (1 / compressionFactor) * (source bitrate) This property only applies to outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol. Valid values are floating point numbers in the range of 3.0 to 10.0, inclusive.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-encodingparameters.html#cfn-mediaconnect-flowoutput-encodingparameters-compressionfactor">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-encodingparameters.html#cfn-mediaconnect-flowoutput-encodingparameters-compressionfactor</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getCompressionFactor();

        /**
         * A setting on the encoder that drives compression settings.
         * <p>
         * This property only applies to video media streams associated with outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-encodingparameters.html#cfn-mediaconnect-flowoutput-encodingparameters-encoderprofile">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-encodingparameters.html#cfn-mediaconnect-flowoutput-encodingparameters-encoderprofile</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEncoderProfile() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EncodingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EncodingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EncodingParametersProperty> {
            java.lang.Number compressionFactor;
            java.lang.String encoderProfile;

            /**
             * Sets the value of {@link EncodingParametersProperty#getCompressionFactor}
             * @param compressionFactor A value that is used to calculate compression for an output. This parameter is required.
             *                          The bitrate of the output is calculated as follows: Output bitrate = (1 / compressionFactor) * (source bitrate) This property only applies to outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol. Valid values are floating point numbers in the range of 3.0 to 10.0, inclusive.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder compressionFactor(java.lang.Number compressionFactor) {
                this.compressionFactor = compressionFactor;
                return this;
            }

            /**
             * Sets the value of {@link EncodingParametersProperty#getEncoderProfile}
             * @param encoderProfile A setting on the encoder that drives compression settings.
             *                       This property only applies to video media streams associated with outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encoderProfile(java.lang.String encoderProfile) {
                this.encoderProfile = encoderProfile;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EncodingParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EncodingParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EncodingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EncodingParametersProperty {
            private final java.lang.Number compressionFactor;
            private final java.lang.String encoderProfile;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.compressionFactor = software.amazon.jsii.Kernel.get(this, "compressionFactor", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.encoderProfile = software.amazon.jsii.Kernel.get(this, "encoderProfile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.compressionFactor = java.util.Objects.requireNonNull(builder.compressionFactor, "compressionFactor is required");
                this.encoderProfile = builder.encoderProfile;
            }

            @Override
            public final java.lang.Number getCompressionFactor() {
                return this.compressionFactor;
            }

            @Override
            public final java.lang.String getEncoderProfile() {
                return this.encoderProfile;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("compressionFactor", om.valueToTree(this.getCompressionFactor()));
                if (this.getEncoderProfile() != null) {
                    data.set("encoderProfile", om.valueToTree(this.getEncoderProfile()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnFlowOutput.EncodingParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EncodingParametersProperty.Jsii$Proxy that = (EncodingParametersProperty.Jsii$Proxy) o;

                if (!compressionFactor.equals(that.compressionFactor)) return false;
                return this.encoderProfile != null ? this.encoderProfile.equals(that.encoderProfile) : that.encoderProfile == null;
            }

            @Override
            public final int hashCode() {
                int result = this.compressionFactor.hashCode();
                result = 31 * result + (this.encoderProfile != null ? this.encoderProfile.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about the encryption of the flow.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * EncryptionProperty encryptionProperty = EncryptionProperty.builder()
     *         .roleArn("roleArn")
     *         .secretArn("secretArn")
     *         // the properties below are optional
     *         .algorithm("algorithm")
     *         .keyType("keyType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-encryption.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-encryption.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnFlowOutput.EncryptionProperty")
    @software.amazon.jsii.Jsii.Proxy(EncryptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EncryptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the role that you created during setup (when you set up MediaConnect as a trusted entity).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-encryption.html#cfn-mediaconnect-flowoutput-encryption-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-encryption.html#cfn-mediaconnect-flowoutput-encryption-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * The ARN of the secret that you created in AWS Secrets Manager to store the encryption key.
         * <p>
         * This parameter is required for static key encryption and is not valid for SPEKE encryption.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-encryption.html#cfn-mediaconnect-flowoutput-encryption-secretarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-encryption.html#cfn-mediaconnect-flowoutput-encryption-secretarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSecretArn();

        /**
         * The type of algorithm that is used for static key encryption (such as aes128, aes192, or aes256).
         * <p>
         * If you are using SPEKE or SRT-password encryption, this property must be left blank.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-encryption.html#cfn-mediaconnect-flowoutput-encryption-algorithm">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-encryption.html#cfn-mediaconnect-flowoutput-encryption-algorithm</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAlgorithm() {
            return null;
        }

        /**
         * The type of key that is used for the encryption.
         * <p>
         * If you don't specify a <code>keyType</code> value, the service uses the default setting ( <code>static-key</code> ). Valid key types are: <code>static-key</code> , <code>speke</code> , and <code>srt-password</code> .
         * <p>
         * Default: - "static-key"
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-encryption.html#cfn-mediaconnect-flowoutput-encryption-keytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-encryption.html#cfn-mediaconnect-flowoutput-encryption-keytype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKeyType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EncryptionProperty> {
            java.lang.String roleArn;
            java.lang.String secretArn;
            java.lang.String algorithm;
            java.lang.String keyType;

            /**
             * Sets the value of {@link EncryptionProperty#getRoleArn}
             * @param roleArn The ARN of the role that you created during setup (when you set up MediaConnect as a trusted entity). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionProperty#getSecretArn}
             * @param secretArn The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required.
             *                  This parameter is required for static key encryption and is not valid for SPEKE encryption.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretArn(java.lang.String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionProperty#getAlgorithm}
             * @param algorithm The type of algorithm that is used for static key encryption (such as aes128, aes192, or aes256).
             *                  If you are using SPEKE or SRT-password encryption, this property must be left blank.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder algorithm(java.lang.String algorithm) {
                this.algorithm = algorithm;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionProperty#getKeyType}
             * @param keyType The type of key that is used for the encryption.
             *                If you don't specify a <code>keyType</code> value, the service uses the default setting ( <code>static-key</code> ). Valid key types are: <code>static-key</code> , <code>speke</code> , and <code>srt-password</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyType(java.lang.String keyType) {
                this.keyType = keyType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EncryptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EncryptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EncryptionProperty {
            private final java.lang.String roleArn;
            private final java.lang.String secretArn;
            private final java.lang.String algorithm;
            private final java.lang.String keyType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretArn = software.amazon.jsii.Kernel.get(this, "secretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.algorithm = software.amazon.jsii.Kernel.get(this, "algorithm", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.keyType = software.amazon.jsii.Kernel.get(this, "keyType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.secretArn = java.util.Objects.requireNonNull(builder.secretArn, "secretArn is required");
                this.algorithm = builder.algorithm;
                this.keyType = builder.keyType;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getSecretArn() {
                return this.secretArn;
            }

            @Override
            public final java.lang.String getAlgorithm() {
                return this.algorithm;
            }

            @Override
            public final java.lang.String getKeyType() {
                return this.keyType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                data.set("secretArn", om.valueToTree(this.getSecretArn()));
                if (this.getAlgorithm() != null) {
                    data.set("algorithm", om.valueToTree(this.getAlgorithm()));
                }
                if (this.getKeyType() != null) {
                    data.set("keyType", om.valueToTree(this.getKeyType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnFlowOutput.EncryptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EncryptionProperty.Jsii$Proxy that = (EncryptionProperty.Jsii$Proxy) o;

                if (!roleArn.equals(that.roleArn)) return false;
                if (!secretArn.equals(that.secretArn)) return false;
                if (this.algorithm != null ? !this.algorithm.equals(that.algorithm) : that.algorithm != null) return false;
                return this.keyType != null ? this.keyType.equals(that.keyType) : that.keyType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.roleArn.hashCode();
                result = 31 * result + (this.secretArn.hashCode());
                result = 31 * result + (this.algorithm != null ? this.algorithm.hashCode() : 0);
                result = 31 * result + (this.keyType != null ? this.keyType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The VPC interface that is used for the media stream associated with the source or output.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * InterfaceProperty interfaceProperty = InterfaceProperty.builder()
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-interface.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-interface.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnFlowOutput.InterfaceProperty")
    @software.amazon.jsii.Jsii.Proxy(InterfaceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InterfaceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the VPC interface.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-interface.html#cfn-mediaconnect-flowoutput-interface-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-interface.html#cfn-mediaconnect-flowoutput-interface-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * @return a {@link Builder} of {@link InterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InterfaceProperty> {
            java.lang.String name;

            /**
             * Sets the value of {@link InterfaceProperty#getName}
             * @param name The name of the VPC interface. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InterfaceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InterfaceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InterfaceProperty {
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnFlowOutput.InterfaceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InterfaceProperty.Jsii$Proxy that = (InterfaceProperty.Jsii$Proxy) o;

                return this.name.equals(that.name);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                return result;
            }
        }
    }
    /**
     * The media stream that is associated with the output, and the parameters for that association.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * MediaStreamOutputConfigurationProperty mediaStreamOutputConfigurationProperty = MediaStreamOutputConfigurationProperty.builder()
     *         .encodingName("encodingName")
     *         .mediaStreamName("mediaStreamName")
     *         // the properties below are optional
     *         .destinationConfigurations(List.of(DestinationConfigurationProperty.builder()
     *                 .destinationIp("destinationIp")
     *                 .destinationPort(123)
     *                 .interface(InterfaceProperty.builder()
     *                         .name("name")
     *                         .build())
     *                 .build()))
     *         .encodingParameters(EncodingParametersProperty.builder()
     *                 .compressionFactor(123)
     *                 // the properties below are optional
     *                 .encoderProfile("encoderProfile")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-mediastreamoutputconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-mediastreamoutputconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnFlowOutput.MediaStreamOutputConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(MediaStreamOutputConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MediaStreamOutputConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The format that was used to encode the data.
         * <p>
         * For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-mediastreamoutputconfiguration.html#cfn-mediaconnect-flowoutput-mediastreamoutputconfiguration-encodingname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-mediastreamoutputconfiguration.html#cfn-mediaconnect-flowoutput-mediastreamoutputconfiguration-encodingname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEncodingName();

        /**
         * The name of the media stream.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-mediastreamoutputconfiguration.html#cfn-mediaconnect-flowoutput-mediastreamoutputconfiguration-mediastreamname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-mediastreamoutputconfiguration.html#cfn-mediaconnect-flowoutput-mediastreamoutputconfiguration-mediastreamname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMediaStreamName();

        /**
         * The transport parameters that are associated with each outbound media stream.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-mediastreamoutputconfiguration.html#cfn-mediaconnect-flowoutput-mediastreamoutputconfiguration-destinationconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-mediastreamoutputconfiguration.html#cfn-mediaconnect-flowoutput-mediastreamoutputconfiguration-destinationconfigurations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDestinationConfigurations() {
            return null;
        }

        /**
         * A collection of parameters that determine how MediaConnect will convert the content.
         * <p>
         * These fields only apply to outputs on flows that have a CDI source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-mediastreamoutputconfiguration.html#cfn-mediaconnect-flowoutput-mediastreamoutputconfiguration-encodingparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-mediastreamoutputconfiguration.html#cfn-mediaconnect-flowoutput-mediastreamoutputconfiguration-encodingparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncodingParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MediaStreamOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MediaStreamOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MediaStreamOutputConfigurationProperty> {
            java.lang.String encodingName;
            java.lang.String mediaStreamName;
            java.lang.Object destinationConfigurations;
            java.lang.Object encodingParameters;

            /**
             * Sets the value of {@link MediaStreamOutputConfigurationProperty#getEncodingName}
             * @param encodingName The format that was used to encode the data. This parameter is required.
             *                     For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encodingName(java.lang.String encodingName) {
                this.encodingName = encodingName;
                return this;
            }

            /**
             * Sets the value of {@link MediaStreamOutputConfigurationProperty#getMediaStreamName}
             * @param mediaStreamName The name of the media stream. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mediaStreamName(java.lang.String mediaStreamName) {
                this.mediaStreamName = mediaStreamName;
                return this;
            }

            /**
             * Sets the value of {@link MediaStreamOutputConfigurationProperty#getDestinationConfigurations}
             * @param destinationConfigurations The transport parameters that are associated with each outbound media stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationConfigurations(software.amazon.awscdk.IResolvable destinationConfigurations) {
                this.destinationConfigurations = destinationConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link MediaStreamOutputConfigurationProperty#getDestinationConfigurations}
             * @param destinationConfigurations The transport parameters that are associated with each outbound media stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationConfigurations(java.util.List<? extends java.lang.Object> destinationConfigurations) {
                this.destinationConfigurations = destinationConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link MediaStreamOutputConfigurationProperty#getEncodingParameters}
             * @param encodingParameters A collection of parameters that determine how MediaConnect will convert the content.
             *                           These fields only apply to outputs on flows that have a CDI source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encodingParameters(software.amazon.awscdk.IResolvable encodingParameters) {
                this.encodingParameters = encodingParameters;
                return this;
            }

            /**
             * Sets the value of {@link MediaStreamOutputConfigurationProperty#getEncodingParameters}
             * @param encodingParameters A collection of parameters that determine how MediaConnect will convert the content.
             *                           These fields only apply to outputs on flows that have a CDI source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encodingParameters(software.amazon.awscdk.services.mediaconnect.CfnFlowOutput.EncodingParametersProperty encodingParameters) {
                this.encodingParameters = encodingParameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MediaStreamOutputConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MediaStreamOutputConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MediaStreamOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MediaStreamOutputConfigurationProperty {
            private final java.lang.String encodingName;
            private final java.lang.String mediaStreamName;
            private final java.lang.Object destinationConfigurations;
            private final java.lang.Object encodingParameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.encodingName = software.amazon.jsii.Kernel.get(this, "encodingName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mediaStreamName = software.amazon.jsii.Kernel.get(this, "mediaStreamName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.destinationConfigurations = software.amazon.jsii.Kernel.get(this, "destinationConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.encodingParameters = software.amazon.jsii.Kernel.get(this, "encodingParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.encodingName = java.util.Objects.requireNonNull(builder.encodingName, "encodingName is required");
                this.mediaStreamName = java.util.Objects.requireNonNull(builder.mediaStreamName, "mediaStreamName is required");
                this.destinationConfigurations = builder.destinationConfigurations;
                this.encodingParameters = builder.encodingParameters;
            }

            @Override
            public final java.lang.String getEncodingName() {
                return this.encodingName;
            }

            @Override
            public final java.lang.String getMediaStreamName() {
                return this.mediaStreamName;
            }

            @Override
            public final java.lang.Object getDestinationConfigurations() {
                return this.destinationConfigurations;
            }

            @Override
            public final java.lang.Object getEncodingParameters() {
                return this.encodingParameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("encodingName", om.valueToTree(this.getEncodingName()));
                data.set("mediaStreamName", om.valueToTree(this.getMediaStreamName()));
                if (this.getDestinationConfigurations() != null) {
                    data.set("destinationConfigurations", om.valueToTree(this.getDestinationConfigurations()));
                }
                if (this.getEncodingParameters() != null) {
                    data.set("encodingParameters", om.valueToTree(this.getEncodingParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnFlowOutput.MediaStreamOutputConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MediaStreamOutputConfigurationProperty.Jsii$Proxy that = (MediaStreamOutputConfigurationProperty.Jsii$Proxy) o;

                if (!encodingName.equals(that.encodingName)) return false;
                if (!mediaStreamName.equals(that.mediaStreamName)) return false;
                if (this.destinationConfigurations != null ? !this.destinationConfigurations.equals(that.destinationConfigurations) : that.destinationConfigurations != null) return false;
                return this.encodingParameters != null ? this.encodingParameters.equals(that.encodingParameters) : that.encodingParameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.encodingName.hashCode();
                result = 31 * result + (this.mediaStreamName.hashCode());
                result = 31 * result + (this.destinationConfigurations != null ? this.destinationConfigurations.hashCode() : 0);
                result = 31 * result + (this.encodingParameters != null ? this.encodingParameters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The settings for attaching a VPC interface to an resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * VpcInterfaceAttachmentProperty vpcInterfaceAttachmentProperty = VpcInterfaceAttachmentProperty.builder()
     *         .vpcInterfaceName("vpcInterfaceName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-vpcinterfaceattachment.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-vpcinterfaceattachment.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnFlowOutput.VpcInterfaceAttachmentProperty")
    @software.amazon.jsii.Jsii.Proxy(VpcInterfaceAttachmentProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VpcInterfaceAttachmentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the VPC interface to use for this resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-vpcinterfaceattachment.html#cfn-mediaconnect-flowoutput-vpcinterfaceattachment-vpcinterfacename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-vpcinterfaceattachment.html#cfn-mediaconnect-flowoutput-vpcinterfaceattachment-vpcinterfacename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVpcInterfaceName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VpcInterfaceAttachmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VpcInterfaceAttachmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VpcInterfaceAttachmentProperty> {
            java.lang.String vpcInterfaceName;

            /**
             * Sets the value of {@link VpcInterfaceAttachmentProperty#getVpcInterfaceName}
             * @param vpcInterfaceName The name of the VPC interface to use for this resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcInterfaceName(java.lang.String vpcInterfaceName) {
                this.vpcInterfaceName = vpcInterfaceName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VpcInterfaceAttachmentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VpcInterfaceAttachmentProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VpcInterfaceAttachmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcInterfaceAttachmentProperty {
            private final java.lang.String vpcInterfaceName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.vpcInterfaceName = software.amazon.jsii.Kernel.get(this, "vpcInterfaceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.vpcInterfaceName = builder.vpcInterfaceName;
            }

            @Override
            public final java.lang.String getVpcInterfaceName() {
                return this.vpcInterfaceName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getVpcInterfaceName() != null) {
                    data.set("vpcInterfaceName", om.valueToTree(this.getVpcInterfaceName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnFlowOutput.VpcInterfaceAttachmentProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VpcInterfaceAttachmentProperty.Jsii$Proxy that = (VpcInterfaceAttachmentProperty.Jsii$Proxy) o;

                return this.vpcInterfaceName != null ? this.vpcInterfaceName.equals(that.vpcInterfaceName) : that.vpcInterfaceName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.vpcInterfaceName != null ? this.vpcInterfaceName.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.mediaconnect.CfnFlowOutput}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.mediaconnect.CfnFlowOutput> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.mediaconnect.CfnFlowOutputProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.mediaconnect.CfnFlowOutputProps.Builder();
        }

        /**
         * The Amazon Resource Name (ARN) of the flow this output is attached to.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-flowarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-flowarn</a>
         * @param flowArn The Amazon Resource Name (ARN) of the flow this output is attached to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder flowArn(final java.lang.String flowArn) {
            this.props.flowArn(flowArn);
            return this;
        }

        /**
         * The protocol to use for the output.
         * <p>
         * <blockquote>
         * <p>
         * AWS Elemental MediaConnect no longer supports the Fujitsu QoS protocol. This reference is maintained for legacy purposes only.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-protocol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-protocol</a>
         * @param protocol The protocol to use for the output. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(final java.lang.String protocol) {
            this.props.protocol(protocol);
            return this;
        }

        /**
         * The range of IP addresses that should be allowed to initiate output requests to this flow.
         * <p>
         * These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-cidrallowlist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-cidrallowlist</a>
         * @param cidrAllowList The range of IP addresses that should be allowed to initiate output requests to this flow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cidrAllowList(final java.util.List<java.lang.String> cidrAllowList) {
            this.props.cidrAllowList(cidrAllowList);
            return this;
        }

        /**
         * A description of the output.
         * <p>
         * This description appears only on the MediaConnect console and will not be seen by the end user.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-description</a>
         * @param description A description of the output. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The IP address where you want to send the output.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-destination">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-destination</a>
         * @param destination The IP address where you want to send the output. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destination(final java.lang.String destination) {
            this.props.destination(destination);
            return this;
        }

        /**
         * The type of key used for the encryption.
         * <p>
         * If no <code>keyType</code> is provided, the service will use the default setting (static-key). Allowable encryption types: static-key.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-encryption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-encryption</a>
         * @param encryption The type of key used for the encryption. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryption(final software.amazon.awscdk.IResolvable encryption) {
            this.props.encryption(encryption);
            return this;
        }
        /**
         * The type of key used for the encryption.
         * <p>
         * If no <code>keyType</code> is provided, the service will use the default setting (static-key). Allowable encryption types: static-key.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-encryption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-encryption</a>
         * @param encryption The type of key used for the encryption. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryption(final software.amazon.awscdk.services.mediaconnect.CfnFlowOutput.EncryptionProperty encryption) {
            this.props.encryption(encryption);
            return this;
        }

        /**
         * The maximum latency in milliseconds.
         * <p>
         * This parameter applies only to RIST-based and Zixi-based streams.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-maxlatency">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-maxlatency</a>
         * @param maxLatency The maximum latency in milliseconds. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxLatency(final java.lang.Number maxLatency) {
            this.props.maxLatency(maxLatency);
            return this;
        }

        /**
         * The media streams that are associated with the output, and the parameters for those associations.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-mediastreamoutputconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-mediastreamoutputconfigurations</a>
         * @param mediaStreamOutputConfigurations The media streams that are associated with the output, and the parameters for those associations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mediaStreamOutputConfigurations(final software.amazon.awscdk.IResolvable mediaStreamOutputConfigurations) {
            this.props.mediaStreamOutputConfigurations(mediaStreamOutputConfigurations);
            return this;
        }
        /**
         * The media streams that are associated with the output, and the parameters for those associations.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-mediastreamoutputconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-mediastreamoutputconfigurations</a>
         * @param mediaStreamOutputConfigurations The media streams that are associated with the output, and the parameters for those associations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mediaStreamOutputConfigurations(final java.util.List<? extends java.lang.Object> mediaStreamOutputConfigurations) {
            this.props.mediaStreamOutputConfigurations(mediaStreamOutputConfigurations);
            return this;
        }

        /**
         * The minimum latency in milliseconds for SRT-based streams.
         * <p>
         * In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-minlatency">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-minlatency</a>
         * @param minLatency The minimum latency in milliseconds for SRT-based streams. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minLatency(final java.lang.Number minLatency) {
            this.props.minLatency(minLatency);
            return this;
        }

        /**
         * The name of the bridge's output.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-name</a>
         * @param name The name of the bridge's output. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * A suffix for the names of the NDI sources that the flow creates.
         * <p>
         * If a custom name isn't specified, MediaConnect uses the output name.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-ndiprogramname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-ndiprogramname</a>
         * @param ndiProgramName A suffix for the names of the NDI sources that the flow creates. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ndiProgramName(final java.lang.String ndiProgramName) {
            this.props.ndiProgramName(ndiProgramName);
            return this;
        }

        /**
         * A quality setting for the NDI Speed HQ encoder.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-ndispeedhqquality">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-ndispeedhqquality</a>
         * @param ndiSpeedHqQuality A quality setting for the NDI Speed HQ encoder. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ndiSpeedHqQuality(final java.lang.Number ndiSpeedHqQuality) {
            this.props.ndiSpeedHqQuality(ndiSpeedHqQuality);
            return this;
        }

        /**
         * An indication of whether the output should transmit data or not.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-outputstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-outputstatus</a>
         * @param outputStatus An indication of whether the output should transmit data or not. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputStatus(final java.lang.String outputStatus) {
            this.props.outputStatus(outputStatus);
            return this;
        }

        /**
         * The port to use when content is distributed to this output.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-port</a>
         * @param port The port to use when content is distributed to this output. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(final java.lang.Number port) {
            this.props.port(port);
            return this;
        }

        /**
         * The remote ID for the Zixi-pull stream.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-remoteid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-remoteid</a>
         * @param remoteId The remote ID for the Zixi-pull stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder remoteId(final java.lang.String remoteId) {
            this.props.remoteId(remoteId);
            return this;
        }

        /**
         * The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-smoothinglatency">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-smoothinglatency</a>
         * @param smoothingLatency The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder smoothingLatency(final java.lang.Number smoothingLatency) {
            this.props.smoothingLatency(smoothingLatency);
            return this;
        }

        /**
         * The stream ID that you want to use for this transport.
         * <p>
         * This parameter applies only to Zixi and SRT caller-based streams.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-streamid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-streamid</a>
         * @param streamId The stream ID that you want to use for this transport. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamId(final java.lang.String streamId) {
            this.props.streamId(streamId);
            return this;
        }

        /**
         * The name of the VPC interface attachment to use for this output.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-vpcinterfaceattachment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-vpcinterfaceattachment</a>
         * @param vpcInterfaceAttachment The name of the VPC interface attachment to use for this output. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcInterfaceAttachment(final software.amazon.awscdk.IResolvable vpcInterfaceAttachment) {
            this.props.vpcInterfaceAttachment(vpcInterfaceAttachment);
            return this;
        }
        /**
         * The name of the VPC interface attachment to use for this output.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-vpcinterfaceattachment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-vpcinterfaceattachment</a>
         * @param vpcInterfaceAttachment The name of the VPC interface attachment to use for this output. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcInterfaceAttachment(final software.amazon.awscdk.services.mediaconnect.CfnFlowOutput.VpcInterfaceAttachmentProperty vpcInterfaceAttachment) {
            this.props.vpcInterfaceAttachment(vpcInterfaceAttachment);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.mediaconnect.CfnFlowOutput}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.mediaconnect.CfnFlowOutput build() {
            return new software.amazon.awscdk.services.mediaconnect.CfnFlowOutput(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
