package software.amazon.awscdk.services.neptunegraph;

/**
 * The <code>AWS ::NeptuneGraph::Graph</code> resource creates an  graph.
 * <p>
 * is a memory-optimized graph database engine for analytics. For more information, see <a href="https://docs.aws.amazon.com/neptune-analytics/latest/userguide/what-is-neptune-analytics.html"></a> .
 * <p>
 * You can use <code>AWS ::NeptuneGraph::Graph.DeletionProtection</code> to help guard against unintended deletion of your graph.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.neptunegraph.*;
 * CfnGraph cfnGraph = CfnGraph.Builder.create(this, "MyCfnGraph")
 *         .provisionedMemory(123)
 *         // the properties below are optional
 *         .deletionProtection(false)
 *         .graphName("graphName")
 *         .publicConnectivity(false)
 *         .replicaCount(123)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .vectorSearchConfiguration(VectorSearchConfigurationProperty.builder()
 *                 .vectorSearchDimension(123)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptunegraph-graph.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptunegraph-graph.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:40.260Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_neptunegraph.CfnGraph")
public class CfnGraph extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnGraph(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnGraph(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.neptunegraph.CfnGraph.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnGraph(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.neptunegraph.CfnGraphProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The connection endpoint for the graph.
     * <p>
     * For example: <code>g-12a3bcdef4.us-east-1.neptune-graph.amazonaws.com</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "attrEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the graph.
     * <p>
     * For example: <code>arn:aws:neptune-graph:us-east-1:111122223333:graph/g-12a3bcdef4</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrGraphArn() {
        return software.amazon.jsii.Kernel.get(this, "attrGraphArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the graph.
     * <p>
     * For example: <code>g-12a3bcdef4</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrGraphId() {
        return software.amazon.jsii.Kernel.get(this, "attrGraphId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getProvisionedMemory() {
        return software.amazon.jsii.Kernel.get(this, "provisionedMemory", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProvisionedMemory(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "provisionedMemory", java.util.Objects.requireNonNull(value, "provisionedMemory is required"));
    }

    /**
     * A value that indicates whether the graph has deletion protection enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeletionProtection() {
        return software.amazon.jsii.Kernel.get(this, "deletionProtection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A value that indicates whether the graph has deletion protection enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeletionProtection(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "deletionProtection", value);
    }

    /**
     * A value that indicates whether the graph has deletion protection enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeletionProtection(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deletionProtection", value);
    }

    /**
     * The graph name.
     * <p>
     * For example: <code>my-graph-1</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getGraphName() {
        return software.amazon.jsii.Kernel.get(this, "graphName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The graph name.
     * <p>
     * For example: <code>my-graph-1</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGraphName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "graphName", value);
    }

    /**
     * Specifies whether or not the graph can be reachable over the internet.
     * <p>
     * All access to graphs is IAM authenticated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPublicConnectivity() {
        return software.amazon.jsii.Kernel.get(this, "publicConnectivity", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether or not the graph can be reachable over the internet.
     * <p>
     * All access to graphs is IAM authenticated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPublicConnectivity(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "publicConnectivity", value);
    }

    /**
     * Specifies whether or not the graph can be reachable over the internet.
     * <p>
     * All access to graphs is IAM authenticated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPublicConnectivity(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "publicConnectivity", value);
    }

    /**
     * The number of replicas in other AZs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getReplicaCount() {
        return software.amazon.jsii.Kernel.get(this, "replicaCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of replicas in other AZs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReplicaCount(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "replicaCount", value);
    }

    /**
     * Adds metadata tags to the new graph.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Adds metadata tags to the new graph.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }

    /**
     * Specifies the number of dimensions for vector embeddings that will be loaded into the graph.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVectorSearchConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "vectorSearchConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the number of dimensions for vector embeddings that will be loaded into the graph.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVectorSearchConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "vectorSearchConfiguration", value);
    }

    /**
     * Specifies the number of dimensions for vector embeddings that will be loaded into the graph.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVectorSearchConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.neptunegraph.CfnGraph.VectorSearchConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "vectorSearchConfiguration", value);
    }
    /**
     * The vector-search configuration for the graph, which specifies the vector dimension to use in the vector index, if any.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.neptunegraph.*;
     * VectorSearchConfigurationProperty vectorSearchConfigurationProperty = VectorSearchConfigurationProperty.builder()
     *         .vectorSearchDimension(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-neptunegraph-graph-vectorsearchconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-neptunegraph-graph-vectorsearchconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_neptunegraph.CfnGraph.VectorSearchConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(VectorSearchConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VectorSearchConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of dimensions.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-neptunegraph-graph-vectorsearchconfiguration.html#cfn-neptunegraph-graph-vectorsearchconfiguration-vectorsearchdimension">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-neptunegraph-graph-vectorsearchconfiguration.html#cfn-neptunegraph-graph-vectorsearchconfiguration-vectorsearchdimension</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getVectorSearchDimension();

        /**
         * @return a {@link Builder} of {@link VectorSearchConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VectorSearchConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VectorSearchConfigurationProperty> {
            java.lang.Number vectorSearchDimension;

            /**
             * Sets the value of {@link VectorSearchConfigurationProperty#getVectorSearchDimension}
             * @param vectorSearchDimension The number of dimensions. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vectorSearchDimension(java.lang.Number vectorSearchDimension) {
                this.vectorSearchDimension = vectorSearchDimension;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VectorSearchConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VectorSearchConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VectorSearchConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VectorSearchConfigurationProperty {
            private final java.lang.Number vectorSearchDimension;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.vectorSearchDimension = software.amazon.jsii.Kernel.get(this, "vectorSearchDimension", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.vectorSearchDimension = java.util.Objects.requireNonNull(builder.vectorSearchDimension, "vectorSearchDimension is required");
            }

            @Override
            public final java.lang.Number getVectorSearchDimension() {
                return this.vectorSearchDimension;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("vectorSearchDimension", om.valueToTree(this.getVectorSearchDimension()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_neptunegraph.CfnGraph.VectorSearchConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VectorSearchConfigurationProperty.Jsii$Proxy that = (VectorSearchConfigurationProperty.Jsii$Proxy) o;

                return this.vectorSearchDimension.equals(that.vectorSearchDimension);
            }

            @Override
            public final int hashCode() {
                int result = this.vectorSearchDimension.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.neptunegraph.CfnGraph}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.neptunegraph.CfnGraph> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.neptunegraph.CfnGraphProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.neptunegraph.CfnGraphProps.Builder();
        }

        /**
         * The provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph.
         * <p>
         * Min = 16
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptunegraph-graph.html#cfn-neptunegraph-graph-provisionedmemory">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptunegraph-graph.html#cfn-neptunegraph-graph-provisionedmemory</a>
         * @param provisionedMemory The provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisionedMemory(final java.lang.Number provisionedMemory) {
            this.props.provisionedMemory(provisionedMemory);
            return this;
        }

        /**
         * A value that indicates whether the graph has deletion protection enabled.
         * <p>
         * The graph can't be deleted when deletion protection is enabled.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptunegraph-graph.html#cfn-neptunegraph-graph-deletionprotection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptunegraph-graph.html#cfn-neptunegraph-graph-deletionprotection</a>
         * @param deletionProtection A value that indicates whether the graph has deletion protection enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(final java.lang.Boolean deletionProtection) {
            this.props.deletionProtection(deletionProtection);
            return this;
        }
        /**
         * A value that indicates whether the graph has deletion protection enabled.
         * <p>
         * The graph can't be deleted when deletion protection is enabled.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptunegraph-graph.html#cfn-neptunegraph-graph-deletionprotection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptunegraph-graph.html#cfn-neptunegraph-graph-deletionprotection</a>
         * @param deletionProtection A value that indicates whether the graph has deletion protection enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(final software.amazon.awscdk.IResolvable deletionProtection) {
            this.props.deletionProtection(deletionProtection);
            return this;
        }

        /**
         * The graph name. For example: <code>my-graph-1</code> .
         * <p>
         * The name must contain from 1 to 63 letters, numbers, or hyphens, and its first character must be a letter. It cannot end with a hyphen or contain two consecutive hyphens.
         * <p>
         * If you don't specify a graph name, a unique graph name is generated for you using the prefix <code>graph-for</code> , followed by a combination of <code>Stack Name</code> and a <code>UUID</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptunegraph-graph.html#cfn-neptunegraph-graph-graphname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptunegraph-graph.html#cfn-neptunegraph-graph-graphname</a>
         * @param graphName The graph name. For example: <code>my-graph-1</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder graphName(final java.lang.String graphName) {
            this.props.graphName(graphName);
            return this;
        }

        /**
         * Specifies whether or not the graph can be reachable over the internet. All access to graphs is IAM authenticated.
         * <p>
         * When the graph is publicly available, its domain name system (DNS) endpoint resolves to the public IP address from the internet. When the graph isn't publicly available, you need to create a <code>PrivateGraphEndpoint</code> in a given VPC to ensure the DNS name resolves to a private IP address that is reachable from the VPC.
         * <p>
         * Default: If not specified, the default value is false.
         * <p>
         * <blockquote>
         * <p>
         * If enabling public connectivity for the first time, there will be a delay while it is enabled.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptunegraph-graph.html#cfn-neptunegraph-graph-publicconnectivity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptunegraph-graph.html#cfn-neptunegraph-graph-publicconnectivity</a>
         * @param publicConnectivity Specifies whether or not the graph can be reachable over the internet. All access to graphs is IAM authenticated. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicConnectivity(final java.lang.Boolean publicConnectivity) {
            this.props.publicConnectivity(publicConnectivity);
            return this;
        }
        /**
         * Specifies whether or not the graph can be reachable over the internet. All access to graphs is IAM authenticated.
         * <p>
         * When the graph is publicly available, its domain name system (DNS) endpoint resolves to the public IP address from the internet. When the graph isn't publicly available, you need to create a <code>PrivateGraphEndpoint</code> in a given VPC to ensure the DNS name resolves to a private IP address that is reachable from the VPC.
         * <p>
         * Default: If not specified, the default value is false.
         * <p>
         * <blockquote>
         * <p>
         * If enabling public connectivity for the first time, there will be a delay while it is enabled.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptunegraph-graph.html#cfn-neptunegraph-graph-publicconnectivity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptunegraph-graph.html#cfn-neptunegraph-graph-publicconnectivity</a>
         * @param publicConnectivity Specifies whether or not the graph can be reachable over the internet. All access to graphs is IAM authenticated. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicConnectivity(final software.amazon.awscdk.IResolvable publicConnectivity) {
            this.props.publicConnectivity(publicConnectivity);
            return this;
        }

        /**
         * The number of replicas in other AZs.
         * <p>
         * Default: If not specified, the default value is 1.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptunegraph-graph.html#cfn-neptunegraph-graph-replicacount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptunegraph-graph.html#cfn-neptunegraph-graph-replicacount</a>
         * @param replicaCount The number of replicas in other AZs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicaCount(final java.lang.Number replicaCount) {
            this.props.replicaCount(replicaCount);
            return this;
        }

        /**
         * Adds metadata tags to the new graph.
         * <p>
         * These tags can also be used with cost allocation reporting, or used in a Condition statement in an IAM policy.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptunegraph-graph.html#cfn-neptunegraph-graph-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptunegraph-graph.html#cfn-neptunegraph-graph-tags</a>
         * @param tags Adds metadata tags to the new graph. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * Specifies the number of dimensions for vector embeddings that will be loaded into the graph.
         * <p>
         * The value is specified as <code>dimension=</code> value. Max = 65,535
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptunegraph-graph.html#cfn-neptunegraph-graph-vectorsearchconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptunegraph-graph.html#cfn-neptunegraph-graph-vectorsearchconfiguration</a>
         * @param vectorSearchConfiguration Specifies the number of dimensions for vector embeddings that will be loaded into the graph. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vectorSearchConfiguration(final software.amazon.awscdk.IResolvable vectorSearchConfiguration) {
            this.props.vectorSearchConfiguration(vectorSearchConfiguration);
            return this;
        }
        /**
         * Specifies the number of dimensions for vector embeddings that will be loaded into the graph.
         * <p>
         * The value is specified as <code>dimension=</code> value. Max = 65,535
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptunegraph-graph.html#cfn-neptunegraph-graph-vectorsearchconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptunegraph-graph.html#cfn-neptunegraph-graph-vectorsearchconfiguration</a>
         * @param vectorSearchConfiguration Specifies the number of dimensions for vector embeddings that will be loaded into the graph. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vectorSearchConfiguration(final software.amazon.awscdk.services.neptunegraph.CfnGraph.VectorSearchConfigurationProperty vectorSearchConfiguration) {
            this.props.vectorSearchConfiguration(vectorSearchConfiguration);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.neptunegraph.CfnGraph}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.neptunegraph.CfnGraph build() {
            return new software.amazon.awscdk.services.neptunegraph.CfnGraph(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
