package software.amazon.awscdk.services.networkfirewall;

/**
 * Properties for defining a <code>CfnTLSInspectionConfiguration</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.networkfirewall.*;
 * CfnTLSInspectionConfigurationProps cfnTLSInspectionConfigurationProps = CfnTLSInspectionConfigurationProps.builder()
 *         .tlsInspectionConfiguration(TLSInspectionConfigurationProperty.builder()
 *                 .serverCertificateConfigurations(List.of(ServerCertificateConfigurationProperty.builder()
 *                         .certificateAuthorityArn("certificateAuthorityArn")
 *                         .checkCertificateRevocationStatus(CheckCertificateRevocationStatusProperty.builder()
 *                                 .revokedStatusAction("revokedStatusAction")
 *                                 .unknownStatusAction("unknownStatusAction")
 *                                 .build())
 *                         .scopes(List.of(ServerCertificateScopeProperty.builder()
 *                                 .destinationPorts(List.of(PortRangeProperty.builder()
 *                                         .fromPort(123)
 *                                         .toPort(123)
 *                                         .build()))
 *                                 .destinations(List.of(AddressProperty.builder()
 *                                         .addressDefinition("addressDefinition")
 *                                         .build()))
 *                                 .protocols(List.of(123))
 *                                 .sourcePorts(List.of(PortRangeProperty.builder()
 *                                         .fromPort(123)
 *                                         .toPort(123)
 *                                         .build()))
 *                                 .sources(List.of(AddressProperty.builder()
 *                                         .addressDefinition("addressDefinition")
 *                                         .build()))
 *                                 .build()))
 *                         .serverCertificates(List.of(ServerCertificateProperty.builder()
 *                                 .resourceArn("resourceArn")
 *                                 .build()))
 *                         .build()))
 *                 .build())
 *         .tlsInspectionConfigurationName("tlsInspectionConfigurationName")
 *         // the properties below are optional
 *         .description("description")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-tlsinspectionconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-tlsinspectionconfiguration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:40.386Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnTLSInspectionConfigurationProps")
@software.amazon.jsii.Jsii.Proxy(CfnTLSInspectionConfigurationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTLSInspectionConfigurationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The object that defines a TLS inspection configuration.
     * <p>
     * AWS Network Firewall uses TLS inspection configurations to decrypt your firewall's inbound and outbound SSL/TLS traffic. After decryption, AWS Network Firewall inspects the traffic according to your firewall policy's stateful rules, and then re-encrypts it before sending it to its destination. You can enable inspection of your firewall's inbound traffic, outbound traffic, or both. To use TLS inspection with your firewall, you must first import or provision certificates using AWS Certificate Manager , create a TLS inspection configuration, add that configuration to a new firewall policy, and then associate that policy with your firewall. For more information about using TLS inspection configurations, see <a href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection.html">Inspecting SSL/TLS traffic with TLS inspection configurations</a> in the <em>AWS Network Firewall Developer Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-tlsinspectionconfiguration.html#cfn-networkfirewall-tlsinspectionconfiguration-tlsinspectionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-tlsinspectionconfiguration.html#cfn-networkfirewall-tlsinspectionconfiguration-tlsinspectionconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getTlsInspectionConfiguration();

    /**
     * The descriptive name of the TLS inspection configuration.
     * <p>
     * You can't change the name of a TLS inspection configuration after you create it.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-tlsinspectionconfiguration.html#cfn-networkfirewall-tlsinspectionconfiguration-tlsinspectionconfigurationname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-tlsinspectionconfiguration.html#cfn-networkfirewall-tlsinspectionconfiguration-tlsinspectionconfigurationname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTlsInspectionConfigurationName();

    /**
     * A description of the TLS inspection configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-tlsinspectionconfiguration.html#cfn-networkfirewall-tlsinspectionconfiguration-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-tlsinspectionconfiguration.html#cfn-networkfirewall-tlsinspectionconfiguration-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The key:value pairs to associate with the resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-tlsinspectionconfiguration.html#cfn-networkfirewall-tlsinspectionconfiguration-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-tlsinspectionconfiguration.html#cfn-networkfirewall-tlsinspectionconfiguration-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnTLSInspectionConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTLSInspectionConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTLSInspectionConfigurationProps> {
        java.lang.Object tlsInspectionConfiguration;
        java.lang.String tlsInspectionConfigurationName;
        java.lang.String description;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnTLSInspectionConfigurationProps#getTlsInspectionConfiguration}
         * @param tlsInspectionConfiguration The object that defines a TLS inspection configuration. This parameter is required.
         *                                   AWS Network Firewall uses TLS inspection configurations to decrypt your firewall's inbound and outbound SSL/TLS traffic. After decryption, AWS Network Firewall inspects the traffic according to your firewall policy's stateful rules, and then re-encrypts it before sending it to its destination. You can enable inspection of your firewall's inbound traffic, outbound traffic, or both. To use TLS inspection with your firewall, you must first import or provision certificates using AWS Certificate Manager , create a TLS inspection configuration, add that configuration to a new firewall policy, and then associate that policy with your firewall. For more information about using TLS inspection configurations, see <a href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection.html">Inspecting SSL/TLS traffic with TLS inspection configurations</a> in the <em>AWS Network Firewall Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tlsInspectionConfiguration(software.amazon.awscdk.IResolvable tlsInspectionConfiguration) {
            this.tlsInspectionConfiguration = tlsInspectionConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnTLSInspectionConfigurationProps#getTlsInspectionConfiguration}
         * @param tlsInspectionConfiguration The object that defines a TLS inspection configuration. This parameter is required.
         *                                   AWS Network Firewall uses TLS inspection configurations to decrypt your firewall's inbound and outbound SSL/TLS traffic. After decryption, AWS Network Firewall inspects the traffic according to your firewall policy's stateful rules, and then re-encrypts it before sending it to its destination. You can enable inspection of your firewall's inbound traffic, outbound traffic, or both. To use TLS inspection with your firewall, you must first import or provision certificates using AWS Certificate Manager , create a TLS inspection configuration, add that configuration to a new firewall policy, and then associate that policy with your firewall. For more information about using TLS inspection configurations, see <a href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection.html">Inspecting SSL/TLS traffic with TLS inspection configurations</a> in the <em>AWS Network Firewall Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tlsInspectionConfiguration(software.amazon.awscdk.services.networkfirewall.CfnTLSInspectionConfiguration.TLSInspectionConfigurationProperty tlsInspectionConfiguration) {
            this.tlsInspectionConfiguration = tlsInspectionConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnTLSInspectionConfigurationProps#getTlsInspectionConfigurationName}
         * @param tlsInspectionConfigurationName The descriptive name of the TLS inspection configuration. This parameter is required.
         *                                       You can't change the name of a TLS inspection configuration after you create it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tlsInspectionConfigurationName(java.lang.String tlsInspectionConfigurationName) {
            this.tlsInspectionConfigurationName = tlsInspectionConfigurationName;
            return this;
        }

        /**
         * Sets the value of {@link CfnTLSInspectionConfigurationProps#getDescription}
         * @param description A description of the TLS inspection configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnTLSInspectionConfigurationProps#getTags}
         * @param tags The key:value pairs to associate with the resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTLSInspectionConfigurationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTLSInspectionConfigurationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTLSInspectionConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTLSInspectionConfigurationProps {
        private final java.lang.Object tlsInspectionConfiguration;
        private final java.lang.String tlsInspectionConfigurationName;
        private final java.lang.String description;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.tlsInspectionConfiguration = software.amazon.jsii.Kernel.get(this, "tlsInspectionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tlsInspectionConfigurationName = software.amazon.jsii.Kernel.get(this, "tlsInspectionConfigurationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.tlsInspectionConfiguration = java.util.Objects.requireNonNull(builder.tlsInspectionConfiguration, "tlsInspectionConfiguration is required");
            this.tlsInspectionConfigurationName = java.util.Objects.requireNonNull(builder.tlsInspectionConfigurationName, "tlsInspectionConfigurationName is required");
            this.description = builder.description;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getTlsInspectionConfiguration() {
            return this.tlsInspectionConfiguration;
        }

        @Override
        public final java.lang.String getTlsInspectionConfigurationName() {
            return this.tlsInspectionConfigurationName;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("tlsInspectionConfiguration", om.valueToTree(this.getTlsInspectionConfiguration()));
            data.set("tlsInspectionConfigurationName", om.valueToTree(this.getTlsInspectionConfigurationName()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnTLSInspectionConfigurationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTLSInspectionConfigurationProps.Jsii$Proxy that = (CfnTLSInspectionConfigurationProps.Jsii$Proxy) o;

            if (!tlsInspectionConfiguration.equals(that.tlsInspectionConfiguration)) return false;
            if (!tlsInspectionConfigurationName.equals(that.tlsInspectionConfigurationName)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.tlsInspectionConfiguration.hashCode();
            result = 31 * result + (this.tlsInspectionConfigurationName.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
