package software.amazon.awscdk.services.odb;

/**
 * Properties for defining a <code>CfnCloudAutonomousVmCluster</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.odb.*;
 * CfnCloudAutonomousVmClusterProps cfnCloudAutonomousVmClusterProps = CfnCloudAutonomousVmClusterProps.builder()
 *         .autonomousDataStorageSizeInTBs(123)
 *         .cloudExadataInfrastructureId("cloudExadataInfrastructureId")
 *         .cpuCoreCountPerNode(123)
 *         .dbServers(List.of("dbServers"))
 *         .description("description")
 *         .displayName("displayName")
 *         .isMtlsEnabledVmCluster(false)
 *         .licenseModel("licenseModel")
 *         .maintenanceWindow(MaintenanceWindowProperty.builder()
 *                 .daysOfWeek(List.of("daysOfWeek"))
 *                 .hoursOfDay(List.of(123))
 *                 .leadTimeInWeeks(123)
 *                 .months(List.of("months"))
 *                 .preference("preference")
 *                 .weeksOfMonth(List.of(123))
 *                 .build())
 *         .memoryPerOracleComputeUnitInGBs(123)
 *         .odbNetworkId("odbNetworkId")
 *         .scanListenerPortNonTls(123)
 *         .scanListenerPortTls(123)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .timeZone("timeZone")
 *         .totalContainerDatabases(123)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:40.623Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_odb.CfnCloudAutonomousVmClusterProps")
@software.amazon.jsii.Jsii.Proxy(CfnCloudAutonomousVmClusterProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCloudAutonomousVmClusterProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The data storage size allocated for Autonomous Databases in the Autonomous VM cluster, in TB.
     * <p>
     * Required when creating an Autonomous VM cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-autonomousdatastoragesizeintbs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-autonomousdatastoragesizeintbs</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getAutonomousDataStorageSizeInTBs() {
        return null;
    }

    /**
     * The unique identifier of the Cloud Exadata Infrastructure containing this Autonomous VM cluster.
     * <p>
     * Required when creating an Autonomous VM cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-cloudexadatainfrastructureid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-cloudexadatainfrastructureid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCloudExadataInfrastructureId() {
        return null;
    }

    /**
     * The number of CPU cores enabled per node in the Autonomous VM cluster.
     * <p>
     * Required when creating an Autonomous VM cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-cpucorecountpernode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-cpucorecountpernode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getCpuCoreCountPerNode() {
        return null;
    }

    /**
     * The list of database servers associated with the Autonomous VM cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-dbservers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-dbservers</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDbServers() {
        return null;
    }

    /**
     * The user-provided description of the Autonomous VM cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The display name of the Autonomous VM cluster.
     * <p>
     * Required when creating an Autonomous VM cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-displayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-displayname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDisplayName() {
        return null;
    }

    /**
     * Specifies whether mutual TLS (mTLS) authentication is enabled for the Autonomous VM cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-ismtlsenabledvmcluster">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-ismtlsenabledvmcluster</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIsMtlsEnabledVmCluster() {
        return null;
    }

    /**
     * The Oracle license model that applies to the Autonomous VM cluster.
     * <p>
     * Valid values are <code>LICENSE_INCLUDED</code> or <code>BRING_YOUR_OWN_LICENSE</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-licensemodel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-licensemodel</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLicenseModel() {
        return null;
    }

    /**
     * The scheduling details for the maintenance window.
     * <p>
     * Patching and system updates take place during the maintenance window.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-maintenancewindow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-maintenancewindow</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMaintenanceWindow() {
        return null;
    }

    /**
     * The amount of memory allocated per Oracle Compute Unit, in GB.
     * <p>
     * Required when creating an Autonomous VM cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-memoryperoraclecomputeunitingbs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-memoryperoraclecomputeunitingbs</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMemoryPerOracleComputeUnitInGBs() {
        return null;
    }

    /**
     * The unique identifier of the ODB network associated with this Autonomous VM cluster.
     * <p>
     * Required when creating an Autonomous VM cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-odbnetworkid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-odbnetworkid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOdbNetworkId() {
        return null;
    }

    /**
     * The SCAN listener port for non-TLS (TCP) protocol.
     * <p>
     * The default is 1521.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-scanlistenerportnontls">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-scanlistenerportnontls</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getScanListenerPortNonTls() {
        return null;
    }

    /**
     * The SCAN listener port for TLS (TCP) protocol.
     * <p>
     * The default is 2484.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-scanlistenerporttls">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-scanlistenerporttls</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getScanListenerPortTls() {
        return null;
    }

    /**
     * Tags to assign to the Autonomous Vm Cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The time zone of the Autonomous VM cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-timezone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-timezone</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTimeZone() {
        return null;
    }

    /**
     * The total number of Autonomous Container Databases that can be created with the allocated local storage.
     * <p>
     * Required when creating an Autonomous VM cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-totalcontainerdatabases">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-totalcontainerdatabases</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getTotalContainerDatabases() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnCloudAutonomousVmClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCloudAutonomousVmClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCloudAutonomousVmClusterProps> {
        java.lang.Number autonomousDataStorageSizeInTBs;
        java.lang.String cloudExadataInfrastructureId;
        java.lang.Number cpuCoreCountPerNode;
        java.util.List<java.lang.String> dbServers;
        java.lang.String description;
        java.lang.String displayName;
        java.lang.Object isMtlsEnabledVmCluster;
        java.lang.String licenseModel;
        java.lang.Object maintenanceWindow;
        java.lang.Number memoryPerOracleComputeUnitInGBs;
        java.lang.String odbNetworkId;
        java.lang.Number scanListenerPortNonTls;
        java.lang.Number scanListenerPortTls;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String timeZone;
        java.lang.Number totalContainerDatabases;

        /**
         * Sets the value of {@link CfnCloudAutonomousVmClusterProps#getAutonomousDataStorageSizeInTBs}
         * @param autonomousDataStorageSizeInTBs The data storage size allocated for Autonomous Databases in the Autonomous VM cluster, in TB.
         *                                       Required when creating an Autonomous VM cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autonomousDataStorageSizeInTBs(java.lang.Number autonomousDataStorageSizeInTBs) {
            this.autonomousDataStorageSizeInTBs = autonomousDataStorageSizeInTBs;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudAutonomousVmClusterProps#getCloudExadataInfrastructureId}
         * @param cloudExadataInfrastructureId The unique identifier of the Cloud Exadata Infrastructure containing this Autonomous VM cluster.
         *                                     Required when creating an Autonomous VM cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudExadataInfrastructureId(java.lang.String cloudExadataInfrastructureId) {
            this.cloudExadataInfrastructureId = cloudExadataInfrastructureId;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudAutonomousVmClusterProps#getCpuCoreCountPerNode}
         * @param cpuCoreCountPerNode The number of CPU cores enabled per node in the Autonomous VM cluster.
         *                            Required when creating an Autonomous VM cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpuCoreCountPerNode(java.lang.Number cpuCoreCountPerNode) {
            this.cpuCoreCountPerNode = cpuCoreCountPerNode;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudAutonomousVmClusterProps#getDbServers}
         * @param dbServers The list of database servers associated with the Autonomous VM cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbServers(java.util.List<java.lang.String> dbServers) {
            this.dbServers = dbServers;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudAutonomousVmClusterProps#getDescription}
         * @param description The user-provided description of the Autonomous VM cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudAutonomousVmClusterProps#getDisplayName}
         * @param displayName The display name of the Autonomous VM cluster.
         *                    Required when creating an Autonomous VM cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudAutonomousVmClusterProps#getIsMtlsEnabledVmCluster}
         * @param isMtlsEnabledVmCluster Specifies whether mutual TLS (mTLS) authentication is enabled for the Autonomous VM cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isMtlsEnabledVmCluster(java.lang.Boolean isMtlsEnabledVmCluster) {
            this.isMtlsEnabledVmCluster = isMtlsEnabledVmCluster;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudAutonomousVmClusterProps#getIsMtlsEnabledVmCluster}
         * @param isMtlsEnabledVmCluster Specifies whether mutual TLS (mTLS) authentication is enabled for the Autonomous VM cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isMtlsEnabledVmCluster(software.amazon.awscdk.IResolvable isMtlsEnabledVmCluster) {
            this.isMtlsEnabledVmCluster = isMtlsEnabledVmCluster;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudAutonomousVmClusterProps#getLicenseModel}
         * @param licenseModel The Oracle license model that applies to the Autonomous VM cluster.
         *                     Valid values are <code>LICENSE_INCLUDED</code> or <code>BRING_YOUR_OWN_LICENSE</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder licenseModel(java.lang.String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudAutonomousVmClusterProps#getMaintenanceWindow}
         * @param maintenanceWindow The scheduling details for the maintenance window.
         *                          Patching and system updates take place during the maintenance window.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maintenanceWindow(software.amazon.awscdk.IResolvable maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudAutonomousVmClusterProps#getMaintenanceWindow}
         * @param maintenanceWindow The scheduling details for the maintenance window.
         *                          Patching and system updates take place during the maintenance window.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maintenanceWindow(software.amazon.awscdk.services.odb.CfnCloudAutonomousVmCluster.MaintenanceWindowProperty maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudAutonomousVmClusterProps#getMemoryPerOracleComputeUnitInGBs}
         * @param memoryPerOracleComputeUnitInGBs The amount of memory allocated per Oracle Compute Unit, in GB.
         *                                        Required when creating an Autonomous VM cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memoryPerOracleComputeUnitInGBs(java.lang.Number memoryPerOracleComputeUnitInGBs) {
            this.memoryPerOracleComputeUnitInGBs = memoryPerOracleComputeUnitInGBs;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudAutonomousVmClusterProps#getOdbNetworkId}
         * @param odbNetworkId The unique identifier of the ODB network associated with this Autonomous VM cluster.
         *                     Required when creating an Autonomous VM cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder odbNetworkId(java.lang.String odbNetworkId) {
            this.odbNetworkId = odbNetworkId;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudAutonomousVmClusterProps#getScanListenerPortNonTls}
         * @param scanListenerPortNonTls The SCAN listener port for non-TLS (TCP) protocol.
         *                               The default is 1521.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scanListenerPortNonTls(java.lang.Number scanListenerPortNonTls) {
            this.scanListenerPortNonTls = scanListenerPortNonTls;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudAutonomousVmClusterProps#getScanListenerPortTls}
         * @param scanListenerPortTls The SCAN listener port for TLS (TCP) protocol.
         *                            The default is 2484.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scanListenerPortTls(java.lang.Number scanListenerPortTls) {
            this.scanListenerPortTls = scanListenerPortTls;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudAutonomousVmClusterProps#getTags}
         * @param tags Tags to assign to the Autonomous Vm Cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudAutonomousVmClusterProps#getTimeZone}
         * @param timeZone The time zone of the Autonomous VM cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeZone(java.lang.String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudAutonomousVmClusterProps#getTotalContainerDatabases}
         * @param totalContainerDatabases The total number of Autonomous Container Databases that can be created with the allocated local storage.
         *                                Required when creating an Autonomous VM cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder totalContainerDatabases(java.lang.Number totalContainerDatabases) {
            this.totalContainerDatabases = totalContainerDatabases;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCloudAutonomousVmClusterProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCloudAutonomousVmClusterProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnCloudAutonomousVmClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCloudAutonomousVmClusterProps {
        private final java.lang.Number autonomousDataStorageSizeInTBs;
        private final java.lang.String cloudExadataInfrastructureId;
        private final java.lang.Number cpuCoreCountPerNode;
        private final java.util.List<java.lang.String> dbServers;
        private final java.lang.String description;
        private final java.lang.String displayName;
        private final java.lang.Object isMtlsEnabledVmCluster;
        private final java.lang.String licenseModel;
        private final java.lang.Object maintenanceWindow;
        private final java.lang.Number memoryPerOracleComputeUnitInGBs;
        private final java.lang.String odbNetworkId;
        private final java.lang.Number scanListenerPortNonTls;
        private final java.lang.Number scanListenerPortTls;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String timeZone;
        private final java.lang.Number totalContainerDatabases;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.autonomousDataStorageSizeInTBs = software.amazon.jsii.Kernel.get(this, "autonomousDataStorageSizeInTBs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.cloudExadataInfrastructureId = software.amazon.jsii.Kernel.get(this, "cloudExadataInfrastructureId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cpuCoreCountPerNode = software.amazon.jsii.Kernel.get(this, "cpuCoreCountPerNode", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.dbServers = software.amazon.jsii.Kernel.get(this, "dbServers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.displayName = software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.isMtlsEnabledVmCluster = software.amazon.jsii.Kernel.get(this, "isMtlsEnabledVmCluster", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.licenseModel = software.amazon.jsii.Kernel.get(this, "licenseModel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maintenanceWindow = software.amazon.jsii.Kernel.get(this, "maintenanceWindow", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.memoryPerOracleComputeUnitInGBs = software.amazon.jsii.Kernel.get(this, "memoryPerOracleComputeUnitInGBs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.odbNetworkId = software.amazon.jsii.Kernel.get(this, "odbNetworkId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scanListenerPortNonTls = software.amazon.jsii.Kernel.get(this, "scanListenerPortNonTls", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.scanListenerPortTls = software.amazon.jsii.Kernel.get(this, "scanListenerPortTls", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.timeZone = software.amazon.jsii.Kernel.get(this, "timeZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.totalContainerDatabases = software.amazon.jsii.Kernel.get(this, "totalContainerDatabases", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.autonomousDataStorageSizeInTBs = builder.autonomousDataStorageSizeInTBs;
            this.cloudExadataInfrastructureId = builder.cloudExadataInfrastructureId;
            this.cpuCoreCountPerNode = builder.cpuCoreCountPerNode;
            this.dbServers = builder.dbServers;
            this.description = builder.description;
            this.displayName = builder.displayName;
            this.isMtlsEnabledVmCluster = builder.isMtlsEnabledVmCluster;
            this.licenseModel = builder.licenseModel;
            this.maintenanceWindow = builder.maintenanceWindow;
            this.memoryPerOracleComputeUnitInGBs = builder.memoryPerOracleComputeUnitInGBs;
            this.odbNetworkId = builder.odbNetworkId;
            this.scanListenerPortNonTls = builder.scanListenerPortNonTls;
            this.scanListenerPortTls = builder.scanListenerPortTls;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.timeZone = builder.timeZone;
            this.totalContainerDatabases = builder.totalContainerDatabases;
        }

        @Override
        public final java.lang.Number getAutonomousDataStorageSizeInTBs() {
            return this.autonomousDataStorageSizeInTBs;
        }

        @Override
        public final java.lang.String getCloudExadataInfrastructureId() {
            return this.cloudExadataInfrastructureId;
        }

        @Override
        public final java.lang.Number getCpuCoreCountPerNode() {
            return this.cpuCoreCountPerNode;
        }

        @Override
        public final java.util.List<java.lang.String> getDbServers() {
            return this.dbServers;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final java.lang.Object getIsMtlsEnabledVmCluster() {
            return this.isMtlsEnabledVmCluster;
        }

        @Override
        public final java.lang.String getLicenseModel() {
            return this.licenseModel;
        }

        @Override
        public final java.lang.Object getMaintenanceWindow() {
            return this.maintenanceWindow;
        }

        @Override
        public final java.lang.Number getMemoryPerOracleComputeUnitInGBs() {
            return this.memoryPerOracleComputeUnitInGBs;
        }

        @Override
        public final java.lang.String getOdbNetworkId() {
            return this.odbNetworkId;
        }

        @Override
        public final java.lang.Number getScanListenerPortNonTls() {
            return this.scanListenerPortNonTls;
        }

        @Override
        public final java.lang.Number getScanListenerPortTls() {
            return this.scanListenerPortTls;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getTimeZone() {
            return this.timeZone;
        }

        @Override
        public final java.lang.Number getTotalContainerDatabases() {
            return this.totalContainerDatabases;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAutonomousDataStorageSizeInTBs() != null) {
                data.set("autonomousDataStorageSizeInTBs", om.valueToTree(this.getAutonomousDataStorageSizeInTBs()));
            }
            if (this.getCloudExadataInfrastructureId() != null) {
                data.set("cloudExadataInfrastructureId", om.valueToTree(this.getCloudExadataInfrastructureId()));
            }
            if (this.getCpuCoreCountPerNode() != null) {
                data.set("cpuCoreCountPerNode", om.valueToTree(this.getCpuCoreCountPerNode()));
            }
            if (this.getDbServers() != null) {
                data.set("dbServers", om.valueToTree(this.getDbServers()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDisplayName() != null) {
                data.set("displayName", om.valueToTree(this.getDisplayName()));
            }
            if (this.getIsMtlsEnabledVmCluster() != null) {
                data.set("isMtlsEnabledVmCluster", om.valueToTree(this.getIsMtlsEnabledVmCluster()));
            }
            if (this.getLicenseModel() != null) {
                data.set("licenseModel", om.valueToTree(this.getLicenseModel()));
            }
            if (this.getMaintenanceWindow() != null) {
                data.set("maintenanceWindow", om.valueToTree(this.getMaintenanceWindow()));
            }
            if (this.getMemoryPerOracleComputeUnitInGBs() != null) {
                data.set("memoryPerOracleComputeUnitInGBs", om.valueToTree(this.getMemoryPerOracleComputeUnitInGBs()));
            }
            if (this.getOdbNetworkId() != null) {
                data.set("odbNetworkId", om.valueToTree(this.getOdbNetworkId()));
            }
            if (this.getScanListenerPortNonTls() != null) {
                data.set("scanListenerPortNonTls", om.valueToTree(this.getScanListenerPortNonTls()));
            }
            if (this.getScanListenerPortTls() != null) {
                data.set("scanListenerPortTls", om.valueToTree(this.getScanListenerPortTls()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTimeZone() != null) {
                data.set("timeZone", om.valueToTree(this.getTimeZone()));
            }
            if (this.getTotalContainerDatabases() != null) {
                data.set("totalContainerDatabases", om.valueToTree(this.getTotalContainerDatabases()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_odb.CfnCloudAutonomousVmClusterProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCloudAutonomousVmClusterProps.Jsii$Proxy that = (CfnCloudAutonomousVmClusterProps.Jsii$Proxy) o;

            if (this.autonomousDataStorageSizeInTBs != null ? !this.autonomousDataStorageSizeInTBs.equals(that.autonomousDataStorageSizeInTBs) : that.autonomousDataStorageSizeInTBs != null) return false;
            if (this.cloudExadataInfrastructureId != null ? !this.cloudExadataInfrastructureId.equals(that.cloudExadataInfrastructureId) : that.cloudExadataInfrastructureId != null) return false;
            if (this.cpuCoreCountPerNode != null ? !this.cpuCoreCountPerNode.equals(that.cpuCoreCountPerNode) : that.cpuCoreCountPerNode != null) return false;
            if (this.dbServers != null ? !this.dbServers.equals(that.dbServers) : that.dbServers != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.displayName != null ? !this.displayName.equals(that.displayName) : that.displayName != null) return false;
            if (this.isMtlsEnabledVmCluster != null ? !this.isMtlsEnabledVmCluster.equals(that.isMtlsEnabledVmCluster) : that.isMtlsEnabledVmCluster != null) return false;
            if (this.licenseModel != null ? !this.licenseModel.equals(that.licenseModel) : that.licenseModel != null) return false;
            if (this.maintenanceWindow != null ? !this.maintenanceWindow.equals(that.maintenanceWindow) : that.maintenanceWindow != null) return false;
            if (this.memoryPerOracleComputeUnitInGBs != null ? !this.memoryPerOracleComputeUnitInGBs.equals(that.memoryPerOracleComputeUnitInGBs) : that.memoryPerOracleComputeUnitInGBs != null) return false;
            if (this.odbNetworkId != null ? !this.odbNetworkId.equals(that.odbNetworkId) : that.odbNetworkId != null) return false;
            if (this.scanListenerPortNonTls != null ? !this.scanListenerPortNonTls.equals(that.scanListenerPortNonTls) : that.scanListenerPortNonTls != null) return false;
            if (this.scanListenerPortTls != null ? !this.scanListenerPortTls.equals(that.scanListenerPortTls) : that.scanListenerPortTls != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.timeZone != null ? !this.timeZone.equals(that.timeZone) : that.timeZone != null) return false;
            return this.totalContainerDatabases != null ? this.totalContainerDatabases.equals(that.totalContainerDatabases) : that.totalContainerDatabases == null;
        }

        @Override
        public final int hashCode() {
            int result = this.autonomousDataStorageSizeInTBs != null ? this.autonomousDataStorageSizeInTBs.hashCode() : 0;
            result = 31 * result + (this.cloudExadataInfrastructureId != null ? this.cloudExadataInfrastructureId.hashCode() : 0);
            result = 31 * result + (this.cpuCoreCountPerNode != null ? this.cpuCoreCountPerNode.hashCode() : 0);
            result = 31 * result + (this.dbServers != null ? this.dbServers.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.displayName != null ? this.displayName.hashCode() : 0);
            result = 31 * result + (this.isMtlsEnabledVmCluster != null ? this.isMtlsEnabledVmCluster.hashCode() : 0);
            result = 31 * result + (this.licenseModel != null ? this.licenseModel.hashCode() : 0);
            result = 31 * result + (this.maintenanceWindow != null ? this.maintenanceWindow.hashCode() : 0);
            result = 31 * result + (this.memoryPerOracleComputeUnitInGBs != null ? this.memoryPerOracleComputeUnitInGBs.hashCode() : 0);
            result = 31 * result + (this.odbNetworkId != null ? this.odbNetworkId.hashCode() : 0);
            result = 31 * result + (this.scanListenerPortNonTls != null ? this.scanListenerPortNonTls.hashCode() : 0);
            result = 31 * result + (this.scanListenerPortTls != null ? this.scanListenerPortTls.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.timeZone != null ? this.timeZone.hashCode() : 0);
            result = 31 * result + (this.totalContainerDatabases != null ? this.totalContainerDatabases.hashCode() : 0);
            return result;
        }
    }
}
