package software.amazon.awscdk.services.opensearchservice;

/**
 * NodeType is a string enum of the node types in OpenSearch domain.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.opensearchservice.*;
 * Domain domain = Domain.Builder.create(this, "Domain")
 *         .version(EngineVersion.OPENSEARCH_1_3)
 *         .capacity(CapacityConfig.builder()
 *                 .nodeOptions(List.of(NodeOptions.builder()
 *                         .nodeType(NodeType.COORDINATOR)
 *                         .nodeConfig(NodeConfig.builder()
 *                                 .enabled(true)
 *                                 .count(2)
 *                                 .type("m5.large.search")
 *                                 .build())
 *                         .build()))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:40.758Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opensearchservice.NodeType")
public enum NodeType {
    /**
     * Coordinator node type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COORDINATOR,
}
