package software.amazon.awscdk.services.personalize;

/**
 * Properties for defining a <code>CfnSolution</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.personalize.*;
 * Object autoMlConfig;
 * Object hpoConfig;
 * CfnSolutionProps cfnSolutionProps = CfnSolutionProps.builder()
 *         .datasetGroupArn("datasetGroupArn")
 *         .name("name")
 *         // the properties below are optional
 *         .eventType("eventType")
 *         .performAutoMl(false)
 *         .performHpo(false)
 *         .recipeArn("recipeArn")
 *         .solutionConfig(SolutionConfigProperty.builder()
 *                 .algorithmHyperParameters(Map.of(
 *                         "algorithmHyperParametersKey", "algorithmHyperParameters"))
 *                 .autoMlConfig(autoMlConfig)
 *                 .eventValueThreshold("eventValueThreshold")
 *                 .featureTransformationParameters(Map.of(
 *                         "featureTransformationParametersKey", "featureTransformationParameters"))
 *                 .hpoConfig(hpoConfig)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-solution.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-solution.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:40.965Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_personalize.CfnSolutionProps")
@software.amazon.jsii.Jsii.Proxy(CfnSolutionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnSolutionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of the dataset group that provides the training data.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-solution.html#cfn-personalize-solution-datasetgrouparn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-solution.html#cfn-personalize-solution-datasetgrouparn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDatasetGroupArn();

    /**
     * The name of the solution.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-solution.html#cfn-personalize-solution-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-solution.html#cfn-personalize-solution-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The event type (for example, 'click' or 'like') that is used for training the model.
     * <p>
     * If no <code>eventType</code> is provided, Amazon Personalize uses all interactions for training with equal weight regardless of type.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-solution.html#cfn-personalize-solution-eventtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-solution.html#cfn-personalize-solution-eventtype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEventType() {
        return null;
    }

    /**
     * <blockquote><p>We don't recommend enabling automated machine learning.<p></blockquote>
     * <p>
     * Instead, match your use case to the available Amazon Personalize recipes. For more information, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/determining-use-case.html">Determining your use case.</a>
     * <p>
     * When true, Amazon Personalize performs a search for the best USER_PERSONALIZATION recipe from the list specified in the solution configuration ( <code>recipeArn</code> must not be specified). When false (the default), Amazon Personalize uses <code>recipeArn</code> for training.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-solution.html#cfn-personalize-solution-performautoml">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-solution.html#cfn-personalize-solution-performautoml</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPerformAutoMl() {
        return null;
    }

    /**
     * Whether to perform hyperparameter optimization (HPO) on the chosen recipe.
     * <p>
     * The default is <code>false</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-solution.html#cfn-personalize-solution-performhpo">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-solution.html#cfn-personalize-solution-performhpo</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPerformHpo() {
        return null;
    }

    /**
     * The ARN of the recipe used to create the solution.
     * <p>
     * This is required when <code>performAutoML</code> is false.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-solution.html#cfn-personalize-solution-recipearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-solution.html#cfn-personalize-solution-recipearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRecipeArn() {
        return null;
    }

    /**
     * Describes the configuration properties for the solution.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-solution.html#cfn-personalize-solution-solutionconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-solution.html#cfn-personalize-solution-solutionconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSolutionConfig() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnSolutionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSolutionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnSolutionProps> {
        java.lang.String datasetGroupArn;
        java.lang.String name;
        java.lang.String eventType;
        java.lang.Object performAutoMl;
        java.lang.Object performHpo;
        java.lang.String recipeArn;
        java.lang.Object solutionConfig;

        /**
         * Sets the value of {@link CfnSolutionProps#getDatasetGroupArn}
         * @param datasetGroupArn The Amazon Resource Name (ARN) of the dataset group that provides the training data. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datasetGroupArn(java.lang.String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnSolutionProps#getName}
         * @param name The name of the solution. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnSolutionProps#getEventType}
         * @param eventType The event type (for example, 'click' or 'like') that is used for training the model.
         *                  If no <code>eventType</code> is provided, Amazon Personalize uses all interactions for training with equal weight regardless of type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventType(java.lang.String eventType) {
            this.eventType = eventType;
            return this;
        }

        /**
         * Sets the value of {@link CfnSolutionProps#getPerformAutoMl}
         * @param performAutoMl <blockquote><p>We don't recommend enabling automated machine learning.<p></blockquote>
         *                      Instead, match your use case to the available Amazon Personalize recipes. For more information, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/determining-use-case.html">Determining your use case.</a>
         *                      <p>
         *                      When true, Amazon Personalize performs a search for the best USER_PERSONALIZATION recipe from the list specified in the solution configuration ( <code>recipeArn</code> must not be specified). When false (the default), Amazon Personalize uses <code>recipeArn</code> for training.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder performAutoMl(java.lang.Boolean performAutoMl) {
            this.performAutoMl = performAutoMl;
            return this;
        }

        /**
         * Sets the value of {@link CfnSolutionProps#getPerformAutoMl}
         * @param performAutoMl <blockquote><p>We don't recommend enabling automated machine learning.<p></blockquote>
         *                      Instead, match your use case to the available Amazon Personalize recipes. For more information, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/determining-use-case.html">Determining your use case.</a>
         *                      <p>
         *                      When true, Amazon Personalize performs a search for the best USER_PERSONALIZATION recipe from the list specified in the solution configuration ( <code>recipeArn</code> must not be specified). When false (the default), Amazon Personalize uses <code>recipeArn</code> for training.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder performAutoMl(software.amazon.awscdk.IResolvable performAutoMl) {
            this.performAutoMl = performAutoMl;
            return this;
        }

        /**
         * Sets the value of {@link CfnSolutionProps#getPerformHpo}
         * @param performHpo Whether to perform hyperparameter optimization (HPO) on the chosen recipe.
         *                   The default is <code>false</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder performHpo(java.lang.Boolean performHpo) {
            this.performHpo = performHpo;
            return this;
        }

        /**
         * Sets the value of {@link CfnSolutionProps#getPerformHpo}
         * @param performHpo Whether to perform hyperparameter optimization (HPO) on the chosen recipe.
         *                   The default is <code>false</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder performHpo(software.amazon.awscdk.IResolvable performHpo) {
            this.performHpo = performHpo;
            return this;
        }

        /**
         * Sets the value of {@link CfnSolutionProps#getRecipeArn}
         * @param recipeArn The ARN of the recipe used to create the solution.
         *                  This is required when <code>performAutoML</code> is false.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recipeArn(java.lang.String recipeArn) {
            this.recipeArn = recipeArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnSolutionProps#getSolutionConfig}
         * @param solutionConfig Describes the configuration properties for the solution.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder solutionConfig(software.amazon.awscdk.IResolvable solutionConfig) {
            this.solutionConfig = solutionConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnSolutionProps#getSolutionConfig}
         * @param solutionConfig Describes the configuration properties for the solution.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder solutionConfig(software.amazon.awscdk.services.personalize.CfnSolution.SolutionConfigProperty solutionConfig) {
            this.solutionConfig = solutionConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSolutionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnSolutionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnSolutionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSolutionProps {
        private final java.lang.String datasetGroupArn;
        private final java.lang.String name;
        private final java.lang.String eventType;
        private final java.lang.Object performAutoMl;
        private final java.lang.Object performHpo;
        private final java.lang.String recipeArn;
        private final java.lang.Object solutionConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.datasetGroupArn = software.amazon.jsii.Kernel.get(this, "datasetGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.eventType = software.amazon.jsii.Kernel.get(this, "eventType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.performAutoMl = software.amazon.jsii.Kernel.get(this, "performAutoMl", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.performHpo = software.amazon.jsii.Kernel.get(this, "performHpo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.recipeArn = software.amazon.jsii.Kernel.get(this, "recipeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.solutionConfig = software.amazon.jsii.Kernel.get(this, "solutionConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.datasetGroupArn = java.util.Objects.requireNonNull(builder.datasetGroupArn, "datasetGroupArn is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.eventType = builder.eventType;
            this.performAutoMl = builder.performAutoMl;
            this.performHpo = builder.performHpo;
            this.recipeArn = builder.recipeArn;
            this.solutionConfig = builder.solutionConfig;
        }

        @Override
        public final java.lang.String getDatasetGroupArn() {
            return this.datasetGroupArn;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getEventType() {
            return this.eventType;
        }

        @Override
        public final java.lang.Object getPerformAutoMl() {
            return this.performAutoMl;
        }

        @Override
        public final java.lang.Object getPerformHpo() {
            return this.performHpo;
        }

        @Override
        public final java.lang.String getRecipeArn() {
            return this.recipeArn;
        }

        @Override
        public final java.lang.Object getSolutionConfig() {
            return this.solutionConfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("datasetGroupArn", om.valueToTree(this.getDatasetGroupArn()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getEventType() != null) {
                data.set("eventType", om.valueToTree(this.getEventType()));
            }
            if (this.getPerformAutoMl() != null) {
                data.set("performAutoMl", om.valueToTree(this.getPerformAutoMl()));
            }
            if (this.getPerformHpo() != null) {
                data.set("performHpo", om.valueToTree(this.getPerformHpo()));
            }
            if (this.getRecipeArn() != null) {
                data.set("recipeArn", om.valueToTree(this.getRecipeArn()));
            }
            if (this.getSolutionConfig() != null) {
                data.set("solutionConfig", om.valueToTree(this.getSolutionConfig()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_personalize.CfnSolutionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSolutionProps.Jsii$Proxy that = (CfnSolutionProps.Jsii$Proxy) o;

            if (!datasetGroupArn.equals(that.datasetGroupArn)) return false;
            if (!name.equals(that.name)) return false;
            if (this.eventType != null ? !this.eventType.equals(that.eventType) : that.eventType != null) return false;
            if (this.performAutoMl != null ? !this.performAutoMl.equals(that.performAutoMl) : that.performAutoMl != null) return false;
            if (this.performHpo != null ? !this.performHpo.equals(that.performHpo) : that.performHpo != null) return false;
            if (this.recipeArn != null ? !this.recipeArn.equals(that.recipeArn) : that.recipeArn != null) return false;
            return this.solutionConfig != null ? this.solutionConfig.equals(that.solutionConfig) : that.solutionConfig == null;
        }

        @Override
        public final int hashCode() {
            int result = this.datasetGroupArn.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.eventType != null ? this.eventType.hashCode() : 0);
            result = 31 * result + (this.performAutoMl != null ? this.performAutoMl.hashCode() : 0);
            result = 31 * result + (this.performHpo != null ? this.performHpo.hashCode() : 0);
            result = 31 * result + (this.recipeArn != null ? this.recipeArn.hashCode() : 0);
            result = 31 * result + (this.solutionConfig != null ? this.solutionConfig.hashCode() : 0);
            return result;
        }
    }
}
