package software.amazon.awscdk.services.pinpoint;

/**
 * Properties for defining a <code>CfnAPNSChannel</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.pinpoint.*;
 * CfnAPNSChannelProps cfnAPNSChannelProps = CfnAPNSChannelProps.builder()
 *         .applicationId("applicationId")
 *         // the properties below are optional
 *         .bundleId("bundleId")
 *         .certificate("certificate")
 *         .defaultAuthenticationMethod("defaultAuthenticationMethod")
 *         .enabled(false)
 *         .privateKey("privateKey")
 *         .teamId("teamId")
 *         .tokenKey("tokenKey")
 *         .tokenKeyId("tokenKeyId")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:40.968Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnAPNSChannelProps")
@software.amazon.jsii.Jsii.Proxy(CfnAPNSChannelProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAPNSChannelProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The unique identifier for the Amazon Pinpoint application that the APNs channel applies to.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-applicationid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-applicationid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApplicationId();

    /**
     * The bundle identifier that's assigned to your iOS app.
     * <p>
     * This identifier is used for APNs tokens.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-bundleid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-bundleid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBundleId() {
        return null;
    }

    /**
     * The APNs client certificate that you received from Apple.
     * <p>
     * Specify this value if you want Amazon Pinpoint to communicate with APNs by using an APNs certificate.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-certificate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-certificate</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCertificate() {
        return null;
    }

    /**
     * The default authentication method that you want Amazon Pinpoint to use when authenticating with APNs.
     * <p>
     * Valid options are <code>key</code> or <code>certificate</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-defaultauthenticationmethod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-defaultauthenticationmethod</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDefaultAuthenticationMethod() {
        return null;
    }

    /**
     * Specifies whether to enable the APNs channel for the application.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-enabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
        return null;
    }

    /**
     * The private key for the APNs client certificate that you want Amazon Pinpoint to use to communicate with APNs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-privatekey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-privatekey</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPrivateKey() {
        return null;
    }

    /**
     * The identifier that's assigned to your Apple Developer Account team.
     * <p>
     * This identifier is used for APNs tokens.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-teamid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-teamid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTeamId() {
        return null;
    }

    /**
     * The authentication key to use for APNs tokens.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-tokenkey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-tokenkey</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTokenKey() {
        return null;
    }

    /**
     * The key identifier that's assigned to your APNs signing key.
     * <p>
     * Specify this value if you want Amazon Pinpoint to communicate with APNs by using APNs tokens.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-tokenkeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-tokenkeyid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTokenKeyId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAPNSChannelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAPNSChannelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAPNSChannelProps> {
        java.lang.String applicationId;
        java.lang.String bundleId;
        java.lang.String certificate;
        java.lang.String defaultAuthenticationMethod;
        java.lang.Object enabled;
        java.lang.String privateKey;
        java.lang.String teamId;
        java.lang.String tokenKey;
        java.lang.String tokenKeyId;

        /**
         * Sets the value of {@link CfnAPNSChannelProps#getApplicationId}
         * @param applicationId The unique identifier for the Amazon Pinpoint application that the APNs channel applies to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationId(java.lang.String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        /**
         * Sets the value of {@link CfnAPNSChannelProps#getBundleId}
         * @param bundleId The bundle identifier that's assigned to your iOS app.
         *                 This identifier is used for APNs tokens.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bundleId(java.lang.String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        /**
         * Sets the value of {@link CfnAPNSChannelProps#getCertificate}
         * @param certificate The APNs client certificate that you received from Apple.
         *                    Specify this value if you want Amazon Pinpoint to communicate with APNs by using an APNs certificate.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificate(java.lang.String certificate) {
            this.certificate = certificate;
            return this;
        }

        /**
         * Sets the value of {@link CfnAPNSChannelProps#getDefaultAuthenticationMethod}
         * @param defaultAuthenticationMethod The default authentication method that you want Amazon Pinpoint to use when authenticating with APNs.
         *                                    Valid options are <code>key</code> or <code>certificate</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultAuthenticationMethod(java.lang.String defaultAuthenticationMethod) {
            this.defaultAuthenticationMethod = defaultAuthenticationMethod;
            return this;
        }

        /**
         * Sets the value of {@link CfnAPNSChannelProps#getEnabled}
         * @param enabled Specifies whether to enable the APNs channel for the application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnAPNSChannelProps#getEnabled}
         * @param enabled Specifies whether to enable the APNs channel for the application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnAPNSChannelProps#getPrivateKey}
         * @param privateKey The private key for the APNs client certificate that you want Amazon Pinpoint to use to communicate with APNs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateKey(java.lang.String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        /**
         * Sets the value of {@link CfnAPNSChannelProps#getTeamId}
         * @param teamId The identifier that's assigned to your Apple Developer Account team.
         *               This identifier is used for APNs tokens.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder teamId(java.lang.String teamId) {
            this.teamId = teamId;
            return this;
        }

        /**
         * Sets the value of {@link CfnAPNSChannelProps#getTokenKey}
         * @param tokenKey The authentication key to use for APNs tokens.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tokenKey(java.lang.String tokenKey) {
            this.tokenKey = tokenKey;
            return this;
        }

        /**
         * Sets the value of {@link CfnAPNSChannelProps#getTokenKeyId}
         * @param tokenKeyId The key identifier that's assigned to your APNs signing key.
         *                   Specify this value if you want Amazon Pinpoint to communicate with APNs by using APNs tokens.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tokenKeyId(java.lang.String tokenKeyId) {
            this.tokenKeyId = tokenKeyId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAPNSChannelProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAPNSChannelProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAPNSChannelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAPNSChannelProps {
        private final java.lang.String applicationId;
        private final java.lang.String bundleId;
        private final java.lang.String certificate;
        private final java.lang.String defaultAuthenticationMethod;
        private final java.lang.Object enabled;
        private final java.lang.String privateKey;
        private final java.lang.String teamId;
        private final java.lang.String tokenKey;
        private final java.lang.String tokenKeyId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.applicationId = software.amazon.jsii.Kernel.get(this, "applicationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.bundleId = software.amazon.jsii.Kernel.get(this, "bundleId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.certificate = software.amazon.jsii.Kernel.get(this, "certificate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.defaultAuthenticationMethod = software.amazon.jsii.Kernel.get(this, "defaultAuthenticationMethod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.privateKey = software.amazon.jsii.Kernel.get(this, "privateKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.teamId = software.amazon.jsii.Kernel.get(this, "teamId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tokenKey = software.amazon.jsii.Kernel.get(this, "tokenKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tokenKeyId = software.amazon.jsii.Kernel.get(this, "tokenKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.applicationId = java.util.Objects.requireNonNull(builder.applicationId, "applicationId is required");
            this.bundleId = builder.bundleId;
            this.certificate = builder.certificate;
            this.defaultAuthenticationMethod = builder.defaultAuthenticationMethod;
            this.enabled = builder.enabled;
            this.privateKey = builder.privateKey;
            this.teamId = builder.teamId;
            this.tokenKey = builder.tokenKey;
            this.tokenKeyId = builder.tokenKeyId;
        }

        @Override
        public final java.lang.String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final java.lang.String getBundleId() {
            return this.bundleId;
        }

        @Override
        public final java.lang.String getCertificate() {
            return this.certificate;
        }

        @Override
        public final java.lang.String getDefaultAuthenticationMethod() {
            return this.defaultAuthenticationMethod;
        }

        @Override
        public final java.lang.Object getEnabled() {
            return this.enabled;
        }

        @Override
        public final java.lang.String getPrivateKey() {
            return this.privateKey;
        }

        @Override
        public final java.lang.String getTeamId() {
            return this.teamId;
        }

        @Override
        public final java.lang.String getTokenKey() {
            return this.tokenKey;
        }

        @Override
        public final java.lang.String getTokenKeyId() {
            return this.tokenKeyId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("applicationId", om.valueToTree(this.getApplicationId()));
            if (this.getBundleId() != null) {
                data.set("bundleId", om.valueToTree(this.getBundleId()));
            }
            if (this.getCertificate() != null) {
                data.set("certificate", om.valueToTree(this.getCertificate()));
            }
            if (this.getDefaultAuthenticationMethod() != null) {
                data.set("defaultAuthenticationMethod", om.valueToTree(this.getDefaultAuthenticationMethod()));
            }
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getPrivateKey() != null) {
                data.set("privateKey", om.valueToTree(this.getPrivateKey()));
            }
            if (this.getTeamId() != null) {
                data.set("teamId", om.valueToTree(this.getTeamId()));
            }
            if (this.getTokenKey() != null) {
                data.set("tokenKey", om.valueToTree(this.getTokenKey()));
            }
            if (this.getTokenKeyId() != null) {
                data.set("tokenKeyId", om.valueToTree(this.getTokenKeyId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnAPNSChannelProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAPNSChannelProps.Jsii$Proxy that = (CfnAPNSChannelProps.Jsii$Proxy) o;

            if (!applicationId.equals(that.applicationId)) return false;
            if (this.bundleId != null ? !this.bundleId.equals(that.bundleId) : that.bundleId != null) return false;
            if (this.certificate != null ? !this.certificate.equals(that.certificate) : that.certificate != null) return false;
            if (this.defaultAuthenticationMethod != null ? !this.defaultAuthenticationMethod.equals(that.defaultAuthenticationMethod) : that.defaultAuthenticationMethod != null) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            if (this.privateKey != null ? !this.privateKey.equals(that.privateKey) : that.privateKey != null) return false;
            if (this.teamId != null ? !this.teamId.equals(that.teamId) : that.teamId != null) return false;
            if (this.tokenKey != null ? !this.tokenKey.equals(that.tokenKey) : that.tokenKey != null) return false;
            return this.tokenKeyId != null ? this.tokenKeyId.equals(that.tokenKeyId) : that.tokenKeyId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.applicationId.hashCode();
            result = 31 * result + (this.bundleId != null ? this.bundleId.hashCode() : 0);
            result = 31 * result + (this.certificate != null ? this.certificate.hashCode() : 0);
            result = 31 * result + (this.defaultAuthenticationMethod != null ? this.defaultAuthenticationMethod.hashCode() : 0);
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.privateKey != null ? this.privateKey.hashCode() : 0);
            result = 31 * result + (this.teamId != null ? this.teamId.hashCode() : 0);
            result = 31 * result + (this.tokenKey != null ? this.tokenKey.hashCode() : 0);
            result = 31 * result + (this.tokenKeyId != null ? this.tokenKeyId.hashCode() : 0);
            return result;
        }
    }
}
