package software.amazon.awscdk.services.quicksight;

/**
 * Creates a data source.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.quicksight.*;
 * CfnDataSource cfnDataSource = CfnDataSource.Builder.create(this, "MyCfnDataSource")
 *         .name("name")
 *         .type("type")
 *         // the properties below are optional
 *         .alternateDataSourceParameters(List.of(DataSourceParametersProperty.builder()
 *                 .amazonElasticsearchParameters(AmazonElasticsearchParametersProperty.builder()
 *                         .domain("domain")
 *                         .build())
 *                 .amazonOpenSearchParameters(AmazonOpenSearchParametersProperty.builder()
 *                         .domain("domain")
 *                         .build())
 *                 .athenaParameters(AthenaParametersProperty.builder()
 *                         .roleArn("roleArn")
 *                         .workGroup("workGroup")
 *                         .build())
 *                 .auroraParameters(AuroraParametersProperty.builder()
 *                         .database("database")
 *                         .host("host")
 *                         .port(123)
 *                         .build())
 *                 .auroraPostgreSqlParameters(AuroraPostgreSqlParametersProperty.builder()
 *                         .database("database")
 *                         .host("host")
 *                         .port(123)
 *                         .build())
 *                 .databricksParameters(DatabricksParametersProperty.builder()
 *                         .host("host")
 *                         .port(123)
 *                         .sqlEndpointPath("sqlEndpointPath")
 *                         .build())
 *                 .mariaDbParameters(MariaDbParametersProperty.builder()
 *                         .database("database")
 *                         .host("host")
 *                         .port(123)
 *                         .build())
 *                 .mySqlParameters(MySqlParametersProperty.builder()
 *                         .database("database")
 *                         .host("host")
 *                         .port(123)
 *                         .build())
 *                 .oracleParameters(OracleParametersProperty.builder()
 *                         .database("database")
 *                         .host("host")
 *                         .port(123)
 *                         // the properties below are optional
 *                         .useServiceName(false)
 *                         .build())
 *                 .postgreSqlParameters(PostgreSqlParametersProperty.builder()
 *                         .database("database")
 *                         .host("host")
 *                         .port(123)
 *                         .build())
 *                 .prestoParameters(PrestoParametersProperty.builder()
 *                         .catalog("catalog")
 *                         .host("host")
 *                         .port(123)
 *                         .build())
 *                 .rdsParameters(RdsParametersProperty.builder()
 *                         .database("database")
 *                         .instanceId("instanceId")
 *                         .build())
 *                 .redshiftParameters(RedshiftParametersProperty.builder()
 *                         .database("database")
 *                         // the properties below are optional
 *                         .clusterId("clusterId")
 *                         .host("host")
 *                         .iamParameters(RedshiftIAMParametersProperty.builder()
 *                                 .roleArn("roleArn")
 *                                 // the properties below are optional
 *                                 .autoCreateDatabaseUser(false)
 *                                 .databaseGroups(List.of("databaseGroups"))
 *                                 .databaseUser("databaseUser")
 *                                 .build())
 *                         .identityCenterConfiguration(IdentityCenterConfigurationProperty.builder()
 *                                 .enableIdentityPropagation(false)
 *                                 .build())
 *                         .port(123)
 *                         .build())
 *                 .s3Parameters(S3ParametersProperty.builder()
 *                         .manifestFileLocation(ManifestFileLocationProperty.builder()
 *                                 .bucket("bucket")
 *                                 .key("key")
 *                                 .build())
 *                         // the properties below are optional
 *                         .roleArn("roleArn")
 *                         .build())
 *                 .snowflakeParameters(SnowflakeParametersProperty.builder()
 *                         .database("database")
 *                         .host("host")
 *                         .warehouse("warehouse")
 *                         // the properties below are optional
 *                         .authenticationType("authenticationType")
 *                         .databaseAccessControlRole("databaseAccessControlRole")
 *                         .oAuthParameters(OAuthParametersProperty.builder()
 *                                 .tokenProviderUrl("tokenProviderUrl")
 *                                 // the properties below are optional
 *                                 .identityProviderResourceUri("identityProviderResourceUri")
 *                                 .identityProviderVpcConnectionProperties(VpcConnectionPropertiesProperty.builder()
 *                                         .vpcConnectionArn("vpcConnectionArn")
 *                                         .build())
 *                                 .oAuthScope("oAuthScope")
 *                                 .build())
 *                         .build())
 *                 .sparkParameters(SparkParametersProperty.builder()
 *                         .host("host")
 *                         .port(123)
 *                         .build())
 *                 .sqlServerParameters(SqlServerParametersProperty.builder()
 *                         .database("database")
 *                         .host("host")
 *                         .port(123)
 *                         .build())
 *                 .starburstParameters(StarburstParametersProperty.builder()
 *                         .catalog("catalog")
 *                         .host("host")
 *                         .port(123)
 *                         // the properties below are optional
 *                         .authenticationType("authenticationType")
 *                         .databaseAccessControlRole("databaseAccessControlRole")
 *                         .oAuthParameters(OAuthParametersProperty.builder()
 *                                 .tokenProviderUrl("tokenProviderUrl")
 *                                 // the properties below are optional
 *                                 .identityProviderResourceUri("identityProviderResourceUri")
 *                                 .identityProviderVpcConnectionProperties(VpcConnectionPropertiesProperty.builder()
 *                                         .vpcConnectionArn("vpcConnectionArn")
 *                                         .build())
 *                                 .oAuthScope("oAuthScope")
 *                                 .build())
 *                         .productType("productType")
 *                         .build())
 *                 .teradataParameters(TeradataParametersProperty.builder()
 *                         .database("database")
 *                         .host("host")
 *                         .port(123)
 *                         .build())
 *                 .trinoParameters(TrinoParametersProperty.builder()
 *                         .catalog("catalog")
 *                         .host("host")
 *                         .port(123)
 *                         .build())
 *                 .build()))
 *         .awsAccountId("awsAccountId")
 *         .credentials(DataSourceCredentialsProperty.builder()
 *                 .copySourceArn("copySourceArn")
 *                 .credentialPair(CredentialPairProperty.builder()
 *                         .password("password")
 *                         .username("username")
 *                         // the properties below are optional
 *                         .alternateDataSourceParameters(List.of(DataSourceParametersProperty.builder()
 *                                 .amazonElasticsearchParameters(AmazonElasticsearchParametersProperty.builder()
 *                                         .domain("domain")
 *                                         .build())
 *                                 .amazonOpenSearchParameters(AmazonOpenSearchParametersProperty.builder()
 *                                         .domain("domain")
 *                                         .build())
 *                                 .athenaParameters(AthenaParametersProperty.builder()
 *                                         .roleArn("roleArn")
 *                                         .workGroup("workGroup")
 *                                         .build())
 *                                 .auroraParameters(AuroraParametersProperty.builder()
 *                                         .database("database")
 *                                         .host("host")
 *                                         .port(123)
 *                                         .build())
 *                                 .auroraPostgreSqlParameters(AuroraPostgreSqlParametersProperty.builder()
 *                                         .database("database")
 *                                         .host("host")
 *                                         .port(123)
 *                                         .build())
 *                                 .databricksParameters(DatabricksParametersProperty.builder()
 *                                         .host("host")
 *                                         .port(123)
 *                                         .sqlEndpointPath("sqlEndpointPath")
 *                                         .build())
 *                                 .mariaDbParameters(MariaDbParametersProperty.builder()
 *                                         .database("database")
 *                                         .host("host")
 *                                         .port(123)
 *                                         .build())
 *                                 .mySqlParameters(MySqlParametersProperty.builder()
 *                                         .database("database")
 *                                         .host("host")
 *                                         .port(123)
 *                                         .build())
 *                                 .oracleParameters(OracleParametersProperty.builder()
 *                                         .database("database")
 *                                         .host("host")
 *                                         .port(123)
 *                                         // the properties below are optional
 *                                         .useServiceName(false)
 *                                         .build())
 *                                 .postgreSqlParameters(PostgreSqlParametersProperty.builder()
 *                                         .database("database")
 *                                         .host("host")
 *                                         .port(123)
 *                                         .build())
 *                                 .prestoParameters(PrestoParametersProperty.builder()
 *                                         .catalog("catalog")
 *                                         .host("host")
 *                                         .port(123)
 *                                         .build())
 *                                 .rdsParameters(RdsParametersProperty.builder()
 *                                         .database("database")
 *                                         .instanceId("instanceId")
 *                                         .build())
 *                                 .redshiftParameters(RedshiftParametersProperty.builder()
 *                                         .database("database")
 *                                         // the properties below are optional
 *                                         .clusterId("clusterId")
 *                                         .host("host")
 *                                         .iamParameters(RedshiftIAMParametersProperty.builder()
 *                                                 .roleArn("roleArn")
 *                                                 // the properties below are optional
 *                                                 .autoCreateDatabaseUser(false)
 *                                                 .databaseGroups(List.of("databaseGroups"))
 *                                                 .databaseUser("databaseUser")
 *                                                 .build())
 *                                         .identityCenterConfiguration(IdentityCenterConfigurationProperty.builder()
 *                                                 .enableIdentityPropagation(false)
 *                                                 .build())
 *                                         .port(123)
 *                                         .build())
 *                                 .s3Parameters(S3ParametersProperty.builder()
 *                                         .manifestFileLocation(ManifestFileLocationProperty.builder()
 *                                                 .bucket("bucket")
 *                                                 .key("key")
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .roleArn("roleArn")
 *                                         .build())
 *                                 .snowflakeParameters(SnowflakeParametersProperty.builder()
 *                                         .database("database")
 *                                         .host("host")
 *                                         .warehouse("warehouse")
 *                                         // the properties below are optional
 *                                         .authenticationType("authenticationType")
 *                                         .databaseAccessControlRole("databaseAccessControlRole")
 *                                         .oAuthParameters(OAuthParametersProperty.builder()
 *                                                 .tokenProviderUrl("tokenProviderUrl")
 *                                                 // the properties below are optional
 *                                                 .identityProviderResourceUri("identityProviderResourceUri")
 *                                                 .identityProviderVpcConnectionProperties(VpcConnectionPropertiesProperty.builder()
 *                                                         .vpcConnectionArn("vpcConnectionArn")
 *                                                         .build())
 *                                                 .oAuthScope("oAuthScope")
 *                                                 .build())
 *                                         .build())
 *                                 .sparkParameters(SparkParametersProperty.builder()
 *                                         .host("host")
 *                                         .port(123)
 *                                         .build())
 *                                 .sqlServerParameters(SqlServerParametersProperty.builder()
 *                                         .database("database")
 *                                         .host("host")
 *                                         .port(123)
 *                                         .build())
 *                                 .starburstParameters(StarburstParametersProperty.builder()
 *                                         .catalog("catalog")
 *                                         .host("host")
 *                                         .port(123)
 *                                         // the properties below are optional
 *                                         .authenticationType("authenticationType")
 *                                         .databaseAccessControlRole("databaseAccessControlRole")
 *                                         .oAuthParameters(OAuthParametersProperty.builder()
 *                                                 .tokenProviderUrl("tokenProviderUrl")
 *                                                 // the properties below are optional
 *                                                 .identityProviderResourceUri("identityProviderResourceUri")
 *                                                 .identityProviderVpcConnectionProperties(VpcConnectionPropertiesProperty.builder()
 *                                                         .vpcConnectionArn("vpcConnectionArn")
 *                                                         .build())
 *                                                 .oAuthScope("oAuthScope")
 *                                                 .build())
 *                                         .productType("productType")
 *                                         .build())
 *                                 .teradataParameters(TeradataParametersProperty.builder()
 *                                         .database("database")
 *                                         .host("host")
 *                                         .port(123)
 *                                         .build())
 *                                 .trinoParameters(TrinoParametersProperty.builder()
 *                                         .catalog("catalog")
 *                                         .host("host")
 *                                         .port(123)
 *                                         .build())
 *                                 .build()))
 *                         .build())
 *                 .secretArn("secretArn")
 *                 .build())
 *         .dataSourceId("dataSourceId")
 *         .dataSourceParameters(DataSourceParametersProperty.builder()
 *                 .amazonElasticsearchParameters(AmazonElasticsearchParametersProperty.builder()
 *                         .domain("domain")
 *                         .build())
 *                 .amazonOpenSearchParameters(AmazonOpenSearchParametersProperty.builder()
 *                         .domain("domain")
 *                         .build())
 *                 .athenaParameters(AthenaParametersProperty.builder()
 *                         .roleArn("roleArn")
 *                         .workGroup("workGroup")
 *                         .build())
 *                 .auroraParameters(AuroraParametersProperty.builder()
 *                         .database("database")
 *                         .host("host")
 *                         .port(123)
 *                         .build())
 *                 .auroraPostgreSqlParameters(AuroraPostgreSqlParametersProperty.builder()
 *                         .database("database")
 *                         .host("host")
 *                         .port(123)
 *                         .build())
 *                 .databricksParameters(DatabricksParametersProperty.builder()
 *                         .host("host")
 *                         .port(123)
 *                         .sqlEndpointPath("sqlEndpointPath")
 *                         .build())
 *                 .mariaDbParameters(MariaDbParametersProperty.builder()
 *                         .database("database")
 *                         .host("host")
 *                         .port(123)
 *                         .build())
 *                 .mySqlParameters(MySqlParametersProperty.builder()
 *                         .database("database")
 *                         .host("host")
 *                         .port(123)
 *                         .build())
 *                 .oracleParameters(OracleParametersProperty.builder()
 *                         .database("database")
 *                         .host("host")
 *                         .port(123)
 *                         // the properties below are optional
 *                         .useServiceName(false)
 *                         .build())
 *                 .postgreSqlParameters(PostgreSqlParametersProperty.builder()
 *                         .database("database")
 *                         .host("host")
 *                         .port(123)
 *                         .build())
 *                 .prestoParameters(PrestoParametersProperty.builder()
 *                         .catalog("catalog")
 *                         .host("host")
 *                         .port(123)
 *                         .build())
 *                 .rdsParameters(RdsParametersProperty.builder()
 *                         .database("database")
 *                         .instanceId("instanceId")
 *                         .build())
 *                 .redshiftParameters(RedshiftParametersProperty.builder()
 *                         .database("database")
 *                         // the properties below are optional
 *                         .clusterId("clusterId")
 *                         .host("host")
 *                         .iamParameters(RedshiftIAMParametersProperty.builder()
 *                                 .roleArn("roleArn")
 *                                 // the properties below are optional
 *                                 .autoCreateDatabaseUser(false)
 *                                 .databaseGroups(List.of("databaseGroups"))
 *                                 .databaseUser("databaseUser")
 *                                 .build())
 *                         .identityCenterConfiguration(IdentityCenterConfigurationProperty.builder()
 *                                 .enableIdentityPropagation(false)
 *                                 .build())
 *                         .port(123)
 *                         .build())
 *                 .s3Parameters(S3ParametersProperty.builder()
 *                         .manifestFileLocation(ManifestFileLocationProperty.builder()
 *                                 .bucket("bucket")
 *                                 .key("key")
 *                                 .build())
 *                         // the properties below are optional
 *                         .roleArn("roleArn")
 *                         .build())
 *                 .snowflakeParameters(SnowflakeParametersProperty.builder()
 *                         .database("database")
 *                         .host("host")
 *                         .warehouse("warehouse")
 *                         // the properties below are optional
 *                         .authenticationType("authenticationType")
 *                         .databaseAccessControlRole("databaseAccessControlRole")
 *                         .oAuthParameters(OAuthParametersProperty.builder()
 *                                 .tokenProviderUrl("tokenProviderUrl")
 *                                 // the properties below are optional
 *                                 .identityProviderResourceUri("identityProviderResourceUri")
 *                                 .identityProviderVpcConnectionProperties(VpcConnectionPropertiesProperty.builder()
 *                                         .vpcConnectionArn("vpcConnectionArn")
 *                                         .build())
 *                                 .oAuthScope("oAuthScope")
 *                                 .build())
 *                         .build())
 *                 .sparkParameters(SparkParametersProperty.builder()
 *                         .host("host")
 *                         .port(123)
 *                         .build())
 *                 .sqlServerParameters(SqlServerParametersProperty.builder()
 *                         .database("database")
 *                         .host("host")
 *                         .port(123)
 *                         .build())
 *                 .starburstParameters(StarburstParametersProperty.builder()
 *                         .catalog("catalog")
 *                         .host("host")
 *                         .port(123)
 *                         // the properties below are optional
 *                         .authenticationType("authenticationType")
 *                         .databaseAccessControlRole("databaseAccessControlRole")
 *                         .oAuthParameters(OAuthParametersProperty.builder()
 *                                 .tokenProviderUrl("tokenProviderUrl")
 *                                 // the properties below are optional
 *                                 .identityProviderResourceUri("identityProviderResourceUri")
 *                                 .identityProviderVpcConnectionProperties(VpcConnectionPropertiesProperty.builder()
 *                                         .vpcConnectionArn("vpcConnectionArn")
 *                                         .build())
 *                                 .oAuthScope("oAuthScope")
 *                                 .build())
 *                         .productType("productType")
 *                         .build())
 *                 .teradataParameters(TeradataParametersProperty.builder()
 *                         .database("database")
 *                         .host("host")
 *                         .port(123)
 *                         .build())
 *                 .trinoParameters(TrinoParametersProperty.builder()
 *                         .catalog("catalog")
 *                         .host("host")
 *                         .port(123)
 *                         .build())
 *                 .build())
 *         .errorInfo(DataSourceErrorInfoProperty.builder()
 *                 .message("message")
 *                 .type("type")
 *                 .build())
 *         .folderArns(List.of("folderArns"))
 *         .permissions(List.of(ResourcePermissionProperty.builder()
 *                 .actions(List.of("actions"))
 *                 .principal("principal")
 *                 // the properties below are optional
 *                 .resource("resource")
 *                 .build()))
 *         .sslProperties(SslPropertiesProperty.builder()
 *                 .disableSsl(false)
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .vpcConnectionProperties(VpcConnectionPropertiesProperty.builder()
 *                 .vpcConnectionArn("vpcConnectionArn")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:42.293Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSource")
public class CfnDataSource extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnDataSource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDataSource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.quicksight.CfnDataSource.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDataSource(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.quicksight.CfnDataSourceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time that this data source was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The last time that this data source was updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLastUpdatedTime() {
        return software.amazon.jsii.Kernel.get(this, "attrLastUpdatedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The HTTP status of the request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * A display name for the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A display name for the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The type of the data source.
     * <p>
     * To return a list of all data sources, use <code>ListDataSources</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of the data source.
     * <p>
     * To return a list of all data sources, use <code>ListDataSources</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "type", java.util.Objects.requireNonNull(value, "type is required"));
    }

    /**
     * A set of alternate data source parameters that you want to share for the credentials stored with this data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAlternateDataSourceParameters() {
        return software.amazon.jsii.Kernel.get(this, "alternateDataSourceParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A set of alternate data source parameters that you want to share for the credentials stored with this data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAlternateDataSourceParameters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "alternateDataSourceParameters", value);
    }

    /**
     * A set of alternate data source parameters that you want to share for the credentials stored with this data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAlternateDataSourceParameters(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.quicksight.CfnDataSource.DataSourceParametersProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.quicksight.CfnDataSource.DataSourceParametersProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "alternateDataSourceParameters", value);
    }

    /**
     * The AWS account ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAwsAccountId() {
        return software.amazon.jsii.Kernel.get(this, "awsAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS account ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAwsAccountId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "awsAccountId", value);
    }

    /**
     * The credentials Amazon QuickSight that uses to connect to your underlying source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCredentials() {
        return software.amazon.jsii.Kernel.get(this, "credentials", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The credentials Amazon QuickSight that uses to connect to your underlying source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCredentials(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "credentials", value);
    }

    /**
     * The credentials Amazon QuickSight that uses to connect to your underlying source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCredentials(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.quicksight.CfnDataSource.DataSourceCredentialsProperty value) {
        software.amazon.jsii.Kernel.set(this, "credentials", value);
    }

    /**
     * An ID for the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDataSourceId() {
        return software.amazon.jsii.Kernel.get(this, "dataSourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An ID for the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataSourceId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dataSourceId", value);
    }

    /**
     * The parameters that Amazon QuickSight uses to connect to your underlying source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDataSourceParameters() {
        return software.amazon.jsii.Kernel.get(this, "dataSourceParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The parameters that Amazon QuickSight uses to connect to your underlying source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataSourceParameters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dataSourceParameters", value);
    }

    /**
     * The parameters that Amazon QuickSight uses to connect to your underlying source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataSourceParameters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.quicksight.CfnDataSource.DataSourceParametersProperty value) {
        software.amazon.jsii.Kernel.set(this, "dataSourceParameters", value);
    }

    /**
     * Error information from the last update or the creation of the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getErrorInfo() {
        return software.amazon.jsii.Kernel.get(this, "errorInfo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Error information from the last update or the creation of the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setErrorInfo(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "errorInfo", value);
    }

    /**
     * Error information from the last update or the creation of the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setErrorInfo(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.quicksight.CfnDataSource.DataSourceErrorInfoProperty value) {
        software.amazon.jsii.Kernel.set(this, "errorInfo", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getFolderArns() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "folderArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFolderArns(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "folderArns", value);
    }

    /**
     * A list of resource permissions on the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPermissions() {
        return software.amazon.jsii.Kernel.get(this, "permissions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of resource permissions on the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPermissions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "permissions", value);
    }

    /**
     * A list of resource permissions on the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPermissions(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.quicksight.CfnDataSource.ResourcePermissionProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.quicksight.CfnDataSource.ResourcePermissionProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "permissions", value);
    }

    /**
     * Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your underlying source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSslProperties() {
        return software.amazon.jsii.Kernel.get(this, "sslProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your underlying source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSslProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sslProperties", value);
    }

    /**
     * Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your underlying source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSslProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.quicksight.CfnDataSource.SslPropertiesProperty value) {
        software.amazon.jsii.Kernel.set(this, "sslProperties", value);
    }

    /**
     * Contains a map of the key-value pairs for the resource tag or tags assigned to the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Contains a map of the key-value pairs for the resource tag or tags assigned to the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * Use this parameter only when you want Amazon QuickSight to use a VPC connection when connecting to your underlying source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVpcConnectionProperties() {
        return software.amazon.jsii.Kernel.get(this, "vpcConnectionProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Use this parameter only when you want Amazon QuickSight to use a VPC connection when connecting to your underlying source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcConnectionProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "vpcConnectionProperties", value);
    }

    /**
     * Use this parameter only when you want Amazon QuickSight to use a VPC connection when connecting to your underlying source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcConnectionProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.quicksight.CfnDataSource.VpcConnectionPropertiesProperty value) {
        software.amazon.jsii.Kernel.set(this, "vpcConnectionProperties", value);
    }
    /**
     * The parameters for OpenSearch.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * AmazonElasticsearchParametersProperty amazonElasticsearchParametersProperty = AmazonElasticsearchParametersProperty.builder()
     *         .domain("domain")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-amazonelasticsearchparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-amazonelasticsearchparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSource.AmazonElasticsearchParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(AmazonElasticsearchParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AmazonElasticsearchParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The OpenSearch domain.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-amazonelasticsearchparameters.html#cfn-quicksight-datasource-amazonelasticsearchparameters-domain">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-amazonelasticsearchparameters.html#cfn-quicksight-datasource-amazonelasticsearchparameters-domain</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDomain();

        /**
         * @return a {@link Builder} of {@link AmazonElasticsearchParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AmazonElasticsearchParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AmazonElasticsearchParametersProperty> {
            java.lang.String domain;

            /**
             * Sets the value of {@link AmazonElasticsearchParametersProperty#getDomain}
             * @param domain The OpenSearch domain. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder domain(java.lang.String domain) {
                this.domain = domain;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AmazonElasticsearchParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AmazonElasticsearchParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AmazonElasticsearchParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AmazonElasticsearchParametersProperty {
            private final java.lang.String domain;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.domain = software.amazon.jsii.Kernel.get(this, "domain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.domain = java.util.Objects.requireNonNull(builder.domain, "domain is required");
            }

            @Override
            public final java.lang.String getDomain() {
                return this.domain;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("domain", om.valueToTree(this.getDomain()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSource.AmazonElasticsearchParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AmazonElasticsearchParametersProperty.Jsii$Proxy that = (AmazonElasticsearchParametersProperty.Jsii$Proxy) o;

                return this.domain.equals(that.domain);
            }

            @Override
            public final int hashCode() {
                int result = this.domain.hashCode();
                return result;
            }
        }
    }
    /**
     * The parameters for OpenSearch.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * AmazonOpenSearchParametersProperty amazonOpenSearchParametersProperty = AmazonOpenSearchParametersProperty.builder()
     *         .domain("domain")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-amazonopensearchparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-amazonopensearchparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSource.AmazonOpenSearchParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(AmazonOpenSearchParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AmazonOpenSearchParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The OpenSearch domain.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-amazonopensearchparameters.html#cfn-quicksight-datasource-amazonopensearchparameters-domain">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-amazonopensearchparameters.html#cfn-quicksight-datasource-amazonopensearchparameters-domain</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDomain();

        /**
         * @return a {@link Builder} of {@link AmazonOpenSearchParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AmazonOpenSearchParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AmazonOpenSearchParametersProperty> {
            java.lang.String domain;

            /**
             * Sets the value of {@link AmazonOpenSearchParametersProperty#getDomain}
             * @param domain The OpenSearch domain. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder domain(java.lang.String domain) {
                this.domain = domain;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AmazonOpenSearchParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AmazonOpenSearchParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AmazonOpenSearchParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AmazonOpenSearchParametersProperty {
            private final java.lang.String domain;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.domain = software.amazon.jsii.Kernel.get(this, "domain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.domain = java.util.Objects.requireNonNull(builder.domain, "domain is required");
            }

            @Override
            public final java.lang.String getDomain() {
                return this.domain;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("domain", om.valueToTree(this.getDomain()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSource.AmazonOpenSearchParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AmazonOpenSearchParametersProperty.Jsii$Proxy that = (AmazonOpenSearchParametersProperty.Jsii$Proxy) o;

                return this.domain.equals(that.domain);
            }

            @Override
            public final int hashCode() {
                int result = this.domain.hashCode();
                return result;
            }
        }
    }
    /**
     * Parameters for Amazon Athena.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * AthenaParametersProperty athenaParametersProperty = AthenaParametersProperty.builder()
     *         .roleArn("roleArn")
     *         .workGroup("workGroup")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-athenaparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-athenaparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSource.AthenaParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(AthenaParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AthenaParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Use the <code>RoleArn</code> structure to override an account-wide role for a specific Athena data source.
         * <p>
         * For example, say an account administrator has turned off all Athena access with an account-wide role. The administrator can then use <code>RoleArn</code> to bypass the account-wide role and allow Athena access for the single Athena data source that is specified in the structure, even if the account-wide role forbidding Athena access is still active.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-athenaparameters.html#cfn-quicksight-datasource-athenaparameters-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-athenaparameters.html#cfn-quicksight-datasource-athenaparameters-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
            return null;
        }

        /**
         * The workgroup that Amazon Athena uses.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-athenaparameters.html#cfn-quicksight-datasource-athenaparameters-workgroup">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-athenaparameters.html#cfn-quicksight-datasource-athenaparameters-workgroup</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWorkGroup() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AthenaParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AthenaParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AthenaParametersProperty> {
            java.lang.String roleArn;
            java.lang.String workGroup;

            /**
             * Sets the value of {@link AthenaParametersProperty#getRoleArn}
             * @param roleArn Use the <code>RoleArn</code> structure to override an account-wide role for a specific Athena data source.
             *                For example, say an account administrator has turned off all Athena access with an account-wide role. The administrator can then use <code>RoleArn</code> to bypass the account-wide role and allow Athena access for the single Athena data source that is specified in the structure, even if the account-wide role forbidding Athena access is still active.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link AthenaParametersProperty#getWorkGroup}
             * @param workGroup The workgroup that Amazon Athena uses.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workGroup(java.lang.String workGroup) {
                this.workGroup = workGroup;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AthenaParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AthenaParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AthenaParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AthenaParametersProperty {
            private final java.lang.String roleArn;
            private final java.lang.String workGroup;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.workGroup = software.amazon.jsii.Kernel.get(this, "workGroup", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.roleArn = builder.roleArn;
                this.workGroup = builder.workGroup;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getWorkGroup() {
                return this.workGroup;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRoleArn() != null) {
                    data.set("roleArn", om.valueToTree(this.getRoleArn()));
                }
                if (this.getWorkGroup() != null) {
                    data.set("workGroup", om.valueToTree(this.getWorkGroup()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSource.AthenaParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AthenaParametersProperty.Jsii$Proxy that = (AthenaParametersProperty.Jsii$Proxy) o;

                if (this.roleArn != null ? !this.roleArn.equals(that.roleArn) : that.roleArn != null) return false;
                return this.workGroup != null ? this.workGroup.equals(that.workGroup) : that.workGroup == null;
            }

            @Override
            public final int hashCode() {
                int result = this.roleArn != null ? this.roleArn.hashCode() : 0;
                result = 31 * result + (this.workGroup != null ? this.workGroup.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Parameters for Amazon Aurora.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * AuroraParametersProperty auroraParametersProperty = AuroraParametersProperty.builder()
     *         .database("database")
     *         .host("host")
     *         .port(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-auroraparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-auroraparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSource.AuroraParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(AuroraParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AuroraParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-auroraparameters.html#cfn-quicksight-datasource-auroraparameters-database">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-auroraparameters.html#cfn-quicksight-datasource-auroraparameters-database</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabase();

        /**
         * Host.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-auroraparameters.html#cfn-quicksight-datasource-auroraparameters-host">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-auroraparameters.html#cfn-quicksight-datasource-auroraparameters-host</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHost();

        /**
         * Port.
         * <p>
         * Default: - 0
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-auroraparameters.html#cfn-quicksight-datasource-auroraparameters-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-auroraparameters.html#cfn-quicksight-datasource-auroraparameters-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPort();

        /**
         * @return a {@link Builder} of {@link AuroraParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AuroraParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AuroraParametersProperty> {
            java.lang.String database;
            java.lang.String host;
            java.lang.Number port;

            /**
             * Sets the value of {@link AuroraParametersProperty#getDatabase}
             * @param database Database. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder database(java.lang.String database) {
                this.database = database;
                return this;
            }

            /**
             * Sets the value of {@link AuroraParametersProperty#getHost}
             * @param host Host. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder host(java.lang.String host) {
                this.host = host;
                return this;
            }

            /**
             * Sets the value of {@link AuroraParametersProperty#getPort}
             * @param port Port. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AuroraParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AuroraParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AuroraParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuroraParametersProperty {
            private final java.lang.String database;
            private final java.lang.String host;
            private final java.lang.Number port;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.database = software.amazon.jsii.Kernel.get(this, "database", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.host = software.amazon.jsii.Kernel.get(this, "host", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.database = java.util.Objects.requireNonNull(builder.database, "database is required");
                this.host = java.util.Objects.requireNonNull(builder.host, "host is required");
                this.port = java.util.Objects.requireNonNull(builder.port, "port is required");
            }

            @Override
            public final java.lang.String getDatabase() {
                return this.database;
            }

            @Override
            public final java.lang.String getHost() {
                return this.host;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("database", om.valueToTree(this.getDatabase()));
                data.set("host", om.valueToTree(this.getHost()));
                data.set("port", om.valueToTree(this.getPort()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSource.AuroraParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AuroraParametersProperty.Jsii$Proxy that = (AuroraParametersProperty.Jsii$Proxy) o;

                if (!database.equals(that.database)) return false;
                if (!host.equals(that.host)) return false;
                return this.port.equals(that.port);
            }

            @Override
            public final int hashCode() {
                int result = this.database.hashCode();
                result = 31 * result + (this.host.hashCode());
                result = 31 * result + (this.port.hashCode());
                return result;
            }
        }
    }
    /**
     * Parameters for Amazon Aurora PostgreSQL-Compatible Edition.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * AuroraPostgreSqlParametersProperty auroraPostgreSqlParametersProperty = AuroraPostgreSqlParametersProperty.builder()
     *         .database("database")
     *         .host("host")
     *         .port(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-aurorapostgresqlparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-aurorapostgresqlparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSource.AuroraPostgreSqlParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(AuroraPostgreSqlParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AuroraPostgreSqlParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Aurora PostgreSQL database to connect to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-aurorapostgresqlparameters.html#cfn-quicksight-datasource-aurorapostgresqlparameters-database">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-aurorapostgresqlparameters.html#cfn-quicksight-datasource-aurorapostgresqlparameters-database</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabase();

        /**
         * The Amazon Aurora PostgreSQL-Compatible host to connect to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-aurorapostgresqlparameters.html#cfn-quicksight-datasource-aurorapostgresqlparameters-host">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-aurorapostgresqlparameters.html#cfn-quicksight-datasource-aurorapostgresqlparameters-host</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHost();

        /**
         * The port that Amazon Aurora PostgreSQL is listening on.
         * <p>
         * Default: - 0
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-aurorapostgresqlparameters.html#cfn-quicksight-datasource-aurorapostgresqlparameters-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-aurorapostgresqlparameters.html#cfn-quicksight-datasource-aurorapostgresqlparameters-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPort();

        /**
         * @return a {@link Builder} of {@link AuroraPostgreSqlParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AuroraPostgreSqlParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AuroraPostgreSqlParametersProperty> {
            java.lang.String database;
            java.lang.String host;
            java.lang.Number port;

            /**
             * Sets the value of {@link AuroraPostgreSqlParametersProperty#getDatabase}
             * @param database The Amazon Aurora PostgreSQL database to connect to. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder database(java.lang.String database) {
                this.database = database;
                return this;
            }

            /**
             * Sets the value of {@link AuroraPostgreSqlParametersProperty#getHost}
             * @param host The Amazon Aurora PostgreSQL-Compatible host to connect to. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder host(java.lang.String host) {
                this.host = host;
                return this;
            }

            /**
             * Sets the value of {@link AuroraPostgreSqlParametersProperty#getPort}
             * @param port The port that Amazon Aurora PostgreSQL is listening on. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AuroraPostgreSqlParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AuroraPostgreSqlParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AuroraPostgreSqlParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuroraPostgreSqlParametersProperty {
            private final java.lang.String database;
            private final java.lang.String host;
            private final java.lang.Number port;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.database = software.amazon.jsii.Kernel.get(this, "database", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.host = software.amazon.jsii.Kernel.get(this, "host", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.database = java.util.Objects.requireNonNull(builder.database, "database is required");
                this.host = java.util.Objects.requireNonNull(builder.host, "host is required");
                this.port = java.util.Objects.requireNonNull(builder.port, "port is required");
            }

            @Override
            public final java.lang.String getDatabase() {
                return this.database;
            }

            @Override
            public final java.lang.String getHost() {
                return this.host;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("database", om.valueToTree(this.getDatabase()));
                data.set("host", om.valueToTree(this.getHost()));
                data.set("port", om.valueToTree(this.getPort()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSource.AuroraPostgreSqlParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AuroraPostgreSqlParametersProperty.Jsii$Proxy that = (AuroraPostgreSqlParametersProperty.Jsii$Proxy) o;

                if (!database.equals(that.database)) return false;
                if (!host.equals(that.host)) return false;
                return this.port.equals(that.port);
            }

            @Override
            public final int hashCode() {
                int result = this.database.hashCode();
                result = 31 * result + (this.host.hashCode());
                result = 31 * result + (this.port.hashCode());
                return result;
            }
        }
    }
    /**
     * The combination of user name and password that are used as credentials.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * CredentialPairProperty credentialPairProperty = CredentialPairProperty.builder()
     *         .password("password")
     *         .username("username")
     *         // the properties below are optional
     *         .alternateDataSourceParameters(List.of(DataSourceParametersProperty.builder()
     *                 .amazonElasticsearchParameters(AmazonElasticsearchParametersProperty.builder()
     *                         .domain("domain")
     *                         .build())
     *                 .amazonOpenSearchParameters(AmazonOpenSearchParametersProperty.builder()
     *                         .domain("domain")
     *                         .build())
     *                 .athenaParameters(AthenaParametersProperty.builder()
     *                         .roleArn("roleArn")
     *                         .workGroup("workGroup")
     *                         .build())
     *                 .auroraParameters(AuroraParametersProperty.builder()
     *                         .database("database")
     *                         .host("host")
     *                         .port(123)
     *                         .build())
     *                 .auroraPostgreSqlParameters(AuroraPostgreSqlParametersProperty.builder()
     *                         .database("database")
     *                         .host("host")
     *                         .port(123)
     *                         .build())
     *                 .databricksParameters(DatabricksParametersProperty.builder()
     *                         .host("host")
     *                         .port(123)
     *                         .sqlEndpointPath("sqlEndpointPath")
     *                         .build())
     *                 .mariaDbParameters(MariaDbParametersProperty.builder()
     *                         .database("database")
     *                         .host("host")
     *                         .port(123)
     *                         .build())
     *                 .mySqlParameters(MySqlParametersProperty.builder()
     *                         .database("database")
     *                         .host("host")
     *                         .port(123)
     *                         .build())
     *                 .oracleParameters(OracleParametersProperty.builder()
     *                         .database("database")
     *                         .host("host")
     *                         .port(123)
     *                         // the properties below are optional
     *                         .useServiceName(false)
     *                         .build())
     *                 .postgreSqlParameters(PostgreSqlParametersProperty.builder()
     *                         .database("database")
     *                         .host("host")
     *                         .port(123)
     *                         .build())
     *                 .prestoParameters(PrestoParametersProperty.builder()
     *                         .catalog("catalog")
     *                         .host("host")
     *                         .port(123)
     *                         .build())
     *                 .rdsParameters(RdsParametersProperty.builder()
     *                         .database("database")
     *                         .instanceId("instanceId")
     *                         .build())
     *                 .redshiftParameters(RedshiftParametersProperty.builder()
     *                         .database("database")
     *                         // the properties below are optional
     *                         .clusterId("clusterId")
     *                         .host("host")
     *                         .iamParameters(RedshiftIAMParametersProperty.builder()
     *                                 .roleArn("roleArn")
     *                                 // the properties below are optional
     *                                 .autoCreateDatabaseUser(false)
     *                                 .databaseGroups(List.of("databaseGroups"))
     *                                 .databaseUser("databaseUser")
     *                                 .build())
     *                         .identityCenterConfiguration(IdentityCenterConfigurationProperty.builder()
     *                                 .enableIdentityPropagation(false)
     *                                 .build())
     *                         .port(123)
     *                         .build())
     *                 .s3Parameters(S3ParametersProperty.builder()
     *                         .manifestFileLocation(ManifestFileLocationProperty.builder()
     *                                 .bucket("bucket")
     *                                 .key("key")
     *                                 .build())
     *                         // the properties below are optional
     *                         .roleArn("roleArn")
     *                         .build())
     *                 .snowflakeParameters(SnowflakeParametersProperty.builder()
     *                         .database("database")
     *                         .host("host")
     *                         .warehouse("warehouse")
     *                         // the properties below are optional
     *                         .authenticationType("authenticationType")
     *                         .databaseAccessControlRole("databaseAccessControlRole")
     *                         .oAuthParameters(OAuthParametersProperty.builder()
     *                                 .tokenProviderUrl("tokenProviderUrl")
     *                                 // the properties below are optional
     *                                 .identityProviderResourceUri("identityProviderResourceUri")
     *                                 .identityProviderVpcConnectionProperties(VpcConnectionPropertiesProperty.builder()
     *                                         .vpcConnectionArn("vpcConnectionArn")
     *                                         .build())
     *                                 .oAuthScope("oAuthScope")
     *                                 .build())
     *                         .build())
     *                 .sparkParameters(SparkParametersProperty.builder()
     *                         .host("host")
     *                         .port(123)
     *                         .build())
     *                 .sqlServerParameters(SqlServerParametersProperty.builder()
     *                         .database("database")
     *                         .host("host")
     *                         .port(123)
     *                         .build())
     *                 .starburstParameters(StarburstParametersProperty.builder()
     *                         .catalog("catalog")
     *                         .host("host")
     *                         .port(123)
     *                         // the properties below are optional
     *                         .authenticationType("authenticationType")
     *                         .databaseAccessControlRole("databaseAccessControlRole")
     *                         .oAuthParameters(OAuthParametersProperty.builder()
     *                                 .tokenProviderUrl("tokenProviderUrl")
     *                                 // the properties below are optional
     *                                 .identityProviderResourceUri("identityProviderResourceUri")
     *                                 .identityProviderVpcConnectionProperties(VpcConnectionPropertiesProperty.builder()
     *                                         .vpcConnectionArn("vpcConnectionArn")
     *                                         .build())
     *                                 .oAuthScope("oAuthScope")
     *                                 .build())
     *                         .productType("productType")
     *                         .build())
     *                 .teradataParameters(TeradataParametersProperty.builder()
     *                         .database("database")
     *                         .host("host")
     *                         .port(123)
     *                         .build())
     *                 .trinoParameters(TrinoParametersProperty.builder()
     *                         .catalog("catalog")
     *                         .host("host")
     *                         .port(123)
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-credentialpair.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-credentialpair.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSource.CredentialPairProperty")
    @software.amazon.jsii.Jsii.Proxy(CredentialPairProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CredentialPairProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Password.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-credentialpair.html#cfn-quicksight-datasource-credentialpair-password">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-credentialpair.html#cfn-quicksight-datasource-credentialpair-password</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPassword();

        /**
         * User name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-credentialpair.html#cfn-quicksight-datasource-credentialpair-username">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-credentialpair.html#cfn-quicksight-datasource-credentialpair-username</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUsername();

        /**
         * A set of alternate data source parameters that you want to share for these credentials.
         * <p>
         * The credentials are applied in tandem with the data source parameters when you copy a data source by using a create or update request. The API operation compares the <code>DataSourceParameters</code> structure that's in the request with the structures in the <code>AlternateDataSourceParameters</code> allow list. If the structures are an exact match, the request is allowed to use the new data source with the existing credentials. If the <code>AlternateDataSourceParameters</code> list is null, the <code>DataSourceParameters</code> originally used with these <code>Credentials</code> is automatically allowed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-credentialpair.html#cfn-quicksight-datasource-credentialpair-alternatedatasourceparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-credentialpair.html#cfn-quicksight-datasource-credentialpair-alternatedatasourceparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAlternateDataSourceParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CredentialPairProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CredentialPairProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CredentialPairProperty> {
            java.lang.String password;
            java.lang.String username;
            java.lang.Object alternateDataSourceParameters;

            /**
             * Sets the value of {@link CredentialPairProperty#getPassword}
             * @param password Password. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder password(java.lang.String password) {
                this.password = password;
                return this;
            }

            /**
             * Sets the value of {@link CredentialPairProperty#getUsername}
             * @param username User name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder username(java.lang.String username) {
                this.username = username;
                return this;
            }

            /**
             * Sets the value of {@link CredentialPairProperty#getAlternateDataSourceParameters}
             * @param alternateDataSourceParameters A set of alternate data source parameters that you want to share for these credentials.
             *                                      The credentials are applied in tandem with the data source parameters when you copy a data source by using a create or update request. The API operation compares the <code>DataSourceParameters</code> structure that's in the request with the structures in the <code>AlternateDataSourceParameters</code> allow list. If the structures are an exact match, the request is allowed to use the new data source with the existing credentials. If the <code>AlternateDataSourceParameters</code> list is null, the <code>DataSourceParameters</code> originally used with these <code>Credentials</code> is automatically allowed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alternateDataSourceParameters(software.amazon.awscdk.IResolvable alternateDataSourceParameters) {
                this.alternateDataSourceParameters = alternateDataSourceParameters;
                return this;
            }

            /**
             * Sets the value of {@link CredentialPairProperty#getAlternateDataSourceParameters}
             * @param alternateDataSourceParameters A set of alternate data source parameters that you want to share for these credentials.
             *                                      The credentials are applied in tandem with the data source parameters when you copy a data source by using a create or update request. The API operation compares the <code>DataSourceParameters</code> structure that's in the request with the structures in the <code>AlternateDataSourceParameters</code> allow list. If the structures are an exact match, the request is allowed to use the new data source with the existing credentials. If the <code>AlternateDataSourceParameters</code> list is null, the <code>DataSourceParameters</code> originally used with these <code>Credentials</code> is automatically allowed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alternateDataSourceParameters(java.util.List<? extends java.lang.Object> alternateDataSourceParameters) {
                this.alternateDataSourceParameters = alternateDataSourceParameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CredentialPairProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CredentialPairProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CredentialPairProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CredentialPairProperty {
            private final java.lang.String password;
            private final java.lang.String username;
            private final java.lang.Object alternateDataSourceParameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.password = software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.username = software.amazon.jsii.Kernel.get(this, "username", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.alternateDataSourceParameters = software.amazon.jsii.Kernel.get(this, "alternateDataSourceParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.password = java.util.Objects.requireNonNull(builder.password, "password is required");
                this.username = java.util.Objects.requireNonNull(builder.username, "username is required");
                this.alternateDataSourceParameters = builder.alternateDataSourceParameters;
            }

            @Override
            public final java.lang.String getPassword() {
                return this.password;
            }

            @Override
            public final java.lang.String getUsername() {
                return this.username;
            }

            @Override
            public final java.lang.Object getAlternateDataSourceParameters() {
                return this.alternateDataSourceParameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("password", om.valueToTree(this.getPassword()));
                data.set("username", om.valueToTree(this.getUsername()));
                if (this.getAlternateDataSourceParameters() != null) {
                    data.set("alternateDataSourceParameters", om.valueToTree(this.getAlternateDataSourceParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSource.CredentialPairProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CredentialPairProperty.Jsii$Proxy that = (CredentialPairProperty.Jsii$Proxy) o;

                if (!password.equals(that.password)) return false;
                if (!username.equals(that.username)) return false;
                return this.alternateDataSourceParameters != null ? this.alternateDataSourceParameters.equals(that.alternateDataSourceParameters) : that.alternateDataSourceParameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.password.hashCode();
                result = 31 * result + (this.username.hashCode());
                result = 31 * result + (this.alternateDataSourceParameters != null ? this.alternateDataSourceParameters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Data source credentials.
     * <p>
     * This is a variant type structure. For this structure to be valid, only one of the attributes can be non-null.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DataSourceCredentialsProperty dataSourceCredentialsProperty = DataSourceCredentialsProperty.builder()
     *         .copySourceArn("copySourceArn")
     *         .credentialPair(CredentialPairProperty.builder()
     *                 .password("password")
     *                 .username("username")
     *                 // the properties below are optional
     *                 .alternateDataSourceParameters(List.of(DataSourceParametersProperty.builder()
     *                         .amazonElasticsearchParameters(AmazonElasticsearchParametersProperty.builder()
     *                                 .domain("domain")
     *                                 .build())
     *                         .amazonOpenSearchParameters(AmazonOpenSearchParametersProperty.builder()
     *                                 .domain("domain")
     *                                 .build())
     *                         .athenaParameters(AthenaParametersProperty.builder()
     *                                 .roleArn("roleArn")
     *                                 .workGroup("workGroup")
     *                                 .build())
     *                         .auroraParameters(AuroraParametersProperty.builder()
     *                                 .database("database")
     *                                 .host("host")
     *                                 .port(123)
     *                                 .build())
     *                         .auroraPostgreSqlParameters(AuroraPostgreSqlParametersProperty.builder()
     *                                 .database("database")
     *                                 .host("host")
     *                                 .port(123)
     *                                 .build())
     *                         .databricksParameters(DatabricksParametersProperty.builder()
     *                                 .host("host")
     *                                 .port(123)
     *                                 .sqlEndpointPath("sqlEndpointPath")
     *                                 .build())
     *                         .mariaDbParameters(MariaDbParametersProperty.builder()
     *                                 .database("database")
     *                                 .host("host")
     *                                 .port(123)
     *                                 .build())
     *                         .mySqlParameters(MySqlParametersProperty.builder()
     *                                 .database("database")
     *                                 .host("host")
     *                                 .port(123)
     *                                 .build())
     *                         .oracleParameters(OracleParametersProperty.builder()
     *                                 .database("database")
     *                                 .host("host")
     *                                 .port(123)
     *                                 // the properties below are optional
     *                                 .useServiceName(false)
     *                                 .build())
     *                         .postgreSqlParameters(PostgreSqlParametersProperty.builder()
     *                                 .database("database")
     *                                 .host("host")
     *                                 .port(123)
     *                                 .build())
     *                         .prestoParameters(PrestoParametersProperty.builder()
     *                                 .catalog("catalog")
     *                                 .host("host")
     *                                 .port(123)
     *                                 .build())
     *                         .rdsParameters(RdsParametersProperty.builder()
     *                                 .database("database")
     *                                 .instanceId("instanceId")
     *                                 .build())
     *                         .redshiftParameters(RedshiftParametersProperty.builder()
     *                                 .database("database")
     *                                 // the properties below are optional
     *                                 .clusterId("clusterId")
     *                                 .host("host")
     *                                 .iamParameters(RedshiftIAMParametersProperty.builder()
     *                                         .roleArn("roleArn")
     *                                         // the properties below are optional
     *                                         .autoCreateDatabaseUser(false)
     *                                         .databaseGroups(List.of("databaseGroups"))
     *                                         .databaseUser("databaseUser")
     *                                         .build())
     *                                 .identityCenterConfiguration(IdentityCenterConfigurationProperty.builder()
     *                                         .enableIdentityPropagation(false)
     *                                         .build())
     *                                 .port(123)
     *                                 .build())
     *                         .s3Parameters(S3ParametersProperty.builder()
     *                                 .manifestFileLocation(ManifestFileLocationProperty.builder()
     *                                         .bucket("bucket")
     *                                         .key("key")
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .roleArn("roleArn")
     *                                 .build())
     *                         .snowflakeParameters(SnowflakeParametersProperty.builder()
     *                                 .database("database")
     *                                 .host("host")
     *                                 .warehouse("warehouse")
     *                                 // the properties below are optional
     *                                 .authenticationType("authenticationType")
     *                                 .databaseAccessControlRole("databaseAccessControlRole")
     *                                 .oAuthParameters(OAuthParametersProperty.builder()
     *                                         .tokenProviderUrl("tokenProviderUrl")
     *                                         // the properties below are optional
     *                                         .identityProviderResourceUri("identityProviderResourceUri")
     *                                         .identityProviderVpcConnectionProperties(VpcConnectionPropertiesProperty.builder()
     *                                                 .vpcConnectionArn("vpcConnectionArn")
     *                                                 .build())
     *                                         .oAuthScope("oAuthScope")
     *                                         .build())
     *                                 .build())
     *                         .sparkParameters(SparkParametersProperty.builder()
     *                                 .host("host")
     *                                 .port(123)
     *                                 .build())
     *                         .sqlServerParameters(SqlServerParametersProperty.builder()
     *                                 .database("database")
     *                                 .host("host")
     *                                 .port(123)
     *                                 .build())
     *                         .starburstParameters(StarburstParametersProperty.builder()
     *                                 .catalog("catalog")
     *                                 .host("host")
     *                                 .port(123)
     *                                 // the properties below are optional
     *                                 .authenticationType("authenticationType")
     *                                 .databaseAccessControlRole("databaseAccessControlRole")
     *                                 .oAuthParameters(OAuthParametersProperty.builder()
     *                                         .tokenProviderUrl("tokenProviderUrl")
     *                                         // the properties below are optional
     *                                         .identityProviderResourceUri("identityProviderResourceUri")
     *                                         .identityProviderVpcConnectionProperties(VpcConnectionPropertiesProperty.builder()
     *                                                 .vpcConnectionArn("vpcConnectionArn")
     *                                                 .build())
     *                                         .oAuthScope("oAuthScope")
     *                                         .build())
     *                                 .productType("productType")
     *                                 .build())
     *                         .teradataParameters(TeradataParametersProperty.builder()
     *                                 .database("database")
     *                                 .host("host")
     *                                 .port(123)
     *                                 .build())
     *                         .trinoParameters(TrinoParametersProperty.builder()
     *                                 .catalog("catalog")
     *                                 .host("host")
     *                                 .port(123)
     *                                 .build())
     *                         .build()))
     *                 .build())
     *         .secretArn("secretArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourcecredentials.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourcecredentials.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSource.DataSourceCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(DataSourceCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataSourceCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of a data source that has the credential pair that you want to use.
         * <p>
         * When <code>CopySourceArn</code> is not null, the credential pair from the data source in the ARN is used as the credentials for the <code>DataSourceCredentials</code> structure.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourcecredentials.html#cfn-quicksight-datasource-datasourcecredentials-copysourcearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourcecredentials.html#cfn-quicksight-datasource-datasourcecredentials-copysourcearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCopySourceArn() {
            return null;
        }

        /**
         * Credential pair.
         * <p>
         * For more information, see <code>[CredentialPair](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CredentialPair.html)</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourcecredentials.html#cfn-quicksight-datasource-datasourcecredentials-credentialpair">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourcecredentials.html#cfn-quicksight-datasource-datasourcecredentials-credentialpair</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCredentialPair() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the secret associated with the data source in AWS Secrets Manager .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourcecredentials.html#cfn-quicksight-datasource-datasourcecredentials-secretarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourcecredentials.html#cfn-quicksight-datasource-datasourcecredentials-secretarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataSourceCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataSourceCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataSourceCredentialsProperty> {
            java.lang.String copySourceArn;
            java.lang.Object credentialPair;
            java.lang.String secretArn;

            /**
             * Sets the value of {@link DataSourceCredentialsProperty#getCopySourceArn}
             * @param copySourceArn The Amazon Resource Name (ARN) of a data source that has the credential pair that you want to use.
             *                      When <code>CopySourceArn</code> is not null, the credential pair from the data source in the ARN is used as the credentials for the <code>DataSourceCredentials</code> structure.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copySourceArn(java.lang.String copySourceArn) {
                this.copySourceArn = copySourceArn;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceCredentialsProperty#getCredentialPair}
             * @param credentialPair Credential pair.
             *                       For more information, see <code>[CredentialPair](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CredentialPair.html)</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder credentialPair(software.amazon.awscdk.IResolvable credentialPair) {
                this.credentialPair = credentialPair;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceCredentialsProperty#getCredentialPair}
             * @param credentialPair Credential pair.
             *                       For more information, see <code>[CredentialPair](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CredentialPair.html)</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder credentialPair(software.amazon.awscdk.services.quicksight.CfnDataSource.CredentialPairProperty credentialPair) {
                this.credentialPair = credentialPair;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceCredentialsProperty#getSecretArn}
             * @param secretArn The Amazon Resource Name (ARN) of the secret associated with the data source in AWS Secrets Manager .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretArn(java.lang.String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataSourceCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataSourceCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataSourceCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataSourceCredentialsProperty {
            private final java.lang.String copySourceArn;
            private final java.lang.Object credentialPair;
            private final java.lang.String secretArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.copySourceArn = software.amazon.jsii.Kernel.get(this, "copySourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.credentialPair = software.amazon.jsii.Kernel.get(this, "credentialPair", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.secretArn = software.amazon.jsii.Kernel.get(this, "secretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.copySourceArn = builder.copySourceArn;
                this.credentialPair = builder.credentialPair;
                this.secretArn = builder.secretArn;
            }

            @Override
            public final java.lang.String getCopySourceArn() {
                return this.copySourceArn;
            }

            @Override
            public final java.lang.Object getCredentialPair() {
                return this.credentialPair;
            }

            @Override
            public final java.lang.String getSecretArn() {
                return this.secretArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCopySourceArn() != null) {
                    data.set("copySourceArn", om.valueToTree(this.getCopySourceArn()));
                }
                if (this.getCredentialPair() != null) {
                    data.set("credentialPair", om.valueToTree(this.getCredentialPair()));
                }
                if (this.getSecretArn() != null) {
                    data.set("secretArn", om.valueToTree(this.getSecretArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSource.DataSourceCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataSourceCredentialsProperty.Jsii$Proxy that = (DataSourceCredentialsProperty.Jsii$Proxy) o;

                if (this.copySourceArn != null ? !this.copySourceArn.equals(that.copySourceArn) : that.copySourceArn != null) return false;
                if (this.credentialPair != null ? !this.credentialPair.equals(that.credentialPair) : that.credentialPair != null) return false;
                return this.secretArn != null ? this.secretArn.equals(that.secretArn) : that.secretArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.copySourceArn != null ? this.copySourceArn.hashCode() : 0;
                result = 31 * result + (this.credentialPair != null ? this.credentialPair.hashCode() : 0);
                result = 31 * result + (this.secretArn != null ? this.secretArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Error information for the data source creation or update.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DataSourceErrorInfoProperty dataSourceErrorInfoProperty = DataSourceErrorInfoProperty.builder()
     *         .message("message")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceerrorinfo.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceerrorinfo.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSource.DataSourceErrorInfoProperty")
    @software.amazon.jsii.Jsii.Proxy(DataSourceErrorInfoProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataSourceErrorInfoProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Error message.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceerrorinfo.html#cfn-quicksight-datasource-datasourceerrorinfo-message">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceerrorinfo.html#cfn-quicksight-datasource-datasourceerrorinfo-message</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMessage() {
            return null;
        }

        /**
         * Error type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceerrorinfo.html#cfn-quicksight-datasource-datasourceerrorinfo-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceerrorinfo.html#cfn-quicksight-datasource-datasourceerrorinfo-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataSourceErrorInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataSourceErrorInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataSourceErrorInfoProperty> {
            java.lang.String message;
            java.lang.String type;

            /**
             * Sets the value of {@link DataSourceErrorInfoProperty#getMessage}
             * @param message Error message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder message(java.lang.String message) {
                this.message = message;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceErrorInfoProperty#getType}
             * @param type Error type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataSourceErrorInfoProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataSourceErrorInfoProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataSourceErrorInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataSourceErrorInfoProperty {
            private final java.lang.String message;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.message = software.amazon.jsii.Kernel.get(this, "message", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.message = builder.message;
                this.type = builder.type;
            }

            @Override
            public final java.lang.String getMessage() {
                return this.message;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMessage() != null) {
                    data.set("message", om.valueToTree(this.getMessage()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSource.DataSourceErrorInfoProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataSourceErrorInfoProperty.Jsii$Proxy that = (DataSourceErrorInfoProperty.Jsii$Proxy) o;

                if (this.message != null ? !this.message.equals(that.message) : that.message != null) return false;
                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.message != null ? this.message.hashCode() : 0;
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The parameters that Amazon QuickSight uses to connect to your underlying data source.
     * <p>
     * This is a variant type structure. For this structure to be valid, only one of the attributes can be non-null.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DataSourceParametersProperty dataSourceParametersProperty = DataSourceParametersProperty.builder()
     *         .amazonElasticsearchParameters(AmazonElasticsearchParametersProperty.builder()
     *                 .domain("domain")
     *                 .build())
     *         .amazonOpenSearchParameters(AmazonOpenSearchParametersProperty.builder()
     *                 .domain("domain")
     *                 .build())
     *         .athenaParameters(AthenaParametersProperty.builder()
     *                 .roleArn("roleArn")
     *                 .workGroup("workGroup")
     *                 .build())
     *         .auroraParameters(AuroraParametersProperty.builder()
     *                 .database("database")
     *                 .host("host")
     *                 .port(123)
     *                 .build())
     *         .auroraPostgreSqlParameters(AuroraPostgreSqlParametersProperty.builder()
     *                 .database("database")
     *                 .host("host")
     *                 .port(123)
     *                 .build())
     *         .databricksParameters(DatabricksParametersProperty.builder()
     *                 .host("host")
     *                 .port(123)
     *                 .sqlEndpointPath("sqlEndpointPath")
     *                 .build())
     *         .mariaDbParameters(MariaDbParametersProperty.builder()
     *                 .database("database")
     *                 .host("host")
     *                 .port(123)
     *                 .build())
     *         .mySqlParameters(MySqlParametersProperty.builder()
     *                 .database("database")
     *                 .host("host")
     *                 .port(123)
     *                 .build())
     *         .oracleParameters(OracleParametersProperty.builder()
     *                 .database("database")
     *                 .host("host")
     *                 .port(123)
     *                 // the properties below are optional
     *                 .useServiceName(false)
     *                 .build())
     *         .postgreSqlParameters(PostgreSqlParametersProperty.builder()
     *                 .database("database")
     *                 .host("host")
     *                 .port(123)
     *                 .build())
     *         .prestoParameters(PrestoParametersProperty.builder()
     *                 .catalog("catalog")
     *                 .host("host")
     *                 .port(123)
     *                 .build())
     *         .rdsParameters(RdsParametersProperty.builder()
     *                 .database("database")
     *                 .instanceId("instanceId")
     *                 .build())
     *         .redshiftParameters(RedshiftParametersProperty.builder()
     *                 .database("database")
     *                 // the properties below are optional
     *                 .clusterId("clusterId")
     *                 .host("host")
     *                 .iamParameters(RedshiftIAMParametersProperty.builder()
     *                         .roleArn("roleArn")
     *                         // the properties below are optional
     *                         .autoCreateDatabaseUser(false)
     *                         .databaseGroups(List.of("databaseGroups"))
     *                         .databaseUser("databaseUser")
     *                         .build())
     *                 .identityCenterConfiguration(IdentityCenterConfigurationProperty.builder()
     *                         .enableIdentityPropagation(false)
     *                         .build())
     *                 .port(123)
     *                 .build())
     *         .s3Parameters(S3ParametersProperty.builder()
     *                 .manifestFileLocation(ManifestFileLocationProperty.builder()
     *                         .bucket("bucket")
     *                         .key("key")
     *                         .build())
     *                 // the properties below are optional
     *                 .roleArn("roleArn")
     *                 .build())
     *         .snowflakeParameters(SnowflakeParametersProperty.builder()
     *                 .database("database")
     *                 .host("host")
     *                 .warehouse("warehouse")
     *                 // the properties below are optional
     *                 .authenticationType("authenticationType")
     *                 .databaseAccessControlRole("databaseAccessControlRole")
     *                 .oAuthParameters(OAuthParametersProperty.builder()
     *                         .tokenProviderUrl("tokenProviderUrl")
     *                         // the properties below are optional
     *                         .identityProviderResourceUri("identityProviderResourceUri")
     *                         .identityProviderVpcConnectionProperties(VpcConnectionPropertiesProperty.builder()
     *                                 .vpcConnectionArn("vpcConnectionArn")
     *                                 .build())
     *                         .oAuthScope("oAuthScope")
     *                         .build())
     *                 .build())
     *         .sparkParameters(SparkParametersProperty.builder()
     *                 .host("host")
     *                 .port(123)
     *                 .build())
     *         .sqlServerParameters(SqlServerParametersProperty.builder()
     *                 .database("database")
     *                 .host("host")
     *                 .port(123)
     *                 .build())
     *         .starburstParameters(StarburstParametersProperty.builder()
     *                 .catalog("catalog")
     *                 .host("host")
     *                 .port(123)
     *                 // the properties below are optional
     *                 .authenticationType("authenticationType")
     *                 .databaseAccessControlRole("databaseAccessControlRole")
     *                 .oAuthParameters(OAuthParametersProperty.builder()
     *                         .tokenProviderUrl("tokenProviderUrl")
     *                         // the properties below are optional
     *                         .identityProviderResourceUri("identityProviderResourceUri")
     *                         .identityProviderVpcConnectionProperties(VpcConnectionPropertiesProperty.builder()
     *                                 .vpcConnectionArn("vpcConnectionArn")
     *                                 .build())
     *                         .oAuthScope("oAuthScope")
     *                         .build())
     *                 .productType("productType")
     *                 .build())
     *         .teradataParameters(TeradataParametersProperty.builder()
     *                 .database("database")
     *                 .host("host")
     *                 .port(123)
     *                 .build())
     *         .trinoParameters(TrinoParametersProperty.builder()
     *                 .catalog("catalog")
     *                 .host("host")
     *                 .port(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSource.DataSourceParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(DataSourceParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataSourceParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The parameters for OpenSearch.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-amazonelasticsearchparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-amazonelasticsearchparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAmazonElasticsearchParameters() {
            return null;
        }

        /**
         * The parameters for OpenSearch.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-amazonopensearchparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-amazonopensearchparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAmazonOpenSearchParameters() {
            return null;
        }

        /**
         * The parameters for Amazon Athena.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-athenaparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-athenaparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAthenaParameters() {
            return null;
        }

        /**
         * The parameters for Amazon Aurora MySQL.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-auroraparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-auroraparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAuroraParameters() {
            return null;
        }

        /**
         * The parameters for Amazon Aurora.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-aurorapostgresqlparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-aurorapostgresqlparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAuroraPostgreSqlParameters() {
            return null;
        }

        /**
         * The required parameters that are needed to connect to a Databricks data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-databricksparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-databricksparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDatabricksParameters() {
            return null;
        }

        /**
         * The parameters for MariaDB.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-mariadbparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-mariadbparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMariaDbParameters() {
            return null;
        }

        /**
         * The parameters for MySQL.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-mysqlparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-mysqlparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMySqlParameters() {
            return null;
        }

        /**
         * Oracle parameters.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-oracleparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-oracleparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOracleParameters() {
            return null;
        }

        /**
         * The parameters for PostgreSQL.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-postgresqlparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-postgresqlparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPostgreSqlParameters() {
            return null;
        }

        /**
         * The parameters for Presto.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-prestoparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-prestoparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPrestoParameters() {
            return null;
        }

        /**
         * The parameters for Amazon RDS.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-rdsparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-rdsparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRdsParameters() {
            return null;
        }

        /**
         * The parameters for Amazon Redshift.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-redshiftparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-redshiftparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRedshiftParameters() {
            return null;
        }

        /**
         * The parameters for S3.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-s3parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-s3parameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3Parameters() {
            return null;
        }

        /**
         * The parameters for Snowflake.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-snowflakeparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-snowflakeparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSnowflakeParameters() {
            return null;
        }

        /**
         * The parameters for Spark.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-sparkparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-sparkparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSparkParameters() {
            return null;
        }

        /**
         * The parameters for SQL Server.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-sqlserverparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-sqlserverparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSqlServerParameters() {
            return null;
        }

        /**
         * The parameters that are required to connect to a Starburst data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-starburstparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-starburstparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStarburstParameters() {
            return null;
        }

        /**
         * The parameters for Teradata.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-teradataparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-teradataparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTeradataParameters() {
            return null;
        }

        /**
         * The parameters that are required to connect to a Trino data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-trinoparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html#cfn-quicksight-datasource-datasourceparameters-trinoparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTrinoParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataSourceParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataSourceParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataSourceParametersProperty> {
            java.lang.Object amazonElasticsearchParameters;
            java.lang.Object amazonOpenSearchParameters;
            java.lang.Object athenaParameters;
            java.lang.Object auroraParameters;
            java.lang.Object auroraPostgreSqlParameters;
            java.lang.Object databricksParameters;
            java.lang.Object mariaDbParameters;
            java.lang.Object mySqlParameters;
            java.lang.Object oracleParameters;
            java.lang.Object postgreSqlParameters;
            java.lang.Object prestoParameters;
            java.lang.Object rdsParameters;
            java.lang.Object redshiftParameters;
            java.lang.Object s3Parameters;
            java.lang.Object snowflakeParameters;
            java.lang.Object sparkParameters;
            java.lang.Object sqlServerParameters;
            java.lang.Object starburstParameters;
            java.lang.Object teradataParameters;
            java.lang.Object trinoParameters;

            /**
             * Sets the value of {@link DataSourceParametersProperty#getAmazonElasticsearchParameters}
             * @param amazonElasticsearchParameters The parameters for OpenSearch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder amazonElasticsearchParameters(software.amazon.awscdk.IResolvable amazonElasticsearchParameters) {
                this.amazonElasticsearchParameters = amazonElasticsearchParameters;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceParametersProperty#getAmazonElasticsearchParameters}
             * @param amazonElasticsearchParameters The parameters for OpenSearch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder amazonElasticsearchParameters(software.amazon.awscdk.services.quicksight.CfnDataSource.AmazonElasticsearchParametersProperty amazonElasticsearchParameters) {
                this.amazonElasticsearchParameters = amazonElasticsearchParameters;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceParametersProperty#getAmazonOpenSearchParameters}
             * @param amazonOpenSearchParameters The parameters for OpenSearch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder amazonOpenSearchParameters(software.amazon.awscdk.IResolvable amazonOpenSearchParameters) {
                this.amazonOpenSearchParameters = amazonOpenSearchParameters;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceParametersProperty#getAmazonOpenSearchParameters}
             * @param amazonOpenSearchParameters The parameters for OpenSearch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder amazonOpenSearchParameters(software.amazon.awscdk.services.quicksight.CfnDataSource.AmazonOpenSearchParametersProperty amazonOpenSearchParameters) {
                this.amazonOpenSearchParameters = amazonOpenSearchParameters;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceParametersProperty#getAthenaParameters}
             * @param athenaParameters The parameters for Amazon Athena.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder athenaParameters(software.amazon.awscdk.IResolvable athenaParameters) {
                this.athenaParameters = athenaParameters;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceParametersProperty#getAthenaParameters}
             * @param athenaParameters The parameters for Amazon Athena.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder athenaParameters(software.amazon.awscdk.services.quicksight.CfnDataSource.AthenaParametersProperty athenaParameters) {
                this.athenaParameters = athenaParameters;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceParametersProperty#getAuroraParameters}
             * @param auroraParameters The parameters for Amazon Aurora MySQL.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder auroraParameters(software.amazon.awscdk.IResolvable auroraParameters) {
                this.auroraParameters = auroraParameters;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceParametersProperty#getAuroraParameters}
             * @param auroraParameters The parameters for Amazon Aurora MySQL.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder auroraParameters(software.amazon.awscdk.services.quicksight.CfnDataSource.AuroraParametersProperty auroraParameters) {
                this.auroraParameters = auroraParameters;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceParametersProperty#getAuroraPostgreSqlParameters}
             * @param auroraPostgreSqlParameters The parameters for Amazon Aurora.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder auroraPostgreSqlParameters(software.amazon.awscdk.IResolvable auroraPostgreSqlParameters) {
                this.auroraPostgreSqlParameters = auroraPostgreSqlParameters;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceParametersProperty#getAuroraPostgreSqlParameters}
             * @param auroraPostgreSqlParameters The parameters for Amazon Aurora.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder auroraPostgreSqlParameters(software.amazon.awscdk.services.quicksight.CfnDataSource.AuroraPostgreSqlParametersProperty auroraPostgreSqlParameters) {
                this.auroraPostgreSqlParameters = auroraPostgreSqlParameters;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceParametersProperty#getDatabricksParameters}
             * @param databricksParameters The required parameters that are needed to connect to a Databricks data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databricksParameters(software.amazon.awscdk.IResolvable databricksParameters) {
                this.databricksParameters = databricksParameters;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceParametersProperty#getDatabricksParameters}
             * @param databricksParameters The required parameters that are needed to connect to a Databricks data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databricksParameters(software.amazon.awscdk.services.quicksight.CfnDataSource.DatabricksParametersProperty databricksParameters) {
                this.databricksParameters = databricksParameters;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceParametersProperty#getMariaDbParameters}
             * @param mariaDbParameters The parameters for MariaDB.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mariaDbParameters(software.amazon.awscdk.IResolvable mariaDbParameters) {
                this.mariaDbParameters = mariaDbParameters;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceParametersProperty#getMariaDbParameters}
             * @param mariaDbParameters The parameters for MariaDB.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mariaDbParameters(software.amazon.awscdk.services.quicksight.CfnDataSource.MariaDbParametersProperty mariaDbParameters) {
                this.mariaDbParameters = mariaDbParameters;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceParametersProperty#getMySqlParameters}
             * @param mySqlParameters The parameters for MySQL.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mySqlParameters(software.amazon.awscdk.IResolvable mySqlParameters) {
                this.mySqlParameters = mySqlParameters;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceParametersProperty#getMySqlParameters}
             * @param mySqlParameters The parameters for MySQL.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mySqlParameters(software.amazon.awscdk.services.quicksight.CfnDataSource.MySqlParametersProperty mySqlParameters) {
                this.mySqlParameters = mySqlParameters;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceParametersProperty#getOracleParameters}
             * @param oracleParameters Oracle parameters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oracleParameters(software.amazon.awscdk.IResolvable oracleParameters) {
                this.oracleParameters = oracleParameters;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceParametersProperty#getOracleParameters}
             * @param oracleParameters Oracle parameters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oracleParameters(software.amazon.awscdk.services.quicksight.CfnDataSource.OracleParametersProperty oracleParameters) {
                this.oracleParameters = oracleParameters;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceParametersProperty#getPostgreSqlParameters}
             * @param postgreSqlParameters The parameters for PostgreSQL.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder postgreSqlParameters(software.amazon.awscdk.IResolvable postgreSqlParameters) {
                this.postgreSqlParameters = postgreSqlParameters;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceParametersProperty#getPostgreSqlParameters}
             * @param postgreSqlParameters The parameters for PostgreSQL.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder postgreSqlParameters(software.amazon.awscdk.services.quicksight.CfnDataSource.PostgreSqlParametersProperty postgreSqlParameters) {
                this.postgreSqlParameters = postgreSqlParameters;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceParametersProperty#getPrestoParameters}
             * @param prestoParameters The parameters for Presto.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prestoParameters(software.amazon.awscdk.IResolvable prestoParameters) {
                this.prestoParameters = prestoParameters;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceParametersProperty#getPrestoParameters}
             * @param prestoParameters The parameters for Presto.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prestoParameters(software.amazon.awscdk.services.quicksight.CfnDataSource.PrestoParametersProperty prestoParameters) {
                this.prestoParameters = prestoParameters;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceParametersProperty#getRdsParameters}
             * @param rdsParameters The parameters for Amazon RDS.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rdsParameters(software.amazon.awscdk.IResolvable rdsParameters) {
                this.rdsParameters = rdsParameters;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceParametersProperty#getRdsParameters}
             * @param rdsParameters The parameters for Amazon RDS.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rdsParameters(software.amazon.awscdk.services.quicksight.CfnDataSource.RdsParametersProperty rdsParameters) {
                this.rdsParameters = rdsParameters;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceParametersProperty#getRedshiftParameters}
             * @param redshiftParameters The parameters for Amazon Redshift.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redshiftParameters(software.amazon.awscdk.IResolvable redshiftParameters) {
                this.redshiftParameters = redshiftParameters;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceParametersProperty#getRedshiftParameters}
             * @param redshiftParameters The parameters for Amazon Redshift.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redshiftParameters(software.amazon.awscdk.services.quicksight.CfnDataSource.RedshiftParametersProperty redshiftParameters) {
                this.redshiftParameters = redshiftParameters;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceParametersProperty#getS3Parameters}
             * @param s3Parameters The parameters for S3.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Parameters(software.amazon.awscdk.IResolvable s3Parameters) {
                this.s3Parameters = s3Parameters;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceParametersProperty#getS3Parameters}
             * @param s3Parameters The parameters for S3.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Parameters(software.amazon.awscdk.services.quicksight.CfnDataSource.S3ParametersProperty s3Parameters) {
                this.s3Parameters = s3Parameters;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceParametersProperty#getSnowflakeParameters}
             * @param snowflakeParameters The parameters for Snowflake.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snowflakeParameters(software.amazon.awscdk.IResolvable snowflakeParameters) {
                this.snowflakeParameters = snowflakeParameters;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceParametersProperty#getSnowflakeParameters}
             * @param snowflakeParameters The parameters for Snowflake.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snowflakeParameters(software.amazon.awscdk.services.quicksight.CfnDataSource.SnowflakeParametersProperty snowflakeParameters) {
                this.snowflakeParameters = snowflakeParameters;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceParametersProperty#getSparkParameters}
             * @param sparkParameters The parameters for Spark.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sparkParameters(software.amazon.awscdk.IResolvable sparkParameters) {
                this.sparkParameters = sparkParameters;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceParametersProperty#getSparkParameters}
             * @param sparkParameters The parameters for Spark.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sparkParameters(software.amazon.awscdk.services.quicksight.CfnDataSource.SparkParametersProperty sparkParameters) {
                this.sparkParameters = sparkParameters;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceParametersProperty#getSqlServerParameters}
             * @param sqlServerParameters The parameters for SQL Server.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqlServerParameters(software.amazon.awscdk.IResolvable sqlServerParameters) {
                this.sqlServerParameters = sqlServerParameters;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceParametersProperty#getSqlServerParameters}
             * @param sqlServerParameters The parameters for SQL Server.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqlServerParameters(software.amazon.awscdk.services.quicksight.CfnDataSource.SqlServerParametersProperty sqlServerParameters) {
                this.sqlServerParameters = sqlServerParameters;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceParametersProperty#getStarburstParameters}
             * @param starburstParameters The parameters that are required to connect to a Starburst data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder starburstParameters(software.amazon.awscdk.IResolvable starburstParameters) {
                this.starburstParameters = starburstParameters;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceParametersProperty#getStarburstParameters}
             * @param starburstParameters The parameters that are required to connect to a Starburst data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder starburstParameters(software.amazon.awscdk.services.quicksight.CfnDataSource.StarburstParametersProperty starburstParameters) {
                this.starburstParameters = starburstParameters;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceParametersProperty#getTeradataParameters}
             * @param teradataParameters The parameters for Teradata.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder teradataParameters(software.amazon.awscdk.IResolvable teradataParameters) {
                this.teradataParameters = teradataParameters;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceParametersProperty#getTeradataParameters}
             * @param teradataParameters The parameters for Teradata.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder teradataParameters(software.amazon.awscdk.services.quicksight.CfnDataSource.TeradataParametersProperty teradataParameters) {
                this.teradataParameters = teradataParameters;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceParametersProperty#getTrinoParameters}
             * @param trinoParameters The parameters that are required to connect to a Trino data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trinoParameters(software.amazon.awscdk.IResolvable trinoParameters) {
                this.trinoParameters = trinoParameters;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceParametersProperty#getTrinoParameters}
             * @param trinoParameters The parameters that are required to connect to a Trino data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trinoParameters(software.amazon.awscdk.services.quicksight.CfnDataSource.TrinoParametersProperty trinoParameters) {
                this.trinoParameters = trinoParameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataSourceParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataSourceParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataSourceParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataSourceParametersProperty {
            private final java.lang.Object amazonElasticsearchParameters;
            private final java.lang.Object amazonOpenSearchParameters;
            private final java.lang.Object athenaParameters;
            private final java.lang.Object auroraParameters;
            private final java.lang.Object auroraPostgreSqlParameters;
            private final java.lang.Object databricksParameters;
            private final java.lang.Object mariaDbParameters;
            private final java.lang.Object mySqlParameters;
            private final java.lang.Object oracleParameters;
            private final java.lang.Object postgreSqlParameters;
            private final java.lang.Object prestoParameters;
            private final java.lang.Object rdsParameters;
            private final java.lang.Object redshiftParameters;
            private final java.lang.Object s3Parameters;
            private final java.lang.Object snowflakeParameters;
            private final java.lang.Object sparkParameters;
            private final java.lang.Object sqlServerParameters;
            private final java.lang.Object starburstParameters;
            private final java.lang.Object teradataParameters;
            private final java.lang.Object trinoParameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.amazonElasticsearchParameters = software.amazon.jsii.Kernel.get(this, "amazonElasticsearchParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.amazonOpenSearchParameters = software.amazon.jsii.Kernel.get(this, "amazonOpenSearchParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.athenaParameters = software.amazon.jsii.Kernel.get(this, "athenaParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.auroraParameters = software.amazon.jsii.Kernel.get(this, "auroraParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.auroraPostgreSqlParameters = software.amazon.jsii.Kernel.get(this, "auroraPostgreSqlParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.databricksParameters = software.amazon.jsii.Kernel.get(this, "databricksParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.mariaDbParameters = software.amazon.jsii.Kernel.get(this, "mariaDbParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.mySqlParameters = software.amazon.jsii.Kernel.get(this, "mySqlParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.oracleParameters = software.amazon.jsii.Kernel.get(this, "oracleParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.postgreSqlParameters = software.amazon.jsii.Kernel.get(this, "postgreSqlParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.prestoParameters = software.amazon.jsii.Kernel.get(this, "prestoParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rdsParameters = software.amazon.jsii.Kernel.get(this, "rdsParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.redshiftParameters = software.amazon.jsii.Kernel.get(this, "redshiftParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3Parameters = software.amazon.jsii.Kernel.get(this, "s3Parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.snowflakeParameters = software.amazon.jsii.Kernel.get(this, "snowflakeParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sparkParameters = software.amazon.jsii.Kernel.get(this, "sparkParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sqlServerParameters = software.amazon.jsii.Kernel.get(this, "sqlServerParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.starburstParameters = software.amazon.jsii.Kernel.get(this, "starburstParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.teradataParameters = software.amazon.jsii.Kernel.get(this, "teradataParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.trinoParameters = software.amazon.jsii.Kernel.get(this, "trinoParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.amazonElasticsearchParameters = builder.amazonElasticsearchParameters;
                this.amazonOpenSearchParameters = builder.amazonOpenSearchParameters;
                this.athenaParameters = builder.athenaParameters;
                this.auroraParameters = builder.auroraParameters;
                this.auroraPostgreSqlParameters = builder.auroraPostgreSqlParameters;
                this.databricksParameters = builder.databricksParameters;
                this.mariaDbParameters = builder.mariaDbParameters;
                this.mySqlParameters = builder.mySqlParameters;
                this.oracleParameters = builder.oracleParameters;
                this.postgreSqlParameters = builder.postgreSqlParameters;
                this.prestoParameters = builder.prestoParameters;
                this.rdsParameters = builder.rdsParameters;
                this.redshiftParameters = builder.redshiftParameters;
                this.s3Parameters = builder.s3Parameters;
                this.snowflakeParameters = builder.snowflakeParameters;
                this.sparkParameters = builder.sparkParameters;
                this.sqlServerParameters = builder.sqlServerParameters;
                this.starburstParameters = builder.starburstParameters;
                this.teradataParameters = builder.teradataParameters;
                this.trinoParameters = builder.trinoParameters;
            }

            @Override
            public final java.lang.Object getAmazonElasticsearchParameters() {
                return this.amazonElasticsearchParameters;
            }

            @Override
            public final java.lang.Object getAmazonOpenSearchParameters() {
                return this.amazonOpenSearchParameters;
            }

            @Override
            public final java.lang.Object getAthenaParameters() {
                return this.athenaParameters;
            }

            @Override
            public final java.lang.Object getAuroraParameters() {
                return this.auroraParameters;
            }

            @Override
            public final java.lang.Object getAuroraPostgreSqlParameters() {
                return this.auroraPostgreSqlParameters;
            }

            @Override
            public final java.lang.Object getDatabricksParameters() {
                return this.databricksParameters;
            }

            @Override
            public final java.lang.Object getMariaDbParameters() {
                return this.mariaDbParameters;
            }

            @Override
            public final java.lang.Object getMySqlParameters() {
                return this.mySqlParameters;
            }

            @Override
            public final java.lang.Object getOracleParameters() {
                return this.oracleParameters;
            }

            @Override
            public final java.lang.Object getPostgreSqlParameters() {
                return this.postgreSqlParameters;
            }

            @Override
            public final java.lang.Object getPrestoParameters() {
                return this.prestoParameters;
            }

            @Override
            public final java.lang.Object getRdsParameters() {
                return this.rdsParameters;
            }

            @Override
            public final java.lang.Object getRedshiftParameters() {
                return this.redshiftParameters;
            }

            @Override
            public final java.lang.Object getS3Parameters() {
                return this.s3Parameters;
            }

            @Override
            public final java.lang.Object getSnowflakeParameters() {
                return this.snowflakeParameters;
            }

            @Override
            public final java.lang.Object getSparkParameters() {
                return this.sparkParameters;
            }

            @Override
            public final java.lang.Object getSqlServerParameters() {
                return this.sqlServerParameters;
            }

            @Override
            public final java.lang.Object getStarburstParameters() {
                return this.starburstParameters;
            }

            @Override
            public final java.lang.Object getTeradataParameters() {
                return this.teradataParameters;
            }

            @Override
            public final java.lang.Object getTrinoParameters() {
                return this.trinoParameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAmazonElasticsearchParameters() != null) {
                    data.set("amazonElasticsearchParameters", om.valueToTree(this.getAmazonElasticsearchParameters()));
                }
                if (this.getAmazonOpenSearchParameters() != null) {
                    data.set("amazonOpenSearchParameters", om.valueToTree(this.getAmazonOpenSearchParameters()));
                }
                if (this.getAthenaParameters() != null) {
                    data.set("athenaParameters", om.valueToTree(this.getAthenaParameters()));
                }
                if (this.getAuroraParameters() != null) {
                    data.set("auroraParameters", om.valueToTree(this.getAuroraParameters()));
                }
                if (this.getAuroraPostgreSqlParameters() != null) {
                    data.set("auroraPostgreSqlParameters", om.valueToTree(this.getAuroraPostgreSqlParameters()));
                }
                if (this.getDatabricksParameters() != null) {
                    data.set("databricksParameters", om.valueToTree(this.getDatabricksParameters()));
                }
                if (this.getMariaDbParameters() != null) {
                    data.set("mariaDbParameters", om.valueToTree(this.getMariaDbParameters()));
                }
                if (this.getMySqlParameters() != null) {
                    data.set("mySqlParameters", om.valueToTree(this.getMySqlParameters()));
                }
                if (this.getOracleParameters() != null) {
                    data.set("oracleParameters", om.valueToTree(this.getOracleParameters()));
                }
                if (this.getPostgreSqlParameters() != null) {
                    data.set("postgreSqlParameters", om.valueToTree(this.getPostgreSqlParameters()));
                }
                if (this.getPrestoParameters() != null) {
                    data.set("prestoParameters", om.valueToTree(this.getPrestoParameters()));
                }
                if (this.getRdsParameters() != null) {
                    data.set("rdsParameters", om.valueToTree(this.getRdsParameters()));
                }
                if (this.getRedshiftParameters() != null) {
                    data.set("redshiftParameters", om.valueToTree(this.getRedshiftParameters()));
                }
                if (this.getS3Parameters() != null) {
                    data.set("s3Parameters", om.valueToTree(this.getS3Parameters()));
                }
                if (this.getSnowflakeParameters() != null) {
                    data.set("snowflakeParameters", om.valueToTree(this.getSnowflakeParameters()));
                }
                if (this.getSparkParameters() != null) {
                    data.set("sparkParameters", om.valueToTree(this.getSparkParameters()));
                }
                if (this.getSqlServerParameters() != null) {
                    data.set("sqlServerParameters", om.valueToTree(this.getSqlServerParameters()));
                }
                if (this.getStarburstParameters() != null) {
                    data.set("starburstParameters", om.valueToTree(this.getStarburstParameters()));
                }
                if (this.getTeradataParameters() != null) {
                    data.set("teradataParameters", om.valueToTree(this.getTeradataParameters()));
                }
                if (this.getTrinoParameters() != null) {
                    data.set("trinoParameters", om.valueToTree(this.getTrinoParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSource.DataSourceParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataSourceParametersProperty.Jsii$Proxy that = (DataSourceParametersProperty.Jsii$Proxy) o;

                if (this.amazonElasticsearchParameters != null ? !this.amazonElasticsearchParameters.equals(that.amazonElasticsearchParameters) : that.amazonElasticsearchParameters != null) return false;
                if (this.amazonOpenSearchParameters != null ? !this.amazonOpenSearchParameters.equals(that.amazonOpenSearchParameters) : that.amazonOpenSearchParameters != null) return false;
                if (this.athenaParameters != null ? !this.athenaParameters.equals(that.athenaParameters) : that.athenaParameters != null) return false;
                if (this.auroraParameters != null ? !this.auroraParameters.equals(that.auroraParameters) : that.auroraParameters != null) return false;
                if (this.auroraPostgreSqlParameters != null ? !this.auroraPostgreSqlParameters.equals(that.auroraPostgreSqlParameters) : that.auroraPostgreSqlParameters != null) return false;
                if (this.databricksParameters != null ? !this.databricksParameters.equals(that.databricksParameters) : that.databricksParameters != null) return false;
                if (this.mariaDbParameters != null ? !this.mariaDbParameters.equals(that.mariaDbParameters) : that.mariaDbParameters != null) return false;
                if (this.mySqlParameters != null ? !this.mySqlParameters.equals(that.mySqlParameters) : that.mySqlParameters != null) return false;
                if (this.oracleParameters != null ? !this.oracleParameters.equals(that.oracleParameters) : that.oracleParameters != null) return false;
                if (this.postgreSqlParameters != null ? !this.postgreSqlParameters.equals(that.postgreSqlParameters) : that.postgreSqlParameters != null) return false;
                if (this.prestoParameters != null ? !this.prestoParameters.equals(that.prestoParameters) : that.prestoParameters != null) return false;
                if (this.rdsParameters != null ? !this.rdsParameters.equals(that.rdsParameters) : that.rdsParameters != null) return false;
                if (this.redshiftParameters != null ? !this.redshiftParameters.equals(that.redshiftParameters) : that.redshiftParameters != null) return false;
                if (this.s3Parameters != null ? !this.s3Parameters.equals(that.s3Parameters) : that.s3Parameters != null) return false;
                if (this.snowflakeParameters != null ? !this.snowflakeParameters.equals(that.snowflakeParameters) : that.snowflakeParameters != null) return false;
                if (this.sparkParameters != null ? !this.sparkParameters.equals(that.sparkParameters) : that.sparkParameters != null) return false;
                if (this.sqlServerParameters != null ? !this.sqlServerParameters.equals(that.sqlServerParameters) : that.sqlServerParameters != null) return false;
                if (this.starburstParameters != null ? !this.starburstParameters.equals(that.starburstParameters) : that.starburstParameters != null) return false;
                if (this.teradataParameters != null ? !this.teradataParameters.equals(that.teradataParameters) : that.teradataParameters != null) return false;
                return this.trinoParameters != null ? this.trinoParameters.equals(that.trinoParameters) : that.trinoParameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.amazonElasticsearchParameters != null ? this.amazonElasticsearchParameters.hashCode() : 0;
                result = 31 * result + (this.amazonOpenSearchParameters != null ? this.amazonOpenSearchParameters.hashCode() : 0);
                result = 31 * result + (this.athenaParameters != null ? this.athenaParameters.hashCode() : 0);
                result = 31 * result + (this.auroraParameters != null ? this.auroraParameters.hashCode() : 0);
                result = 31 * result + (this.auroraPostgreSqlParameters != null ? this.auroraPostgreSqlParameters.hashCode() : 0);
                result = 31 * result + (this.databricksParameters != null ? this.databricksParameters.hashCode() : 0);
                result = 31 * result + (this.mariaDbParameters != null ? this.mariaDbParameters.hashCode() : 0);
                result = 31 * result + (this.mySqlParameters != null ? this.mySqlParameters.hashCode() : 0);
                result = 31 * result + (this.oracleParameters != null ? this.oracleParameters.hashCode() : 0);
                result = 31 * result + (this.postgreSqlParameters != null ? this.postgreSqlParameters.hashCode() : 0);
                result = 31 * result + (this.prestoParameters != null ? this.prestoParameters.hashCode() : 0);
                result = 31 * result + (this.rdsParameters != null ? this.rdsParameters.hashCode() : 0);
                result = 31 * result + (this.redshiftParameters != null ? this.redshiftParameters.hashCode() : 0);
                result = 31 * result + (this.s3Parameters != null ? this.s3Parameters.hashCode() : 0);
                result = 31 * result + (this.snowflakeParameters != null ? this.snowflakeParameters.hashCode() : 0);
                result = 31 * result + (this.sparkParameters != null ? this.sparkParameters.hashCode() : 0);
                result = 31 * result + (this.sqlServerParameters != null ? this.sqlServerParameters.hashCode() : 0);
                result = 31 * result + (this.starburstParameters != null ? this.starburstParameters.hashCode() : 0);
                result = 31 * result + (this.teradataParameters != null ? this.teradataParameters.hashCode() : 0);
                result = 31 * result + (this.trinoParameters != null ? this.trinoParameters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The required parameters that are needed to connect to a Databricks data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DatabricksParametersProperty databricksParametersProperty = DatabricksParametersProperty.builder()
     *         .host("host")
     *         .port(123)
     *         .sqlEndpointPath("sqlEndpointPath")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-databricksparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-databricksparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSource.DatabricksParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(DatabricksParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DatabricksParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The host name of the Databricks data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-databricksparameters.html#cfn-quicksight-datasource-databricksparameters-host">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-databricksparameters.html#cfn-quicksight-datasource-databricksparameters-host</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHost();

        /**
         * The port for the Databricks data source.
         * <p>
         * Default: - 0
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-databricksparameters.html#cfn-quicksight-datasource-databricksparameters-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-databricksparameters.html#cfn-quicksight-datasource-databricksparameters-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPort();

        /**
         * The HTTP path of the Databricks data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-databricksparameters.html#cfn-quicksight-datasource-databricksparameters-sqlendpointpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-databricksparameters.html#cfn-quicksight-datasource-databricksparameters-sqlendpointpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSqlEndpointPath();

        /**
         * @return a {@link Builder} of {@link DatabricksParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DatabricksParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DatabricksParametersProperty> {
            java.lang.String host;
            java.lang.Number port;
            java.lang.String sqlEndpointPath;

            /**
             * Sets the value of {@link DatabricksParametersProperty#getHost}
             * @param host The host name of the Databricks data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder host(java.lang.String host) {
                this.host = host;
                return this;
            }

            /**
             * Sets the value of {@link DatabricksParametersProperty#getPort}
             * @param port The port for the Databricks data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link DatabricksParametersProperty#getSqlEndpointPath}
             * @param sqlEndpointPath The HTTP path of the Databricks data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqlEndpointPath(java.lang.String sqlEndpointPath) {
                this.sqlEndpointPath = sqlEndpointPath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DatabricksParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DatabricksParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DatabricksParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatabricksParametersProperty {
            private final java.lang.String host;
            private final java.lang.Number port;
            private final java.lang.String sqlEndpointPath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.host = software.amazon.jsii.Kernel.get(this, "host", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.sqlEndpointPath = software.amazon.jsii.Kernel.get(this, "sqlEndpointPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.host = java.util.Objects.requireNonNull(builder.host, "host is required");
                this.port = java.util.Objects.requireNonNull(builder.port, "port is required");
                this.sqlEndpointPath = java.util.Objects.requireNonNull(builder.sqlEndpointPath, "sqlEndpointPath is required");
            }

            @Override
            public final java.lang.String getHost() {
                return this.host;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            public final java.lang.String getSqlEndpointPath() {
                return this.sqlEndpointPath;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("host", om.valueToTree(this.getHost()));
                data.set("port", om.valueToTree(this.getPort()));
                data.set("sqlEndpointPath", om.valueToTree(this.getSqlEndpointPath()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSource.DatabricksParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DatabricksParametersProperty.Jsii$Proxy that = (DatabricksParametersProperty.Jsii$Proxy) o;

                if (!host.equals(that.host)) return false;
                if (!port.equals(that.port)) return false;
                return this.sqlEndpointPath.equals(that.sqlEndpointPath);
            }

            @Override
            public final int hashCode() {
                int result = this.host.hashCode();
                result = 31 * result + (this.port.hashCode());
                result = 31 * result + (this.sqlEndpointPath.hashCode());
                return result;
            }
        }
    }
    /**
     * The parameters for an IAM Identity Center configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * IdentityCenterConfigurationProperty identityCenterConfigurationProperty = IdentityCenterConfigurationProperty.builder()
     *         .enableIdentityPropagation(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-identitycenterconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-identitycenterconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSource.IdentityCenterConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(IdentityCenterConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IdentityCenterConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A Boolean option that controls whether Trusted Identity Propagation should be used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-identitycenterconfiguration.html#cfn-quicksight-datasource-identitycenterconfiguration-enableidentitypropagation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-identitycenterconfiguration.html#cfn-quicksight-datasource-identitycenterconfiguration-enableidentitypropagation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableIdentityPropagation() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IdentityCenterConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IdentityCenterConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IdentityCenterConfigurationProperty> {
            java.lang.Object enableIdentityPropagation;

            /**
             * Sets the value of {@link IdentityCenterConfigurationProperty#getEnableIdentityPropagation}
             * @param enableIdentityPropagation A Boolean option that controls whether Trusted Identity Propagation should be used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableIdentityPropagation(java.lang.Boolean enableIdentityPropagation) {
                this.enableIdentityPropagation = enableIdentityPropagation;
                return this;
            }

            /**
             * Sets the value of {@link IdentityCenterConfigurationProperty#getEnableIdentityPropagation}
             * @param enableIdentityPropagation A Boolean option that controls whether Trusted Identity Propagation should be used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableIdentityPropagation(software.amazon.awscdk.IResolvable enableIdentityPropagation) {
                this.enableIdentityPropagation = enableIdentityPropagation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IdentityCenterConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IdentityCenterConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IdentityCenterConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IdentityCenterConfigurationProperty {
            private final java.lang.Object enableIdentityPropagation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enableIdentityPropagation = software.amazon.jsii.Kernel.get(this, "enableIdentityPropagation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enableIdentityPropagation = builder.enableIdentityPropagation;
            }

            @Override
            public final java.lang.Object getEnableIdentityPropagation() {
                return this.enableIdentityPropagation;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnableIdentityPropagation() != null) {
                    data.set("enableIdentityPropagation", om.valueToTree(this.getEnableIdentityPropagation()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSource.IdentityCenterConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IdentityCenterConfigurationProperty.Jsii$Proxy that = (IdentityCenterConfigurationProperty.Jsii$Proxy) o;

                return this.enableIdentityPropagation != null ? this.enableIdentityPropagation.equals(that.enableIdentityPropagation) : that.enableIdentityPropagation == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enableIdentityPropagation != null ? this.enableIdentityPropagation.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Amazon S3 manifest file location.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ManifestFileLocationProperty manifestFileLocationProperty = ManifestFileLocationProperty.builder()
     *         .bucket("bucket")
     *         .key("key")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-manifestfilelocation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-manifestfilelocation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSource.ManifestFileLocationProperty")
    @software.amazon.jsii.Jsii.Proxy(ManifestFileLocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ManifestFileLocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Amazon S3 bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-manifestfilelocation.html#cfn-quicksight-datasource-manifestfilelocation-bucket">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-manifestfilelocation.html#cfn-quicksight-datasource-manifestfilelocation-bucket</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucket();

        /**
         * Amazon S3 key that identifies an object.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-manifestfilelocation.html#cfn-quicksight-datasource-manifestfilelocation-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-manifestfilelocation.html#cfn-quicksight-datasource-manifestfilelocation-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * @return a {@link Builder} of {@link ManifestFileLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ManifestFileLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ManifestFileLocationProperty> {
            java.lang.String bucket;
            java.lang.String key;

            /**
             * Sets the value of {@link ManifestFileLocationProperty#getBucket}
             * @param bucket Amazon S3 bucket. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of {@link ManifestFileLocationProperty#getKey}
             * @param key Amazon S3 key that identifies an object. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ManifestFileLocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ManifestFileLocationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ManifestFileLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ManifestFileLocationProperty {
            private final java.lang.String bucket;
            private final java.lang.String key;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucket = java.util.Objects.requireNonNull(builder.bucket, "bucket is required");
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
            }

            @Override
            public final java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucket", om.valueToTree(this.getBucket()));
                data.set("key", om.valueToTree(this.getKey()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSource.ManifestFileLocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ManifestFileLocationProperty.Jsii$Proxy that = (ManifestFileLocationProperty.Jsii$Proxy) o;

                if (!bucket.equals(that.bucket)) return false;
                return this.key.equals(that.key);
            }

            @Override
            public final int hashCode() {
                int result = this.bucket.hashCode();
                result = 31 * result + (this.key.hashCode());
                return result;
            }
        }
    }
    /**
     * The parameters for MariaDB.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * MariaDbParametersProperty mariaDbParametersProperty = MariaDbParametersProperty.builder()
     *         .database("database")
     *         .host("host")
     *         .port(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-mariadbparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-mariadbparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSource.MariaDbParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(MariaDbParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MariaDbParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-mariadbparameters.html#cfn-quicksight-datasource-mariadbparameters-database">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-mariadbparameters.html#cfn-quicksight-datasource-mariadbparameters-database</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabase();

        /**
         * Host.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-mariadbparameters.html#cfn-quicksight-datasource-mariadbparameters-host">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-mariadbparameters.html#cfn-quicksight-datasource-mariadbparameters-host</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHost();

        /**
         * Port.
         * <p>
         * Default: - 0
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-mariadbparameters.html#cfn-quicksight-datasource-mariadbparameters-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-mariadbparameters.html#cfn-quicksight-datasource-mariadbparameters-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPort();

        /**
         * @return a {@link Builder} of {@link MariaDbParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MariaDbParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MariaDbParametersProperty> {
            java.lang.String database;
            java.lang.String host;
            java.lang.Number port;

            /**
             * Sets the value of {@link MariaDbParametersProperty#getDatabase}
             * @param database Database. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder database(java.lang.String database) {
                this.database = database;
                return this;
            }

            /**
             * Sets the value of {@link MariaDbParametersProperty#getHost}
             * @param host Host. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder host(java.lang.String host) {
                this.host = host;
                return this;
            }

            /**
             * Sets the value of {@link MariaDbParametersProperty#getPort}
             * @param port Port. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MariaDbParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MariaDbParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MariaDbParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MariaDbParametersProperty {
            private final java.lang.String database;
            private final java.lang.String host;
            private final java.lang.Number port;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.database = software.amazon.jsii.Kernel.get(this, "database", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.host = software.amazon.jsii.Kernel.get(this, "host", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.database = java.util.Objects.requireNonNull(builder.database, "database is required");
                this.host = java.util.Objects.requireNonNull(builder.host, "host is required");
                this.port = java.util.Objects.requireNonNull(builder.port, "port is required");
            }

            @Override
            public final java.lang.String getDatabase() {
                return this.database;
            }

            @Override
            public final java.lang.String getHost() {
                return this.host;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("database", om.valueToTree(this.getDatabase()));
                data.set("host", om.valueToTree(this.getHost()));
                data.set("port", om.valueToTree(this.getPort()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSource.MariaDbParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MariaDbParametersProperty.Jsii$Proxy that = (MariaDbParametersProperty.Jsii$Proxy) o;

                if (!database.equals(that.database)) return false;
                if (!host.equals(that.host)) return false;
                return this.port.equals(that.port);
            }

            @Override
            public final int hashCode() {
                int result = this.database.hashCode();
                result = 31 * result + (this.host.hashCode());
                result = 31 * result + (this.port.hashCode());
                return result;
            }
        }
    }
    /**
     * The parameters for MySQL.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * MySqlParametersProperty mySqlParametersProperty = MySqlParametersProperty.builder()
     *         .database("database")
     *         .host("host")
     *         .port(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-mysqlparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-mysqlparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSource.MySqlParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(MySqlParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MySqlParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-mysqlparameters.html#cfn-quicksight-datasource-mysqlparameters-database">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-mysqlparameters.html#cfn-quicksight-datasource-mysqlparameters-database</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabase();

        /**
         * Host.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-mysqlparameters.html#cfn-quicksight-datasource-mysqlparameters-host">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-mysqlparameters.html#cfn-quicksight-datasource-mysqlparameters-host</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHost();

        /**
         * Port.
         * <p>
         * Default: - 0
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-mysqlparameters.html#cfn-quicksight-datasource-mysqlparameters-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-mysqlparameters.html#cfn-quicksight-datasource-mysqlparameters-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPort();

        /**
         * @return a {@link Builder} of {@link MySqlParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MySqlParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MySqlParametersProperty> {
            java.lang.String database;
            java.lang.String host;
            java.lang.Number port;

            /**
             * Sets the value of {@link MySqlParametersProperty#getDatabase}
             * @param database Database. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder database(java.lang.String database) {
                this.database = database;
                return this;
            }

            /**
             * Sets the value of {@link MySqlParametersProperty#getHost}
             * @param host Host. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder host(java.lang.String host) {
                this.host = host;
                return this;
            }

            /**
             * Sets the value of {@link MySqlParametersProperty#getPort}
             * @param port Port. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MySqlParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MySqlParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MySqlParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MySqlParametersProperty {
            private final java.lang.String database;
            private final java.lang.String host;
            private final java.lang.Number port;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.database = software.amazon.jsii.Kernel.get(this, "database", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.host = software.amazon.jsii.Kernel.get(this, "host", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.database = java.util.Objects.requireNonNull(builder.database, "database is required");
                this.host = java.util.Objects.requireNonNull(builder.host, "host is required");
                this.port = java.util.Objects.requireNonNull(builder.port, "port is required");
            }

            @Override
            public final java.lang.String getDatabase() {
                return this.database;
            }

            @Override
            public final java.lang.String getHost() {
                return this.host;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("database", om.valueToTree(this.getDatabase()));
                data.set("host", om.valueToTree(this.getHost()));
                data.set("port", om.valueToTree(this.getPort()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSource.MySqlParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MySqlParametersProperty.Jsii$Proxy that = (MySqlParametersProperty.Jsii$Proxy) o;

                if (!database.equals(that.database)) return false;
                if (!host.equals(that.host)) return false;
                return this.port.equals(that.port);
            }

            @Override
            public final int hashCode() {
                int result = this.database.hashCode();
                result = 31 * result + (this.host.hashCode());
                result = 31 * result + (this.port.hashCode());
                return result;
            }
        }
    }
    /**
     * An object that contains information needed to create a data source connection that uses OAuth client credentials.
     * <p>
     * This option is available for data source connections that are made with Snowflake and Starburst.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * OAuthParametersProperty oAuthParametersProperty = OAuthParametersProperty.builder()
     *         .tokenProviderUrl("tokenProviderUrl")
     *         // the properties below are optional
     *         .identityProviderResourceUri("identityProviderResourceUri")
     *         .identityProviderVpcConnectionProperties(VpcConnectionPropertiesProperty.builder()
     *                 .vpcConnectionArn("vpcConnectionArn")
     *                 .build())
     *         .oAuthScope("oAuthScope")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-oauthparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-oauthparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSource.OAuthParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(OAuthParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OAuthParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The token endpoint URL of the identity provider.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-oauthparameters.html#cfn-quicksight-datasource-oauthparameters-tokenproviderurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-oauthparameters.html#cfn-quicksight-datasource-oauthparameters-tokenproviderurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTokenProviderUrl();

        /**
         * The resource uri of the identity provider.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-oauthparameters.html#cfn-quicksight-datasource-oauthparameters-identityproviderresourceuri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-oauthparameters.html#cfn-quicksight-datasource-oauthparameters-identityproviderresourceuri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIdentityProviderResourceUri() {
            return null;
        }

        /**
         * <p>VPC connection properties.</p>.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-oauthparameters.html#cfn-quicksight-datasource-oauthparameters-identityprovidervpcconnectionproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-oauthparameters.html#cfn-quicksight-datasource-oauthparameters-identityprovidervpcconnectionproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIdentityProviderVpcConnectionProperties() {
            return null;
        }

        /**
         * The OAuth scope.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-oauthparameters.html#cfn-quicksight-datasource-oauthparameters-oauthscope">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-oauthparameters.html#cfn-quicksight-datasource-oauthparameters-oauthscope</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOAuthScope() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OAuthParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OAuthParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OAuthParametersProperty> {
            java.lang.String tokenProviderUrl;
            java.lang.String identityProviderResourceUri;
            java.lang.Object identityProviderVpcConnectionProperties;
            java.lang.String oAuthScope;

            /**
             * Sets the value of {@link OAuthParametersProperty#getTokenProviderUrl}
             * @param tokenProviderUrl The token endpoint URL of the identity provider. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tokenProviderUrl(java.lang.String tokenProviderUrl) {
                this.tokenProviderUrl = tokenProviderUrl;
                return this;
            }

            /**
             * Sets the value of {@link OAuthParametersProperty#getIdentityProviderResourceUri}
             * @param identityProviderResourceUri The resource uri of the identity provider.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder identityProviderResourceUri(java.lang.String identityProviderResourceUri) {
                this.identityProviderResourceUri = identityProviderResourceUri;
                return this;
            }

            /**
             * Sets the value of {@link OAuthParametersProperty#getIdentityProviderVpcConnectionProperties}
             * @param identityProviderVpcConnectionProperties <p>VPC connection properties.</p>.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder identityProviderVpcConnectionProperties(software.amazon.awscdk.IResolvable identityProviderVpcConnectionProperties) {
                this.identityProviderVpcConnectionProperties = identityProviderVpcConnectionProperties;
                return this;
            }

            /**
             * Sets the value of {@link OAuthParametersProperty#getIdentityProviderVpcConnectionProperties}
             * @param identityProviderVpcConnectionProperties <p>VPC connection properties.</p>.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder identityProviderVpcConnectionProperties(software.amazon.awscdk.services.quicksight.CfnDataSource.VpcConnectionPropertiesProperty identityProviderVpcConnectionProperties) {
                this.identityProviderVpcConnectionProperties = identityProviderVpcConnectionProperties;
                return this;
            }

            /**
             * Sets the value of {@link OAuthParametersProperty#getOAuthScope}
             * @param oAuthScope The OAuth scope.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oAuthScope(java.lang.String oAuthScope) {
                this.oAuthScope = oAuthScope;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OAuthParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OAuthParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OAuthParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OAuthParametersProperty {
            private final java.lang.String tokenProviderUrl;
            private final java.lang.String identityProviderResourceUri;
            private final java.lang.Object identityProviderVpcConnectionProperties;
            private final java.lang.String oAuthScope;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.tokenProviderUrl = software.amazon.jsii.Kernel.get(this, "tokenProviderUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.identityProviderResourceUri = software.amazon.jsii.Kernel.get(this, "identityProviderResourceUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.identityProviderVpcConnectionProperties = software.amazon.jsii.Kernel.get(this, "identityProviderVpcConnectionProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.oAuthScope = software.amazon.jsii.Kernel.get(this, "oAuthScope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.tokenProviderUrl = java.util.Objects.requireNonNull(builder.tokenProviderUrl, "tokenProviderUrl is required");
                this.identityProviderResourceUri = builder.identityProviderResourceUri;
                this.identityProviderVpcConnectionProperties = builder.identityProviderVpcConnectionProperties;
                this.oAuthScope = builder.oAuthScope;
            }

            @Override
            public final java.lang.String getTokenProviderUrl() {
                return this.tokenProviderUrl;
            }

            @Override
            public final java.lang.String getIdentityProviderResourceUri() {
                return this.identityProviderResourceUri;
            }

            @Override
            public final java.lang.Object getIdentityProviderVpcConnectionProperties() {
                return this.identityProviderVpcConnectionProperties;
            }

            @Override
            public final java.lang.String getOAuthScope() {
                return this.oAuthScope;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("tokenProviderUrl", om.valueToTree(this.getTokenProviderUrl()));
                if (this.getIdentityProviderResourceUri() != null) {
                    data.set("identityProviderResourceUri", om.valueToTree(this.getIdentityProviderResourceUri()));
                }
                if (this.getIdentityProviderVpcConnectionProperties() != null) {
                    data.set("identityProviderVpcConnectionProperties", om.valueToTree(this.getIdentityProviderVpcConnectionProperties()));
                }
                if (this.getOAuthScope() != null) {
                    data.set("oAuthScope", om.valueToTree(this.getOAuthScope()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSource.OAuthParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OAuthParametersProperty.Jsii$Proxy that = (OAuthParametersProperty.Jsii$Proxy) o;

                if (!tokenProviderUrl.equals(that.tokenProviderUrl)) return false;
                if (this.identityProviderResourceUri != null ? !this.identityProviderResourceUri.equals(that.identityProviderResourceUri) : that.identityProviderResourceUri != null) return false;
                if (this.identityProviderVpcConnectionProperties != null ? !this.identityProviderVpcConnectionProperties.equals(that.identityProviderVpcConnectionProperties) : that.identityProviderVpcConnectionProperties != null) return false;
                return this.oAuthScope != null ? this.oAuthScope.equals(that.oAuthScope) : that.oAuthScope == null;
            }

            @Override
            public final int hashCode() {
                int result = this.tokenProviderUrl.hashCode();
                result = 31 * result + (this.identityProviderResourceUri != null ? this.identityProviderResourceUri.hashCode() : 0);
                result = 31 * result + (this.identityProviderVpcConnectionProperties != null ? this.identityProviderVpcConnectionProperties.hashCode() : 0);
                result = 31 * result + (this.oAuthScope != null ? this.oAuthScope.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Oracle parameters.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * OracleParametersProperty oracleParametersProperty = OracleParametersProperty.builder()
     *         .database("database")
     *         .host("host")
     *         .port(123)
     *         // the properties below are optional
     *         .useServiceName(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-oracleparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-oracleparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSource.OracleParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(OracleParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OracleParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-oracleparameters.html#cfn-quicksight-datasource-oracleparameters-database">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-oracleparameters.html#cfn-quicksight-datasource-oracleparameters-database</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabase();

        /**
         * Host.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-oracleparameters.html#cfn-quicksight-datasource-oracleparameters-host">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-oracleparameters.html#cfn-quicksight-datasource-oracleparameters-host</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHost();

        /**
         * Port.
         * <p>
         * Default: - 0
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-oracleparameters.html#cfn-quicksight-datasource-oracleparameters-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-oracleparameters.html#cfn-quicksight-datasource-oracleparameters-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPort();

        /**
         * Default: - false
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-oracleparameters.html#cfn-quicksight-datasource-oracleparameters-useservicename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-oracleparameters.html#cfn-quicksight-datasource-oracleparameters-useservicename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUseServiceName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OracleParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OracleParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OracleParametersProperty> {
            java.lang.String database;
            java.lang.String host;
            java.lang.Number port;
            java.lang.Object useServiceName;

            /**
             * Sets the value of {@link OracleParametersProperty#getDatabase}
             * @param database Database. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder database(java.lang.String database) {
                this.database = database;
                return this;
            }

            /**
             * Sets the value of {@link OracleParametersProperty#getHost}
             * @param host Host. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder host(java.lang.String host) {
                this.host = host;
                return this;
            }

            /**
             * Sets the value of {@link OracleParametersProperty#getPort}
             * @param port Port. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link OracleParametersProperty#getUseServiceName}
             * @param useServiceName the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useServiceName(java.lang.Boolean useServiceName) {
                this.useServiceName = useServiceName;
                return this;
            }

            /**
             * Sets the value of {@link OracleParametersProperty#getUseServiceName}
             * @param useServiceName the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useServiceName(software.amazon.awscdk.IResolvable useServiceName) {
                this.useServiceName = useServiceName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OracleParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OracleParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OracleParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OracleParametersProperty {
            private final java.lang.String database;
            private final java.lang.String host;
            private final java.lang.Number port;
            private final java.lang.Object useServiceName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.database = software.amazon.jsii.Kernel.get(this, "database", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.host = software.amazon.jsii.Kernel.get(this, "host", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.useServiceName = software.amazon.jsii.Kernel.get(this, "useServiceName", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.database = java.util.Objects.requireNonNull(builder.database, "database is required");
                this.host = java.util.Objects.requireNonNull(builder.host, "host is required");
                this.port = java.util.Objects.requireNonNull(builder.port, "port is required");
                this.useServiceName = builder.useServiceName;
            }

            @Override
            public final java.lang.String getDatabase() {
                return this.database;
            }

            @Override
            public final java.lang.String getHost() {
                return this.host;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            public final java.lang.Object getUseServiceName() {
                return this.useServiceName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("database", om.valueToTree(this.getDatabase()));
                data.set("host", om.valueToTree(this.getHost()));
                data.set("port", om.valueToTree(this.getPort()));
                if (this.getUseServiceName() != null) {
                    data.set("useServiceName", om.valueToTree(this.getUseServiceName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSource.OracleParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OracleParametersProperty.Jsii$Proxy that = (OracleParametersProperty.Jsii$Proxy) o;

                if (!database.equals(that.database)) return false;
                if (!host.equals(that.host)) return false;
                if (!port.equals(that.port)) return false;
                return this.useServiceName != null ? this.useServiceName.equals(that.useServiceName) : that.useServiceName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.database.hashCode();
                result = 31 * result + (this.host.hashCode());
                result = 31 * result + (this.port.hashCode());
                result = 31 * result + (this.useServiceName != null ? this.useServiceName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The parameters for PostgreSQL.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * PostgreSqlParametersProperty postgreSqlParametersProperty = PostgreSqlParametersProperty.builder()
     *         .database("database")
     *         .host("host")
     *         .port(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-postgresqlparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-postgresqlparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSource.PostgreSqlParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(PostgreSqlParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PostgreSqlParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-postgresqlparameters.html#cfn-quicksight-datasource-postgresqlparameters-database">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-postgresqlparameters.html#cfn-quicksight-datasource-postgresqlparameters-database</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabase();

        /**
         * Host.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-postgresqlparameters.html#cfn-quicksight-datasource-postgresqlparameters-host">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-postgresqlparameters.html#cfn-quicksight-datasource-postgresqlparameters-host</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHost();

        /**
         * Port.
         * <p>
         * Default: - 0
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-postgresqlparameters.html#cfn-quicksight-datasource-postgresqlparameters-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-postgresqlparameters.html#cfn-quicksight-datasource-postgresqlparameters-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPort();

        /**
         * @return a {@link Builder} of {@link PostgreSqlParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PostgreSqlParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PostgreSqlParametersProperty> {
            java.lang.String database;
            java.lang.String host;
            java.lang.Number port;

            /**
             * Sets the value of {@link PostgreSqlParametersProperty#getDatabase}
             * @param database Database. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder database(java.lang.String database) {
                this.database = database;
                return this;
            }

            /**
             * Sets the value of {@link PostgreSqlParametersProperty#getHost}
             * @param host Host. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder host(java.lang.String host) {
                this.host = host;
                return this;
            }

            /**
             * Sets the value of {@link PostgreSqlParametersProperty#getPort}
             * @param port Port. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PostgreSqlParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PostgreSqlParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PostgreSqlParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PostgreSqlParametersProperty {
            private final java.lang.String database;
            private final java.lang.String host;
            private final java.lang.Number port;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.database = software.amazon.jsii.Kernel.get(this, "database", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.host = software.amazon.jsii.Kernel.get(this, "host", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.database = java.util.Objects.requireNonNull(builder.database, "database is required");
                this.host = java.util.Objects.requireNonNull(builder.host, "host is required");
                this.port = java.util.Objects.requireNonNull(builder.port, "port is required");
            }

            @Override
            public final java.lang.String getDatabase() {
                return this.database;
            }

            @Override
            public final java.lang.String getHost() {
                return this.host;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("database", om.valueToTree(this.getDatabase()));
                data.set("host", om.valueToTree(this.getHost()));
                data.set("port", om.valueToTree(this.getPort()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSource.PostgreSqlParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PostgreSqlParametersProperty.Jsii$Proxy that = (PostgreSqlParametersProperty.Jsii$Proxy) o;

                if (!database.equals(that.database)) return false;
                if (!host.equals(that.host)) return false;
                return this.port.equals(that.port);
            }

            @Override
            public final int hashCode() {
                int result = this.database.hashCode();
                result = 31 * result + (this.host.hashCode());
                result = 31 * result + (this.port.hashCode());
                return result;
            }
        }
    }
    /**
     * The parameters for Presto.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * PrestoParametersProperty prestoParametersProperty = PrestoParametersProperty.builder()
     *         .catalog("catalog")
     *         .host("host")
     *         .port(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-prestoparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-prestoparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSource.PrestoParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(PrestoParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PrestoParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Catalog.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-prestoparameters.html#cfn-quicksight-datasource-prestoparameters-catalog">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-prestoparameters.html#cfn-quicksight-datasource-prestoparameters-catalog</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCatalog();

        /**
         * Host.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-prestoparameters.html#cfn-quicksight-datasource-prestoparameters-host">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-prestoparameters.html#cfn-quicksight-datasource-prestoparameters-host</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHost();

        /**
         * Port.
         * <p>
         * Default: - 0
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-prestoparameters.html#cfn-quicksight-datasource-prestoparameters-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-prestoparameters.html#cfn-quicksight-datasource-prestoparameters-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPort();

        /**
         * @return a {@link Builder} of {@link PrestoParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PrestoParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PrestoParametersProperty> {
            java.lang.String catalog;
            java.lang.String host;
            java.lang.Number port;

            /**
             * Sets the value of {@link PrestoParametersProperty#getCatalog}
             * @param catalog Catalog. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder catalog(java.lang.String catalog) {
                this.catalog = catalog;
                return this;
            }

            /**
             * Sets the value of {@link PrestoParametersProperty#getHost}
             * @param host Host. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder host(java.lang.String host) {
                this.host = host;
                return this;
            }

            /**
             * Sets the value of {@link PrestoParametersProperty#getPort}
             * @param port Port. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PrestoParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PrestoParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PrestoParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PrestoParametersProperty {
            private final java.lang.String catalog;
            private final java.lang.String host;
            private final java.lang.Number port;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.catalog = software.amazon.jsii.Kernel.get(this, "catalog", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.host = software.amazon.jsii.Kernel.get(this, "host", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.catalog = java.util.Objects.requireNonNull(builder.catalog, "catalog is required");
                this.host = java.util.Objects.requireNonNull(builder.host, "host is required");
                this.port = java.util.Objects.requireNonNull(builder.port, "port is required");
            }

            @Override
            public final java.lang.String getCatalog() {
                return this.catalog;
            }

            @Override
            public final java.lang.String getHost() {
                return this.host;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("catalog", om.valueToTree(this.getCatalog()));
                data.set("host", om.valueToTree(this.getHost()));
                data.set("port", om.valueToTree(this.getPort()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSource.PrestoParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PrestoParametersProperty.Jsii$Proxy that = (PrestoParametersProperty.Jsii$Proxy) o;

                if (!catalog.equals(that.catalog)) return false;
                if (!host.equals(that.host)) return false;
                return this.port.equals(that.port);
            }

            @Override
            public final int hashCode() {
                int result = this.catalog.hashCode();
                result = 31 * result + (this.host.hashCode());
                result = 31 * result + (this.port.hashCode());
                return result;
            }
        }
    }
    /**
     * The parameters for Amazon RDS.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * RdsParametersProperty rdsParametersProperty = RdsParametersProperty.builder()
     *         .database("database")
     *         .instanceId("instanceId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-rdsparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-rdsparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSource.RdsParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(RdsParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RdsParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-rdsparameters.html#cfn-quicksight-datasource-rdsparameters-database">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-rdsparameters.html#cfn-quicksight-datasource-rdsparameters-database</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabase();

        /**
         * Instance ID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-rdsparameters.html#cfn-quicksight-datasource-rdsparameters-instanceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-rdsparameters.html#cfn-quicksight-datasource-rdsparameters-instanceid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInstanceId();

        /**
         * @return a {@link Builder} of {@link RdsParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RdsParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RdsParametersProperty> {
            java.lang.String database;
            java.lang.String instanceId;

            /**
             * Sets the value of {@link RdsParametersProperty#getDatabase}
             * @param database Database. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder database(java.lang.String database) {
                this.database = database;
                return this;
            }

            /**
             * Sets the value of {@link RdsParametersProperty#getInstanceId}
             * @param instanceId Instance ID. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceId(java.lang.String instanceId) {
                this.instanceId = instanceId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RdsParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RdsParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RdsParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RdsParametersProperty {
            private final java.lang.String database;
            private final java.lang.String instanceId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.database = software.amazon.jsii.Kernel.get(this, "database", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instanceId = software.amazon.jsii.Kernel.get(this, "instanceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.database = java.util.Objects.requireNonNull(builder.database, "database is required");
                this.instanceId = java.util.Objects.requireNonNull(builder.instanceId, "instanceId is required");
            }

            @Override
            public final java.lang.String getDatabase() {
                return this.database;
            }

            @Override
            public final java.lang.String getInstanceId() {
                return this.instanceId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("database", om.valueToTree(this.getDatabase()));
                data.set("instanceId", om.valueToTree(this.getInstanceId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSource.RdsParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RdsParametersProperty.Jsii$Proxy that = (RdsParametersProperty.Jsii$Proxy) o;

                if (!database.equals(that.database)) return false;
                return this.instanceId.equals(that.instanceId);
            }

            @Override
            public final int hashCode() {
                int result = this.database.hashCode();
                result = 31 * result + (this.instanceId.hashCode());
                return result;
            }
        }
    }
    /**
     * A structure that grants Amazon QuickSight access to your cluster and make a call to the <code>redshift:GetClusterCredentials</code> API.
     * <p>
     * For more information on the <code>redshift:GetClusterCredentials</code> API, see <a href="https://docs.aws.amazon.com/redshift/latest/APIReference/API_GetClusterCredentials.html"><code>GetClusterCredentials</code></a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * RedshiftIAMParametersProperty redshiftIAMParametersProperty = RedshiftIAMParametersProperty.builder()
     *         .roleArn("roleArn")
     *         // the properties below are optional
     *         .autoCreateDatabaseUser(false)
     *         .databaseGroups(List.of("databaseGroups"))
     *         .databaseUser("databaseUser")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-redshiftiamparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-redshiftiamparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSource.RedshiftIAMParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(RedshiftIAMParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedshiftIAMParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Use the <code>RoleArn</code> structure to allow Amazon QuickSight to call <code>redshift:GetClusterCredentials</code> on your cluster.
         * <p>
         * The calling principal must have <code>iam:PassRole</code> access to pass the role to Amazon QuickSight. The role's trust policy must allow the Amazon QuickSight service principal to assume the role.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-redshiftiamparameters.html#cfn-quicksight-datasource-redshiftiamparameters-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-redshiftiamparameters.html#cfn-quicksight-datasource-redshiftiamparameters-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * Automatically creates a database user.
         * <p>
         * If your database doesn't have a <code>DatabaseUser</code> , set this parameter to <code>True</code> . If there is no <code>DatabaseUser</code> , Amazon QuickSight can't connect to your cluster. The <code>RoleArn</code> that you use for this operation must grant access to <code>redshift:CreateClusterUser</code> to successfully create the user.
         * <p>
         * Default: - false
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-redshiftiamparameters.html#cfn-quicksight-datasource-redshiftiamparameters-autocreatedatabaseuser">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-redshiftiamparameters.html#cfn-quicksight-datasource-redshiftiamparameters-autocreatedatabaseuser</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutoCreateDatabaseUser() {
            return null;
        }

        /**
         * A list of groups whose permissions will be granted to Amazon QuickSight to access the cluster.
         * <p>
         * These permissions are combined with the permissions granted to Amazon QuickSight by the <code>DatabaseUser</code> . If you choose to include this parameter, the <code>RoleArn</code> must grant access to <code>redshift:JoinGroup</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-redshiftiamparameters.html#cfn-quicksight-datasource-redshiftiamparameters-databasegroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-redshiftiamparameters.html#cfn-quicksight-datasource-redshiftiamparameters-databasegroups</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDatabaseGroups() {
            return null;
        }

        /**
         * The user whose permissions and group memberships will be used by Amazon QuickSight to access the cluster.
         * <p>
         * If this user already exists in your database, Amazon QuickSight is granted the same permissions that the user has. If the user doesn't exist, set the value of <code>AutoCreateDatabaseUser</code> to <code>True</code> to create a new user with PUBLIC permissions.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-redshiftiamparameters.html#cfn-quicksight-datasource-redshiftiamparameters-databaseuser">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-redshiftiamparameters.html#cfn-quicksight-datasource-redshiftiamparameters-databaseuser</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDatabaseUser() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RedshiftIAMParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedshiftIAMParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedshiftIAMParametersProperty> {
            java.lang.String roleArn;
            java.lang.Object autoCreateDatabaseUser;
            java.util.List<java.lang.String> databaseGroups;
            java.lang.String databaseUser;

            /**
             * Sets the value of {@link RedshiftIAMParametersProperty#getRoleArn}
             * @param roleArn Use the <code>RoleArn</code> structure to allow Amazon QuickSight to call <code>redshift:GetClusterCredentials</code> on your cluster. This parameter is required.
             *                The calling principal must have <code>iam:PassRole</code> access to pass the role to Amazon QuickSight. The role's trust policy must allow the Amazon QuickSight service principal to assume the role.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftIAMParametersProperty#getAutoCreateDatabaseUser}
             * @param autoCreateDatabaseUser Automatically creates a database user.
             *                               If your database doesn't have a <code>DatabaseUser</code> , set this parameter to <code>True</code> . If there is no <code>DatabaseUser</code> , Amazon QuickSight can't connect to your cluster. The <code>RoleArn</code> that you use for this operation must grant access to <code>redshift:CreateClusterUser</code> to successfully create the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoCreateDatabaseUser(java.lang.Boolean autoCreateDatabaseUser) {
                this.autoCreateDatabaseUser = autoCreateDatabaseUser;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftIAMParametersProperty#getAutoCreateDatabaseUser}
             * @param autoCreateDatabaseUser Automatically creates a database user.
             *                               If your database doesn't have a <code>DatabaseUser</code> , set this parameter to <code>True</code> . If there is no <code>DatabaseUser</code> , Amazon QuickSight can't connect to your cluster. The <code>RoleArn</code> that you use for this operation must grant access to <code>redshift:CreateClusterUser</code> to successfully create the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoCreateDatabaseUser(software.amazon.awscdk.IResolvable autoCreateDatabaseUser) {
                this.autoCreateDatabaseUser = autoCreateDatabaseUser;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftIAMParametersProperty#getDatabaseGroups}
             * @param databaseGroups A list of groups whose permissions will be granted to Amazon QuickSight to access the cluster.
             *                       These permissions are combined with the permissions granted to Amazon QuickSight by the <code>DatabaseUser</code> . If you choose to include this parameter, the <code>RoleArn</code> must grant access to <code>redshift:JoinGroup</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseGroups(java.util.List<java.lang.String> databaseGroups) {
                this.databaseGroups = databaseGroups;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftIAMParametersProperty#getDatabaseUser}
             * @param databaseUser The user whose permissions and group memberships will be used by Amazon QuickSight to access the cluster.
             *                     If this user already exists in your database, Amazon QuickSight is granted the same permissions that the user has. If the user doesn't exist, set the value of <code>AutoCreateDatabaseUser</code> to <code>True</code> to create a new user with PUBLIC permissions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseUser(java.lang.String databaseUser) {
                this.databaseUser = databaseUser;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedshiftIAMParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedshiftIAMParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RedshiftIAMParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedshiftIAMParametersProperty {
            private final java.lang.String roleArn;
            private final java.lang.Object autoCreateDatabaseUser;
            private final java.util.List<java.lang.String> databaseGroups;
            private final java.lang.String databaseUser;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.autoCreateDatabaseUser = software.amazon.jsii.Kernel.get(this, "autoCreateDatabaseUser", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.databaseGroups = software.amazon.jsii.Kernel.get(this, "databaseGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.databaseUser = software.amazon.jsii.Kernel.get(this, "databaseUser", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.autoCreateDatabaseUser = builder.autoCreateDatabaseUser;
                this.databaseGroups = builder.databaseGroups;
                this.databaseUser = builder.databaseUser;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.Object getAutoCreateDatabaseUser() {
                return this.autoCreateDatabaseUser;
            }

            @Override
            public final java.util.List<java.lang.String> getDatabaseGroups() {
                return this.databaseGroups;
            }

            @Override
            public final java.lang.String getDatabaseUser() {
                return this.databaseUser;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                if (this.getAutoCreateDatabaseUser() != null) {
                    data.set("autoCreateDatabaseUser", om.valueToTree(this.getAutoCreateDatabaseUser()));
                }
                if (this.getDatabaseGroups() != null) {
                    data.set("databaseGroups", om.valueToTree(this.getDatabaseGroups()));
                }
                if (this.getDatabaseUser() != null) {
                    data.set("databaseUser", om.valueToTree(this.getDatabaseUser()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSource.RedshiftIAMParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedshiftIAMParametersProperty.Jsii$Proxy that = (RedshiftIAMParametersProperty.Jsii$Proxy) o;

                if (!roleArn.equals(that.roleArn)) return false;
                if (this.autoCreateDatabaseUser != null ? !this.autoCreateDatabaseUser.equals(that.autoCreateDatabaseUser) : that.autoCreateDatabaseUser != null) return false;
                if (this.databaseGroups != null ? !this.databaseGroups.equals(that.databaseGroups) : that.databaseGroups != null) return false;
                return this.databaseUser != null ? this.databaseUser.equals(that.databaseUser) : that.databaseUser == null;
            }

            @Override
            public final int hashCode() {
                int result = this.roleArn.hashCode();
                result = 31 * result + (this.autoCreateDatabaseUser != null ? this.autoCreateDatabaseUser.hashCode() : 0);
                result = 31 * result + (this.databaseGroups != null ? this.databaseGroups.hashCode() : 0);
                result = 31 * result + (this.databaseUser != null ? this.databaseUser.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The parameters for Amazon Redshift.
     * <p>
     * The <code>ClusterId</code> field can be blank if <code>Host</code> and <code>Port</code> are both set. The <code>Host</code> and <code>Port</code> fields can be blank if the <code>ClusterId</code> field is set.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * RedshiftParametersProperty redshiftParametersProperty = RedshiftParametersProperty.builder()
     *         .database("database")
     *         // the properties below are optional
     *         .clusterId("clusterId")
     *         .host("host")
     *         .iamParameters(RedshiftIAMParametersProperty.builder()
     *                 .roleArn("roleArn")
     *                 // the properties below are optional
     *                 .autoCreateDatabaseUser(false)
     *                 .databaseGroups(List.of("databaseGroups"))
     *                 .databaseUser("databaseUser")
     *                 .build())
     *         .identityCenterConfiguration(IdentityCenterConfigurationProperty.builder()
     *                 .enableIdentityPropagation(false)
     *                 .build())
     *         .port(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-redshiftparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-redshiftparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSource.RedshiftParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(RedshiftParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedshiftParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-redshiftparameters.html#cfn-quicksight-datasource-redshiftparameters-database">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-redshiftparameters.html#cfn-quicksight-datasource-redshiftparameters-database</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabase();

        /**
         * Cluster ID.
         * <p>
         * This field can be blank if the <code>Host</code> and <code>Port</code> are provided.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-redshiftparameters.html#cfn-quicksight-datasource-redshiftparameters-clusterid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-redshiftparameters.html#cfn-quicksight-datasource-redshiftparameters-clusterid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getClusterId() {
            return null;
        }

        /**
         * Host.
         * <p>
         * This field can be blank if <code>ClusterId</code> is provided.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-redshiftparameters.html#cfn-quicksight-datasource-redshiftparameters-host">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-redshiftparameters.html#cfn-quicksight-datasource-redshiftparameters-host</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHost() {
            return null;
        }

        /**
         * An optional parameter that uses IAM authentication to grant Amazon QuickSight access to your cluster.
         * <p>
         * This parameter can be used instead of <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DataSourceCredentials.html">DataSourceCredentials</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-redshiftparameters.html#cfn-quicksight-datasource-redshiftparameters-iamparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-redshiftparameters.html#cfn-quicksight-datasource-redshiftparameters-iamparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIamParameters() {
            return null;
        }

        /**
         * An optional parameter that configures IAM Identity Center authentication to grant Amazon QuickSight access to your cluster.
         * <p>
         * This parameter can only be specified if your Amazon QuickSight account is configured with IAM Identity Center.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-redshiftparameters.html#cfn-quicksight-datasource-redshiftparameters-identitycenterconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-redshiftparameters.html#cfn-quicksight-datasource-redshiftparameters-identitycenterconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIdentityCenterConfiguration() {
            return null;
        }

        /**
         * Port.
         * <p>
         * This field can be blank if the <code>ClusterId</code> is provided.
         * <p>
         * Default: - 0
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-redshiftparameters.html#cfn-quicksight-datasource-redshiftparameters-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-redshiftparameters.html#cfn-quicksight-datasource-redshiftparameters-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RedshiftParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedshiftParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedshiftParametersProperty> {
            java.lang.String database;
            java.lang.String clusterId;
            java.lang.String host;
            java.lang.Object iamParameters;
            java.lang.Object identityCenterConfiguration;
            java.lang.Number port;

            /**
             * Sets the value of {@link RedshiftParametersProperty#getDatabase}
             * @param database Database. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder database(java.lang.String database) {
                this.database = database;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftParametersProperty#getClusterId}
             * @param clusterId Cluster ID.
             *                  This field can be blank if the <code>Host</code> and <code>Port</code> are provided.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clusterId(java.lang.String clusterId) {
                this.clusterId = clusterId;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftParametersProperty#getHost}
             * @param host Host.
             *             This field can be blank if <code>ClusterId</code> is provided.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder host(java.lang.String host) {
                this.host = host;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftParametersProperty#getIamParameters}
             * @param iamParameters An optional parameter that uses IAM authentication to grant Amazon QuickSight access to your cluster.
             *                      This parameter can be used instead of <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DataSourceCredentials.html">DataSourceCredentials</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iamParameters(software.amazon.awscdk.IResolvable iamParameters) {
                this.iamParameters = iamParameters;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftParametersProperty#getIamParameters}
             * @param iamParameters An optional parameter that uses IAM authentication to grant Amazon QuickSight access to your cluster.
             *                      This parameter can be used instead of <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DataSourceCredentials.html">DataSourceCredentials</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iamParameters(software.amazon.awscdk.services.quicksight.CfnDataSource.RedshiftIAMParametersProperty iamParameters) {
                this.iamParameters = iamParameters;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftParametersProperty#getIdentityCenterConfiguration}
             * @param identityCenterConfiguration An optional parameter that configures IAM Identity Center authentication to grant Amazon QuickSight access to your cluster.
             *                                    This parameter can only be specified if your Amazon QuickSight account is configured with IAM Identity Center.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder identityCenterConfiguration(software.amazon.awscdk.IResolvable identityCenterConfiguration) {
                this.identityCenterConfiguration = identityCenterConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftParametersProperty#getIdentityCenterConfiguration}
             * @param identityCenterConfiguration An optional parameter that configures IAM Identity Center authentication to grant Amazon QuickSight access to your cluster.
             *                                    This parameter can only be specified if your Amazon QuickSight account is configured with IAM Identity Center.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder identityCenterConfiguration(software.amazon.awscdk.services.quicksight.CfnDataSource.IdentityCenterConfigurationProperty identityCenterConfiguration) {
                this.identityCenterConfiguration = identityCenterConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftParametersProperty#getPort}
             * @param port Port.
             *             This field can be blank if the <code>ClusterId</code> is provided.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedshiftParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedshiftParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RedshiftParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedshiftParametersProperty {
            private final java.lang.String database;
            private final java.lang.String clusterId;
            private final java.lang.String host;
            private final java.lang.Object iamParameters;
            private final java.lang.Object identityCenterConfiguration;
            private final java.lang.Number port;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.database = software.amazon.jsii.Kernel.get(this, "database", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.clusterId = software.amazon.jsii.Kernel.get(this, "clusterId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.host = software.amazon.jsii.Kernel.get(this, "host", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.iamParameters = software.amazon.jsii.Kernel.get(this, "iamParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.identityCenterConfiguration = software.amazon.jsii.Kernel.get(this, "identityCenterConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.database = java.util.Objects.requireNonNull(builder.database, "database is required");
                this.clusterId = builder.clusterId;
                this.host = builder.host;
                this.iamParameters = builder.iamParameters;
                this.identityCenterConfiguration = builder.identityCenterConfiguration;
                this.port = builder.port;
            }

            @Override
            public final java.lang.String getDatabase() {
                return this.database;
            }

            @Override
            public final java.lang.String getClusterId() {
                return this.clusterId;
            }

            @Override
            public final java.lang.String getHost() {
                return this.host;
            }

            @Override
            public final java.lang.Object getIamParameters() {
                return this.iamParameters;
            }

            @Override
            public final java.lang.Object getIdentityCenterConfiguration() {
                return this.identityCenterConfiguration;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("database", om.valueToTree(this.getDatabase()));
                if (this.getClusterId() != null) {
                    data.set("clusterId", om.valueToTree(this.getClusterId()));
                }
                if (this.getHost() != null) {
                    data.set("host", om.valueToTree(this.getHost()));
                }
                if (this.getIamParameters() != null) {
                    data.set("iamParameters", om.valueToTree(this.getIamParameters()));
                }
                if (this.getIdentityCenterConfiguration() != null) {
                    data.set("identityCenterConfiguration", om.valueToTree(this.getIdentityCenterConfiguration()));
                }
                if (this.getPort() != null) {
                    data.set("port", om.valueToTree(this.getPort()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSource.RedshiftParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedshiftParametersProperty.Jsii$Proxy that = (RedshiftParametersProperty.Jsii$Proxy) o;

                if (!database.equals(that.database)) return false;
                if (this.clusterId != null ? !this.clusterId.equals(that.clusterId) : that.clusterId != null) return false;
                if (this.host != null ? !this.host.equals(that.host) : that.host != null) return false;
                if (this.iamParameters != null ? !this.iamParameters.equals(that.iamParameters) : that.iamParameters != null) return false;
                if (this.identityCenterConfiguration != null ? !this.identityCenterConfiguration.equals(that.identityCenterConfiguration) : that.identityCenterConfiguration != null) return false;
                return this.port != null ? this.port.equals(that.port) : that.port == null;
            }

            @Override
            public final int hashCode() {
                int result = this.database.hashCode();
                result = 31 * result + (this.clusterId != null ? this.clusterId.hashCode() : 0);
                result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
                result = 31 * result + (this.iamParameters != null ? this.iamParameters.hashCode() : 0);
                result = 31 * result + (this.identityCenterConfiguration != null ? this.identityCenterConfiguration.hashCode() : 0);
                result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Permission for the resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ResourcePermissionProperty resourcePermissionProperty = ResourcePermissionProperty.builder()
     *         .actions(List.of("actions"))
     *         .principal("principal")
     *         // the properties below are optional
     *         .resource("resource")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-resourcepermission.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-resourcepermission.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSource.ResourcePermissionProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourcePermissionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourcePermissionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The IAM action to grant or revoke permissions on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-resourcepermission.html#cfn-quicksight-datasource-resourcepermission-actions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-resourcepermission.html#cfn-quicksight-datasource-resourcepermission-actions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getActions();

        /**
         * The Amazon Resource Name (ARN) of the principal. This can be one of the following:.
         * <p>
         * <ul>
         * <li>The ARN of an Amazon QuickSight user or group associated with a data source or dataset. (This is common.)</li>
         * <li>The ARN of an Amazon QuickSight user, group, or namespace associated with an analysis, dashboard, template, or theme. (This is common.)</li>
         * <li>The ARN of an AWS account root: This is an IAM ARN rather than a QuickSight ARN. Use this option only to share resources (templates) across AWS accounts . (This is less common.)</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-resourcepermission.html#cfn-quicksight-datasource-resourcepermission-principal">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-resourcepermission.html#cfn-quicksight-datasource-resourcepermission-principal</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPrincipal();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-resourcepermission.html#cfn-quicksight-datasource-resourcepermission-resource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-resourcepermission.html#cfn-quicksight-datasource-resourcepermission-resource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResource() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ResourcePermissionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourcePermissionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourcePermissionProperty> {
            java.util.List<java.lang.String> actions;
            java.lang.String principal;
            java.lang.String resource;

            /**
             * Sets the value of {@link ResourcePermissionProperty#getActions}
             * @param actions The IAM action to grant or revoke permissions on. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actions(java.util.List<java.lang.String> actions) {
                this.actions = actions;
                return this;
            }

            /**
             * Sets the value of {@link ResourcePermissionProperty#getPrincipal}
             * @param principal The Amazon Resource Name (ARN) of the principal. This can be one of the following:. This parameter is required.
             *                  <ul>
             *                  <li>The ARN of an Amazon QuickSight user or group associated with a data source or dataset. (This is common.)</li>
             *                  <li>The ARN of an Amazon QuickSight user, group, or namespace associated with an analysis, dashboard, template, or theme. (This is common.)</li>
             *                  <li>The ARN of an AWS account root: This is an IAM ARN rather than a QuickSight ARN. Use this option only to share resources (templates) across AWS accounts . (This is less common.)</li>
             *                  </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder principal(java.lang.String principal) {
                this.principal = principal;
                return this;
            }

            /**
             * Sets the value of {@link ResourcePermissionProperty#getResource}
             * @param resource the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resource(java.lang.String resource) {
                this.resource = resource;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourcePermissionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourcePermissionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourcePermissionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourcePermissionProperty {
            private final java.util.List<java.lang.String> actions;
            private final java.lang.String principal;
            private final java.lang.String resource;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.actions = software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.principal = software.amazon.jsii.Kernel.get(this, "principal", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resource = software.amazon.jsii.Kernel.get(this, "resource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.actions = java.util.Objects.requireNonNull(builder.actions, "actions is required");
                this.principal = java.util.Objects.requireNonNull(builder.principal, "principal is required");
                this.resource = builder.resource;
            }

            @Override
            public final java.util.List<java.lang.String> getActions() {
                return this.actions;
            }

            @Override
            public final java.lang.String getPrincipal() {
                return this.principal;
            }

            @Override
            public final java.lang.String getResource() {
                return this.resource;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("actions", om.valueToTree(this.getActions()));
                data.set("principal", om.valueToTree(this.getPrincipal()));
                if (this.getResource() != null) {
                    data.set("resource", om.valueToTree(this.getResource()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSource.ResourcePermissionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourcePermissionProperty.Jsii$Proxy that = (ResourcePermissionProperty.Jsii$Proxy) o;

                if (!actions.equals(that.actions)) return false;
                if (!principal.equals(that.principal)) return false;
                return this.resource != null ? this.resource.equals(that.resource) : that.resource == null;
            }

            @Override
            public final int hashCode() {
                int result = this.actions.hashCode();
                result = 31 * result + (this.principal.hashCode());
                result = 31 * result + (this.resource != null ? this.resource.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The parameters for S3.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * S3ParametersProperty s3ParametersProperty = S3ParametersProperty.builder()
     *         .manifestFileLocation(ManifestFileLocationProperty.builder()
     *                 .bucket("bucket")
     *                 .key("key")
     *                 .build())
     *         // the properties below are optional
     *         .roleArn("roleArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-s3parameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-s3parameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSource.S3ParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(S3ParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3ParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Location of the Amazon S3 manifest file.
         * <p>
         * This is NULL if the manifest file was uploaded into Amazon QuickSight.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-s3parameters.html#cfn-quicksight-datasource-s3parameters-manifestfilelocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-s3parameters.html#cfn-quicksight-datasource-s3parameters-manifestfilelocation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getManifestFileLocation();

        /**
         * Use the <code>RoleArn</code> structure to override an account-wide role for a specific S3 data source.
         * <p>
         * For example, say an account administrator has turned off all S3 access with an account-wide role. The administrator can then use <code>RoleArn</code> to bypass the account-wide role and allow S3 access for the single S3 data source that is specified in the structure, even if the account-wide role forbidding S3 access is still active.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-s3parameters.html#cfn-quicksight-datasource-s3parameters-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-s3parameters.html#cfn-quicksight-datasource-s3parameters-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3ParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3ParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3ParametersProperty> {
            java.lang.Object manifestFileLocation;
            java.lang.String roleArn;

            /**
             * Sets the value of {@link S3ParametersProperty#getManifestFileLocation}
             * @param manifestFileLocation Location of the Amazon S3 manifest file. This parameter is required.
             *                             This is NULL if the manifest file was uploaded into Amazon QuickSight.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder manifestFileLocation(software.amazon.awscdk.IResolvable manifestFileLocation) {
                this.manifestFileLocation = manifestFileLocation;
                return this;
            }

            /**
             * Sets the value of {@link S3ParametersProperty#getManifestFileLocation}
             * @param manifestFileLocation Location of the Amazon S3 manifest file. This parameter is required.
             *                             This is NULL if the manifest file was uploaded into Amazon QuickSight.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder manifestFileLocation(software.amazon.awscdk.services.quicksight.CfnDataSource.ManifestFileLocationProperty manifestFileLocation) {
                this.manifestFileLocation = manifestFileLocation;
                return this;
            }

            /**
             * Sets the value of {@link S3ParametersProperty#getRoleArn}
             * @param roleArn Use the <code>RoleArn</code> structure to override an account-wide role for a specific S3 data source.
             *                For example, say an account administrator has turned off all S3 access with an account-wide role. The administrator can then use <code>RoleArn</code> to bypass the account-wide role and allow S3 access for the single S3 data source that is specified in the structure, even if the account-wide role forbidding S3 access is still active.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3ParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3ParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3ParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3ParametersProperty {
            private final java.lang.Object manifestFileLocation;
            private final java.lang.String roleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.manifestFileLocation = software.amazon.jsii.Kernel.get(this, "manifestFileLocation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.manifestFileLocation = java.util.Objects.requireNonNull(builder.manifestFileLocation, "manifestFileLocation is required");
                this.roleArn = builder.roleArn;
            }

            @Override
            public final java.lang.Object getManifestFileLocation() {
                return this.manifestFileLocation;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("manifestFileLocation", om.valueToTree(this.getManifestFileLocation()));
                if (this.getRoleArn() != null) {
                    data.set("roleArn", om.valueToTree(this.getRoleArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSource.S3ParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3ParametersProperty.Jsii$Proxy that = (S3ParametersProperty.Jsii$Proxy) o;

                if (!manifestFileLocation.equals(that.manifestFileLocation)) return false;
                return this.roleArn != null ? this.roleArn.equals(that.roleArn) : that.roleArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.manifestFileLocation.hashCode();
                result = 31 * result + (this.roleArn != null ? this.roleArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The parameters for Snowflake.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * SnowflakeParametersProperty snowflakeParametersProperty = SnowflakeParametersProperty.builder()
     *         .database("database")
     *         .host("host")
     *         .warehouse("warehouse")
     *         // the properties below are optional
     *         .authenticationType("authenticationType")
     *         .databaseAccessControlRole("databaseAccessControlRole")
     *         .oAuthParameters(OAuthParametersProperty.builder()
     *                 .tokenProviderUrl("tokenProviderUrl")
     *                 // the properties below are optional
     *                 .identityProviderResourceUri("identityProviderResourceUri")
     *                 .identityProviderVpcConnectionProperties(VpcConnectionPropertiesProperty.builder()
     *                         .vpcConnectionArn("vpcConnectionArn")
     *                         .build())
     *                 .oAuthScope("oAuthScope")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-snowflakeparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-snowflakeparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSource.SnowflakeParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(SnowflakeParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SnowflakeParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-snowflakeparameters.html#cfn-quicksight-datasource-snowflakeparameters-database">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-snowflakeparameters.html#cfn-quicksight-datasource-snowflakeparameters-database</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabase();

        /**
         * Host.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-snowflakeparameters.html#cfn-quicksight-datasource-snowflakeparameters-host">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-snowflakeparameters.html#cfn-quicksight-datasource-snowflakeparameters-host</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHost();

        /**
         * Warehouse.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-snowflakeparameters.html#cfn-quicksight-datasource-snowflakeparameters-warehouse">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-snowflakeparameters.html#cfn-quicksight-datasource-snowflakeparameters-warehouse</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getWarehouse();

        /**
         * The authentication type that you want to use for your connection.
         * <p>
         * This parameter accepts OAuth and non-OAuth authentication types.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-snowflakeparameters.html#cfn-quicksight-datasource-snowflakeparameters-authenticationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-snowflakeparameters.html#cfn-quicksight-datasource-snowflakeparameters-authenticationtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuthenticationType() {
            return null;
        }

        /**
         * The database access control role.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-snowflakeparameters.html#cfn-quicksight-datasource-snowflakeparameters-databaseaccesscontrolrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-snowflakeparameters.html#cfn-quicksight-datasource-snowflakeparameters-databaseaccesscontrolrole</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDatabaseAccessControlRole() {
            return null;
        }

        /**
         * An object that contains information needed to create a data source connection between an Amazon QuickSight account and Snowflake.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-snowflakeparameters.html#cfn-quicksight-datasource-snowflakeparameters-oauthparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-snowflakeparameters.html#cfn-quicksight-datasource-snowflakeparameters-oauthparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOAuthParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SnowflakeParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SnowflakeParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SnowflakeParametersProperty> {
            java.lang.String database;
            java.lang.String host;
            java.lang.String warehouse;
            java.lang.String authenticationType;
            java.lang.String databaseAccessControlRole;
            java.lang.Object oAuthParameters;

            /**
             * Sets the value of {@link SnowflakeParametersProperty#getDatabase}
             * @param database Database. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder database(java.lang.String database) {
                this.database = database;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeParametersProperty#getHost}
             * @param host Host. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder host(java.lang.String host) {
                this.host = host;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeParametersProperty#getWarehouse}
             * @param warehouse Warehouse. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder warehouse(java.lang.String warehouse) {
                this.warehouse = warehouse;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeParametersProperty#getAuthenticationType}
             * @param authenticationType The authentication type that you want to use for your connection.
             *                           This parameter accepts OAuth and non-OAuth authentication types.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticationType(java.lang.String authenticationType) {
                this.authenticationType = authenticationType;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeParametersProperty#getDatabaseAccessControlRole}
             * @param databaseAccessControlRole The database access control role.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseAccessControlRole(java.lang.String databaseAccessControlRole) {
                this.databaseAccessControlRole = databaseAccessControlRole;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeParametersProperty#getOAuthParameters}
             * @param oAuthParameters An object that contains information needed to create a data source connection between an Amazon QuickSight account and Snowflake.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oAuthParameters(software.amazon.awscdk.IResolvable oAuthParameters) {
                this.oAuthParameters = oAuthParameters;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeParametersProperty#getOAuthParameters}
             * @param oAuthParameters An object that contains information needed to create a data source connection between an Amazon QuickSight account and Snowflake.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oAuthParameters(software.amazon.awscdk.services.quicksight.CfnDataSource.OAuthParametersProperty oAuthParameters) {
                this.oAuthParameters = oAuthParameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SnowflakeParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SnowflakeParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SnowflakeParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SnowflakeParametersProperty {
            private final java.lang.String database;
            private final java.lang.String host;
            private final java.lang.String warehouse;
            private final java.lang.String authenticationType;
            private final java.lang.String databaseAccessControlRole;
            private final java.lang.Object oAuthParameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.database = software.amazon.jsii.Kernel.get(this, "database", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.host = software.amazon.jsii.Kernel.get(this, "host", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.warehouse = software.amazon.jsii.Kernel.get(this, "warehouse", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.authenticationType = software.amazon.jsii.Kernel.get(this, "authenticationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.databaseAccessControlRole = software.amazon.jsii.Kernel.get(this, "databaseAccessControlRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.oAuthParameters = software.amazon.jsii.Kernel.get(this, "oAuthParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.database = java.util.Objects.requireNonNull(builder.database, "database is required");
                this.host = java.util.Objects.requireNonNull(builder.host, "host is required");
                this.warehouse = java.util.Objects.requireNonNull(builder.warehouse, "warehouse is required");
                this.authenticationType = builder.authenticationType;
                this.databaseAccessControlRole = builder.databaseAccessControlRole;
                this.oAuthParameters = builder.oAuthParameters;
            }

            @Override
            public final java.lang.String getDatabase() {
                return this.database;
            }

            @Override
            public final java.lang.String getHost() {
                return this.host;
            }

            @Override
            public final java.lang.String getWarehouse() {
                return this.warehouse;
            }

            @Override
            public final java.lang.String getAuthenticationType() {
                return this.authenticationType;
            }

            @Override
            public final java.lang.String getDatabaseAccessControlRole() {
                return this.databaseAccessControlRole;
            }

            @Override
            public final java.lang.Object getOAuthParameters() {
                return this.oAuthParameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("database", om.valueToTree(this.getDatabase()));
                data.set("host", om.valueToTree(this.getHost()));
                data.set("warehouse", om.valueToTree(this.getWarehouse()));
                if (this.getAuthenticationType() != null) {
                    data.set("authenticationType", om.valueToTree(this.getAuthenticationType()));
                }
                if (this.getDatabaseAccessControlRole() != null) {
                    data.set("databaseAccessControlRole", om.valueToTree(this.getDatabaseAccessControlRole()));
                }
                if (this.getOAuthParameters() != null) {
                    data.set("oAuthParameters", om.valueToTree(this.getOAuthParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSource.SnowflakeParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SnowflakeParametersProperty.Jsii$Proxy that = (SnowflakeParametersProperty.Jsii$Proxy) o;

                if (!database.equals(that.database)) return false;
                if (!host.equals(that.host)) return false;
                if (!warehouse.equals(that.warehouse)) return false;
                if (this.authenticationType != null ? !this.authenticationType.equals(that.authenticationType) : that.authenticationType != null) return false;
                if (this.databaseAccessControlRole != null ? !this.databaseAccessControlRole.equals(that.databaseAccessControlRole) : that.databaseAccessControlRole != null) return false;
                return this.oAuthParameters != null ? this.oAuthParameters.equals(that.oAuthParameters) : that.oAuthParameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.database.hashCode();
                result = 31 * result + (this.host.hashCode());
                result = 31 * result + (this.warehouse.hashCode());
                result = 31 * result + (this.authenticationType != null ? this.authenticationType.hashCode() : 0);
                result = 31 * result + (this.databaseAccessControlRole != null ? this.databaseAccessControlRole.hashCode() : 0);
                result = 31 * result + (this.oAuthParameters != null ? this.oAuthParameters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The parameters for Spark.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * SparkParametersProperty sparkParametersProperty = SparkParametersProperty.builder()
     *         .host("host")
     *         .port(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-sparkparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-sparkparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSource.SparkParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(SparkParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SparkParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Host.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-sparkparameters.html#cfn-quicksight-datasource-sparkparameters-host">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-sparkparameters.html#cfn-quicksight-datasource-sparkparameters-host</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHost();

        /**
         * Port.
         * <p>
         * Default: - 0
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-sparkparameters.html#cfn-quicksight-datasource-sparkparameters-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-sparkparameters.html#cfn-quicksight-datasource-sparkparameters-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPort();

        /**
         * @return a {@link Builder} of {@link SparkParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SparkParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SparkParametersProperty> {
            java.lang.String host;
            java.lang.Number port;

            /**
             * Sets the value of {@link SparkParametersProperty#getHost}
             * @param host Host. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder host(java.lang.String host) {
                this.host = host;
                return this;
            }

            /**
             * Sets the value of {@link SparkParametersProperty#getPort}
             * @param port Port. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SparkParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SparkParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SparkParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SparkParametersProperty {
            private final java.lang.String host;
            private final java.lang.Number port;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.host = software.amazon.jsii.Kernel.get(this, "host", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.host = java.util.Objects.requireNonNull(builder.host, "host is required");
                this.port = java.util.Objects.requireNonNull(builder.port, "port is required");
            }

            @Override
            public final java.lang.String getHost() {
                return this.host;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("host", om.valueToTree(this.getHost()));
                data.set("port", om.valueToTree(this.getPort()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSource.SparkParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SparkParametersProperty.Jsii$Proxy that = (SparkParametersProperty.Jsii$Proxy) o;

                if (!host.equals(that.host)) return false;
                return this.port.equals(that.port);
            }

            @Override
            public final int hashCode() {
                int result = this.host.hashCode();
                result = 31 * result + (this.port.hashCode());
                return result;
            }
        }
    }
    /**
     * The parameters for SQL Server.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * SqlServerParametersProperty sqlServerParametersProperty = SqlServerParametersProperty.builder()
     *         .database("database")
     *         .host("host")
     *         .port(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-sqlserverparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-sqlserverparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSource.SqlServerParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(SqlServerParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SqlServerParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-sqlserverparameters.html#cfn-quicksight-datasource-sqlserverparameters-database">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-sqlserverparameters.html#cfn-quicksight-datasource-sqlserverparameters-database</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabase();

        /**
         * Host.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-sqlserverparameters.html#cfn-quicksight-datasource-sqlserverparameters-host">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-sqlserverparameters.html#cfn-quicksight-datasource-sqlserverparameters-host</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHost();

        /**
         * Port.
         * <p>
         * Default: - 0
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-sqlserverparameters.html#cfn-quicksight-datasource-sqlserverparameters-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-sqlserverparameters.html#cfn-quicksight-datasource-sqlserverparameters-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPort();

        /**
         * @return a {@link Builder} of {@link SqlServerParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SqlServerParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SqlServerParametersProperty> {
            java.lang.String database;
            java.lang.String host;
            java.lang.Number port;

            /**
             * Sets the value of {@link SqlServerParametersProperty#getDatabase}
             * @param database Database. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder database(java.lang.String database) {
                this.database = database;
                return this;
            }

            /**
             * Sets the value of {@link SqlServerParametersProperty#getHost}
             * @param host Host. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder host(java.lang.String host) {
                this.host = host;
                return this;
            }

            /**
             * Sets the value of {@link SqlServerParametersProperty#getPort}
             * @param port Port. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SqlServerParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SqlServerParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SqlServerParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SqlServerParametersProperty {
            private final java.lang.String database;
            private final java.lang.String host;
            private final java.lang.Number port;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.database = software.amazon.jsii.Kernel.get(this, "database", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.host = software.amazon.jsii.Kernel.get(this, "host", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.database = java.util.Objects.requireNonNull(builder.database, "database is required");
                this.host = java.util.Objects.requireNonNull(builder.host, "host is required");
                this.port = java.util.Objects.requireNonNull(builder.port, "port is required");
            }

            @Override
            public final java.lang.String getDatabase() {
                return this.database;
            }

            @Override
            public final java.lang.String getHost() {
                return this.host;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("database", om.valueToTree(this.getDatabase()));
                data.set("host", om.valueToTree(this.getHost()));
                data.set("port", om.valueToTree(this.getPort()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSource.SqlServerParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SqlServerParametersProperty.Jsii$Proxy that = (SqlServerParametersProperty.Jsii$Proxy) o;

                if (!database.equals(that.database)) return false;
                if (!host.equals(that.host)) return false;
                return this.port.equals(that.port);
            }

            @Override
            public final int hashCode() {
                int result = this.database.hashCode();
                result = 31 * result + (this.host.hashCode());
                result = 31 * result + (this.port.hashCode());
                return result;
            }
        }
    }
    /**
     * Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your underlying data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * SslPropertiesProperty sslPropertiesProperty = SslPropertiesProperty.builder()
     *         .disableSsl(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-sslproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-sslproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSource.SslPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(SslPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SslPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A Boolean option to control whether SSL should be disabled.
         * <p>
         * Default: - false
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-sslproperties.html#cfn-quicksight-datasource-sslproperties-disablessl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-sslproperties.html#cfn-quicksight-datasource-sslproperties-disablessl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDisableSsl() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SslPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SslPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SslPropertiesProperty> {
            java.lang.Object disableSsl;

            /**
             * Sets the value of {@link SslPropertiesProperty#getDisableSsl}
             * @param disableSsl A Boolean option to control whether SSL should be disabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableSsl(java.lang.Boolean disableSsl) {
                this.disableSsl = disableSsl;
                return this;
            }

            /**
             * Sets the value of {@link SslPropertiesProperty#getDisableSsl}
             * @param disableSsl A Boolean option to control whether SSL should be disabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableSsl(software.amazon.awscdk.IResolvable disableSsl) {
                this.disableSsl = disableSsl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SslPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SslPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SslPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SslPropertiesProperty {
            private final java.lang.Object disableSsl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.disableSsl = software.amazon.jsii.Kernel.get(this, "disableSsl", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.disableSsl = builder.disableSsl;
            }

            @Override
            public final java.lang.Object getDisableSsl() {
                return this.disableSsl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDisableSsl() != null) {
                    data.set("disableSsl", om.valueToTree(this.getDisableSsl()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSource.SslPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SslPropertiesProperty.Jsii$Proxy that = (SslPropertiesProperty.Jsii$Proxy) o;

                return this.disableSsl != null ? this.disableSsl.equals(that.disableSsl) : that.disableSsl == null;
            }

            @Override
            public final int hashCode() {
                int result = this.disableSsl != null ? this.disableSsl.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The parameters that are required to connect to a Starburst data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * StarburstParametersProperty starburstParametersProperty = StarburstParametersProperty.builder()
     *         .catalog("catalog")
     *         .host("host")
     *         .port(123)
     *         // the properties below are optional
     *         .authenticationType("authenticationType")
     *         .databaseAccessControlRole("databaseAccessControlRole")
     *         .oAuthParameters(OAuthParametersProperty.builder()
     *                 .tokenProviderUrl("tokenProviderUrl")
     *                 // the properties below are optional
     *                 .identityProviderResourceUri("identityProviderResourceUri")
     *                 .identityProviderVpcConnectionProperties(VpcConnectionPropertiesProperty.builder()
     *                         .vpcConnectionArn("vpcConnectionArn")
     *                         .build())
     *                 .oAuthScope("oAuthScope")
     *                 .build())
     *         .productType("productType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-starburstparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-starburstparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSource.StarburstParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(StarburstParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StarburstParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The catalog name for the Starburst data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-starburstparameters.html#cfn-quicksight-datasource-starburstparameters-catalog">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-starburstparameters.html#cfn-quicksight-datasource-starburstparameters-catalog</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCatalog();

        /**
         * The host name of the Starburst data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-starburstparameters.html#cfn-quicksight-datasource-starburstparameters-host">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-starburstparameters.html#cfn-quicksight-datasource-starburstparameters-host</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHost();

        /**
         * The port for the Starburst data source.
         * <p>
         * Default: - 0
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-starburstparameters.html#cfn-quicksight-datasource-starburstparameters-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-starburstparameters.html#cfn-quicksight-datasource-starburstparameters-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPort();

        /**
         * The authentication type that you want to use for your connection.
         * <p>
         * This parameter accepts OAuth and non-OAuth authentication types.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-starburstparameters.html#cfn-quicksight-datasource-starburstparameters-authenticationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-starburstparameters.html#cfn-quicksight-datasource-starburstparameters-authenticationtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuthenticationType() {
            return null;
        }

        /**
         * The database access control role.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-starburstparameters.html#cfn-quicksight-datasource-starburstparameters-databaseaccesscontrolrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-starburstparameters.html#cfn-quicksight-datasource-starburstparameters-databaseaccesscontrolrole</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDatabaseAccessControlRole() {
            return null;
        }

        /**
         * An object that contains information needed to create a data source connection between an Amazon QuickSight account and Starburst.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-starburstparameters.html#cfn-quicksight-datasource-starburstparameters-oauthparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-starburstparameters.html#cfn-quicksight-datasource-starburstparameters-oauthparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOAuthParameters() {
            return null;
        }

        /**
         * The product type for the Starburst data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-starburstparameters.html#cfn-quicksight-datasource-starburstparameters-producttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-starburstparameters.html#cfn-quicksight-datasource-starburstparameters-producttype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProductType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StarburstParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StarburstParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StarburstParametersProperty> {
            java.lang.String catalog;
            java.lang.String host;
            java.lang.Number port;
            java.lang.String authenticationType;
            java.lang.String databaseAccessControlRole;
            java.lang.Object oAuthParameters;
            java.lang.String productType;

            /**
             * Sets the value of {@link StarburstParametersProperty#getCatalog}
             * @param catalog The catalog name for the Starburst data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder catalog(java.lang.String catalog) {
                this.catalog = catalog;
                return this;
            }

            /**
             * Sets the value of {@link StarburstParametersProperty#getHost}
             * @param host The host name of the Starburst data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder host(java.lang.String host) {
                this.host = host;
                return this;
            }

            /**
             * Sets the value of {@link StarburstParametersProperty#getPort}
             * @param port The port for the Starburst data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link StarburstParametersProperty#getAuthenticationType}
             * @param authenticationType The authentication type that you want to use for your connection.
             *                           This parameter accepts OAuth and non-OAuth authentication types.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticationType(java.lang.String authenticationType) {
                this.authenticationType = authenticationType;
                return this;
            }

            /**
             * Sets the value of {@link StarburstParametersProperty#getDatabaseAccessControlRole}
             * @param databaseAccessControlRole The database access control role.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseAccessControlRole(java.lang.String databaseAccessControlRole) {
                this.databaseAccessControlRole = databaseAccessControlRole;
                return this;
            }

            /**
             * Sets the value of {@link StarburstParametersProperty#getOAuthParameters}
             * @param oAuthParameters An object that contains information needed to create a data source connection between an Amazon QuickSight account and Starburst.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oAuthParameters(software.amazon.awscdk.IResolvable oAuthParameters) {
                this.oAuthParameters = oAuthParameters;
                return this;
            }

            /**
             * Sets the value of {@link StarburstParametersProperty#getOAuthParameters}
             * @param oAuthParameters An object that contains information needed to create a data source connection between an Amazon QuickSight account and Starburst.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oAuthParameters(software.amazon.awscdk.services.quicksight.CfnDataSource.OAuthParametersProperty oAuthParameters) {
                this.oAuthParameters = oAuthParameters;
                return this;
            }

            /**
             * Sets the value of {@link StarburstParametersProperty#getProductType}
             * @param productType The product type for the Starburst data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder productType(java.lang.String productType) {
                this.productType = productType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StarburstParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StarburstParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StarburstParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StarburstParametersProperty {
            private final java.lang.String catalog;
            private final java.lang.String host;
            private final java.lang.Number port;
            private final java.lang.String authenticationType;
            private final java.lang.String databaseAccessControlRole;
            private final java.lang.Object oAuthParameters;
            private final java.lang.String productType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.catalog = software.amazon.jsii.Kernel.get(this, "catalog", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.host = software.amazon.jsii.Kernel.get(this, "host", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.authenticationType = software.amazon.jsii.Kernel.get(this, "authenticationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.databaseAccessControlRole = software.amazon.jsii.Kernel.get(this, "databaseAccessControlRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.oAuthParameters = software.amazon.jsii.Kernel.get(this, "oAuthParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.productType = software.amazon.jsii.Kernel.get(this, "productType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.catalog = java.util.Objects.requireNonNull(builder.catalog, "catalog is required");
                this.host = java.util.Objects.requireNonNull(builder.host, "host is required");
                this.port = java.util.Objects.requireNonNull(builder.port, "port is required");
                this.authenticationType = builder.authenticationType;
                this.databaseAccessControlRole = builder.databaseAccessControlRole;
                this.oAuthParameters = builder.oAuthParameters;
                this.productType = builder.productType;
            }

            @Override
            public final java.lang.String getCatalog() {
                return this.catalog;
            }

            @Override
            public final java.lang.String getHost() {
                return this.host;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            public final java.lang.String getAuthenticationType() {
                return this.authenticationType;
            }

            @Override
            public final java.lang.String getDatabaseAccessControlRole() {
                return this.databaseAccessControlRole;
            }

            @Override
            public final java.lang.Object getOAuthParameters() {
                return this.oAuthParameters;
            }

            @Override
            public final java.lang.String getProductType() {
                return this.productType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("catalog", om.valueToTree(this.getCatalog()));
                data.set("host", om.valueToTree(this.getHost()));
                data.set("port", om.valueToTree(this.getPort()));
                if (this.getAuthenticationType() != null) {
                    data.set("authenticationType", om.valueToTree(this.getAuthenticationType()));
                }
                if (this.getDatabaseAccessControlRole() != null) {
                    data.set("databaseAccessControlRole", om.valueToTree(this.getDatabaseAccessControlRole()));
                }
                if (this.getOAuthParameters() != null) {
                    data.set("oAuthParameters", om.valueToTree(this.getOAuthParameters()));
                }
                if (this.getProductType() != null) {
                    data.set("productType", om.valueToTree(this.getProductType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSource.StarburstParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StarburstParametersProperty.Jsii$Proxy that = (StarburstParametersProperty.Jsii$Proxy) o;

                if (!catalog.equals(that.catalog)) return false;
                if (!host.equals(that.host)) return false;
                if (!port.equals(that.port)) return false;
                if (this.authenticationType != null ? !this.authenticationType.equals(that.authenticationType) : that.authenticationType != null) return false;
                if (this.databaseAccessControlRole != null ? !this.databaseAccessControlRole.equals(that.databaseAccessControlRole) : that.databaseAccessControlRole != null) return false;
                if (this.oAuthParameters != null ? !this.oAuthParameters.equals(that.oAuthParameters) : that.oAuthParameters != null) return false;
                return this.productType != null ? this.productType.equals(that.productType) : that.productType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.catalog.hashCode();
                result = 31 * result + (this.host.hashCode());
                result = 31 * result + (this.port.hashCode());
                result = 31 * result + (this.authenticationType != null ? this.authenticationType.hashCode() : 0);
                result = 31 * result + (this.databaseAccessControlRole != null ? this.databaseAccessControlRole.hashCode() : 0);
                result = 31 * result + (this.oAuthParameters != null ? this.oAuthParameters.hashCode() : 0);
                result = 31 * result + (this.productType != null ? this.productType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The parameters for Teradata.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * TeradataParametersProperty teradataParametersProperty = TeradataParametersProperty.builder()
     *         .database("database")
     *         .host("host")
     *         .port(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-teradataparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-teradataparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSource.TeradataParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(TeradataParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TeradataParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-teradataparameters.html#cfn-quicksight-datasource-teradataparameters-database">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-teradataparameters.html#cfn-quicksight-datasource-teradataparameters-database</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabase();

        /**
         * Host.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-teradataparameters.html#cfn-quicksight-datasource-teradataparameters-host">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-teradataparameters.html#cfn-quicksight-datasource-teradataparameters-host</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHost();

        /**
         * Port.
         * <p>
         * Default: - 0
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-teradataparameters.html#cfn-quicksight-datasource-teradataparameters-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-teradataparameters.html#cfn-quicksight-datasource-teradataparameters-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPort();

        /**
         * @return a {@link Builder} of {@link TeradataParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TeradataParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TeradataParametersProperty> {
            java.lang.String database;
            java.lang.String host;
            java.lang.Number port;

            /**
             * Sets the value of {@link TeradataParametersProperty#getDatabase}
             * @param database Database. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder database(java.lang.String database) {
                this.database = database;
                return this;
            }

            /**
             * Sets the value of {@link TeradataParametersProperty#getHost}
             * @param host Host. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder host(java.lang.String host) {
                this.host = host;
                return this;
            }

            /**
             * Sets the value of {@link TeradataParametersProperty#getPort}
             * @param port Port. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TeradataParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TeradataParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TeradataParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TeradataParametersProperty {
            private final java.lang.String database;
            private final java.lang.String host;
            private final java.lang.Number port;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.database = software.amazon.jsii.Kernel.get(this, "database", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.host = software.amazon.jsii.Kernel.get(this, "host", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.database = java.util.Objects.requireNonNull(builder.database, "database is required");
                this.host = java.util.Objects.requireNonNull(builder.host, "host is required");
                this.port = java.util.Objects.requireNonNull(builder.port, "port is required");
            }

            @Override
            public final java.lang.String getDatabase() {
                return this.database;
            }

            @Override
            public final java.lang.String getHost() {
                return this.host;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("database", om.valueToTree(this.getDatabase()));
                data.set("host", om.valueToTree(this.getHost()));
                data.set("port", om.valueToTree(this.getPort()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSource.TeradataParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TeradataParametersProperty.Jsii$Proxy that = (TeradataParametersProperty.Jsii$Proxy) o;

                if (!database.equals(that.database)) return false;
                if (!host.equals(that.host)) return false;
                return this.port.equals(that.port);
            }

            @Override
            public final int hashCode() {
                int result = this.database.hashCode();
                result = 31 * result + (this.host.hashCode());
                result = 31 * result + (this.port.hashCode());
                return result;
            }
        }
    }
    /**
     * The parameters that are required to connect to a Trino data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * TrinoParametersProperty trinoParametersProperty = TrinoParametersProperty.builder()
     *         .catalog("catalog")
     *         .host("host")
     *         .port(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-trinoparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-trinoparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSource.TrinoParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(TrinoParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TrinoParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The catalog name for the Trino data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-trinoparameters.html#cfn-quicksight-datasource-trinoparameters-catalog">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-trinoparameters.html#cfn-quicksight-datasource-trinoparameters-catalog</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCatalog();

        /**
         * The host name of the Trino data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-trinoparameters.html#cfn-quicksight-datasource-trinoparameters-host">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-trinoparameters.html#cfn-quicksight-datasource-trinoparameters-host</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHost();

        /**
         * The port for the Trino data source.
         * <p>
         * Default: - 0
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-trinoparameters.html#cfn-quicksight-datasource-trinoparameters-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-trinoparameters.html#cfn-quicksight-datasource-trinoparameters-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPort();

        /**
         * @return a {@link Builder} of {@link TrinoParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TrinoParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TrinoParametersProperty> {
            java.lang.String catalog;
            java.lang.String host;
            java.lang.Number port;

            /**
             * Sets the value of {@link TrinoParametersProperty#getCatalog}
             * @param catalog The catalog name for the Trino data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder catalog(java.lang.String catalog) {
                this.catalog = catalog;
                return this;
            }

            /**
             * Sets the value of {@link TrinoParametersProperty#getHost}
             * @param host The host name of the Trino data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder host(java.lang.String host) {
                this.host = host;
                return this;
            }

            /**
             * Sets the value of {@link TrinoParametersProperty#getPort}
             * @param port The port for the Trino data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TrinoParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TrinoParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TrinoParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TrinoParametersProperty {
            private final java.lang.String catalog;
            private final java.lang.String host;
            private final java.lang.Number port;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.catalog = software.amazon.jsii.Kernel.get(this, "catalog", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.host = software.amazon.jsii.Kernel.get(this, "host", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.catalog = java.util.Objects.requireNonNull(builder.catalog, "catalog is required");
                this.host = java.util.Objects.requireNonNull(builder.host, "host is required");
                this.port = java.util.Objects.requireNonNull(builder.port, "port is required");
            }

            @Override
            public final java.lang.String getCatalog() {
                return this.catalog;
            }

            @Override
            public final java.lang.String getHost() {
                return this.host;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("catalog", om.valueToTree(this.getCatalog()));
                data.set("host", om.valueToTree(this.getHost()));
                data.set("port", om.valueToTree(this.getPort()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSource.TrinoParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TrinoParametersProperty.Jsii$Proxy that = (TrinoParametersProperty.Jsii$Proxy) o;

                if (!catalog.equals(that.catalog)) return false;
                if (!host.equals(that.host)) return false;
                return this.port.equals(that.port);
            }

            @Override
            public final int hashCode() {
                int result = this.catalog.hashCode();
                result = 31 * result + (this.host.hashCode());
                result = 31 * result + (this.port.hashCode());
                return result;
            }
        }
    }
    /**
     * VPC connection properties.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * VpcConnectionPropertiesProperty vpcConnectionPropertiesProperty = VpcConnectionPropertiesProperty.builder()
     *         .vpcConnectionArn("vpcConnectionArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-vpcconnectionproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-vpcconnectionproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSource.VpcConnectionPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(VpcConnectionPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VpcConnectionPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) for the VPC connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-vpcconnectionproperties.html#cfn-quicksight-datasource-vpcconnectionproperties-vpcconnectionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-vpcconnectionproperties.html#cfn-quicksight-datasource-vpcconnectionproperties-vpcconnectionarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVpcConnectionArn();

        /**
         * @return a {@link Builder} of {@link VpcConnectionPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VpcConnectionPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VpcConnectionPropertiesProperty> {
            java.lang.String vpcConnectionArn;

            /**
             * Sets the value of {@link VpcConnectionPropertiesProperty#getVpcConnectionArn}
             * @param vpcConnectionArn The Amazon Resource Name (ARN) for the VPC connection. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcConnectionArn(java.lang.String vpcConnectionArn) {
                this.vpcConnectionArn = vpcConnectionArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VpcConnectionPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VpcConnectionPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VpcConnectionPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcConnectionPropertiesProperty {
            private final java.lang.String vpcConnectionArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.vpcConnectionArn = software.amazon.jsii.Kernel.get(this, "vpcConnectionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.vpcConnectionArn = java.util.Objects.requireNonNull(builder.vpcConnectionArn, "vpcConnectionArn is required");
            }

            @Override
            public final java.lang.String getVpcConnectionArn() {
                return this.vpcConnectionArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("vpcConnectionArn", om.valueToTree(this.getVpcConnectionArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSource.VpcConnectionPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VpcConnectionPropertiesProperty.Jsii$Proxy that = (VpcConnectionPropertiesProperty.Jsii$Proxy) o;

                return this.vpcConnectionArn.equals(that.vpcConnectionArn);
            }

            @Override
            public final int hashCode() {
                int result = this.vpcConnectionArn.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.quicksight.CfnDataSource}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.quicksight.CfnDataSource> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.quicksight.CfnDataSourceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.quicksight.CfnDataSourceProps.Builder();
        }

        /**
         * A display name for the data source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-name</a>
         * @param name A display name for the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The type of the data source. To return a list of all data sources, use <code>ListDataSources</code> .
         * <p>
         * Use <code>AMAZON_ELASTICSEARCH</code> for Amazon OpenSearch Service.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-type</a>
         * @param type The type of the data source. To return a list of all data sources, use <code>ListDataSources</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props.type(type);
            return this;
        }

        /**
         * A set of alternate data source parameters that you want to share for the credentials stored with this data source.
         * <p>
         * The credentials are applied in tandem with the data source parameters when you copy a data source by using a create or update request. The API operation compares the <code>DataSourceParameters</code> structure that's in the request with the structures in the <code>AlternateDataSourceParameters</code> allow list. If the structures are an exact match, the request is allowed to use the credentials from this existing data source. If the <code>AlternateDataSourceParameters</code> list is null, the <code>Credentials</code> originally used with this <code>DataSourceParameters</code> are automatically allowed.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-alternatedatasourceparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-alternatedatasourceparameters</a>
         * @param alternateDataSourceParameters A set of alternate data source parameters that you want to share for the credentials stored with this data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alternateDataSourceParameters(final software.amazon.awscdk.IResolvable alternateDataSourceParameters) {
            this.props.alternateDataSourceParameters(alternateDataSourceParameters);
            return this;
        }
        /**
         * A set of alternate data source parameters that you want to share for the credentials stored with this data source.
         * <p>
         * The credentials are applied in tandem with the data source parameters when you copy a data source by using a create or update request. The API operation compares the <code>DataSourceParameters</code> structure that's in the request with the structures in the <code>AlternateDataSourceParameters</code> allow list. If the structures are an exact match, the request is allowed to use the credentials from this existing data source. If the <code>AlternateDataSourceParameters</code> list is null, the <code>Credentials</code> originally used with this <code>DataSourceParameters</code> are automatically allowed.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-alternatedatasourceparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-alternatedatasourceparameters</a>
         * @param alternateDataSourceParameters A set of alternate data source parameters that you want to share for the credentials stored with this data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alternateDataSourceParameters(final java.util.List<? extends java.lang.Object> alternateDataSourceParameters) {
            this.props.alternateDataSourceParameters(alternateDataSourceParameters);
            return this;
        }

        /**
         * The AWS account ID.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-awsaccountid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-awsaccountid</a>
         * @param awsAccountId The AWS account ID. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder awsAccountId(final java.lang.String awsAccountId) {
            this.props.awsAccountId(awsAccountId);
            return this;
        }

        /**
         * The credentials Amazon QuickSight that uses to connect to your underlying source.
         * <p>
         * Currently, only credentials based on user name and password are supported.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-credentials">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-credentials</a>
         * @param credentials The credentials Amazon QuickSight that uses to connect to your underlying source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentials(final software.amazon.awscdk.IResolvable credentials) {
            this.props.credentials(credentials);
            return this;
        }
        /**
         * The credentials Amazon QuickSight that uses to connect to your underlying source.
         * <p>
         * Currently, only credentials based on user name and password are supported.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-credentials">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-credentials</a>
         * @param credentials The credentials Amazon QuickSight that uses to connect to your underlying source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentials(final software.amazon.awscdk.services.quicksight.CfnDataSource.DataSourceCredentialsProperty credentials) {
            this.props.credentials(credentials);
            return this;
        }

        /**
         * An ID for the data source.
         * <p>
         * This ID is unique per AWS Region for each AWS account.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-datasourceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-datasourceid</a>
         * @param dataSourceId An ID for the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSourceId(final java.lang.String dataSourceId) {
            this.props.dataSourceId(dataSourceId);
            return this;
        }

        /**
         * The parameters that Amazon QuickSight uses to connect to your underlying source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-datasourceparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-datasourceparameters</a>
         * @param dataSourceParameters The parameters that Amazon QuickSight uses to connect to your underlying source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSourceParameters(final software.amazon.awscdk.IResolvable dataSourceParameters) {
            this.props.dataSourceParameters(dataSourceParameters);
            return this;
        }
        /**
         * The parameters that Amazon QuickSight uses to connect to your underlying source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-datasourceparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-datasourceparameters</a>
         * @param dataSourceParameters The parameters that Amazon QuickSight uses to connect to your underlying source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSourceParameters(final software.amazon.awscdk.services.quicksight.CfnDataSource.DataSourceParametersProperty dataSourceParameters) {
            this.props.dataSourceParameters(dataSourceParameters);
            return this;
        }

        /**
         * Error information from the last update or the creation of the data source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-errorinfo">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-errorinfo</a>
         * @param errorInfo Error information from the last update or the creation of the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder errorInfo(final software.amazon.awscdk.IResolvable errorInfo) {
            this.props.errorInfo(errorInfo);
            return this;
        }
        /**
         * Error information from the last update or the creation of the data source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-errorinfo">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-errorinfo</a>
         * @param errorInfo Error information from the last update or the creation of the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder errorInfo(final software.amazon.awscdk.services.quicksight.CfnDataSource.DataSourceErrorInfoProperty errorInfo) {
            this.props.errorInfo(errorInfo);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-folderarns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-folderarns</a>
         * @param folderArns This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder folderArns(final java.util.List<java.lang.String> folderArns) {
            this.props.folderArns(folderArns);
            return this;
        }

        /**
         * A list of resource permissions on the data source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-permissions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-permissions</a>
         * @param permissions A list of resource permissions on the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissions(final software.amazon.awscdk.IResolvable permissions) {
            this.props.permissions(permissions);
            return this;
        }
        /**
         * A list of resource permissions on the data source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-permissions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-permissions</a>
         * @param permissions A list of resource permissions on the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissions(final java.util.List<? extends java.lang.Object> permissions) {
            this.props.permissions(permissions);
            return this;
        }

        /**
         * Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your underlying source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-sslproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-sslproperties</a>
         * @param sslProperties Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your underlying source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sslProperties(final software.amazon.awscdk.IResolvable sslProperties) {
            this.props.sslProperties(sslProperties);
            return this;
        }
        /**
         * Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your underlying source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-sslproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-sslproperties</a>
         * @param sslProperties Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your underlying source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sslProperties(final software.amazon.awscdk.services.quicksight.CfnDataSource.SslPropertiesProperty sslProperties) {
            this.props.sslProperties(sslProperties);
            return this;
        }

        /**
         * Contains a map of the key-value pairs for the resource tag or tags assigned to the data source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-tags</a>
         * @param tags Contains a map of the key-value pairs for the resource tag or tags assigned to the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * Use this parameter only when you want Amazon QuickSight to use a VPC connection when connecting to your underlying source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-vpcconnectionproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-vpcconnectionproperties</a>
         * @param vpcConnectionProperties Use this parameter only when you want Amazon QuickSight to use a VPC connection when connecting to your underlying source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConnectionProperties(final software.amazon.awscdk.IResolvable vpcConnectionProperties) {
            this.props.vpcConnectionProperties(vpcConnectionProperties);
            return this;
        }
        /**
         * Use this parameter only when you want Amazon QuickSight to use a VPC connection when connecting to your underlying source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-vpcconnectionproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html#cfn-quicksight-datasource-vpcconnectionproperties</a>
         * @param vpcConnectionProperties Use this parameter only when you want Amazon QuickSight to use a VPC connection when connecting to your underlying source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConnectionProperties(final software.amazon.awscdk.services.quicksight.CfnDataSource.VpcConnectionPropertiesProperty vpcConnectionProperties) {
            this.props.vpcConnectionProperties(vpcConnectionProperties);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.quicksight.CfnDataSource}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.quicksight.CfnDataSource build() {
            return new software.amazon.awscdk.services.quicksight.CfnDataSource(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
