package software.amazon.awscdk.services.rds;

/**
 * Properties for defining a <code>CfnGlobalCluster</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rds.*;
 * CfnGlobalClusterProps cfnGlobalClusterProps = CfnGlobalClusterProps.builder()
 *         .deletionProtection(false)
 *         .engine("engine")
 *         .engineLifecycleSupport("engineLifecycleSupport")
 *         .engineVersion("engineVersion")
 *         .globalClusterIdentifier("globalClusterIdentifier")
 *         .sourceDbClusterIdentifier("sourceDbClusterIdentifier")
 *         .storageEncrypted(false)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:43.036Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnGlobalClusterProps")
@software.amazon.jsii.Jsii.Proxy(CfnGlobalClusterProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnGlobalClusterProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies whether to enable deletion protection for the new global database cluster.
     * <p>
     * The global database can't be deleted when deletion protection is enabled.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html#cfn-rds-globalcluster-deletionprotection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html#cfn-rds-globalcluster-deletionprotection</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDeletionProtection() {
        return null;
    }

    /**
     * The database engine to use for this global database cluster.
     * <p>
     * Valid Values: <code>aurora-mysql | aurora-postgresql</code>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Can't be specified if <code>SourceDBClusterIdentifier</code> is specified. In this case, Amazon Aurora uses the engine of the source DB cluster.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html#cfn-rds-globalcluster-engine">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html#cfn-rds-globalcluster-engine</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEngine() {
        return null;
    }

    /**
     * The life cycle type for this global database cluster.
     * <p>
     * <blockquote>
     * <p>
     * By default, this value is set to <code>open-source-rds-extended-support</code> , which enrolls your global cluster into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for Extended Support by setting the value to <code>open-source-rds-extended-support-disabled</code> . In this case, creating the global cluster will fail if the DB major version is past its end of standard support date.
     * <p>
     * </blockquote>
     * <p>
     * This setting only applies to Aurora PostgreSQL-based global databases.
     * <p>
     * You can use this setting to enroll your global cluster into Amazon RDS Extended Support. With RDS Extended Support, you can run the selected major engine version on your global cluster past the end of standard support for that engine version. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/extended-support.html">Amazon RDS Extended Support with Amazon Aurora</a> in the <em>Amazon Aurora User Guide</em> .
     * <p>
     * Valid Values: <code>open-source-rds-extended-support | open-source-rds-extended-support-disabled</code>
     * <p>
     * Default: <code>open-source-rds-extended-support</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html#cfn-rds-globalcluster-enginelifecyclesupport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html#cfn-rds-globalcluster-enginelifecyclesupport</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEngineLifecycleSupport() {
        return null;
    }

    /**
     * The engine version to use for this global database cluster.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Can't be specified if <code>SourceDBClusterIdentifier</code> is specified. In this case, Amazon Aurora uses the engine version of the source DB cluster.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html#cfn-rds-globalcluster-engineversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html#cfn-rds-globalcluster-engineversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEngineVersion() {
        return null;
    }

    /**
     * The cluster identifier for this global database cluster.
     * <p>
     * This parameter is stored as a lowercase string.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html#cfn-rds-globalcluster-globalclusteridentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html#cfn-rds-globalcluster-globalclusteridentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getGlobalClusterIdentifier() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) to use as the primary cluster of the global database.
     * <p>
     * If you provide a value for this parameter, don't specify values for the following settings because Amazon Aurora uses the values from the specified source DB cluster:
     * <p>
     * <ul>
     * <li><code>DatabaseName</code></li>
     * <li><code>Engine</code></li>
     * <li><code>EngineVersion</code></li>
     * <li><code>StorageEncrypted</code></li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html#cfn-rds-globalcluster-sourcedbclusteridentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html#cfn-rds-globalcluster-sourcedbclusteridentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSourceDbClusterIdentifier() {
        return null;
    }

    /**
     * Specifies whether to enable storage encryption for the new global database cluster.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Can't be specified if <code>SourceDBClusterIdentifier</code> is specified. In this case, Amazon Aurora uses the setting from the source DB cluster.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html#cfn-rds-globalcluster-storageencrypted">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html#cfn-rds-globalcluster-storageencrypted</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getStorageEncrypted() {
        return null;
    }

    /**
     * Metadata assigned to an Amazon RDS resource consisting of a key-value pair.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS resources</a> in the <em>Amazon RDS User Guide</em> or <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.html">Tagging Amazon Aurora and Amazon RDS resources</a> in the <em>Amazon Aurora User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html#cfn-rds-globalcluster-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html#cfn-rds-globalcluster-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnGlobalClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnGlobalClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnGlobalClusterProps> {
        java.lang.Object deletionProtection;
        java.lang.String engine;
        java.lang.String engineLifecycleSupport;
        java.lang.String engineVersion;
        java.lang.String globalClusterIdentifier;
        java.lang.String sourceDbClusterIdentifier;
        java.lang.Object storageEncrypted;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnGlobalClusterProps#getDeletionProtection}
         * @param deletionProtection Specifies whether to enable deletion protection for the new global database cluster.
         *                           The global database can't be deleted when deletion protection is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(java.lang.Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        /**
         * Sets the value of {@link CfnGlobalClusterProps#getDeletionProtection}
         * @param deletionProtection Specifies whether to enable deletion protection for the new global database cluster.
         *                           The global database can't be deleted when deletion protection is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(software.amazon.awscdk.IResolvable deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        /**
         * Sets the value of {@link CfnGlobalClusterProps#getEngine}
         * @param engine The database engine to use for this global database cluster.
         *               Valid Values: <code>aurora-mysql | aurora-postgresql</code>
         *               <p>
         *               Constraints:
         *               <p>
         *               <ul>
         *               <li>Can't be specified if <code>SourceDBClusterIdentifier</code> is specified. In this case, Amazon Aurora uses the engine of the source DB cluster.</li>
         *               </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engine(java.lang.String engine) {
            this.engine = engine;
            return this;
        }

        /**
         * Sets the value of {@link CfnGlobalClusterProps#getEngineLifecycleSupport}
         * @param engineLifecycleSupport The life cycle type for this global database cluster.
         *                               <blockquote>
         *                               <p>
         *                               By default, this value is set to <code>open-source-rds-extended-support</code> , which enrolls your global cluster into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for Extended Support by setting the value to <code>open-source-rds-extended-support-disabled</code> . In this case, creating the global cluster will fail if the DB major version is past its end of standard support date.
         *                               <p>
         *                               </blockquote>
         *                               <p>
         *                               This setting only applies to Aurora PostgreSQL-based global databases.
         *                               <p>
         *                               You can use this setting to enroll your global cluster into Amazon RDS Extended Support. With RDS Extended Support, you can run the selected major engine version on your global cluster past the end of standard support for that engine version. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/extended-support.html">Amazon RDS Extended Support with Amazon Aurora</a> in the <em>Amazon Aurora User Guide</em> .
         *                               <p>
         *                               Valid Values: <code>open-source-rds-extended-support | open-source-rds-extended-support-disabled</code>
         *                               <p>
         *                               Default: <code>open-source-rds-extended-support</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineLifecycleSupport(java.lang.String engineLifecycleSupport) {
            this.engineLifecycleSupport = engineLifecycleSupport;
            return this;
        }

        /**
         * Sets the value of {@link CfnGlobalClusterProps#getEngineVersion}
         * @param engineVersion The engine version to use for this global database cluster.
         *                      Constraints:
         *                      <p>
         *                      <ul>
         *                      <li>Can't be specified if <code>SourceDBClusterIdentifier</code> is specified. In this case, Amazon Aurora uses the engine version of the source DB cluster.</li>
         *                      </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineVersion(java.lang.String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnGlobalClusterProps#getGlobalClusterIdentifier}
         * @param globalClusterIdentifier The cluster identifier for this global database cluster.
         *                                This parameter is stored as a lowercase string.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder globalClusterIdentifier(java.lang.String globalClusterIdentifier) {
            this.globalClusterIdentifier = globalClusterIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnGlobalClusterProps#getSourceDbClusterIdentifier}
         * @param sourceDbClusterIdentifier The Amazon Resource Name (ARN) to use as the primary cluster of the global database.
         *                                  If you provide a value for this parameter, don't specify values for the following settings because Amazon Aurora uses the values from the specified source DB cluster:
         *                                  <p>
         *                                  <ul>
         *                                  <li><code>DatabaseName</code></li>
         *                                  <li><code>Engine</code></li>
         *                                  <li><code>EngineVersion</code></li>
         *                                  <li><code>StorageEncrypted</code></li>
         *                                  </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceDbClusterIdentifier(java.lang.String sourceDbClusterIdentifier) {
            this.sourceDbClusterIdentifier = sourceDbClusterIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnGlobalClusterProps#getStorageEncrypted}
         * @param storageEncrypted Specifies whether to enable storage encryption for the new global database cluster.
         *                         Constraints:
         *                         <p>
         *                         <ul>
         *                         <li>Can't be specified if <code>SourceDBClusterIdentifier</code> is specified. In this case, Amazon Aurora uses the setting from the source DB cluster.</li>
         *                         </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageEncrypted(java.lang.Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        /**
         * Sets the value of {@link CfnGlobalClusterProps#getStorageEncrypted}
         * @param storageEncrypted Specifies whether to enable storage encryption for the new global database cluster.
         *                         Constraints:
         *                         <p>
         *                         <ul>
         *                         <li>Can't be specified if <code>SourceDBClusterIdentifier</code> is specified. In this case, Amazon Aurora uses the setting from the source DB cluster.</li>
         *                         </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageEncrypted(software.amazon.awscdk.IResolvable storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        /**
         * Sets the value of {@link CfnGlobalClusterProps#getTags}
         * @param tags Metadata assigned to an Amazon RDS resource consisting of a key-value pair.
         *             For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS resources</a> in the <em>Amazon RDS User Guide</em> or <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.html">Tagging Amazon Aurora and Amazon RDS resources</a> in the <em>Amazon Aurora User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnGlobalClusterProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnGlobalClusterProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnGlobalClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnGlobalClusterProps {
        private final java.lang.Object deletionProtection;
        private final java.lang.String engine;
        private final java.lang.String engineLifecycleSupport;
        private final java.lang.String engineVersion;
        private final java.lang.String globalClusterIdentifier;
        private final java.lang.String sourceDbClusterIdentifier;
        private final java.lang.Object storageEncrypted;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.deletionProtection = software.amazon.jsii.Kernel.get(this, "deletionProtection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.engine = software.amazon.jsii.Kernel.get(this, "engine", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.engineLifecycleSupport = software.amazon.jsii.Kernel.get(this, "engineLifecycleSupport", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.engineVersion = software.amazon.jsii.Kernel.get(this, "engineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.globalClusterIdentifier = software.amazon.jsii.Kernel.get(this, "globalClusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceDbClusterIdentifier = software.amazon.jsii.Kernel.get(this, "sourceDbClusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.storageEncrypted = software.amazon.jsii.Kernel.get(this, "storageEncrypted", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.deletionProtection = builder.deletionProtection;
            this.engine = builder.engine;
            this.engineLifecycleSupport = builder.engineLifecycleSupport;
            this.engineVersion = builder.engineVersion;
            this.globalClusterIdentifier = builder.globalClusterIdentifier;
            this.sourceDbClusterIdentifier = builder.sourceDbClusterIdentifier;
            this.storageEncrypted = builder.storageEncrypted;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getDeletionProtection() {
            return this.deletionProtection;
        }

        @Override
        public final java.lang.String getEngine() {
            return this.engine;
        }

        @Override
        public final java.lang.String getEngineLifecycleSupport() {
            return this.engineLifecycleSupport;
        }

        @Override
        public final java.lang.String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final java.lang.String getGlobalClusterIdentifier() {
            return this.globalClusterIdentifier;
        }

        @Override
        public final java.lang.String getSourceDbClusterIdentifier() {
            return this.sourceDbClusterIdentifier;
        }

        @Override
        public final java.lang.Object getStorageEncrypted() {
            return this.storageEncrypted;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDeletionProtection() != null) {
                data.set("deletionProtection", om.valueToTree(this.getDeletionProtection()));
            }
            if (this.getEngine() != null) {
                data.set("engine", om.valueToTree(this.getEngine()));
            }
            if (this.getEngineLifecycleSupport() != null) {
                data.set("engineLifecycleSupport", om.valueToTree(this.getEngineLifecycleSupport()));
            }
            if (this.getEngineVersion() != null) {
                data.set("engineVersion", om.valueToTree(this.getEngineVersion()));
            }
            if (this.getGlobalClusterIdentifier() != null) {
                data.set("globalClusterIdentifier", om.valueToTree(this.getGlobalClusterIdentifier()));
            }
            if (this.getSourceDbClusterIdentifier() != null) {
                data.set("sourceDbClusterIdentifier", om.valueToTree(this.getSourceDbClusterIdentifier()));
            }
            if (this.getStorageEncrypted() != null) {
                data.set("storageEncrypted", om.valueToTree(this.getStorageEncrypted()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.CfnGlobalClusterProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnGlobalClusterProps.Jsii$Proxy that = (CfnGlobalClusterProps.Jsii$Proxy) o;

            if (this.deletionProtection != null ? !this.deletionProtection.equals(that.deletionProtection) : that.deletionProtection != null) return false;
            if (this.engine != null ? !this.engine.equals(that.engine) : that.engine != null) return false;
            if (this.engineLifecycleSupport != null ? !this.engineLifecycleSupport.equals(that.engineLifecycleSupport) : that.engineLifecycleSupport != null) return false;
            if (this.engineVersion != null ? !this.engineVersion.equals(that.engineVersion) : that.engineVersion != null) return false;
            if (this.globalClusterIdentifier != null ? !this.globalClusterIdentifier.equals(that.globalClusterIdentifier) : that.globalClusterIdentifier != null) return false;
            if (this.sourceDbClusterIdentifier != null ? !this.sourceDbClusterIdentifier.equals(that.sourceDbClusterIdentifier) : that.sourceDbClusterIdentifier != null) return false;
            if (this.storageEncrypted != null ? !this.storageEncrypted.equals(that.storageEncrypted) : that.storageEncrypted != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.deletionProtection != null ? this.deletionProtection.hashCode() : 0;
            result = 31 * result + (this.engine != null ? this.engine.hashCode() : 0);
            result = 31 * result + (this.engineLifecycleSupport != null ? this.engineLifecycleSupport.hashCode() : 0);
            result = 31 * result + (this.engineVersion != null ? this.engineVersion.hashCode() : 0);
            result = 31 * result + (this.globalClusterIdentifier != null ? this.globalClusterIdentifier.hashCode() : 0);
            result = 31 * result + (this.sourceDbClusterIdentifier != null ? this.sourceDbClusterIdentifier.hashCode() : 0);
            result = 31 * result + (this.storageEncrypted != null ? this.storageEncrypted.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
