package software.amazon.awscdk.services.route53.targets;

/**
 * Use a user pool domain as an alias record target.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.cognito.*;
 * HostedZone zone;
 * UserPoolDomain domain;
 * ARecord.Builder.create(this, "AliasRecord")
 *         .zone(zone)
 *         .target(RecordTarget.fromAlias(new UserPoolDomainTarget(domain)))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:43.516Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53_targets.UserPoolDomainTarget")
public class UserPoolDomainTarget extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.route53.IAliasRecordTarget {

    protected UserPoolDomainTarget(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected UserPoolDomainTarget(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param domain This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public UserPoolDomainTarget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.UserPoolDomain domain) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(domain, "domain is required") });
    }

    /**
     * Return hosted zone ID and DNS name, usable for Route53 alias targets.
     * <p>
     * @param record This parameter is required.
     * @param _zone
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.AliasRecordTargetConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.IRecordSet record, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.route53.IHostedZone _zone) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.AliasRecordTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(record, "record is required"), _zone });
    }

    /**
     * Return hosted zone ID and DNS name, usable for Route53 alias targets.
     * <p>
     * @param record This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.AliasRecordTargetConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.IRecordSet record) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.AliasRecordTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(record, "record is required") });
    }
}
