package software.amazon.awscdk.services.s3;

/**
 * Describes when an object transitions to a specified storage class.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.s3.*;
 * StorageClass storageClass;
 * Transition transition = Transition.builder()
 *         .storageClass(storageClass)
 *         // the properties below are optional
 *         .transitionAfter(Duration.minutes(30))
 *         .transitionDate(new Date())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:43.765Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3.Transition")
@software.amazon.jsii.Jsii.Proxy(Transition.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface Transition extends software.amazon.jsii.JsiiSerializable {

    /**
     * The storage class to which you want the object to transition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.StorageClass getStorageClass();

    /**
     * Indicates the number of days after creation when objects are transitioned to the specified storage class.
     * <p>
     * Default: - No transition count.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getTransitionAfter() {
        return null;
    }

    /**
     * Indicates when objects are transitioned to the specified storage class.
     * <p>
     * The date value must be in ISO 8601 format. The time is always midnight UTC.
     * <p>
     * Default: - No transition date.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.time.Instant getTransitionDate() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link Transition}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link Transition}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<Transition> {
        software.amazon.awscdk.services.s3.StorageClass storageClass;
        software.amazon.awscdk.Duration transitionAfter;
        java.time.Instant transitionDate;

        /**
         * Sets the value of {@link Transition#getStorageClass}
         * @param storageClass The storage class to which you want the object to transition. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageClass(software.amazon.awscdk.services.s3.StorageClass storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        /**
         * Sets the value of {@link Transition#getTransitionAfter}
         * @param transitionAfter Indicates the number of days after creation when objects are transitioned to the specified storage class.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitionAfter(software.amazon.awscdk.Duration transitionAfter) {
            this.transitionAfter = transitionAfter;
            return this;
        }

        /**
         * Sets the value of {@link Transition#getTransitionDate}
         * @param transitionDate Indicates when objects are transitioned to the specified storage class.
         *                       The date value must be in ISO 8601 format. The time is always midnight UTC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitionDate(java.time.Instant transitionDate) {
            this.transitionDate = transitionDate;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link Transition}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public Transition build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link Transition}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Transition {
        private final software.amazon.awscdk.services.s3.StorageClass storageClass;
        private final software.amazon.awscdk.Duration transitionAfter;
        private final java.time.Instant transitionDate;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.storageClass = software.amazon.jsii.Kernel.get(this, "storageClass", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.StorageClass.class));
            this.transitionAfter = software.amazon.jsii.Kernel.get(this, "transitionAfter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.transitionDate = software.amazon.jsii.Kernel.get(this, "transitionDate", software.amazon.jsii.NativeType.forClass(java.time.Instant.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.storageClass = java.util.Objects.requireNonNull(builder.storageClass, "storageClass is required");
            this.transitionAfter = builder.transitionAfter;
            this.transitionDate = builder.transitionDate;
        }

        @Override
        public final software.amazon.awscdk.services.s3.StorageClass getStorageClass() {
            return this.storageClass;
        }

        @Override
        public final software.amazon.awscdk.Duration getTransitionAfter() {
            return this.transitionAfter;
        }

        @Override
        public final java.time.Instant getTransitionDate() {
            return this.transitionDate;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("storageClass", om.valueToTree(this.getStorageClass()));
            if (this.getTransitionAfter() != null) {
                data.set("transitionAfter", om.valueToTree(this.getTransitionAfter()));
            }
            if (this.getTransitionDate() != null) {
                data.set("transitionDate", om.valueToTree(this.getTransitionDate()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3.Transition"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            Transition.Jsii$Proxy that = (Transition.Jsii$Proxy) o;

            if (!storageClass.equals(that.storageClass)) return false;
            if (this.transitionAfter != null ? !this.transitionAfter.equals(that.transitionAfter) : that.transitionAfter != null) return false;
            return this.transitionDate != null ? this.transitionDate.equals(that.transitionDate) : that.transitionDate == null;
        }

        @Override
        public final int hashCode() {
            int result = this.storageClass.hashCode();
            result = 31 * result + (this.transitionAfter != null ? this.transitionAfter.hashCode() : 0);
            result = 31 * result + (this.transitionDate != null ? this.transitionDate.hashCode() : 0);
            return result;
        }
    }
}
