package software.amazon.awscdk.services.s3;

/**
 * The transition default minimum object size for lifecycle.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket.Builder.create(this, "MyBucket")
 *         .transitionDefaultMinimumObjectSize(TransitionDefaultMinimumObjectSize.VARIES_BY_STORAGE_CLASS)
 *         .lifecycleRules(List.of(LifecycleRule.builder()
 *                 .transitions(List.of(Transition.builder()
 *                         .storageClass(StorageClass.DEEP_ARCHIVE)
 *                         .transitionAfter(Duration.days(30))
 *                         .build()))
 *                 .build(), LifecycleRule.builder()
 *                 .objectSizeLessThan(300000)
 *                 .objectSizeGreaterThan(200000)
 *                 .transitions(List.of(Transition.builder()
 *                         .storageClass(StorageClass.ONE_ZONE_INFREQUENT_ACCESS)
 *                         .transitionAfter(Duration.days(30))
 *                         .build()))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:43.765Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3.TransitionDefaultMinimumObjectSize")
public enum TransitionDefaultMinimumObjectSize {
    /**
     * Objects smaller than 128 KB will not transition to any storage class by default.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ALL_STORAGE_CLASSES_128_K,
    /**
     * Objects smaller than 128 KB will transition to Glacier Flexible Retrieval or Glacier Deep Archive storage classes.
     * <p>
     * By default, all other storage classes will prevent transitions smaller than 128 KB.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    VARIES_BY_STORAGE_CLASS,
}
